function [a,b,rsq] = linfit(x,y)
% Usage: [a,b,rsq] = linfit(x,y)
% This function finds a linear regression of the form y = ax + b
% Outputs: a = slope, b = y-intercept, rsq = coefficient of determination R^2
% Make sure your function (and variables) are linearized before using this!
% See MATLAB documentation on Linear Regression for more details.
% For use with University of Alberta GEOPH 424 Labs.
% Linear regression for linearly related x and y inputs.

p = polyfit(x,y,1);
a = p(1);
b = p(2);

yfit = polyval(p,x);

yresid = y - yfit;

SSresid = sum(yresid.^2);

SStotal = (length(y)-1) * var(y);

rsq = 1 - SSresid/SStotal;

end