function [a,b,rsq] = powfit(x,y)
% Usage: [a,b,rsq] = powfit(x,y)
% This function finds a power regression of the form y = b*(x^a)
% Automatically linearizes inputs according to ln(y) = ln(b) + a*ln(x)
% Outputs: a and b (constants in power regression), rsq = coefficient of determination R^2
% See MATLAB documentation on Linear Regression for more details.
% For use with University of Alberta GEOPH 424 Labs.

p = polyfit(log(x),log(y),1);
a = p(1);
b = exp(p(2));

yfit = polyval(p,log(x));

yresid = log(y) - yfit;

SSresid = sum(yresid.^2);

SStotal = (length(y)-1) * var(log(y));

rsq = 1 - SSresid/SStotal;

end