function [a,b,rsq] = expfit(x,y)
% Usage: [a,b,rsq] = expfit(x,y)
% This function finds an exponential regression of the form y = b*exp(ax)
% Automatically linearizes inputs according to ln(y) = ln(b) + ax
% Outputs: a and b (constants in exponential regression), rsq = coefficient of determination R^2
% See MATLAB documentation on Linear Regression for more details.
% For use with University of Alberta GEOPH 424 Labs.

p = polyfit(x,log(y),1);
a = p(1);
b = exp(p(2));

yfit = polyval(p,x);

yresid = log(y) - yfit;

SSresid = sum(yresid.^2);

SStotal = (length(y)-1) * var(log(y));

rsq = 1 - SSresid/SStotal;

end