function profile2012

clear all
close all

%==========================================================================
% plot settings

x_grid=64; % pseudosection resolution  (number of data points to display)
y_grid=64;
xspacing = 15; % spacing for the survey

x=[0:xspacing:105]; % Profile distance of each station

tot_depth=10; % total depth the cross section is plotted to, meters

xlim = [min(x) max(x)]; % x range of pseudo section
ylim = [-0.5 80]; % y range of pseudo section

reslim = [10 1000]; % apparent resistivity / resistivity limits

%==========================================================================
% comment or uncomment these blocks to pick the profile to be plotted:

% Profile 1

name(:,1)='res01-2009';
name(:,2)='res02-2009';
name(:,3)='res03-2009';
name(:,4)='res04-2009';
name(:,5)='res05-2009';
name(:,6)='res06-2009';
name(:,7)='res07-2009';

% Profile 2

% name(:,1)='res08-2009';
% name(:,2)='res09-2009';
% name(:,3)='res10-2009';
% name(:,4)='res11-2009';
% name(:,5)='res12-2009';
% name(:,6)='res13-2009';
% name(:,7)='res14-2009';

%==========================================================================
% probably do not need to edit anything below here

for i=1:length(name(1,:))
    
    clear temp_name temp

    temp_name=[name(1:length(name(:,i)),i)','.txt'];
    temp=load(temp_name);

    if i==1
        app_res(:,i)=temp(:,3);
        AB2(:,i)=temp(:,1);
        len=length(temp(:,1));
        last=AB2(len,i);
    else
        if length(temp(:,1)) < len
           temp(length(temp(:,1))+1:len,:)=0;
           app_res(:,i)=temp(:,3);
           AB2(:,i)=temp(:,1);
        elseif length(temp(:,1)) > len
           app_res(len+1:length(temp(:,1)),:)=0;
           AB2(len+1:length(temp(:,1)),:)=0;
           len=length(temp(:,1));
           app_res(:,i)=temp(:,3);
           AB2(:,i)=temp(:,1);
           last=AB2(len,i);
        else
           app_res(:,i)=temp(:,3);
           AB2(:,i)=temp(:,1);
        end
    end
end


for i=1:length(name(1,:))
    
    clear temp_name temp
    
    temp_name=['mod_',name(1:length(name(:,i)),i)','.txt'];
    temp=load(temp_name);
    if i==1
        calcrho(:,i)=temp(:,2);
        th(:,i)=temp(:,1);
        len=length(temp(:,1));
    else
        if length(temp(:,1)) < len
           temp(length(temp(:,1))+1:len,:)=0;
           calcrho(:,i)=temp(:,2);
           th(:,i)=temp(:,1);
        elseif length(temp(:,1)) > len
           calcrho(len+1:length(temp(:,1)),:)=0;
           th(len+1:length(temp(:,1)),:)=0;
           len=length(temp(:,1));
           calcrho(:,i)=temp(:,2);
           th(:,i)=temp(:,1);
        else
           calcrho(:,i)=temp(:,2);
           th(:,i)=temp(:,1);
        end
    end
    
end



for i=1:length(AB2(:,1))
    x_dist(i,:)=x;
end


figure
grid_x=linspace(min(x),max(x),x_grid);
grid_y=linspace(AB2(1,1),last,y_grid);

AB2 = [AB2 AB2(:,end)];
app_res = [app_res app_res(:,end)];

pseudo=griddata(x_dist,AB2,app_res,grid_x,grid_y','linear');

pcolor(grid_x,grid_y,log10(pseudo));
caxis(log10(reslim));axis ij
shading flat
% shading interp
h=colorbar;
colormap(flipud(jet))
title('Pseudo Section')
xlabel('Distance along profile (m)')
ylabel('AB/2 electrode separation distance (m)')
set(get(h,'ylabel'),'string','Log10 Apparent Resistivity (Ohm-m)');
axis([xlim ylim]);
hold on
plot(x+xspacing/2,-0.5,'kv','markerfacecolor','black')

clear grid_y

for i=1:length(th(:,1))
    for j=1:length(th(1,:))
        if th(i,j) == 0
            th(i,j) = 100;
        elseif th(i,j) == 10000
            th(i,j) =100;
        end
        if calcrho(i,j)==0
            calcrho(i,j)=calcrho(i-1,j);
        end
    end
end



for i=1:length(th(1,:))
    depth(:,i)=[0:0.25:tot_depth];
    clear d
    d=cumsum(th(:,i));
    counter=1;
    for j=1:length(depth(:,i))
        if depth(j,i) <= d(counter)
            res(j,i)=calcrho(counter,i);
        else depth(j,i) > d(counter);
            res(j,i)=calcrho(counter+1,i);
            counter=counter+1;
        end
    end
end


for i=1:length(depth(:,1))
    x_dist(i,:)=x;
end

figure
% x_dist = [x_dist x_dist(:,end)];
depth = [depth depth(:,end)];
res = [res res(:,end)];
pcolor(x_dist,depth,log10(res))
caxis(log10(reslim));axis ij
shading flat
%shading interp
h=colorbar;
colormap(flipud(jet))
title('Model Cross Section')
xlabel('Distance along profile (m)')
ylabel('Depth (m)')
set(get(h,'ylabel'),'string','Log10 Resistivity (Ohm-m)');
axis([xlim [-0.5 tot_depth]]);
hold on
plot(x+xspacing/2,-0.5,'kv','markerfacecolor','black')

