function resinv2012
% Function to create many random models and test their fit to observed data
% (~monte carlo inversion)
% Keeps only the models that meet the criteria set by mtol (as compared to
% an RMS value)
% BL, Jan 2014 - Small changes, outputs 2 models: first model found and lowest rms
% model, still saves just the model with lowest rms. The first model is
% shown just for comparison.
% Greg Nieuwenhuis, Sept 2009 - large pieces of code 'borrowed' from Martyn
% Unsworth


clear all
close all

nl=menu('Choose the number of layers','Halfspace','2 Layer','3 Layer','4 Layer','5 Layer','6 layer');

[res_file, outpath]=uigetfile('*.txt','Pick Data File');

app_res=load(res_file);

%------------------------------------------------------------------------
% Change these values to fit your data
num_it=5000; % number of models generated, try with 10,000
zscale=2; % scale factor for random number generator (how large do you want depths to vary?)
mtol=1.5; %RMS tolerance level (all models with a larger RMS are thrown out)
ax=[1 500 1 500];  %resistivity and depth scale for setting the axis
%--------------------------------------------------------------------------
% Probably do not need to edit below
rho_error_level=0.1; % Error level for calculating RMS

app_max=max(app_res(:,3));
app_min=min(app_res(:,3));

obrho=[app_res(:,1),app_res(:,3),app_res(:,4)];                 
rho_error=obrho(:,2).*rho_error_level; %percent error, rhoa * err
dat_len=length(obrho(:,1));

index=zeros(num_it,1);
imin=1;
min_rms=mtol;

if app_max <=100 %scaling
    r_logmax=2;
elseif app_max <=1000
    r_logmax=3;
elseif app_max <= 10000
    r_logmax=4;
else
    r_logmax=5;
end

if app_min <=10
    r_logmin=0;
elseif app_min <=100
    r_logmin=1;
elseif app_min <=1000
    r_logmin=2;
end


na=0;
for i=1:num_it % Loop over num_it models
    clear temp mod_len temp_res
    [temp(:,1),temp_res(:,1)]=gen1D_random(zscale,nl,r_logmin,r_logmax); %generate random model.
    %temp(length(temp(:,1))+1,1)=100;

    mod_len=length(temp(:,1));
    
    if dat_len ~= mod_len %need to pad model array with dummy variables so it is the same length as the data
      add_num=dat_len-mod_len;
      temp((mod_len+1):dat_len,1)=10000;
      temp_res((mod_len+1):dat_len,1)=temp_res(mod_len,1);
    end
    t(:,i)=temp(:,1);
    mres(:,i)=temp_res(:,1);

    disp(num2str(i))
    calcrho(:,i)=rafind3(mres(:,i),t(:,i),obrho,nl,rho_error); %calculate the apparent resistivity and plots.


    rms(i)=compute_rms(obrho(:,2),calcrho(:,i),rho_error,dat_len); % calculate the RMS
    
    
    if rms(i) <= mtol %mark wherever the rms is below the tolerance level
        
      na=na+1;
      index(i,1)=1; %from 1-1000, 1's are where rms is below mtol
    
      if rms(i) <= min_rms
        min_rms = rms(i);
        imin=i;
      end
      
      % Display results - update everytime an acceptable model is found
  
    end
      
   %  % Resistivity models and fit to the MT data
   
   if rms(i) <= mtol

      figure(1)
      subplot (2,2,1) 
      
      clear ind

      ind=find(index(:,1)); %Should change this - eats up memory because all models are saved
      for y=1:length(ind)
        clear n1 t_n depth rho m
        m=ind(y);
        n1=length(mres(:,m));
        t_n(2:n1+1)=t(:,m);
        t_n(1)=t(1,m);
        depth=cumsum(t_n);
        rho(:,1)=mres(:,m);
        rho(n1+1)=mres(n1,m);
        [xx,yy]=stairs(depth,rho);
        if m == imin
           loglog(yy,xx,'r'); 
        else
           loglog(yy,xx,'k'); 
        end
        ylabel('depth (m)'); xlabel('Resistivity (\Omega.m)')
        set (gca,'YTICK',[0.1 1 10 100 1000])
        ylim([0.1 1000])
        title([num2str(na,'%4.0f'),' models with misfit < ',num2str(mtol,'%4.2f')])
        axis ij
        hold on
      end
      
      hold off
      

      
      
      subplot(2,2,3)
      nu=zeros(dat_len);
      ploterr(obrho(:,1),obrho(:,2),nu,rho_error,'b','logxy'); hold on;
      for y=1:length(ind)
          if ind(y)==imin
              loglog(obrho(:,1),calcrho(:,ind(y)),'r')
          else
              loglog(obrho(:,1),calcrho(:,ind(y)),'k')
          end
          hold on
      end
      %axis([1 500 1 500])
      %set (gca,'YTICK',[1 10 100 1000 10000])
      %set (gca,'XTICK',[1 10 100 1000 10000])
      xlabel('AB/2 (m)'); ylabel('Apparent Resistivity (\Omega.m)')
      hold off
      
      % best to date Resistivity models
          subplot (2,2,[2 4])
          
          clear xx yy n1 t_n depth rho
          n1=length(mres(:,imin));
          t_n(2:n1+1)=t(:,imin);
          t_n(1)=t(1,imin);
          depth=cumsum(t_n);
          rho(:,1)=mres(:,imin);
          rho(n1+1)=mres(n1,imin);
          
          
          [xx,yy]=stairs(depth,rho);
          loglog(yy,xx,'lineWidth',2);axis ij
          xlabel('Resistivity (\Omega.m)'); ylabel('Depth (m)')
          %axis(ax)
          set (gca,'YTICK',[1 10 100 1000 10000])
          title(['Lowest r.m.s. misfit = ',num2str(min_rms,'%5.3f')])
      end
      
      
      
      
end % end of iteration loop
      
      
  
%  %=================================================================
%     figure (2)   % Look at correlations of layer properties
%       
%       for ilay =1 :nl-1
%       ind=find(index);
%         subplot(2,2,ilay)
%         
%           for y =1:na
%             semilogy(0.001*(t(ilay+1,ind(y))-t(ilay,ind(y))),mres(ilay,ind(y)),'+')
%             hold on
%           end
%           hold off
%           axis([0 0.0011*max(t(ilay+1,ind(y))-t(ilay,ind(y))),0.3*min(rho_accept(ilay,:)), 3*max(rho_accept(ilay,:))])
%           xlabel('thickness (km)'); ylabel('resistivity ( \Omega m )')
%           set (gca,'YTICK',[0.3 1 3 10 30 100 300 1000 3000])
%           title(['Layer ',num2str(ilay,'%2.0f')])
%       end      
%     
%       subplot(2,2,nl)
%       
%         for i =1:na
%           semilogy(1,rho_accept(nl,i),'+')
%           hold on
%         end
%         hold off
%         axis([0,2,0.3*min(rho_accept(nl,:)), 3*max(rho_accept(nl,:))])
%         ylabel('resistivity ( \Omega m )')
%         set (gca,'YTICK',[0.3 1 3 10 30 100 300 1000 3000])
%         set (gca,'XTICK',[-1])
%         title(['Layer ',num2str(nl,'%2.0f'),' Halfspace'])
%       pause(1)
%   end 



print -djpeg -r200 figure1.jpg %print the figure with all models below tolerance level displayed


% Now show the best model generated
f = figure(2);
clf
subplot(1,4,[1:3])
% Plot the calculated apparent resistivity with depth.
loglog(obrho(:,1),calcrho(:,imin),'k','lineWidth',2);  
hold on
% Plot the observed apparent resistivity with depth.
z=zeros(length(obrho(:,1)),1);
ploterr(obrho(:,1),obrho(:,2),z,rho_error,'r*','logxy');
xlabel('AB/2 (m)'); ylabel('Apparent Res. (\Omega.m)')
legend('Model Apparent Resistivity','Observed Apparent Resistivity','location','best')
% legend('Model Apparent Resistivity','Observed Apparent Resistivity',1,'location','best')
title(sprintf('%s Resistivity Fit- RMS = %1.2f',res_file,rms(imin)));

% Now plot the model resistivity with depth.
subplot(1,4,4)
%depth(:,1)=t(1,1);
clear rho n1 t_n
rho=mres(:,imin);
n1=length(rho);
t_n(2:n1+1)=t(:,imin);
t_n(1)=t(1,imin);
depth=cumsum(t_n);
rho(n1+1)=rho(n1);
%depth(n1+1)=depth(n1);
[xx,yy]=stairs(depth,rho);
loglog(yy,xx,'lineWidth',2);axis ij
ylabel('Depth (m)'); xlabel('Resistivity (\Omega.m)')

resfilename = strrep(res_file,'.txt','.jpg');
print(f,'-djpeg','-r200',resfilename)

out_name=['mod_',res_file];
out(:,1)=t(:,imin);
out(:,2)=mres(:,imin);

save(out_name,'out','-ascii')

if na ~= 1;
    imax = min(find(index));

    % Now show the best model generated
figure(3)
clf
subplot(1,4,[1:3])
% Plot the calculated apparent resistivity with depth.
loglog(obrho(:,1),calcrho(:,imax),'k','lineWidth',2);  
hold on
% Plot the observed apparent resistivity with depth.
z=zeros(length(obrho(:,1)),1);
ploterr(obrho(:,1),obrho(:,2),z,rho_error,'r*','logxy');
xlabel('AB/2 (m)'); ylabel('Apparent Res. (\Omega.m)')
legend('Model Apparent Resistivity','Observed Apparent Resistivity','location','best')
title(sprintf('%s Resistivity Fit- RMS = %1.2f',res_file,rms(imax)));

% Now plot the model resistivity with depth.
subplot(1,4,4)
%depth(:,1)=t(1,1);
clear rho n1 t_n
rho=mres(:,imax);
n1=length(rho);
t_n(2:n1+1)=t(:,imax);
t_n(1)=t(1,imax);
depth=cumsum(t_n);
rho(n1+1)=rho(n1);
%depth(n1+1)=depth(n1);
[xx,yy]=stairs(depth,rho);
loglog(yy,xx,'lineWidth',2);axis ij
ylabel('Depth (m)'); xlabel('Resistivity (\Omega.m)')

end

end


