function calcrho=rafind3(rho,t,obrho,nl,rho_error); 

% usage: output = rafind2(rho,t,obrho)  finds the apparent
% resisitivty for an input values of resistivity rho (ohm*m) and
% the corresponding layer thicknesses t (m).  The last layer in
% t is the seminfinite halfspace.  rho and t are filled with
% the same number of components and hence t must also have
% in its last component a dummy number which is not used.
% r is in ohm-m and t is in m.
% These values are then compared to the observed apparent resistivity
% in the second column of obrho, the first column is the corresponding % AB/2 in meters.
% copyright Douglas R. Schmitt, November 1998 who makes no guarantee
% whatsoever that this program is correct so forget about suing me if
% you use this program for a commercial or other venture.  That is,
% you are completely on your own if you use this.

% Modifications by M Heimpel, November, 1999, A new 1-D array called 
% calcrho(1:n) is created (where n is the number of Schlumberger spacings). 
% This array contains theoretical apparent resistivity 
% values which are obtained by interpolating the original calculated values  
% so that they correspond to the observed depth spacing (AB/2).
% On output calcrho(1:n) = output(1:n,5)
% The new array can be used to adjust the theoretical resistivity values after
% itereative depth adjustment in Zohdy's method (Zohdy, Geophys, 54, 245-253, 1989).   
% November, 2000:
% Sign error corrected in "shift to the right" (thanks to Kristen Beaty,
% see comments below). 
% Plotting can be diables by commenting out the 
% plotting secion at the end of this program. 

% Slight modifications by Greg Nieuwenhuis to make rafind2 work as a
% forward modelling program (Sept 2009) (Also changed the plot layout)
%    -added the use of error bars (from standard deviation of measured
%    data)


% First must determine the resisivity transform function T
% For details see the following rhotran.m
% The first column of T is u (in metres), 
% not the abscissa natural log(u)

T = rhotran(rho,t);

	% intfil is the inverse filter
	% which has a abcissa spacing of log(10)/6.
	% The filter here is 
	% for the Schlumberger model from O'Neill (1975)
	% See page 94 of Koefoed, 1979.
	% The first column of intfil is the natural log abscissa
	% in Ghosh's terminology is y = log(u), u comparable to AB/2
	% here of spacing log(10)/6. 
	% The second is the filter coefficients.
	
intfil =  [-1.7881	0.003042
-1.4044	-0.001198
-1.0206	0.01284
-0.6368	0.0235
-0.2531	0.08688
0.1307	0.2374
0.5144	0.6194
0.8982	1.1817
1.282	0.4248
1.6658	-3.4507
2.0495	2.7044
2.4333	-1.1324
2.817	0.393
3.2008	-0.1436
3.5846	0.05812
3.9683	-0.02521
4.3521	0.01125
4.7359	-0.004978
5.1196	0.002072
5.5034	-0.000318 ];
intfilzero = 5; % Note - will have to play some tricks later
	       % because the abscissa does not correspond to zero.

temprho = conv(T(:,2),intfil(:,2));

[m,n] = size(intfil); m2 = floor(m/2); [M,N] = size(T); % T should be
	% larger than intfil by a considerable margin. T was designed
	% with very small and large values of y in order to get to
	% reasonable flat portions on the curves to minimize edge
	% effects in the convolution.

indTzero = ceil(M/2); % NOTE - assumes T is symmetric
		      % wrt to abscissa = 0
		      % and contains an odd number of points.
newzero = intfilzero+indTzero-1;  % where '0' abscissa will be in conv.

rhoapp(:,1:2) = T(indTzero-100:indTzero+100,1:2); % The resistivity 
		% transform (col2) and its abscissa (col1) stored.


% Original line with sign error: rhoapp(:,3) = exp(log(rhoapp(:,1))-intfil(5,1));
% sign error corrected, november 2000:
rhoapp(:,3) = exp(log(rhoapp(:,1))+intfil(5,1));
	% This third column is the u (in metres) value of u = exp(y)
	% where y is the abscissa (natural log) of Ghosh.
	% Again, u is comparable to AB/2 for the Schlumberger array.
	% Note that we are also doing the 'shift to the right'

rhoapp(:,4) = temprho(newzero-100:newzero+100);

% M Heimpel, 1999, 2000 begin
 calcrho=interp1(rhoapp(:,3),rhoapp(:,4),obrho(:,1),'linear'); 
 [nc,dum]=size(calcrho);
 rhoapp(:,5)=0.0;
 rhoapp(1:nc,5)=calcrho(1:nc);
 rho_err=obrho(:,3);
% M Heimpel, 1999 end
% M Heimpel, 2000 begin
% if you want a figure, then uncomment the following 18 lines
% figure(1)
% clf
% subplot(1,4,[1:3])
% % Plot the calculated apparent resistivity with depth.
% loglog(obrho(:,1),calcrho,'k','lineWidth',2);  % M Heimpel, 1999
% hold on
% % Plot the observed apparent resistivity with depth.
% z=zeros(length(obrho(:,1)),1);
% ploterr(obrho(:,1),obrho(:,2),z,rho_error,'r*','logxy');axis([1 500 10 5000])
% xlabel('AB/2 (m)'); ylabel('Apparent Res. (\Omega.m)')
% legend('Model Apparent Resistivity','Observed Apparent Resistivity',1)
% title('Resistivity Fit')
% % temp=axis; temp(1:2)=[min(obrho(:,1))-1 max(obrho(:,1))+10];  
% % temp(3:4)=[min(rho)-0.1*min(rho) max(rho)*10]; 
% % axis(temp);
% % Now plot the model resistivity with depth.
% subplot(1,4,4)
% %depth(:,1)=t(1,1);
% n1=length(rho);
% t_n(2:n1+1)=t;
% t_n(1)=t(1);
% depth=cumsum(t_n);
% rho(n1+1)=rho(n1);
% %depth(n1+1)=depth(n1);
% [xx,yy]=stairs(depth,rho);
% loglog(yy,xx,'lineWidth',2);axis([1 500 1 500]);axis ij
% ylabel('Depth (m)'); xlabel('Resistivity (\Omega.m)')
% rho=rho(1:n1);
% depth=depth(1:n1);title('Model');
% % M Heimpel, 2000 end