function resfwd2012(varargin)
% Function to calculate a forward model of DC resistivity data
% (Schlumberger array)
% Greg Nieuwenhuis, Sept 2009
%--------------------------------------------------------------------------
%Input:
%   Optional input arguments:
%
%   [1] app_res_file - contains data collected in a Schlumberger array
%      First column - AB/2 spacing
%      Second column - MN/2 spacing (although not used here)
%      Third column - Apparent resistivity
%      Fourth column - standard deviation
%   [2] modfile - file containing the input model
%      -The number of rows corresponds to the number of layers
%      -First column contains thicknesses (NOT depth) in meters
%      -Second column contains true layer resistivities
%      (the last thickness is a dummy variable since this layer is modelled
%      as a halfspace
%
%   If no input arguments, set file names below.
%--------------------------------------------------------------------------

% set these:
appresfile='res04-2009.txt'; % insert app_res_file here !!
modelfile='mod.txt';  % insert mod file here

%--------------------------------------------------------------------------
if nargin == 2
    appresfile = varargin{1};
    modelfile = varargin{2};
    fprintf(['Using input file names:\n',appresfile,'\n',modelfile,'\n'])
elseif nargin == 0
    fprintf(['No inputs entered- using file names specified in resfwd2012:\n',appresfile,'\n',modelfile,'\n'])
else
    error('Unknown number of inputs! Need either 2 inputs (the data and model files) or 0.')
end

mod=-1;
while(true)
    mod=load(modelfile); 
        
    if mod==-1
       disp('Cannot read the model file')
       break
    else
       t=mod(:,1);
       mres=mod(:,2);
            
       mod_len=length(t);
       if mod_len~=length(mres)
           disp('Layer thickness column must be as long as resistivity column in model file (last thickness is a dummy variable due to a halfspace model')
           break
       else
           appres=load(appresfile); 
           if appres==-1
               disp('Cannot read data file')
               break
           else
               obrho=[appres(:,1),appres(:,3),appres(:,4)];
                    
               dat_len=length(obrho(:,1));
               if dat_len ~=mod_len
                   add_num=dat_len-mod_len;
                   for i=mod_len+1:dat_len % make the model array as long as the data array by adding dummy variables to the end
                       t(i,1)=50;
                       mres(i,1)=mres(mod_len);
                   end
                end
            end
            calcrho=rafind2(mres,t,obrho,1,1,appresfile); 
            break
        end
    end
end
