/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.LabelBounds;
import java.util.ArrayList;

public class SeriesImage
implements CgviewConstants {
    int zoomValue;
    int zoomCenter;

    public SeriesImage(int n, int n2) {
        this.zoomValue = n;
        this.zoomCenter = n2;
    }

    public int getZoomValue() {
        return this.zoomValue;
    }

    public int getZoomCenter() {
        return this.zoomCenter;
    }

    public boolean isEqual(SeriesImage seriesImage) {
        return seriesImage.getZoomValue() == this.zoomValue && seriesImage.getZoomCenter() == this.zoomCenter;
    }

    protected String getZoomInFilePrefix(ArrayList arrayList, int n) {
        LabelBounds labelBounds;
        int n2;
        if (arrayList.size() == 0) {
            return null;
        }
        if (this.zoomCenter == 1) {
            return Integer.toString(n) + "_" + Integer.toString(1);
        }
        ArrayList<LabelBounds> arrayList2 = new ArrayList<LabelBounds>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            labelBounds = (LabelBounds)arrayList.get(n2);
            if (labelBounds.getType() != 1) continue;
            arrayList2.add(labelBounds);
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        n2 = Math.abs(((LabelBounds)arrayList2.get(0)).getBase() - this.zoomCenter);
        int n3 = ((LabelBounds)arrayList2.get(0)).getBase();
        for (int i = 0; i < arrayList2.size(); ++i) {
            labelBounds = (LabelBounds)arrayList2.get(i);
            if (Math.abs(labelBounds.getBase() - this.zoomCenter) >= n2) continue;
            n2 = Math.abs(labelBounds.getBase() - this.zoomCenter);
            n3 = labelBounds.getBase();
        }
        return Integer.toString(n) + "_" + Integer.toString(n3);
    }

    protected String getZoomOutFilePrefix(ArrayList arrayList, int n) {
        int n2 = 0;
        int n3 = 0;
        if (arrayList.size() == 0) {
            return null;
        }
        if (this.zoomCenter == 1) {
            return Integer.toString(n) + "_" + Integer.toString(1);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SeriesImage seriesImage = (SeriesImage)arrayList.get(i);
            if (i == 0) {
                n2 = Math.abs(seriesImage.getZoomCenter() - this.getZoomCenter());
                n3 = seriesImage.getZoomCenter();
                n = seriesImage.getZoomValue();
                continue;
            }
            if (Math.abs(seriesImage.getZoomCenter() - this.getZoomCenter()) >= n2) continue;
            n2 = Math.abs(seriesImage.getZoomCenter() - this.getZoomCenter());
            n3 = seriesImage.getZoomCenter();
        }
        return Integer.toString(n) + "_" + Integer.toString(n3);
    }

    public String getClockwiseFilePrefix(ArrayList arrayList) {
        if (arrayList.size() <= 1) {
            return Integer.toString(this.zoomValue) + "_" + Integer.toString(this.zoomCenter);
        }
        int n = arrayList.indexOf(this);
        SeriesImage seriesImage = n == arrayList.size() - 1 ? (SeriesImage)arrayList.get(0) : (SeriesImage)arrayList.get(n + 1);
        return Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter());
    }

    public String getCounterclockwiseFilePrefix(ArrayList arrayList) {
        if (arrayList.size() <= 1) {
            return Integer.toString(this.zoomValue) + "_" + Integer.toString(this.zoomCenter);
        }
        int n = arrayList.indexOf(this);
        SeriesImage seriesImage = n == 0 ? (SeriesImage)arrayList.get(arrayList.size() - 1) : (SeriesImage)arrayList.get(n - 1);
        return Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter());
    }
}

