/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.FeatureRange;
import ca.ualberta.stothard.cgview.FeatureSlot;
import ca.ualberta.stothard.cgview.Legend;
import ca.ualberta.stothard.cgview.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Plasmid
implements CgviewConstants {
    private Cgview p;
    private Legend legend;
    private FeatureSlot forwardSlot0;
    private FeatureSlot forwardSlot1;
    private FeatureSlot forwardSlot2;
    private FeatureSlot forwardSlot3;
    private FeatureSlot forwardSlot4;
    private FeatureSlot forwardSlot5;
    private FeatureSlot forwardSlot6;
    private FeatureSlot forwardSlot7;
    private FeatureSlot restrictionSlot;
    private FeatureSlot reverseSlot0;
    private FeatureSlot reverseSlot1;
    private FeatureSlot reverseSlot2;
    private FeatureSlot reverseSlot3;
    private FeatureSlot reverseSlot4;
    private FeatureSlot reverseSlot5;
    private FeatureSlot reverseSlot6;
    private FeatureSlot reverseSlot7;
    static final int NO_DIRECTION = 0;
    static final int FORWARD = 1;
    static final int REVERSE = 2;
    static final int REGULAR = 1;
    static final int INVERSE = 0;
    private Hashtable COLORS;
    private Hashtable MAP_ITEM_COLORS;
    private Hashtable MAP_ITEM_COLORS_INVERSE;
    private Hashtable FEATURE_COLORS;
    private Hashtable FEATURE_COLORS_INVERSE;
    private Hashtable FEATURE_DECORATIONS_DIRECT;
    private Hashtable FEATURE_DECORATIONS_REVERSE;
    private Hashtable FEATURE_CATEGORIES;
    private Hashtable FEATURE_THICKNESSES;
    private Hashtable BACKBONE_THICKNESSES;
    private Hashtable DRAW_LEGEND_ITEMS;
    private Hashtable LEGEND_ITEM_NAMES;
    private float opacity = 1.0f;
    private int imageWidth = 800;
    private int imageHeight = 800;
    private int size;
    private Font labelFont = new Font("SansSerif", 0, 12);
    private Font titleFont = new Font("SansSerif", 0, 13);
    private Font legendFont = new Font("SansSerif", 0, 12);
    private Font rulerFont = new Font("SansSerif", 0, 8);
    private Font messageFont = new Font("SansSerif", 0, 13);
    private float featureThickness = 8.0f;
    private float backboneThickness = 8.0f;
    private float featureSpacing = 2.0f;
    private float tickLength = 7.0f;
    private double labelLineLength = 40.0;
    private boolean useColoredLabelBackground = false;
    private boolean showTitle = true;
    private boolean showShading = true;
    private boolean showPositions = true;
    private boolean showBorder = true;
    private boolean allowLabelClashLegend = false;
    private float shadingProportion = 0.4f;
    private int useInnerLabels = 1;
    private String message = "";
    private boolean moveInnerLabelsToOuter = true;
    private int colorScheme = 1;
    private String title = "";
    private int labelPlacementQuality = 9;
    private int legendPosition = 3;
    private boolean showMessage = true;
    private boolean showLabels = true;
    private boolean showLegend = true;
    private boolean useArrows = true;
    private boolean useColoredLabels = true;
    private boolean drawTickMarks = true;
    private boolean addCategoryInfo = false;
    private int MAXLABELS = 400;

    public Plasmid(int n) {
        this.size = n;
        this.COLORS = new Hashtable();
        this.MAP_ITEM_COLORS = new Hashtable();
        this.MAP_ITEM_COLORS_INVERSE = new Hashtable();
        this.FEATURE_COLORS = new Hashtable();
        this.FEATURE_COLORS_INVERSE = new Hashtable();
        this.FEATURE_DECORATIONS_DIRECT = new Hashtable();
        this.FEATURE_DECORATIONS_REVERSE = new Hashtable();
        this.FEATURE_CATEGORIES = new Hashtable();
        this.FEATURE_THICKNESSES = new Hashtable();
        this.BACKBONE_THICKNESSES = new Hashtable();
        this.DRAW_LEGEND_ITEMS = new Hashtable();
        this.LEGEND_ITEM_NAMES = new Hashtable();
        this.COLORS.put("black", new Color(0, 0, 0));
        this.COLORS.put("silver", new Color(192, 192, 192));
        this.COLORS.put("gray", new Color(128, 128, 128));
        this.COLORS.put("white", new Color(255, 255, 255));
        this.COLORS.put("maroon", new Color(128, 0, 0));
        this.COLORS.put("red", new Color(255, 0, 0));
        this.COLORS.put("pink", new Color(255, 153, 204));
        this.COLORS.put("purple", new Color(128, 0, 128));
        this.COLORS.put("fuchsia", new Color(255, 0, 255));
        this.COLORS.put("orange", new Color(255, 153, 0));
        this.COLORS.put("green", new Color(0, 128, 0));
        this.COLORS.put("spring", new Color(204, 255, 204));
        this.COLORS.put("lime", new Color(0, 255, 0));
        this.COLORS.put("olive", new Color(128, 128, 0));
        this.COLORS.put("yellow", new Color(255, 255, 0));
        this.COLORS.put("navy", new Color(0, 0, 128));
        this.COLORS.put("blue", new Color(0, 0, 255));
        this.COLORS.put("azure", new Color(51, 153, 255));
        this.COLORS.put("lightBlue", new Color(102, 204, 255));
        this.COLORS.put("teal", new Color(153, 255, 204));
        this.COLORS.put("aqua", new Color(0, 255, 255));
        this.MAP_ITEM_COLORS.put("tick", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("rulerFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("titleFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("messageFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("backbone", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("partialTick", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("zeroLine", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("background", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("tick", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("rulerFont", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("titleFont", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("messageFont", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("backbone", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("partialTick", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("zeroLine", this.COLORS.get("white"));
        this.MAP_ITEM_COLORS_INVERSE.put("background", this.COLORS.get("black"));
        this.FEATURE_COLORS.put("origin_of_replication", this.COLORS.get("black"));
        this.FEATURE_COLORS.put("promoter", this.COLORS.get("green"));
        this.FEATURE_COLORS.put("terminator", this.COLORS.get("maroon"));
        this.FEATURE_COLORS.put("selectable_marker", this.COLORS.get("orange"));
        this.FEATURE_COLORS.put("regulatory_sequence", this.COLORS.get("olive"));
        this.FEATURE_COLORS.put("tag", this.COLORS.get("silver"));
        this.FEATURE_COLORS.put("other_gene", this.COLORS.get("fuchsia"));
        this.FEATURE_COLORS.put("reporter_gene", this.COLORS.get("purple"));
        this.FEATURE_COLORS.put("unique_restriction_site", this.COLORS.get("blue"));
        this.FEATURE_COLORS.put("restriction_site", this.COLORS.get("red"));
        this.FEATURE_COLORS.put("open_reading_frame", this.COLORS.get("pink"));
        this.FEATURE_COLORS_INVERSE.put("origin_of_replication", this.COLORS.get("white"));
        this.FEATURE_COLORS_INVERSE.put("promoter", this.COLORS.get("lime"));
        this.FEATURE_COLORS_INVERSE.put("terminator", this.COLORS.get("yellow"));
        this.FEATURE_COLORS_INVERSE.put("selectable_marker", this.COLORS.get("orange"));
        this.FEATURE_COLORS_INVERSE.put("regulatory_sequence", this.COLORS.get("azure"));
        this.FEATURE_COLORS_INVERSE.put("tag", this.COLORS.get("silver"));
        this.FEATURE_COLORS_INVERSE.put("other_gene", this.COLORS.get("fuchsia"));
        this.FEATURE_COLORS_INVERSE.put("reporter_gene", this.COLORS.get("teal"));
        this.FEATURE_COLORS_INVERSE.put("unique_restriction_site", this.COLORS.get("lightBlue"));
        this.FEATURE_COLORS_INVERSE.put("restriction_site", this.COLORS.get("pink"));
        this.FEATURE_COLORS_INVERSE.put("open_reading_frame", this.COLORS.get("red"));
        this.FEATURE_DECORATIONS_DIRECT.put("origin_of_replication", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("promoter", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("terminator", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("selectable_marker", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("regulatory_sequence", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("tag", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("other_gene", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("reporter_gene", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("unique_restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("open_reading_frame", new Integer(3));
        this.FEATURE_DECORATIONS_REVERSE.put("origin_of_replication", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("promoter", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("terminator", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("selectable_marker", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("regulatory_sequence", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("tag", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("other_gene", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("reporter_gene", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("unique_restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("open_reading_frame", new Integer(2));
        this.FEATURE_CATEGORIES.put("origin_of_replication", new String(" origin"));
        this.FEATURE_CATEGORIES.put("promoter", new String(" prom"));
        this.FEATURE_CATEGORIES.put("terminator", new String(" term"));
        this.FEATURE_CATEGORIES.put("selectable_marker", new String(" marker"));
        this.FEATURE_CATEGORIES.put("regulatory_sequence", new String(" reg"));
        this.FEATURE_CATEGORIES.put("tag", new String(" tag"));
        this.FEATURE_CATEGORIES.put("other_gene", new String(" gene"));
        this.FEATURE_CATEGORIES.put("reporter_gene", new String(" gene"));
        this.FEATURE_CATEGORIES.put("unique_restriction_site", new String(""));
        this.FEATURE_CATEGORIES.put("restriction_site", new String(""));
        this.FEATURE_CATEGORIES.put("open_reading_frame", new String(""));
        this.LEGEND_ITEM_NAMES.put("origin_of_replication", "Origin of replication");
        this.LEGEND_ITEM_NAMES.put("promoter", "Promoter");
        this.LEGEND_ITEM_NAMES.put("terminator", "Terminator");
        this.LEGEND_ITEM_NAMES.put("selectable_marker", "Selectable marker");
        this.LEGEND_ITEM_NAMES.put("regulatory_sequence", "Regulatory sequence");
        this.LEGEND_ITEM_NAMES.put("tag", "Tag");
        this.LEGEND_ITEM_NAMES.put("other_gene", "Other gene");
        this.LEGEND_ITEM_NAMES.put("reporter_gene", "Reporter gene");
        this.LEGEND_ITEM_NAMES.put("unique_restriction_site", "Unique restriction site");
        this.LEGEND_ITEM_NAMES.put("restriction_site", "Restriction site");
        this.LEGEND_ITEM_NAMES.put("open_reading_frame", "Open reading frame");
        this.FEATURE_THICKNESSES.put("xxx-small", new Float(4.0f));
        this.FEATURE_THICKNESSES.put("xx-small", new Float(5.0f));
        this.FEATURE_THICKNESSES.put("x-small", new Float(6.0f));
        this.FEATURE_THICKNESSES.put("small", new Float(7.0f));
        this.FEATURE_THICKNESSES.put("medium", new Float(8.0f));
        this.FEATURE_THICKNESSES.put("large", new Float(9.0f));
        this.FEATURE_THICKNESSES.put("x-large", new Float(10.0f));
        this.FEATURE_THICKNESSES.put("xx-large", new Float(11.0f));
        this.FEATURE_THICKNESSES.put("xxx-large", new Float(12.0f));
        this.BACKBONE_THICKNESSES.put("xxx-small", new Float(4.0f));
        this.BACKBONE_THICKNESSES.put("xx-small", new Float(5.0f));
        this.BACKBONE_THICKNESSES.put("x-small", new Float(6.0f));
        this.BACKBONE_THICKNESSES.put("small", new Float(7.0f));
        this.BACKBONE_THICKNESSES.put("medium", new Float(8.0f));
        this.BACKBONE_THICKNESSES.put("large", new Float(9.0f));
        this.BACKBONE_THICKNESSES.put("x-large", new Float(10.0f));
        this.BACKBONE_THICKNESSES.put("xx-large", new Float(11.0f));
        this.BACKBONE_THICKNESSES.put("xxx-large", new Float(12.0f));
        this.p = new Cgview(n);
    }

    public Plasmid(String string, int n) {
        this(n);
        this.title = string;
    }

    public void addFeature(String string, String string2, int n, int n2, int n3) {
        int n4;
        int n5;
        Color color;
        if (n > this.size) {
            n = this.size;
        }
        if (n < 1) {
            n = 1;
        }
        if (n2 > this.size) {
            n2 = this.size;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        try {
            color = this.getFeatureColor(string);
            n5 = this.getFeatureDecoration(string, n3);
            n4 = this.getLabelType();
            this.addItemToLegend(string, n3);
        }
        catch (NullPointerException nullPointerException) {
            color = new Color(0, 0, 128);
            if (this.colorScheme == 1) {
                color = new Color(0, 0, 128);
            } else if (this.colorScheme == 0) {
                color = new Color(0, 128, 128);
            }
            n5 = 1;
            n4 = 2;
        }
        Feature feature = new Feature(this.showShading);
        FeatureRange featureRange = new FeatureRange(feature, n, n2);
        featureRange.setDecoration(n5);
        featureRange.setColor(color);
        featureRange.setOpacity(this.opacity);
        featureRange.setShowLabel(n4);
        if (this.showPositions && (string.equalsIgnoreCase("restriction_site") || string.equalsIgnoreCase("unique_restriction_site"))) {
            featureRange.setLabel(string2 + " " + n);
        } else if (this.addCategoryInfo) {
            try {
                featureRange.setLabel(string2 + (String)this.FEATURE_CATEGORIES.get(string));
            }
            catch (NullPointerException nullPointerException) {
                featureRange.setLabel(string2);
            }
        } else {
            featureRange.setLabel(string2);
        }
        if (string.equalsIgnoreCase("restriction_site") || string.equalsIgnoreCase("unique_restriction_site")) {
            if (this.restrictionSlot == null) {
                this.restrictionSlot = new FeatureSlot(1, this.showShading);
                this.restrictionSlot.setFeatureThickness(1.0f);
            }
            feature.setFeatureSlot(this.restrictionSlot);
        } else if (n3 == 0 || n3 == 1) {
            if (this.forwardSlot0 == null) {
                this.forwardSlot0 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot0);
            } else if (this.forwardSlot0.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot0);
            } else if (this.forwardSlot1 == null) {
                this.forwardSlot1 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot1);
            } else if (this.forwardSlot1.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot1);
            } else if (this.forwardSlot2 == null) {
                this.forwardSlot2 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot2);
            } else if (this.forwardSlot2.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot2);
            } else if (this.forwardSlot3 == null) {
                this.forwardSlot3 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot3);
            } else if (this.forwardSlot3.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot3);
            } else if (this.forwardSlot4 == null) {
                this.forwardSlot4 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot4);
            } else if (this.forwardSlot4.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot4);
            } else if (this.forwardSlot5 == null) {
                this.forwardSlot5 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot5);
            } else if (this.forwardSlot5.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot5);
            } else if (this.forwardSlot6 == null) {
                this.forwardSlot6 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot6);
            } else if (this.forwardSlot6.isRoom(feature)) {
                feature.setFeatureSlot(this.forwardSlot6);
            } else if (this.forwardSlot7 == null) {
                this.forwardSlot7 = new FeatureSlot(1, this.showShading);
                feature.setFeatureSlot(this.forwardSlot7);
            } else {
                feature.setFeatureSlot(this.forwardSlot7);
            }
        } else if (n3 == 2) {
            if (this.reverseSlot0 == null) {
                this.reverseSlot0 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot0);
            } else if (this.reverseSlot0.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot0);
            } else if (this.reverseSlot1 == null) {
                this.reverseSlot1 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot1);
            } else if (this.reverseSlot1.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot1);
            } else if (this.reverseSlot2 == null) {
                this.reverseSlot2 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot2);
            } else if (this.reverseSlot2.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot2);
            } else if (this.reverseSlot3 == null) {
                this.reverseSlot3 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot3);
            } else if (this.reverseSlot3.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot3);
            } else if (this.reverseSlot4 == null) {
                this.reverseSlot4 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot4);
            } else if (this.reverseSlot4.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot4);
            } else if (this.reverseSlot5 == null) {
                this.reverseSlot5 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot5);
            } else if (this.reverseSlot5.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot5);
            } else if (this.reverseSlot6 == null) {
                this.reverseSlot6 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot6);
            } else if (this.reverseSlot6.isRoom(feature)) {
                feature.setFeatureSlot(this.reverseSlot6);
            } else if (this.reverseSlot7 == null) {
                this.reverseSlot7 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot7);
            } else {
                feature.setFeatureSlot(this.reverseSlot7);
            }
        }
    }

    private Color getFeatureColor(String string) throws NullPointerException {
        Color color = (Color)this.FEATURE_COLORS.get(string);
        if (this.colorScheme == 1) {
            color = (Color)this.FEATURE_COLORS.get(string);
        } else if (this.colorScheme == 0) {
            color = (Color)this.FEATURE_COLORS_INVERSE.get(string);
        }
        return color;
    }

    private int getFeatureDecoration(String string, int n) throws NullPointerException {
        int n2 = 1;
        n2 = !this.useArrows ? 1 : (n == 1 ? (Integer)this.FEATURE_DECORATIONS_DIRECT.get(string) : (n == 0 ? ((Integer)this.FEATURE_DECORATIONS_DIRECT.get(string)).intValue() : ((Integer)this.FEATURE_DECORATIONS_REVERSE.get(string)).intValue()));
        return n2;
    }

    private int getLabelType() throws NullPointerException {
        int n = 2;
        n = this.showLabels ? 2 : 1;
        return n;
    }

    private void addItemToLegend(String string, int n) throws NullPointerException {
        if (n == 0 || n == 1 || n == 2) {
            this.DRAW_LEGEND_ITEMS.put(string, new Boolean(true));
        }
    }

    public void setTitle(String string) {
        this.title = string.trim();
    }

    public void setMessage(String string) {
        this.message = string.trim();
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public void setShowTitle(boolean bl) {
        this.showTitle = bl;
    }

    public void setShowMessage(boolean bl) {
        this.showMessage = bl;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public void setAddCategoryInfo(boolean bl) {
        this.addCategoryInfo = bl;
    }

    public void setUseArrows(boolean bl) {
        this.useArrows = bl;
    }

    public void setUseColoredLabels(boolean bl) {
        this.useColoredLabels = bl;
    }

    public void setUseColoredLabelBackground(boolean bl) {
        this.useColoredLabelBackground = bl;
    }

    public void setColorScheme(int n) {
        this.colorScheme = n == 0 ? 0 : 1;
    }

    public void setDrawTickMarks(boolean bl) {
        this.drawTickMarks = bl;
    }

    public void setShowShading(boolean bl) {
        this.showShading = bl;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public void setLegendPosition(String string) {
        this.legendPosition = 3;
        if (string.equalsIgnoreCase("upper_right")) {
            this.legendPosition = 3;
        } else if (string.equalsIgnoreCase("upper_left")) {
            this.legendPosition = 1;
        } else if (string.equalsIgnoreCase("none")) {
            this.setShowLegend(false);
        }
    }

    public void setShowInnerLabels(boolean bl) {
        this.useInnerLabels = bl ? 1 : 2;
    }

    public void setBackboneThickness(String string) {
        try {
            this.backboneThickness = ((Float)this.BACKBONE_THICKNESSES.get(string)).floatValue();
        }
        catch (NullPointerException nullPointerException) {
            this.backboneThickness = ((Float)this.BACKBONE_THICKNESSES.get("medium")).floatValue();
        }
    }

    public void setFeatureThickness(String string) {
        try {
            this.featureThickness = ((Float)this.FEATURE_THICKNESSES.get(string)).floatValue();
        }
        catch (NullPointerException nullPointerException) {
            this.featureThickness = ((Float)this.FEATURE_THICKNESSES.get("medium")).floatValue();
        }
    }

    public void setImageWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.imageWidth = n;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.imageHeight = n;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    private void prepareToDraw() {
        LegendItem legendItem;
        int n;
        if (this.forwardSlot0 != null) {
            this.forwardSlot0.setCgview(this.p);
            this.forwardSlot0.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot1 != null) {
            this.forwardSlot1.setCgview(this.p);
            this.forwardSlot1.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot2 != null) {
            this.forwardSlot2.setCgview(this.p);
            this.forwardSlot2.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot3 != null) {
            this.forwardSlot3.setCgview(this.p);
            this.forwardSlot3.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot4 != null) {
            this.forwardSlot4.setCgview(this.p);
            this.forwardSlot4.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot5 != null) {
            this.forwardSlot5.setCgview(this.p);
            this.forwardSlot5.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot6 != null) {
            this.forwardSlot6.setCgview(this.p);
            this.forwardSlot6.setFeatureThickness(this.featureThickness);
        }
        if (this.forwardSlot7 != null) {
            this.forwardSlot7.setCgview(this.p);
            this.forwardSlot7.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot0 != null) {
            this.reverseSlot0.setCgview(this.p);
            this.reverseSlot0.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot1 != null) {
            this.reverseSlot1.setCgview(this.p);
            this.reverseSlot1.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot2 != null) {
            this.reverseSlot2.setCgview(this.p);
            this.reverseSlot2.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot3 != null) {
            this.reverseSlot3.setCgview(this.p);
            this.reverseSlot3.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot4 != null) {
            this.reverseSlot4.setCgview(this.p);
            this.reverseSlot4.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot5 != null) {
            this.reverseSlot5.setCgview(this.p);
            this.reverseSlot5.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot6 != null) {
            this.reverseSlot6.setCgview(this.p);
            this.reverseSlot6.setFeatureThickness(this.featureThickness);
        }
        if (this.reverseSlot7 != null) {
            this.reverseSlot7.setCgview(this.p);
            this.reverseSlot7.setFeatureThickness(this.featureThickness);
        }
        if (this.restrictionSlot != null) {
            this.restrictionSlot.setCgview(this.p);
            this.restrictionSlot.setFeatureThickness(this.featureThickness);
        }
        if (this.showTitle) {
            this.p.setTitle(this.title);
        }
        this.p.setWidth(this.imageWidth);
        this.p.setHeight(this.imageHeight);
        this.p.setLabelsToKeep(this.MAXLABELS);
        this.p.setDrawTickMarks(this.drawTickMarks);
        this.p.setTitleFont(this.titleFont);
        this.p.setLabelFont(this.labelFont);
        this.p.setFeatureThickness(this.featureThickness);
        this.p.setBackboneThickness(this.backboneThickness);
        this.p.setFeatureSlotSpacing(this.featureSpacing);
        this.p.setLegendFont(this.legendFont);
        this.p.setTickLength(this.tickLength);
        this.p.setLabelLineLength(this.labelLineLength);
        this.p.setLabelPlacementQuality(this.labelPlacementQuality);
        this.p.setUseColoredLabelBackgrounds(this.useColoredLabelBackground);
        this.p.setShowBorder(this.showBorder);
        this.p.setShowShading(this.showShading);
        this.p.setShadingProportion(this.shadingProportion);
        this.p.setUseInnerLabels(this.useInnerLabels);
        this.p.setMoveInnerLabelsToOuter(this.moveInnerLabelsToOuter);
        this.p.setWarningFont(this.rulerFont);
        this.p.setRulerFont(this.rulerFont);
        if (!this.showLabels) {
            this.p.setShowWarning(false);
        }
        if ((n = Math.min(this.imageWidth, this.imageHeight)) <= 750) {
            this.p.setBackboneRadius(0.5 * (double)n / 2.0);
        } else {
            this.p.setBackboneRadius(187.5);
        }
        if (!this.useColoredLabels) {
            if (this.colorScheme == 1) {
                this.p.setGlobalLabelColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            } else if (this.colorScheme == 0) {
                this.p.setGlobalLabelColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("titleFont"));
            }
        }
        if (this.colorScheme == 1) {
            this.p.setLongTickColor((Color)this.MAP_ITEM_COLORS.get("tick"));
            this.p.setShortTickColor((Color)this.MAP_ITEM_COLORS.get("partialTick"));
            this.p.setZeroTickColor((Color)this.MAP_ITEM_COLORS.get("zeroLine"));
            this.p.setRulerFontColor((Color)this.MAP_ITEM_COLORS.get("rulerFont"));
            this.p.setBackboneColor((Color)this.MAP_ITEM_COLORS.get("backbone"));
            this.p.setTitleFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            this.p.setWarningFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            this.p.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
        } else if (this.colorScheme == 0) {
            this.p.setLongTickColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("tick"));
            this.p.setShortTickColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("partialTick"));
            this.p.setZeroTickColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("zeroLine"));
            this.p.setRulerFontColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("rulerFont"));
            this.p.setBackboneColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("backbone"));
            this.p.setTitleFontColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("titleFont"));
            this.p.setWarningFontColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("titleFont"));
            this.p.setBackgroundColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("background"));
        }
        if (this.showLegend && this.DRAW_LEGEND_ITEMS.size() > 0) {
            this.legend = new Legend(this.p);
            this.legend.setAllowLabelClash(this.allowLabelClashLegend);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(this.legendFont);
            this.legend.setPosition(this.legendPosition);
            if (this.colorScheme == 1) {
                this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
                this.legend.setFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            } else if (this.colorScheme == 0) {
                this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("background"));
                this.legend.setFontColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("titleFont"));
            }
            Enumeration enumeration = this.DRAW_LEGEND_ITEMS.keys();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            Collections.sort(arrayList);
            for (String string : arrayList) {
                legendItem = new LegendItem(this.legend);
                legendItem.setDrawSwatch(1);
                legendItem.setLabel((String)this.LEGEND_ITEM_NAMES.get(string));
                if (this.colorScheme == 1) {
                    legendItem.setSwatchColor((Color)this.FEATURE_COLORS.get(string));
                    continue;
                }
                if (this.colorScheme != 0) continue;
                legendItem.setSwatchColor((Color)this.FEATURE_COLORS_INVERSE.get(string));
            }
        }
        if (this.showMessage) {
            this.legend = new Legend(this.p);
            this.legend.setAllowLabelClash(false);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(this.messageFont);
            this.legend.setPosition(11);
            if (this.colorScheme == 1) {
                this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
                this.legend.setFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
                legendItem = new LegendItem(this.legend);
                legendItem.setLabel(this.message);
                legendItem.setDrawSwatch(2);
            } else if (this.colorScheme == 0) {
                this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("background"));
                this.legend.setFontColor((Color)this.MAP_ITEM_COLORS_INVERSE.get("titleFont"));
                legendItem = new LegendItem(this.legend);
                legendItem.setLabel(this.message);
                legendItem.setDrawSwatch(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPNGFile(String string) throws IOException {
        this.prepareToDraw();
        BufferedImage bufferedImage = new BufferedImage(this.p.getWidth(), this.p.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.p.draw(graphics2D);
            System.out.println("Writing picture to " + string);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string));
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToJPGFile(String string) throws IOException {
        this.prepareToDraw();
        BufferedImage bufferedImage = new BufferedImage(this.p.getWidth(), this.p.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.p.draw(graphics2D);
            System.out.println("Writing picture to " + string);
            ImageIO.write((RenderedImage)bufferedImage, "JPG", new File(string));
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToSVGFile(String string, boolean bl, boolean bl2) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        this.prepareToDraw();
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setComment("Generated by CG-view with the Batik SVG Generator");
        sVGGeneratorContext.setPrecision(12);
        SVGGraphics2D sVGGraphics2D = bl ? new SVGGraphics2D(sVGGeneratorContext, true) : new SVGGraphics2D(sVGGeneratorContext, false);
        try {
            this.p.setMinimumFeatureLength(0.02);
            this.p.draw((Graphics2D)sVGGraphics2D);
            this.p.setMinimumFeatureLength(1.0);
            System.out.println("Writing picture to " + string);
            boolean bl3 = true;
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            if (bl2) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)gZIPOutputStream, "UTF-8");
                sVGGraphics2D.stream((Writer)outputStreamWriter, bl3);
                ((Writer)outputStreamWriter).flush();
                gZIPOutputStream.flush();
                ((Writer)outputStreamWriter).close();
                gZIPOutputStream.close();
            } else {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                sVGGraphics2D.stream((Writer)outputStreamWriter, bl3);
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
            }
        }
        finally {
            sVGGraphics2D.dispose();
        }
    }

    public void writeToSVGFile(String string) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        this.writeToSVGFile(string, true, false);
    }

    public void writeToSVGZFile(String string) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        this.writeToSVGFile(string, true, true);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        Plasmid plasmid = new Plasmid(4921);
        plasmid.setUseColoredLabelBackground(false);
        plasmid.setColorScheme(1);
        plasmid.setTitle("pGFP-1");
        plasmid.setShowTitle(true);
        plasmid.setAddCategoryInfo(true);
        plasmid.setImageWidth(1200);
        plasmid.setImageHeight(1000);
        plasmid.addFeature("restriction_site", "KpnI", 4624, 4624, n);
        plasmid.addFeature("restriction_site", "RsaI", 4622, 4622, n);
        plasmid.addFeature("restriction_site", "NdeII", 4704, 4704, n);
        plasmid.addFeature("restriction_site", "MboI", 4704, 4704, n);
        plasmid.addFeature("restriction_site", "HinfI", 4756, 4756, n);
        plasmid.addFeature("restriction_site", "HpaI", 4774, 4774, n);
        plasmid.addFeature("restriction_site", "HincII", 4774, 4774, n);
        plasmid.addFeature("restriction_site", "NdeII", 4793, 4793, n);
        plasmid.addFeature("restriction_site", "MboI", 4793, 4793, n);
        plasmid.addFeature("restriction_site", "SpeI", 4842, 4842, n);
        plasmid.addFeature("restriction_site", "HinfI", 4888, 4888, n);
        plasmid.addFeature("restriction_site", "AluI", 4905, 4905, n);
        plasmid.addFeature("restriction_site", "TaqI", 4957, 4957, n);
        plasmid.addFeature("restriction_site", "MspI", 4968, 4968, n);
        plasmid.addFeature("restriction_site", "HpaII", 4968, 4968, n);
        plasmid.addFeature("restriction_site", "BglII", 8, 8, n);
        plasmid.addFeature("restriction_site", "MboI", 8, 8, n);
        plasmid.addFeature("restriction_site", "NdeII", 8, 8, n);
        plasmid.addFeature("restriction_site", "HinfI", 14, 14, n);
        plasmid.addFeature("restriction_site", "HinfI", 41, 41, n);
        plasmid.addFeature("restriction_site", "RsaI", 78, 78, n);
        plasmid.addFeature("restriction_site", "MspI", 87, 87, n);
        plasmid.addFeature("restriction_site", "HpaII", 87, 87, n);
        plasmid.addFeature("restriction_site", "TaqI", 113, 113, n);
        plasmid.addFeature("restriction_site", "MboI", 158, 158, n);
        plasmid.addFeature("restriction_site", "NdeII", 158, 158, n);
        plasmid.addFeature("restriction_site", "MboI", 247, 247, n);
        plasmid.addFeature("restriction_site", "NdeII", 247, 247, n);
        plasmid.addFeature("restriction_site", "TaqI", 250, 250, n);
        plasmid.addFeature("restriction_site", "ClaI", 250, 250, n);
        plasmid.addFeature("restriction_site", "PvuI", 276, 276, n);
        plasmid.addFeature("restriction_site", "MboI", 273, 273, n);
        plasmid.addFeature("restriction_site", "NdeII", 273, 273, n);
        plasmid.addFeature("restriction_site", "BglII", 288, 288, n);
        plasmid.addFeature("restriction_site", "MboI", 288, 288, n);
        plasmid.addFeature("restriction_site", "NdeII", 288, 288, n);
        plasmid.addFeature("restriction_site", "PstI", 310, 310, n);
        plasmid.addFeature("promoter", "the promoter", 4000, 4050, n2);
        plasmid.addFeature("terminator", "T7 term", 6780, 100, n2);
        plasmid.addFeature("selectable_marker", "AmpR", 1500, 2500, n2);
        plasmid.addFeature("selectable_marker", "a longer marker label a longg label extending long", 700, 750, n3);
        plasmid.addFeature("reporter_gene", "GFP", 750, 800, n2);
        plasmid.addFeature("regulatory_sequence", "regulatory", 300, 342, n3);
        plasmid.addFeature("tag", "tag", 30, 50, n2);
        plasmid.addFeature("other_gene", "other gene", 70, 150, n3);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "EcoRI", 32, 32, n);
        plasmid.addFeature("unique_restriction_site", "XmaI", 578, 578, n);
        plasmid.addFeature("unique_restriction_site", "SmaI", 578, 578, n);
        plasmid.addFeature("unique_restriction_site", "XmeII", 578, 578, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 20, 20, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 250, 250, n);
        plasmid.addFeature("restriction_site", "BamHI", 500, 500, n);
        plasmid.addFeature("restriction_site", "BamHI", 500, 500, n);
        plasmid.addFeature("restriction_site", "BamHI", 500, 500, n);
        plasmid.addFeature("restriction_site", "BamHI", 500, 500, n);
        plasmid.addFeature("restriction_site", "BamHI", 500, 500, n);
        plasmid.addFeature("restriction_site", "BamHI", 750, 750, n);
        plasmid.addFeature("restriction_site", "XhoI", 757, 757, n);
        plasmid.addFeature("restriction_site", "BglII", 777, 777, n);
        plasmid.addFeature("restriction_site", "NotI", 785, 785, n);
        plasmid.addFeature("restriction_site", "PstI", 792, 792, n);
        plasmid.setMessage("This is a message");
        try {
            plasmid.writeToPNGFile("output.png");
        }
        catch (Exception exception) {
            System.err.println("Exception thrown in main");
        }
    }
}

