/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.LegendItem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Legend
implements CgviewConstants {
    private Font font;
    private Color fontColor;
    private Color backgroundColor;
    private float backgroundOpacity = 1.0f;
    private ArrayList legendItems = new ArrayList();
    private Cgview cgview;
    private int drawWhenZoomed = 1;
    private int position = 3;
    private Rectangle2D bounds;
    private double swatchHeight;
    private int textAlignment = 1;
    private boolean allowLabelClash = false;
    protected static final double PADDING = 5.0;

    public Legend(Cgview cgview) {
        this.cgview = cgview;
        this.font = cgview.getLegendFont();
        this.fontColor = cgview.getLegendTextColor();
        ArrayList arrayList = cgview.getLegends();
        arrayList.add(this);
    }

    protected void addLegendItem(LegendItem legendItem) {
        this.legendItems.add(legendItem);
    }

    protected void draw() {
        if (this.bounds == null) {
            this.setBounds();
        }
        if ((this.cgview.getZoomMultiplier() == 1.0 || this.drawWhenZoomed == 1) && this.legendItems.size() > 0 && this.bounds.getHeight() <= (double)this.cgview.getHeight() && this.bounds.getWidth() <= (double)this.cgview.getWidth()) {
            Graphics2D graphics2D = this.cgview.getGraphics();
            if (this.backgroundColor == null) {
                graphics2D.setPaint(this.cgview.getBackgroundColor());
            } else {
                graphics2D.setPaint(this.backgroundColor);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundOpacity));
            graphics2D.fill(this.bounds);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            Collections.reverse(this.legendItems);
            double d = this.bounds.getX() + 5.0;
            double d2 = this.bounds.getY() + this.bounds.getHeight() - 5.0;
            for (LegendItem legendItem : this.legendItems) {
                double d3 = legendItem.getHeight(this.cgview);
                if (legendItem.getDrawSwatch() == 1) {
                    legendItem.draw(this.cgview, d, d2, this.swatchHeight);
                    d2 = d2 - this.swatchHeight - this.swatchHeight / 2.0;
                    continue;
                }
                legendItem.draw(this.cgview, d, d2, 0.0);
                d2 = d2 - d3 - d3 / 2.0;
            }
            Collections.reverse(this.legendItems);
        } else if (this.bounds.getHeight() > (double)this.cgview.getHeight() || this.bounds.getWidth() > (double)this.cgview.getWidth()) {
            System.err.println("[warning] a legend was removed because it is too large for the canvas.");
            this.allowLabelClash = true;
        }
        this.bounds = null;
    }

    protected Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.setBounds();
        }
        return this.bounds;
    }

    protected void setBounds() {
        this.setBounds(this.cgview.getCenter().getX(), this.cgview.getCenter().getY());
    }

    protected void setBounds(double d, double d2) {
        double d3;
        double d4 = this.cgview.getWidth();
        double d5 = this.cgview.getHeight();
        this.swatchHeight = this.getSwatchHeight();
        double d6 = d3 = this.getWidestLegendItem(this.swatchHeight);
        double d7 = 0.0;
        double d8 = 0.0;
        Iterator iterator = this.legendItems.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            LegendItem legendItem = (LegendItem)iterator.next();
            d8 = legendItem.getHeight(this.cgview);
            if (legendItem.getDrawSwatch() == 1) {
                d7 += this.swatchHeight;
                if (!bl) {
                    d7 += this.swatchHeight / 2.0;
                }
            } else {
                d7 += d8;
                if (!bl) {
                    d7 += d8 / 2.0;
                }
            }
            bl = false;
        }
        d7 += 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        if (this.position == 1) {
            d9 = d - d4 / 2.0 + 5.0;
            d10 = d2 - d5 / 2.0 + 5.0;
        } else if (this.position == 2) {
            d9 = d - d6 / 2.0;
            d10 = d2 - d5 / 2.0 + 5.0;
        } else if (this.position == 3) {
            d9 = d + d4 / 2.0 - d6 - 5.0;
            d10 = d2 - d5 / 2.0 + 5.0;
        } else if (this.position == 4) {
            d9 = d - d4 / 2.0 + 5.0;
            d10 = d2 - d7 / 2.0;
        } else if (this.position == 5) {
            d9 = d - d6;
            d10 = d2 - d7 / 2.0;
        } else if (this.position == 6) {
            d9 = d - d6 / 2.0;
            d10 = d2 - d7 / 2.0;
        } else if (this.position == 7) {
            d9 = d;
            d10 = d2 - d7 / 2.0;
        } else if (this.position == 8) {
            d9 = d + d4 / 2.0 - d6 - 5.0;
            d10 = d2 - d7 / 2.0;
        } else if (this.position == 9) {
            d9 = d - d4 / 2.0 + 5.0;
            d10 = d2 + d5 / 2.0 - d7 - 5.0;
        } else if (this.position == 10) {
            d9 = d - d6 / 2.0;
            d10 = d2 + d5 / 2.0 - d7 - 5.0;
        } else if (this.position == 11) {
            d9 = d + d4 / 2.0 - d6 - 5.0;
            d10 = d2 + d5 / 2.0 - d7 - 5.0;
        } else {
            d9 = d + d4 / 2.0 - d6 - 5.0;
            d10 = d2 - d7 / 2.0;
        }
        this.bounds = new Rectangle2D.Double(d9, d10, d6, d7);
    }

    protected double getWidestLegendItem(double d) {
        double d2 = 0.0;
        for (LegendItem legendItem : this.legendItems) {
            double d3 = legendItem.getDrawSwatch() == 1 ? legendItem.getWidth(this.cgview, d) : legendItem.getWidth(this.cgview, 0.0);
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2 + 10.0;
    }

    protected double getSwatchHeight() {
        double d = 0.0;
        double d2 = 0.0;
        for (LegendItem legendItem : this.legendItems) {
            d2 = legendItem.getHeight(this.cgview);
            if (legendItem.getDrawSwatch() != 1 || !(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setDrawWhenZoomed(int n) {
        this.drawWhenZoomed = n;
    }

    public int getDrawWhenZoomed() {
        return this.drawWhenZoomed;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setAlignment(int n) {
        this.textAlignment = n;
    }

    public int getAlignment() {
        return this.textAlignment;
    }

    public void setBackgroundOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.backgroundOpacity = f;
    }

    public float getBackgroundOpacity() {
        return this.backgroundOpacity;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setAllowLabelClash(boolean bl) {
        this.allowLabelClash = bl;
    }

    public boolean getAllowLabelClash() {
        return this.allowLabelClash;
    }
}

