/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Label
implements CgviewConstants {
    protected String labelText;
    protected Color color;
    protected int strand;
    protected String hyperlink;
    protected String mouseover;
    protected double lineStartRadians;
    protected double lineStartRadius;
    protected double lineEndRadians;
    protected double lineEndRadius;
    protected boolean extendedRadius;
    protected double extendedLineStartRadius;
    protected double extendedLineEndRadius;
    protected boolean fixedInPlace;
    protected double allowedRadiansDelta;
    protected static double radiusShiftAmount;
    protected static double radiansShiftAmount;
    protected Rectangle2D unplacedBounds;
    protected Rectangle2D placedBounds;
    protected Font font;
    protected float descent;
    protected float ascent;
    protected boolean forceLabel;
    protected Cgview cgview;
    protected static double smallestDimension;
    protected static double RADIAN_SHIFT_PADDING;

    protected Label(Cgview cgview, String string, String string2, String string3, Font font, Color color, boolean bl, double d, int n) {
        Pattern pattern;
        Matcher matcher;
        this.cgview = cgview;
        this.labelText = string;
        this.hyperlink = string2;
        this.mouseover = string3;
        this.color = color;
        this.forceLabel = bl;
        this.lineStartRadians = d;
        this.strand = n;
        if (this.labelText == null) {
            this.labelText = "Untitled";
        }
        if (!(matcher = (pattern = Pattern.compile("\\S")).matcher(this.labelText)).find()) {
            this.labelText = "Untitled";
        }
        this.font = font != null ? font : cgview.getLabelFont();
        this.lineEndRadians = d;
        this.allowedRadiansDelta = Math.abs(Math.sin(d)) > 0.7 ? 0.39269908169872414 : 0.6283185307179586;
        this.extendedRadius = false;
        this.fixedInPlace = false;
        Graphics2D graphics2D = cgview.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.labelText, this.font, fontRenderContext);
        this.unplacedBounds = textLayout.getBounds();
        this.placedBounds = textLayout.getBounds();
        this.descent = textLayout.getDescent();
        this.ascent = textLayout.getAscent();
        if (smallestDimension == 0.0) {
            smallestDimension = this.unplacedBounds.getWidth() > this.unplacedBounds.getHeight() ? this.unplacedBounds.getHeight() : this.unplacedBounds.getWidth();
        } else {
            if (this.unplacedBounds.getWidth() < smallestDimension) {
                smallestDimension = this.unplacedBounds.getWidth();
            }
            if (this.unplacedBounds.getHeight() < smallestDimension) {
                smallestDimension = this.unplacedBounds.getHeight();
            }
        }
        radiusShiftAmount = cgview.getRadiusShiftAmount();
        radiansShiftAmount = smallestDimension / 2.0 / cgview.getLastOuterFeatureRadius();
    }

    protected abstract void drawLabelText();

    protected abstract void drawLabelLine();

    protected void drawLine(double d, double d2, double d3, double d4) {
        Graphics2D graphics2D = this.cgview.getGraphics();
        float f = this.cgview.getLabelLineThickness();
        double d5 = Math.cos(d2) * d;
        double d6 = Math.sin(d2) * d;
        double d7 = Math.cos(d4) * d3;
        double d8 = Math.sin(d4) * d3;
        if (this.cgview.getGlobalLabelColor() != null) {
            graphics2D.setPaint(this.cgview.getGlobalLabelColor());
        } else {
            graphics2D.setPaint(this.color);
        }
        graphics2D.setStroke(new BasicStroke(f, 1, 0));
        graphics2D.draw(new Line2D.Double(d5, d6, d7, d8));
    }

    protected void drawLine(double d, double d2, double d3, double d4, Area area) {
        Graphics2D graphics2D = this.cgview.getGraphics();
        float f = this.cgview.getLabelLineThickness();
        double d5 = Math.cos(d2) * d;
        double d6 = Math.sin(d2) * d;
        double d7 = Math.cos(d4) * d3;
        double d8 = Math.sin(d4) * d3;
        if (this.cgview.getGlobalLabelColor() != null) {
            graphics2D.setPaint(this.cgview.getGlobalLabelColor());
        } else {
            graphics2D.setPaint(this.color);
        }
        BasicStroke basicStroke = new BasicStroke(f, 1, 0);
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d5, d6, d7, d8))));
        graphics2D.fill(area);
    }

    protected Area getLineAsArea(double d, double d2, double d3, double d4) {
        Graphics2D graphics2D = this.cgview.getGraphics();
        float f = this.cgview.getLabelLineThickness();
        double d5 = Math.cos(d2) * d;
        double d6 = Math.sin(d2) * d;
        double d7 = Math.cos(d4) * d3;
        double d8 = Math.sin(d4) * d3;
        Area area = new Area();
        BasicStroke basicStroke = new BasicStroke(f, 1, 0);
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d5, d6, d7, d8))));
        return area;
    }

    protected Point2D getLineStart() {
        return new Point2D.Double(Math.cos(this.lineStartRadians) * this.lineStartRadius, Math.sin(this.lineStartRadians) * this.lineStartRadius);
    }

    protected double getLineStartRadians() {
        return this.lineStartRadians;
    }

    protected double getLineEndRadians() {
        return this.lineEndRadians;
    }

    protected boolean isExtendedRadius() {
        return this.extendedRadius;
    }

    protected double getLineStartRadius() {
        return this.lineStartRadius;
    }

    protected double getLineEndRadius() {
        return this.lineEndRadius;
    }

    protected double getExtendedLineEndRadius() {
        return this.extendedLineEndRadius;
    }

    protected boolean getForceLabel() {
        return this.forceLabel;
    }

    protected abstract void updateBounds();

    protected abstract void updateBounds(double var1);

    protected Rectangle2D getBounds() {
        return this.placedBounds;
    }

    protected boolean clashes(Label label) {
        return this.getBounds().intersects(label.getBounds());
    }

    protected abstract boolean clashesWithAny();

    protected final boolean shiftRadiansLower() {
        if (Math.abs(this.lineStartRadians - (this.lineEndRadians - radiansShiftAmount)) < this.allowedRadiansDelta) {
            this.lineEndRadians -= radiansShiftAmount;
            this.updateBounds(3.0);
            return true;
        }
        return false;
    }

    protected final boolean shiftRadiansHigher() {
        if (Math.abs(this.lineStartRadians - (this.lineEndRadians + radiansShiftAmount)) < this.allowedRadiansDelta) {
            this.lineEndRadians += radiansShiftAmount;
            this.updateBounds(3.0);
            return true;
        }
        return false;
    }

    protected boolean shiftRadiansToOriginal(ArrayList arrayList) {
        if (this.lineEndRadians == this.lineStartRadians) {
            return false;
        }
        if (Math.abs(this.lineStartRadians - this.lineEndRadians) <= radiansShiftAmount) {
            double d = this.lineEndRadians;
            this.lineEndRadians = this.lineStartRadians;
            this.updateBounds(3.0);
            if (this.clashesWithAny(arrayList)) {
                this.lineEndRadians = d;
                this.updateBounds(3.0);
                return false;
            }
            return false;
        }
        if (this.lineStartRadians < this.lineEndRadians) {
            this.shiftRadiansLower();
            if (this.clashesWithAny(arrayList)) {
                this.shiftRadiansHigher();
                return false;
            }
            return true;
        }
        if (this.lineStartRadians > this.lineEndRadians) {
            this.shiftRadiansHigher();
            if (this.clashesWithAny(arrayList)) {
                this.shiftRadiansLower();
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract boolean extendRadius();

    protected abstract void setLineStartRadius(double var1);

    protected boolean clashesWithAny(ArrayList arrayList) {
        if (arrayList.size() < 2) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Label label = (Label)arrayList.get(i);
            if (arrayList.indexOf(this) == i || !this.clashes(label)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean fitsInBackground();

    protected void setHyperlink(String string) {
        this.hyperlink = string;
    }

    protected String getHyperlink() {
        return this.hyperlink;
    }

    protected String getLabelText() {
        return this.labelText;
    }

    protected void setMouseover(String string) {
        this.mouseover = string;
    }

    protected String getMouseover() {
        return this.mouseover;
    }

    static {
        smallestDimension = 0.0;
        RADIAN_SHIFT_PADDING = 3.0;
    }
}

