/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.FeatureRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FeatureSlot
implements CgviewConstants {
    private int strand;
    private ArrayList featuresInSlot = new ArrayList();
    private double radius = 0.0;
    private Cgview cgview;
    private float featureThickness;
    private boolean showShading;
    private double minimumFeatureLength;

    public FeatureSlot(Cgview cgview, int n) {
        this.strand = n;
        this.cgview = cgview;
        this.featureThickness = cgview.getFeatureThickness();
        this.showShading = cgview.getShowShading();
        this.minimumFeatureLength = cgview.getMinimumFeatureLength();
        ArrayList arrayList = cgview.getFeatureSlots();
        arrayList.add(this);
    }

    public FeatureSlot(int n) {
        this.strand = n;
    }

    public FeatureSlot(int n, boolean bl) {
        this.strand = n;
        this.showShading = bl;
    }

    public void setCgview(Cgview cgview) {
        this.cgview = cgview;
        this.featureThickness = cgview.getFeatureThickness();
        this.showShading = cgview.getShowShading();
        this.minimumFeatureLength = cgview.getMinimumFeatureLength();
        ArrayList arrayList = cgview.getFeatureSlots();
        arrayList.add(this);
    }

    protected void addFeature(Feature feature) {
        this.featuresInSlot.add(feature);
    }

    public int getStrand() {
        return this.strand;
    }

    public void setMinimumFeatureLength(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.minimumFeatureLength = d;
    }

    public double getMinimumFeatureLength() {
        return this.minimumFeatureLength;
    }

    public void setFeatureThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.featureThickness = f;
    }

    public float getFeatureThickness() {
        return this.featureThickness;
    }

    public void setShowShading(boolean bl) {
        this.showShading = bl;
    }

    public boolean getShowShading() {
        return this.showShading;
    }

    protected void setRadius() {
        if (this.strand == 1) {
            this.radius = this.cgview.getFirstOuterFeatureRadius();
            ArrayList arrayList = this.cgview.getFeatureSlots();
            for (FeatureSlot featureSlot : arrayList) {
                if (featureSlot.getStrand() != 1) continue;
                if (featureSlot.equals(this)) {
                    this.radius += 0.5 * (double)this.featureThickness;
                    break;
                }
                this.radius = this.radius + (double)featureSlot.getFeatureThickness() + this.cgview.getFeatureSlotSpacing();
            }
        } else {
            this.radius = this.cgview.getFirstInnerFeatureRadius();
            ArrayList arrayList = this.cgview.getFeatureSlots();
            for (FeatureSlot featureSlot : arrayList) {
                if (featureSlot.getStrand() != 2) continue;
                if (featureSlot.equals(this)) {
                    this.radius -= 0.5 * (double)this.featureThickness;
                    break;
                }
                this.radius = this.radius - (double)featureSlot.getFeatureThickness() - this.cgview.getFeatureSlotSpacing();
            }
        }
    }

    public double getBasesPerMinFeature(double d) {
        this.setRadius();
        double d2 = this.cgview.adjustZoom(d);
        double d3 = (double)this.cgview.getSequenceLength() / (Math.PI * 2 * this.radius * d2);
        return this.getMinimumFeatureLength() * d3;
    }

    protected void draw() {
        this.setRadius();
        for (Feature feature : this.featuresInSlot) {
            feature.draw(this.cgview, this.radius, this.featureThickness, this.minimumFeatureLength);
        }
    }

    public boolean isRoom(Feature feature) {
        for (Feature feature2 : this.featuresInSlot) {
            for (FeatureRange featureRange : feature2.getRanges()) {
                if (featureRange.getDecoration() == 4) continue;
                int n = featureRange.getStart();
                int n2 = featureRange.getStop();
                for (FeatureRange featureRange2 : feature.getRanges()) {
                    if (featureRange2.getDecoration() == 4) continue;
                    int n3 = featureRange2.getStart();
                    int n4 = featureRange2.getStop();
                    if (n < n2 && n3 < n4) {
                        if (n3 > n2 || n4 < n) continue;
                        return false;
                    }
                    if (n > n2 && n3 > n4) {
                        return false;
                    }
                    if (n < n2 && n3 > n2 && n4 < n || n3 < n4 && n > n4 && n2 < n3) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void sortFeaturesByStart() {
        SortFeaturesByStart sortFeaturesByStart = new SortFeaturesByStart();
        Collections.sort(this.featuresInSlot, sortFeaturesByStart);
        if (this.strand == 1) {
            Collections.reverse(this.featuresInSlot);
        }
    }

    public class SortFeaturesByStart
    implements Comparator {
        public int compare(Object object, Object object2) {
            Feature feature = (Feature)object;
            Feature feature2 = (Feature)object2;
            if (feature.getStart() == feature2.getStart()) {
                return 0;
            }
            if (feature2.getStart() < feature.getStart()) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean equals(Object object) {
            return object.equals(this);
        }
    }
}

