/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.CgviewFactory;
import ca.ualberta.stothard.cgview.CgviewFactoryPtt;
import ca.ualberta.stothard.cgview.CgviewFactoryTab;
import ca.ualberta.stothard.cgview.CgviewHTMLDocument;
import ca.ualberta.stothard.cgview.FileMover;
import ca.ualberta.stothard.cgview.LabelBounds;
import ca.ualberta.stothard.cgview.SeriesImage;
import ca.ualberta.stothard.cgview.SortSeriesImageByZoomCenter;
import jargs.gnu.CmdLineParser;
import java.awt.Graphics2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CgviewIO
implements CgviewConstants {
    private static String outputDirectory;
    private static Integer legendValue;
    private static Boolean useOverlibValue;
    private static Integer heightValue;
    private static Integer widthValue;
    private static Boolean excludeSVGValue;
    private static Boolean useExternalStylesheetValue;
    private static Integer useInnerLabelsValue;
    private static Boolean removeLabelsValue;
    private static Boolean removeLegendsValue;
    private static String seriesValue;
    private static String seriesNumbersValue;
    private static Boolean embedFontsValue;
    private static Integer legendFontValue;
    private static Integer rulerFontValue;
    private static Integer labelFontValue;
    private static Double tickDensityValue;
    private static final String PROBLEM_MESSAGE = "The following error occurred: ";
    private static final String INCLUDES_PATH = "includes";
    private static final String INCLUDES_OUT_PATH = "includes";
    private static final String PNG_OUT_PATH = "png";
    private static final String SVG_OUT_PATH = "svg";
    private static final String ZOOM_IN_BUTTON = "expand_in.png";
    private static final String ZOOM_IN_BUTTON_OFF = "expand_in_g.png";
    private static final String ZOOM_OUT_BUTTON = "expand_out.png";
    private static final String ZOOM_OUT_BUTTON_OFF = "expand_out_g.png";
    private static final String INDEX_BUTTON = "full.png";
    private static final String INDEX_BUTTON_OFF = "full_g.png";
    private static final String MOVE_FORWARD_BUTTON = "move_forward.png";
    private static final String MOVE_FORWARD_BUTTON_OFF = "move_forward_g.png";
    private static final String MOVE_BACK_BUTTON = "move_back.png";
    private static final String MOVE_BACK_BUTTON_OFF = "move_back_g.png";
    private static final String TO_SVG_BUTTON = "as_svg.png";
    private static final String TO_PNG_BUTTON = "as_png.png";
    private static final String HELP_BUTTON = "help.png";
    private static final String HELP_FILE = "help.html";
    private static final String HELP_FILE_PNG = "help_png.html";
    private static final String STYLE_FILE = "stylesheet.css";
    private static final String SVG_JAVASCRIPT = "info.js";
    private static final String OVERLIB_JAVASCRIPT = "overlib.js";
    private static final String EXTERNAL_LEGEND = "legend.png";

    private static void printUsage() {
        System.err.println("usage: java -jar cgview.jar [OPTION]...");
        System.err.println("-A <integer> Specifies a label font size.");
        System.err.println("-c <integer> Specifies the base to center on when zooming.");
        System.err.println("-D <integer> Specifies a legend font size.");
        System.err.println("-d <real> Specifies tick density, between 0 and 1.0. Default is 1.0.");
        System.err.println("-E <boolean> Whether or not to embed vector-based text in SVG output.");
        System.err.println("-e <boolean> Whether or not to exclude SVG output from image series.");
        System.err.println("-f <format> The format of the output: PNG, JPG, SVG, or SVGZ.");
        System.err.println("-h <file> HTML file to create.");
        System.err.println("-H <integer> The height of the map.");
        System.err.println("-i <file> The input file to parse.");
        System.err.println("-I <boolean> Whether or not to draw labels on the inside of the backbone circle.");
        System.err.println("-L <integer> The width of an external legend.");
        System.err.println("-o <file> The image file to create.");
        System.err.println("-p <path> The path to the image file in the HTML file created using the -h option.");
        System.err.println("-r <boolean> Whether or not to remove legends.");
        System.err.println("-R <boolean> Whether or not to remove labels.");
        System.err.println("-s <directory> Directory to receive an image series.");
        System.err.println("-S <boolean> Whether or not to reference external stylesheet in HTML output.");
        System.err.println("-u <boolean> Whether or not to reference overlib.js in HTML output.");
        System.err.println("-U <integer> Specifies a sequence ruler font size.");
        System.err.println("-W <integer> The width of the map.");
        System.err.println("-x <string> Comma separated zoom values for image series.");
        System.err.println("-z <real> The factor to zoom in by.");
        System.err.println("Example usage: java -jar cgview.jar -f png -i cybercell.xml -o my_picture.png -h view_image.html.");
        System.err.println("Example usage: java -jar cgview.jar -i cybercell.xml -s directory_for_series -e true.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToSVGFile(Cgview cgview, String string, boolean bl, boolean bl2, int n, boolean bl3) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, SVG_OUT_PATH, null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setComment("Generated by CGView (written by Paul Stothard, University of Alberta) using the Batik SVG Generator");
        sVGGeneratorContext.setPrecision(12);
        SVGGraphics2D sVGGraphics2D = bl ? new SVGGraphics2D(sVGGeneratorContext, true) : new SVGGraphics2D(sVGGeneratorContext, false);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object52;
            if (cgview.getDesiredZoom() > 1.0) {
                cgview.drawZoomed((Graphics2D)sVGGraphics2D, cgview.getDesiredZoom(), cgview.getDesiredZoomCenter(), bl3);
            } else {
                cgview.draw((Graphics2D)sVGGraphics2D, bl3);
            }
            Element element = sVGGraphics2D.getRoot();
            element.setAttributeNS(null, "width", Integer.toString(cgview.getWidth()));
            element.setAttributeNS(null, "height", Integer.toString(cgview.getHeight()));
            Document document2 = sVGGraphics2D.getDOMFactory();
            ArrayList arrayList = cgview.getLabelBounds();
            boolean bl4 = false;
            for (Object object52 : arrayList) {
                if (!((LabelBounds)object52).getUse() || ((LabelBounds)object52).getMouseover() == null && (((LabelBounds)object52).getType() != 1 || n <= 0)) continue;
                bl4 = true;
            }
            if (bl4) {
                object52 = document2.createElementNS(null, "script");
                if (n == -1) {
                    object4 = "//Written by Paul Stothard, University of Alberta, Canada 2004\nfunction showMouseover(evt, message) {var PADDING = 8; var X_SHIFT = 20; var Y_SHIFT = 20; var svgDoc = evt.target.ownerDocument; var translateX = svgDoc.rootElement.currentTranslate.x; var translateY = svgDoc.rootElement.currentTranslate.y; var scale = 1 / svgDoc.rootElement.currentScale; var effectiveDocWidth = svgDoc.rootElement.getAttribute(\"width\") - translateX; var effectiveDocHeight = svgDoc.rootElement.getAttribute(\"height\") - translateY; var targetText = svgDoc.getElementById(\"mouseoverBox\"); var x = evt.clientX - translateX + X_SHIFT; var y = evt.clientY - translateY + Y_SHIFT; var newText = svgDoc.createTextNode(message); targetText.replaceChild(newText, targetText.firstChild); var textBounds = targetText.getBBox(); y = y + textBounds.height; if (x + textBounds.width + PADDING > effectiveDocWidth) {x = x - (x + textBounds.width + PADDING - effectiveDocWidth); if (y > effectiveDocWidth / 2) { y = y - Y_SHIFT - Y_SHIFT - textBounds.height; } else {}} if (y + textBounds.height + PADDING > effectiveDocHeight) {y = y - (y + textBounds.height + PADDING - effectiveDocHeight); } if (x - PADDING < 0) {x = 0 + PADDING;} if (y - textBounds.height - PADDING < 0) {y = 0 + textBounds.height + PADDING;}targetText.setAttribute(\"x\", x); targetText.setAttribute(\"y\", y); textBounds = targetText.getBBox(); targetTextBackground = svgDoc.getElementById(\"mouseoverBoxBackground\"); targetTextBackground.setAttribute(\"transform\", \"scale(\" + scale + \",\" + scale + \")\"); targetTextBackground.setAttribute(\"x\", textBounds.x - PADDING / 2); targetTextBackground.setAttribute(\"y\", textBounds.y - PADDING / 2); targetTextBackground.setAttribute(\"width\", textBounds.width + PADDING); targetTextBackground.setAttribute(\"height\", textBounds.height + PADDING); targetText.setAttribute(\"transform\", \"scale(\" + scale + \",\" + scale + \")\");} function showMouseout(evt) {var svgDoc = evt.target.ownerDocument; var targetText = svgDoc.getElementById(\"mouseoverBox\"); var newText = svgDoc.createTextNode(\"\"); targetText.setAttribute(\"x\", 0); targetText.setAttribute(\"y\", 0); targetText.replaceChild(newText, targetText.firstChild); targetTextBackground = svgDoc.getElementById(\"mouseoverBoxBackground\"); targetTextBackground.setAttribute(\"x\", 0); targetTextBackground.setAttribute(\"y\", 0); targetTextBackground.setAttribute(\"width\", 0); targetTextBackground.setAttribute(\"height\", 0);}";
                    object52.setAttributeNS(null, "type", "text/javascript");
                    object3 = document2.createCDATASection((String)object4);
                    object52.appendChild((Node)object3);
                } else {
                    object52.setAttributeNS(null, "type", "text/javascript");
                    object52.setAttributeNS(null, "xlink:href", "../includes/info.js");
                }
                element.appendChild((Node)object52);
                object4 = document2.createElementNS(null, "rect");
                object4.setAttributeNS(null, "id", "mouseoverBoxBackground");
                object4.setAttributeNS(null, "x", "0");
                object4.setAttributeNS(null, "y", "0");
                object4.setAttributeNS(null, "width", "0");
                object4.setAttributeNS(null, "height", "0");
                object4.setAttributeNS(null, "style", "fill: rgb(204,204,255); stroke: rgb(51,51,153); stroke-width:1");
                element.appendChild((Node)object4);
                object3 = document2.createElementNS(null, "text");
                object3.setAttributeNS(null, "id", "mouseoverBox");
                object3.setAttributeNS(null, "x", "0");
                object3.setAttributeNS(null, "y", "0");
                object3.setAttributeNS(null, "style", "fill:black; stroke:none; font-family:Arial; font-size:12");
                object2 = document2.createTextNode(" ");
                object3.appendChild((Node)object2);
                element.appendChild((Node)object3);
            }
            Iterator iterator = arrayList.iterator();
            object52 = NumberFormat.getInstance();
            while (iterator.hasNext()) {
                object4 = (LabelBounds)iterator.next();
                object3 = ((LabelBounds)object4).getBounds();
                if (n > 0 && ((LabelBounds)object4).getType() == 1) {
                    ((LabelBounds)object4).setHyperlink("../" + Integer.toString(n) + "_" + Integer.toString(((LabelBounds)object4).getBase()) + ".html");
                    ((LabelBounds)object4).setMouseover("expand " + ((NumberFormat)object52).format(((LabelBounds)object4).getBase()) + " bp region");
                }
                if (!((LabelBounds)object4).getUse() || ((LabelBounds)object4).getMouseover() == null && ((LabelBounds)object4).getHyperlink() == null) continue;
                object2 = document2.createElementNS(null, "rect");
                object2.setAttributeNS(null, "x", Double.toString(((RectangularShape)object3).getX()));
                object2.setAttributeNS(null, "y", Double.toString(((RectangularShape)object3).getY()));
                object2.setAttributeNS(null, "width", Double.toString(((RectangularShape)object3).getWidth()));
                object2.setAttributeNS(null, "height", Double.toString(((RectangularShape)object3).getHeight()));
                object2.setAttributeNS(null, "style", "fill:none; stroke:none");
                object2.setAttributeNS(null, "pointer-events", "fill");
                if (((LabelBounds)object4).getMouseover() != null && !((LabelBounds)object4).getMouseover().matches("\\S*")) {
                    object2.setAttributeNS(null, "onmouseover", "showMouseover(evt, \"" + StringEscapeUtils.escapeXml((String)((LabelBounds)object4).getMouseover()) + "\")");
                    object2.setAttributeNS(null, "onmouseout", "showMouseout(evt)");
                }
                if (((LabelBounds)object4).getHyperlink() != null) {
                    object = document2.createElementNS(null, "a");
                    object.setAttributeNS(null, "xlink:href", StringEscapeUtils.escapeXml((String)((LabelBounds)object4).getHyperlink()));
                    object.appendChild((Node)object2);
                    element.appendChild((Node)object);
                    continue;
                }
                element.appendChild((Node)object2);
            }
            System.out.println("Writing picture to " + string);
            boolean bl5 = true;
            object3 = new FileOutputStream(new File(string));
            if (bl2) {
                object2 = new GZIPOutputStream((OutputStream)object3);
                object = new OutputStreamWriter((OutputStream)object2, "UTF-8");
                sVGGraphics2D.stream(element, (Writer)object, bl5);
                ((Writer)object).flush();
                ((DeflaterOutputStream)object2).flush();
                ((Writer)object).close();
                ((DeflaterOutputStream)object2).close();
            } else {
                object2 = new OutputStreamWriter((OutputStream)object3, "UTF-8");
                sVGGraphics2D.stream(element, (Writer)object2, bl5);
                ((Writer)object2).flush();
                ((Writer)object2).close();
            }
        }
        finally {
            sVGGraphics2D.dispose();
        }
    }

    public static void writeToSVGFile(Cgview cgview, String string, boolean bl, boolean bl2) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        CgviewIO.writeToSVGFile(cgview, string, bl, bl2, -1, false);
    }

    public static void writeToSVGFile(Cgview cgview, String string, boolean bl, boolean bl2, boolean bl3) throws FileNotFoundException, IOException, UnsupportedEncodingException, SVGGraphics2DIOException {
        CgviewIO.writeToSVGFile(cgview, string, bl, bl2, -1, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToPNGFile(Cgview cgview, String string, boolean bl) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(cgview.getWidth(), cgview.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            if (cgview.getDesiredZoom() > 1.0) {
                cgview.drawZoomed(graphics2D, cgview.getDesiredZoom(), cgview.getDesiredZoomCenter(), bl);
            } else {
                cgview.draw(graphics2D, bl);
            }
            System.out.println("Writing picture to " + string);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string));
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static void writeToPNGFile(Cgview cgview, String string) throws IOException {
        CgviewIO.writeToPNGFile(cgview, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToJPGFile(Cgview cgview, String string, boolean bl) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(cgview.getWidth(), cgview.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            if (cgview.getDesiredZoom() > 1.0) {
                cgview.drawZoomed(graphics2D, cgview.getDesiredZoom(), cgview.getDesiredZoomCenter(), bl);
            } else {
                cgview.draw(graphics2D, bl);
            }
            System.out.println("Writing picture to " + string);
            ImageIO.write((RenderedImage)bufferedImage, "JPG", new File(string));
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static void writeToJPGFile(Cgview cgview, String string) throws IOException {
        CgviewIO.writeToJPGFile(cgview, string, false);
    }

    private static void writeHTMLFile(Cgview cgview, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws FileNotFoundException, IOException {
        Iterator iterator;
        Object object;
        int n = legendValue == null ? cgview.getWidth() : cgview.getWidth() + legendValue;
        String string8 = cgview.getTitle() == null || cgview.getTitle().equals("") ? "CGView map" : cgview.getTitle();
        CgviewHTMLDocument cgviewHTMLDocument = new CgviewHTMLDocument();
        cgviewHTMLDocument.addHeader(string8, Double.toString(cgview.getDesiredZoom()), Integer.toString(cgview.getDesiredZoomCenter()), string2, useOverlibValue, useExternalStylesheetValue);
        cgviewHTMLDocument.addTableStart(n);
        cgviewHTMLDocument.addTableRowStart();
        if (seriesValue != null) {
            cgviewHTMLDocument.addTableColumnCenterStart();
        } else {
            cgviewHTMLDocument.addTableColumnStart();
        }
        cgviewHTMLDocument.addTableStart(n, 1);
        cgviewHTMLDocument.addTableRowStart();
        if (seriesValue != null) {
            cgviewHTMLDocument.addTableColumnCenterStart();
        } else {
            cgviewHTMLDocument.addTableColumnStart();
        }
        if (string2.equalsIgnoreCase(PNG_OUT_PATH) || string2.equalsIgnoreCase("jpg")) {
            object = cgview.getLabelBounds();
            boolean bl = false;
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                LabelBounds labelBounds = (LabelBounds)iterator.next();
                if (!labelBounds.getUse() || labelBounds.getMouseover() == null && labelBounds.getHyperlink() == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                cgviewHTMLDocument.addImageMap(string, cgview.getWidth(), cgview.getHeight(), (ArrayList)object, useOverlibValue);
            } else {
                cgviewHTMLDocument.addImage(string, cgview.getWidth(), cgview.getHeight());
            }
        } else if (string2.equalsIgnoreCase(SVG_OUT_PATH) || string2.equalsIgnoreCase("svgz")) {
            cgviewHTMLDocument.addSVG(string, cgview.getWidth(), cgview.getHeight());
        }
        cgviewHTMLDocument.addTableColumnEnd();
        if (legendValue != null) {
            if (seriesValue != null) {
                cgviewHTMLDocument.addTableColumnCenterStart();
                cgviewHTMLDocument.addImage("includes/legend.png", legendValue, cgview.getHeight(), "Legend Image");
            } else {
                cgviewHTMLDocument.addTableColumnStart();
                cgviewHTMLDocument.addImage(EXTERNAL_LEGEND, legendValue, cgview.getHeight(), "Legend Image");
            }
            cgviewHTMLDocument.addTableColumnEnd();
        }
        cgviewHTMLDocument.addTableRowEnd();
        cgviewHTMLDocument.addTableEnd();
        cgviewHTMLDocument.addTableColumnEnd();
        cgviewHTMLDocument.addTableRowEnd();
        if (seriesValue != null) {
            cgviewHTMLDocument.addTableRowStart();
            cgviewHTMLDocument.addTableColumnCenterStart();
            if (string4 != null) {
                cgviewHTMLDocument.addButton("includes/expand_out.png", string4, "[Expand -]");
            } else {
                cgviewHTMLDocument.addButtonNoLink("includes/expand_out_g.png", "[Expand -]");
            }
            if (string5 != null) {
                cgviewHTMLDocument.addButton("includes/expand_in.png", string5, "[Expand +]");
            } else {
                cgviewHTMLDocument.addButtonNoLink("includes/expand_in_g.png", "[Expand +]");
            }
            if (string4 != null) {
                if (string2.equalsIgnoreCase("svgz")) {
                    cgviewHTMLDocument.addButton("includes/full.png", "index.html", "[Full view]");
                } else if (string2.equalsIgnoreCase(PNG_OUT_PATH)) {
                    cgviewHTMLDocument.addButton("includes/full.png", "index.html", "[Full view]");
                }
            } else {
                cgviewHTMLDocument.addButtonNoLink("includes/full_g.png", "[Full view]");
            }
            if (string7 != null) {
                cgviewHTMLDocument.addButton("includes/move_back.png", string7, "[Rotate -]");
            } else {
                cgviewHTMLDocument.addButtonNoLink("includes/move_back_g.png", "[Rotate -]");
            }
            if (string6 != null) {
                cgviewHTMLDocument.addButton("includes/move_forward.png", string6, "[Rotate +]");
            } else {
                cgviewHTMLDocument.addButtonNoLink("includes/move_forward_g.png", "[Rotate +]");
            }
            if (!excludeSVGValue.booleanValue()) {
                if (string2.equalsIgnoreCase("svgz")) {
                    cgviewHTMLDocument.addButton("includes/as_png.png", Integer.toString((int)cgview.getDesiredZoom()) + "_" + Integer.toString(cgview.getDesiredZoomCenter()) + ".html", "[View as PNG]");
                } else if (string2.equalsIgnoreCase(PNG_OUT_PATH)) {
                    cgviewHTMLDocument.addButton("includes/as_svg.png", Integer.toString((int)cgview.getDesiredZoom()) + "_" + Integer.toString(cgview.getDesiredZoomCenter()) + "_svg.html", "[View as SVG]");
                }
            }
            if (!excludeSVGValue.booleanValue()) {
                cgviewHTMLDocument.addButton("includes/help.png", "includes/help.html", "[Help]");
            } else {
                cgviewHTMLDocument.addButton("includes/help.png", "includes/help_png.html", "[Help]");
            }
            cgviewHTMLDocument.addTableColumnEnd();
            cgviewHTMLDocument.addTableRowEnd();
            cgviewHTMLDocument.addTableRowStart();
            cgviewHTMLDocument.addTableColumnCenterStart();
            cgviewHTMLDocument.addTableStart(n);
            cgviewHTMLDocument.addTableRowStart();
            cgviewHTMLDocument.addTableColumnLeftStart();
            cgviewHTMLDocument.addSpanNoteStart();
            if (string5 != null) {
                cgviewHTMLDocument.addText("Click tick marks to expand the view.");
            }
            if (string5 == null && string4 != null) {
                cgviewHTMLDocument.addText("This is a fully expanded view.");
            }
            cgviewHTMLDocument.addSpanEnd();
            cgviewHTMLDocument.addTableColumnEnd();
            cgviewHTMLDocument.addTableColumnRightStart();
            cgviewHTMLDocument.addSpanFileSizeStart();
            object = NumberFormat.getInstance();
            File file = null;
            long l = 0L;
            if (!excludeSVGValue.booleanValue()) {
                file = new File(outputDirectory + File.separator + SVG_OUT_PATH + File.separator + Integer.toString((int)cgview.getDesiredZoom()) + "_" + Integer.toString(cgview.getDesiredZoomCenter()) + ".svgz");
                l = file.length();
                l = (long)Math.floor((float)l / 1000.0f + 0.5f);
            }
            File file2 = new File(outputDirectory + File.separator + PNG_OUT_PATH + File.separator + Integer.toString((int)cgview.getDesiredZoom()) + "_" + Integer.toString(cgview.getDesiredZoomCenter()) + ".png");
            long l2 = file2.length();
            l2 = (long)Math.floor((float)l2 / 1000.0f + 0.5f);
            if (!excludeSVGValue.booleanValue()) {
                if (string2.equalsIgnoreCase("svgz")) {
                    cgviewHTMLDocument.addText("Displayed SVG file size: ");
                    if (l > 1000L) {
                        cgviewHTMLDocument.addSpanWarningStart();
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l) + " kb; ");
                        cgviewHTMLDocument.addSpanEnd();
                    } else {
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l) + " kb; ");
                    }
                    cgviewHTMLDocument.addText("PNG file size: ");
                    if (l2 > 1000L) {
                        cgviewHTMLDocument.addSpanWarningStart();
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb.");
                        cgviewHTMLDocument.addSpanEnd();
                    } else {
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb.");
                    }
                } else if (string2.equalsIgnoreCase(PNG_OUT_PATH)) {
                    cgviewHTMLDocument.addText("Displayed PNG file size: ");
                    if (l2 > 1000L) {
                        cgviewHTMLDocument.addSpanWarningStart();
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb; ");
                        cgviewHTMLDocument.addSpanEnd();
                    } else {
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb; ");
                    }
                    cgviewHTMLDocument.addText("SVG file size: ");
                    if (l > 1000L) {
                        cgviewHTMLDocument.addSpanWarningStart();
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l) + " kb.");
                        cgviewHTMLDocument.addSpanEnd();
                    } else {
                        cgviewHTMLDocument.addText(((NumberFormat)object).format(l) + " kb.");
                    }
                }
            } else {
                cgviewHTMLDocument.addText("Displayed PNG file size: ");
                if (l2 > 1000L) {
                    cgviewHTMLDocument.addSpanWarningStart();
                    cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb.");
                    cgviewHTMLDocument.addSpanEnd();
                } else {
                    cgviewHTMLDocument.addText(((NumberFormat)object).format(l2) + " kb.");
                }
            }
            cgviewHTMLDocument.addSpanEnd();
            cgviewHTMLDocument.addTableColumnEnd();
            cgviewHTMLDocument.addTableRowEnd();
            cgviewHTMLDocument.addTableRowStart();
            cgviewHTMLDocument.addTableColumnLeftStart();
            cgviewHTMLDocument.addSpanValidStart();
            cgviewHTMLDocument.addValidationInfo();
            cgviewHTMLDocument.addSpanEnd();
            cgviewHTMLDocument.addTableColumnEnd();
            long l3 = (long)Math.floor((float)cgview.getDesiredZoomCenter() + 0.5f);
            cgviewHTMLDocument.addTableColumnRightStart();
            cgviewHTMLDocument.addSpanFileSizeStart();
            cgviewHTMLDocument.addText("Centered on base " + ((NumberFormat)object).format(l3) + "; Zoom = " + Integer.toString((int)cgview.getDesiredZoom()) + ".");
            cgviewHTMLDocument.addSpanEnd();
            cgviewHTMLDocument.addTableColumnEnd();
            cgviewHTMLDocument.addTableRowEnd();
            cgviewHTMLDocument.addTableEnd();
            cgviewHTMLDocument.addTableColumnEnd();
            cgviewHTMLDocument.addTableRowEnd();
        }
        cgviewHTMLDocument.addTableEnd();
        cgviewHTMLDocument.addFooter();
        System.out.println("Writing HTML to " + string3);
        object = new BufferedWriter(new FileWriter(string3));
        ArrayList arrayList = cgviewHTMLDocument.getContents();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((Writer)object).write((String)iterator.next());
        }
        ((BufferedWriter)object).close();
    }

    public static void writeHTMLFile(Cgview cgview, String string, String string2, String string3) throws FileNotFoundException, IOException {
        CgviewIO.writeHTMLFile(cgview, string, string2, string3, null, null, null, null);
    }

    public static void writeHTMLFile(Cgview cgview, String string, String string2, String string3, boolean bl) throws FileNotFoundException, IOException {
        useOverlibValue = new Boolean(bl);
        CgviewIO.writeHTMLFile(cgview, string, string2, string3, null, null, null, null);
    }

    private static void writeImageToFile(Cgview cgview, String string, String string2, boolean bl, int n) {
        CgviewIO.writeImageToFile(cgview, string, string2, bl, n, false);
    }

    private static void writeImageToFile(Cgview cgview, String string, String string2, boolean bl, int n, boolean bl2) {
        try {
            if (string2.equalsIgnoreCase(SVG_OUT_PATH)) {
                CgviewIO.writeToSVGFile(cgview, string, bl, false, n, bl2);
            } else if (string2.equalsIgnoreCase("svgz")) {
                CgviewIO.writeToSVGFile(cgview, string, bl, true, n, bl2);
            } else if (string2.equalsIgnoreCase(PNG_OUT_PATH)) {
                CgviewIO.writeToPNGFile(cgview, string, bl2);
            } else if (string2.equalsIgnoreCase("jpg")) {
                CgviewIO.writeToJPGFile(cgview, string, bl2);
            } else {
                System.err.println("The output format was not recognized.");
                System.exit(1);
            }
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            sVGGraphics2DIOException.printStackTrace(System.err);
            System.err.println(PROBLEM_MESSAGE + sVGGraphics2DIOException.toString());
            System.exit(1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace(System.err);
            System.err.println(PROBLEM_MESSAGE + unsupportedEncodingException.toString());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.err.println(PROBLEM_MESSAGE + iOException.toString());
            System.exit(1);
        }
    }

    private static void writeHTMLToFile(Cgview cgview, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        try {
            CgviewIO.writeHTMLFile(cgview, string, string2, string3, string4, string5, string6, string7);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.err.println(PROBLEM_MESSAGE + iOException.toString());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        block152: {
            CmdLineParser cmdLineParser = new CmdLineParser();
            CmdLineParser.Option option = cmdLineParser.addIntegerOption('A', "labelFont");
            CmdLineParser.Option option2 = cmdLineParser.addIntegerOption('c', "centerBase");
            CmdLineParser.Option option3 = cmdLineParser.addIntegerOption('D', "legendFont");
            CmdLineParser.Option option4 = cmdLineParser.addDoubleOption('d', "tickDensity");
            CmdLineParser.Option option5 = cmdLineParser.addStringOption('E', "embedFonts");
            CmdLineParser.Option option6 = cmdLineParser.addStringOption('e', "excludeSVG");
            CmdLineParser.Option option7 = cmdLineParser.addStringOption('f', "formatOfOutput");
            CmdLineParser.Option option8 = cmdLineParser.addStringOption('h', "htmlFile");
            CmdLineParser.Option option9 = cmdLineParser.addIntegerOption('H', "heightOfMap");
            CmdLineParser.Option option10 = cmdLineParser.addStringOption('i', "inputFile");
            CmdLineParser.Option option11 = cmdLineParser.addStringOption('I', "innerLabels");
            CmdLineParser.Option option12 = cmdLineParser.addIntegerOption('L', "legendSpace");
            CmdLineParser.Option option13 = cmdLineParser.addStringOption('o', "outputFile");
            CmdLineParser.Option option14 = cmdLineParser.addStringOption('p', "pathToImage");
            CmdLineParser.Option option15 = cmdLineParser.addStringOption('r', "removeLegends");
            CmdLineParser.Option option16 = cmdLineParser.addStringOption('R', "removeLabels");
            CmdLineParser.Option option17 = cmdLineParser.addStringOption('s', "seriesDirectory");
            CmdLineParser.Option option18 = cmdLineParser.addStringOption('S', "stylesheet");
            CmdLineParser.Option option19 = cmdLineParser.addStringOption('u', "useOverlib");
            CmdLineParser.Option option20 = cmdLineParser.addIntegerOption('U', "rulerFont");
            CmdLineParser.Option option21 = cmdLineParser.addIntegerOption('W', "widthOfMap");
            CmdLineParser.Option option22 = cmdLineParser.addStringOption('x', "seriesNumbers");
            CmdLineParser.Option option23 = cmdLineParser.addDoubleOption('z', "zoomAmount");
            try {
                cmdLineParser.parse(stringArray);
            }
            catch (CmdLineParser.OptionException optionException) {
                System.err.println(optionException.getMessage());
                CgviewIO.printUsage();
                System.exit(1);
            }
            Integer n = (Integer)cmdLineParser.getOptionValue(option2);
            String string = (String)cmdLineParser.getOptionValue(option5);
            String string2 = (String)cmdLineParser.getOptionValue(option6);
            String string3 = (String)cmdLineParser.getOptionValue(option7);
            String string4 = (String)cmdLineParser.getOptionValue(option8);
            String string5 = (String)cmdLineParser.getOptionValue(option10);
            String string6 = (String)cmdLineParser.getOptionValue(option11);
            legendValue = (Integer)cmdLineParser.getOptionValue(option12);
            String string7 = (String)cmdLineParser.getOptionValue(option13);
            String string8 = (String)cmdLineParser.getOptionValue(option14);
            seriesValue = (String)cmdLineParser.getOptionValue(option17);
            String string9 = (String)cmdLineParser.getOptionValue(option18);
            String string10 = (String)cmdLineParser.getOptionValue(option19);
            Double d = (Double)cmdLineParser.getOptionValue(option23);
            heightValue = (Integer)cmdLineParser.getOptionValue(option9);
            widthValue = (Integer)cmdLineParser.getOptionValue(option21);
            String string11 = (String)cmdLineParser.getOptionValue(option16);
            String string12 = (String)cmdLineParser.getOptionValue(option15);
            legendFontValue = (Integer)cmdLineParser.getOptionValue(option3);
            rulerFontValue = (Integer)cmdLineParser.getOptionValue(option20);
            labelFontValue = (Integer)cmdLineParser.getOptionValue(option);
            tickDensityValue = (Double)cmdLineParser.getOptionValue(option4);
            seriesNumbersValue = (String)cmdLineParser.getOptionValue(option22);
            if (string3 == null) {
                string3 = PNG_OUT_PATH;
            }
            if (string5 == null) {
                System.err.println("Please specify an input file name");
                CgviewIO.printUsage();
                System.exit(1);
            }
            if (string7 == null && seriesValue == null) {
                System.err.println("Please specify an output file name");
                CgviewIO.printUsage();
                System.exit(1);
            }
            if (n == null) {
                n = new Integer(1);
            }
            if (d == null) {
                d = new Double(1.0);
            }
            useOverlibValue = string10 == null ? new Boolean(true) : (string10.equalsIgnoreCase("t") || string10.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false));
            useInnerLabelsValue = string6 == null ? null : (string6.equalsIgnoreCase("t") || string6.equalsIgnoreCase("true") ? Integer.valueOf(1) : Integer.valueOf(2));
            excludeSVGValue = string2 == null ? new Boolean(false) : (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false));
            embedFontsValue = string == null ? new Boolean(true) : (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(true));
            useExternalStylesheetValue = string9 == null ? new Boolean(false) : (string9.equalsIgnoreCase("t") || string9.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false));
            removeLabelsValue = string11 == null ? new Boolean(false) : (string11.equalsIgnoreCase("t") || string11.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false));
            removeLegendsValue = string12 == null ? new Boolean(false) : (string12.equalsIgnoreCase("t") || string12.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false));
            String string13 = "xml";
            if (string5.length() >= 3) {
                string13 = string5.substring(string5.length() - 3);
            }
            if (seriesValue == null) {
                Cgview cgview;
                block151: {
                    CgviewConstants cgviewConstants;
                    cgview = new Cgview(1);
                    if (string13.equalsIgnoreCase("xml")) {
                        try {
                            cgviewConstants = new CgviewFactory();
                            if (legendFontValue != null) {
                                ((CgviewFactory)cgviewConstants).setLegendFontSize(legendFontValue);
                            }
                            if (labelFontValue != null) {
                                ((CgviewFactory)cgviewConstants).setLabelFontSize(labelFontValue);
                            }
                            if (rulerFontValue != null) {
                                ((CgviewFactory)cgviewConstants).setRulerFontSize(rulerFontValue);
                            }
                            cgview = ((CgviewFactory)cgviewConstants).createCgviewFromFile(string5);
                            if (heightValue != null) {
                                cgview.setHeight(heightValue);
                            }
                            if (widthValue != null) {
                                cgview.setWidth(widthValue);
                            }
                            if (removeLabelsValue.booleanValue()) {
                                cgview.setGlobalLabel(1);
                            }
                            if (removeLegendsValue.booleanValue()) {
                                cgview.setDrawLegends(false);
                            }
                            if (useInnerLabelsValue != null) {
                                cgview.setUseInnerLabels(useInnerLabelsValue);
                            }
                            if (tickDensityValue != null) {
                                cgview.setTickDensity(tickDensityValue);
                            }
                            cgview.setDesiredZoomCenter(n);
                            cgview.setDesiredZoom(d);
                        }
                        catch (SAXException sAXException) {
                            sAXException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + sAXException.toString());
                            System.exit(1);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                    } else if (string13.equalsIgnoreCase("tab")) {
                        try {
                            cgviewConstants = new CgviewFactoryTab();
                            if (legendFontValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setLegendFontSize(legendFontValue);
                            }
                            if (labelFontValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setLabelFontSize(labelFontValue);
                            }
                            if (rulerFontValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setRulerFontSize(rulerFontValue);
                            }
                            if (heightValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setHeight(heightValue);
                            }
                            if (widthValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setWidth(widthValue);
                            }
                            if (tickDensityValue != null) {
                                ((CgviewFactoryTab)cgviewConstants).setTickDensity(tickDensityValue);
                            }
                            cgview = ((CgviewFactoryTab)cgviewConstants).createCgviewFromFile(string5);
                            cgview.setDesiredZoomCenter(n);
                            cgview.setDesiredZoom(d);
                            if (removeLabelsValue.booleanValue()) {
                                cgview.setGlobalLabel(1);
                            }
                            if (removeLegendsValue.booleanValue()) {
                                cgview.setDrawLegends(false);
                            }
                            if (useInnerLabelsValue != null) {
                                cgview.setUseInnerLabels(useInnerLabelsValue);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + exception.toString());
                            System.exit(1);
                        }
                    } else if (string13.equalsIgnoreCase("ptt")) {
                        try {
                            cgviewConstants = new CgviewFactoryPtt();
                            if (legendFontValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setLegendFontSize(legendFontValue);
                            }
                            if (labelFontValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setLabelFontSize(labelFontValue);
                            }
                            if (rulerFontValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setRulerFontSize(rulerFontValue);
                            }
                            if (heightValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setHeight(heightValue);
                            }
                            if (widthValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setWidth(widthValue);
                            }
                            if (tickDensityValue != null) {
                                ((CgviewFactoryPtt)cgviewConstants).setTickDensity(tickDensityValue);
                            }
                            cgview = ((CgviewFactoryPtt)cgviewConstants).createCgviewFromFile(string5);
                            cgview.setDesiredZoomCenter(n);
                            cgview.setDesiredZoom(d);
                            if (removeLabelsValue.booleanValue()) {
                                cgview.setGlobalLabel(1);
                            }
                            if (removeLegendsValue.booleanValue()) {
                                cgview.setDrawLegends(false);
                            }
                            if (useInnerLabelsValue != null) {
                                cgview.setUseInnerLabels(useInnerLabelsValue);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + exception.toString());
                            System.exit(1);
                        }
                    } else {
                        System.err.println("Input file extension was not recognized.");
                        System.exit(1);
                    }
                    if (string3.equalsIgnoreCase(SVG_OUT_PATH)) {
                        try {
                            if (!embedFontsValue.booleanValue()) {
                                CgviewIO.writeToSVGFile(cgview, string7, false, false);
                                break block151;
                            }
                            CgviewIO.writeToSVGFile(cgview, string7, true, false);
                        }
                        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                            sVGGraphics2DIOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + sVGGraphics2DIOException.toString());
                            System.exit(1);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + unsupportedEncodingException.toString());
                            System.exit(1);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                    } else if (string3.equalsIgnoreCase("svgz")) {
                        try {
                            if (!embedFontsValue.booleanValue()) {
                                CgviewIO.writeToSVGFile(cgview, string7, false, true);
                                break block151;
                            }
                            CgviewIO.writeToSVGFile(cgview, string7, true, true);
                        }
                        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                            sVGGraphics2DIOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + sVGGraphics2DIOException.toString());
                            System.exit(1);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + unsupportedEncodingException.toString());
                            System.exit(1);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                    } else if (string3.equalsIgnoreCase(PNG_OUT_PATH)) {
                        try {
                            CgviewIO.writeToPNGFile(cgview, string7);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                    } else if (string3.equalsIgnoreCase("jpg")) {
                        try {
                            CgviewIO.writeToJPGFile(cgview, string7);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            System.err.println(PROBLEM_MESSAGE + iOException.toString());
                            System.exit(1);
                        }
                    } else {
                        System.err.println("The output format was not recognized.");
                        System.exit(1);
                    }
                }
                if (string4 != null) {
                    try {
                        if (string8 == null) {
                            CgviewIO.writeHTMLFile(cgview, string7, string3, string4);
                            break block152;
                        }
                        CgviewIO.writeHTMLFile(cgview, string8, string3, string4);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + iOException.toString());
                        System.exit(1);
                    }
                }
            } else {
                Object object;
                Object object2;
                File file;
                File file2;
                useExternalStylesheetValue = new Boolean(true);
                File file3 = new File(seriesValue);
                if (!file3.isDirectory() && !file3.mkdirs()) {
                    System.err.println("The directory " + seriesValue + " could not be created.");
                    System.exit(1);
                }
                if (!(file2 = new File(seriesValue + File.separator + "includes")).isDirectory() && !file2.mkdirs()) {
                    System.err.println("The directory " + seriesValue + File.separator + "includes" + " could not be created.");
                    System.exit(1);
                }
                if (!(file = new File(seriesValue + File.separator + PNG_OUT_PATH)).isDirectory() && !file.mkdirs()) {
                    System.err.println("The directory " + seriesValue + File.separator + PNG_OUT_PATH + " could not be created.");
                    System.exit(1);
                }
                File file4 = null;
                if (!(excludeSVGValue.booleanValue() || (file4 = new File(seriesValue + File.separator + SVG_OUT_PATH)).isDirectory() || file4.mkdirs())) {
                    System.err.println("The directory " + seriesValue + File.separator + SVG_OUT_PATH + " could not be created.");
                    System.exit(1);
                }
                outputDirectory = seriesValue;
                Cgview cgview = new Cgview(1);
                if (string13.equalsIgnoreCase("xml")) {
                    try {
                        object2 = new CgviewFactory();
                        if (legendFontValue != null) {
                            ((CgviewFactory)object2).setLegendFontSize(legendFontValue);
                        }
                        if (labelFontValue != null) {
                            ((CgviewFactory)object2).setLabelFontSize(labelFontValue);
                        }
                        if (rulerFontValue != null) {
                            ((CgviewFactory)object2).setRulerFontSize(rulerFontValue);
                        }
                        cgview = ((CgviewFactory)object2).createCgviewFromFile(string5);
                        if (heightValue != null) {
                            cgview.setHeight(heightValue);
                        }
                        if (widthValue != null) {
                            cgview.setWidth(widthValue);
                        }
                        if (removeLabelsValue.booleanValue()) {
                            cgview.setGlobalLabel(1);
                        }
                        if (removeLegendsValue.booleanValue()) {
                            cgview.setDrawLegends(false);
                        }
                        if (useInnerLabelsValue != null) {
                            cgview.setUseInnerLabels(useInnerLabelsValue);
                        }
                        if (tickDensityValue != null) {
                            cgview.setTickDensity(tickDensityValue);
                        }
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + sAXException.toString());
                        System.exit(1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + iOException.toString());
                        System.exit(1);
                    }
                } else if (string13.equalsIgnoreCase("tab")) {
                    try {
                        object2 = new CgviewFactoryTab();
                        if (legendFontValue != null) {
                            ((CgviewFactoryTab)object2).setLegendFontSize(legendFontValue);
                        }
                        if (labelFontValue != null) {
                            ((CgviewFactoryTab)object2).setLabelFontSize(labelFontValue);
                        }
                        if (rulerFontValue != null) {
                            ((CgviewFactoryTab)object2).setRulerFontSize(rulerFontValue);
                        }
                        if (heightValue != null) {
                            ((CgviewFactoryTab)object2).setHeight(heightValue);
                        }
                        if (widthValue != null) {
                            ((CgviewFactoryTab)object2).setWidth(widthValue);
                        }
                        if (tickDensityValue != null) {
                            ((CgviewFactoryTab)object2).setTickDensity(tickDensityValue);
                        }
                        cgview = ((CgviewFactoryTab)object2).createCgviewFromFile(string5);
                        if (removeLabelsValue.booleanValue()) {
                            cgview.setGlobalLabel(1);
                        }
                        if (removeLegendsValue.booleanValue()) {
                            cgview.setDrawLegends(false);
                        }
                        if (useInnerLabelsValue != null) {
                            cgview.setUseInnerLabels(useInnerLabelsValue);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + iOException.toString());
                        System.exit(1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + exception.toString());
                        System.exit(1);
                    }
                } else if (string13.equalsIgnoreCase("ptt")) {
                    try {
                        object2 = new CgviewFactoryPtt();
                        if (legendFontValue != null) {
                            ((CgviewFactoryPtt)object2).setLegendFontSize(legendFontValue);
                        }
                        if (labelFontValue != null) {
                            ((CgviewFactoryPtt)object2).setLabelFontSize(labelFontValue);
                        }
                        if (rulerFontValue != null) {
                            ((CgviewFactoryPtt)object2).setRulerFontSize(rulerFontValue);
                        }
                        if (heightValue != null) {
                            ((CgviewFactoryPtt)object2).setHeight(heightValue);
                        }
                        if (widthValue != null) {
                            ((CgviewFactoryPtt)object2).setWidth(widthValue);
                        }
                        if (tickDensityValue != null) {
                            ((CgviewFactoryPtt)object2).setTickDensity(tickDensityValue);
                        }
                        cgview = ((CgviewFactoryPtt)object2).createCgviewFromFile(string5);
                        if (removeLabelsValue.booleanValue()) {
                            cgview.setGlobalLabel(1);
                        }
                        if (removeLegendsValue.booleanValue()) {
                            cgview.setDrawLegends(false);
                        }
                        if (useInnerLabelsValue != null) {
                            cgview.setUseInnerLabels(useInnerLabelsValue);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + iOException.toString());
                        System.exit(1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        System.err.println(PROBLEM_MESSAGE + exception.toString());
                        System.exit(1);
                    }
                } else {
                    System.err.println("Input file extension was not recognized.");
                    System.exit(1);
                }
                object2 = new FileMover();
                if (excludeSVGValue.booleanValue()) {
                    if (!(((FileMover)object2).moveFile("includes", ZOOM_IN_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_OUT_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_FORWARD_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_BACK_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", INDEX_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_IN_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_OUT_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_FORWARD_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_BACK_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", INDEX_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", HELP_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", HELP_FILE_PNG, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", STYLE_FILE, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", OVERLIB_JAVASCRIPT, seriesValue + File.separator + "includes"))) {
                        System.err.println("Include files could not be copied to the " + seriesValue + File.separator + "includes" + " directory");
                        System.exit(1);
                    }
                } else if (!(((FileMover)object2).moveFile("includes", ZOOM_IN_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_OUT_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_FORWARD_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_BACK_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", INDEX_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_IN_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", ZOOM_OUT_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_FORWARD_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", MOVE_BACK_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", INDEX_BUTTON_OFF, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", TO_SVG_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", TO_PNG_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", HELP_BUTTON, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", HELP_FILE, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", STYLE_FILE, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", SVG_JAVASCRIPT, seriesValue + File.separator + "includes") && ((FileMover)object2).moveFile("includes", OVERLIB_JAVASCRIPT, seriesValue + File.separator + "includes"))) {
                    System.err.println("Include files could not be copied to the " + seriesValue + File.separator + "includes" + " directory");
                    System.exit(1);
                }
                int[] nArray = new int[]{1, 6, 36};
                if (seriesNumbersValue != null) {
                    try {
                        object = seriesNumbersValue.split(",");
                        nArray = new int[((String[])object).length];
                        int n2 = 0;
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            nArray[i] = Integer.parseInt(object[i]);
                            if (i == 0) {
                                if (nArray[i] != 1) {
                                    System.err.println("There is a problem with the supplied zoom values: " + seriesNumbersValue);
                                    System.err.println("The first value in the zoom values must be 1.");
                                    System.exit(1);
                                }
                            } else if (nArray[i] <= n2) {
                                System.err.println("There is a problem with the supplied zoom values: " + seriesNumbersValue);
                                System.err.println("The zoom values must be given in ascending order.");
                                System.exit(1);
                            }
                            n2 = nArray[i];
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("There is a problem with the supplied zoom values: " + seriesNumbersValue);
                        System.err.println("Please enter comma separated values, for example: 1, 6, 36");
                    }
                }
                object = new ArrayList();
                ArrayList arrayList = new ArrayList();
                ArrayList<SeriesImage> arrayList2 = new ArrayList<SeriesImage>();
                NumberFormat numberFormat = NumberFormat.getInstance();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i == 0) {
                        arrayList.add(new SeriesImage(1, 1));
                    }
                    SortSeriesImageByZoomCenter sortSeriesImageByZoomCenter = new SortSeriesImageByZoomCenter();
                    Collections.sort(arrayList, sortSeriesImageByZoomCenter);
                    for (SeriesImage seriesImage : arrayList) {
                        cgview.setDesiredZoomCenter(seriesImage.getZoomCenter());
                        cgview.setDesiredZoom(seriesImage.getZoomValue());
                        if (i < nArray.length - 1) {
                            CgviewIO.writeImageToFile(cgview, seriesValue + File.separator + PNG_OUT_PATH + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, embedFontsValue, nArray[i + 1]);
                            if (!excludeSVGValue.booleanValue()) {
                                CgviewIO.writeImageToFile(cgview, seriesValue + File.separator + SVG_OUT_PATH + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", embedFontsValue, nArray[i + 1], true);
                            }
                        } else {
                            CgviewIO.writeImageToFile(cgview, seriesValue + File.separator + PNG_OUT_PATH + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, embedFontsValue, 0);
                            if (!excludeSVGValue.booleanValue()) {
                                CgviewIO.writeImageToFile(cgview, seriesValue + File.separator + SVG_OUT_PATH + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", embedFontsValue, 0, true);
                            }
                        }
                        ArrayList arrayList3 = cgview.getLabelBounds();
                        if (i < nArray.length - 1) {
                            for (LabelBounds labelBounds : arrayList3) {
                                if (labelBounds.getType() != 1) continue;
                                labelBounds.setHyperlink(Integer.toString(nArray[i + 1]) + "_" + Integer.toString(labelBounds.getBase()) + ".html");
                                labelBounds.setMouseover("expand " + numberFormat.format(labelBounds.getBase()) + " bp region");
                            }
                        }
                        for (LabelBounds labelBounds : arrayList3) {
                            if (labelBounds.getType() != 1 || i >= nArray.length - 1) continue;
                            SeriesImage seriesImage2 = new SeriesImage(nArray[i + 1], labelBounds.getBase());
                            boolean bl = true;
                            for (SeriesImage seriesImage3 : arrayList2) {
                                if (!seriesImage3.isEqual(seriesImage2)) continue;
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            arrayList2.add(seriesImage2);
                        }
                        if (i == 0) {
                            if (i < nArray.length - 1) {
                                CgviewIO.writeHTMLToFile(cgview, "png/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, seriesValue + File.separator + "index.html", null, seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", null, null);
                                CgviewIO.writeHTMLToFile(cgview, "png/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".html", null, seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", null, null);
                                if (excludeSVGValue.booleanValue()) continue;
                                CgviewIO.writeHTMLToFile(cgview, "svg/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", seriesValue + File.separator + "index_svg.html", null, seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", null, null);
                                CgviewIO.writeHTMLToFile(cgview, "svg/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + "_svg.html", null, seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", null, null);
                                continue;
                            }
                            CgviewIO.writeHTMLToFile(cgview, "png/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, seriesValue + File.separator + "index.html", null, null, null, null);
                            if (excludeSVGValue.booleanValue()) continue;
                            CgviewIO.writeHTMLToFile(cgview, "svg/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", seriesValue + File.separator + "index_svg.html", null, null, null, null);
                            continue;
                        }
                        if (i < nArray.length - 1) {
                            CgviewIO.writeHTMLToFile(cgview, "png/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".html", seriesImage.getZoomOutFilePrefix((ArrayList)object, nArray[i - 1]) + ".html", seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", seriesImage.getClockwiseFilePrefix(arrayList) + ".html", seriesImage.getCounterclockwiseFilePrefix(arrayList) + ".html");
                            if (excludeSVGValue.booleanValue()) continue;
                            CgviewIO.writeHTMLToFile(cgview, "svg/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + "_svg.html", seriesImage.getZoomOutFilePrefix((ArrayList)object, nArray[i - 1]) + ".html", seriesImage.getZoomInFilePrefix(arrayList3, nArray[i + 1]) + ".html", seriesImage.getClockwiseFilePrefix(arrayList) + ".html", seriesImage.getCounterclockwiseFilePrefix(arrayList) + ".html");
                            continue;
                        }
                        CgviewIO.writeHTMLToFile(cgview, "png/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".png", PNG_OUT_PATH, seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".html", seriesImage.getZoomOutFilePrefix((ArrayList)object, nArray[i - 1]) + ".html", null, seriesImage.getClockwiseFilePrefix(arrayList) + ".html", seriesImage.getCounterclockwiseFilePrefix(arrayList) + ".html");
                        if (excludeSVGValue.booleanValue()) continue;
                        CgviewIO.writeHTMLToFile(cgview, "svg/" + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + ".svgz", "svgz", seriesValue + File.separator + Integer.toString(seriesImage.getZoomValue()) + "_" + Integer.toString(seriesImage.getZoomCenter()) + "_svg.html", seriesImage.getZoomOutFilePrefix((ArrayList)object, nArray[i - 1]) + ".html", null, seriesImage.getClockwiseFilePrefix(arrayList) + ".html", seriesImage.getCounterclockwiseFilePrefix(arrayList) + ".html");
                    }
                    object.clear();
                    object = (ArrayList)arrayList.clone();
                    arrayList.clear();
                    arrayList = (ArrayList)arrayList2.clone();
                    arrayList2.clear();
                }
            }
        }
        System.exit(0);
    }
}

