/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.LabelBounds;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;

public class CgviewHTMLDocument
implements CgviewConstants {
    private ArrayList contents = new ArrayList();
    private String newline = System.getProperty("line.separator");

    public void addHeader(String string, String string2, String string3, String string4, Boolean bl, Boolean bl2) {
        this.contents.add("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + this.newline);
        this.contents.add("<html lang=\"en\">" + this.newline);
        this.contents.add("<head>" + this.newline);
        this.contents.add("<title>" + StringEscapeUtils.escapeHtml((String)string) + "</title>" + this.newline);
        this.contents.add("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />" + this.newline);
        if (bl2 != null && bl2.booleanValue()) {
            this.contents.add("<link rel=\"stylesheet\" href=\"includes/stylesheet.css\" type=\"text/css\" />" + this.newline);
        } else {
            this.contents.add("<style type=\"text/css\">" + this.newline);
            this.contents.add("body {background-color: #FFFFFF; font-family: arial, sans-serif; color: #000000}" + this.newline);
            this.contents.add("span.note {font-size: small; font-style: italic}" + this.newline);
            this.contents.add("span.validInfo {font-size: x-small}" + this.newline);
            this.contents.add("span.fileSize {font-size: x-small}" + this.newline);
            this.contents.add("span.warning {font-size: x-small; color: red}" + this.newline);
            this.contents.add("div.heading {color: #FFFFFF; background-color: #6666FF; font-size: large; padding: 0.1cm}" + this.newline);
            this.contents.add("div.title {font-size: x-large; text-align: center}" + this.newline);
            this.contents.add("table.noBorder {border-style: none}" + this.newline);
            this.contents.add("table.border {border-style: solid}" + this.newline);
            this.contents.add("td.center {text-align: center; font-size: small}" + this.newline);
            this.contents.add("td.left {text-align: left; font-size: small}" + this.newline);
            this.contents.add("td.right {text-align: right; font-size: small}" + this.newline);
            this.contents.add("a:link {color: #000099; text-decoration: none}" + this.newline);
            this.contents.add("a:visited {color: #000099; text-decoration: none}" + this.newline);
            this.contents.add("a:active {color: #FF0000; text-decoration: underline}" + this.newline);
            this.contents.add("a:hover {color: #FF0000; text-decoration: underline}" + this.newline);
            this.contents.add("</style>" + this.newline);
        }
        if (bl != null && bl.booleanValue() && (string4.equalsIgnoreCase("png") || string4.equalsIgnoreCase("jpg"))) {
            this.contents.add("<script type=\"text/javascript\" src=\"includes/overlib.js\"><!-- overLIB (c) Erik Bosrup --></script>" + this.newline);
        }
        this.contents.add("</head>" + this.newline);
        this.contents.add("<body>" + this.newline);
        if (bl != null && bl.booleanValue() && (string4.equalsIgnoreCase("png") || string4.equalsIgnoreCase("jpg"))) {
            this.contents.add("<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>" + this.newline);
        }
    }

    public void addTableStart(int n) {
        this.addTableStart(n, 0);
    }

    public void addTableStart(int n, int n2) {
        if (n2 == 0) {
            this.contents.add("<table class=\"noBorder\" width=\"" + Integer.toString(n) + "\" cellspacing=\"0\" cellpadding=\"1\" align=\"left\">" + this.newline);
        } else {
            this.contents.add("<table class=\"border\" width=\"" + Integer.toString(n) + "\" border=\"" + n2 + "\" cellspacing=\"0\" cellpadding=\"1\" align=\"left\">" + this.newline);
        }
        this.contents.add("<tbody>" + this.newline);
    }

    public void addTableEnd() {
        this.contents.add("</tbody>" + this.newline);
        this.contents.add("</table>" + this.newline);
    }

    public void addTableRowStart() {
        this.contents.add("<tr>" + this.newline);
    }

    public void addTableRowEnd() {
        this.contents.add("</tr>" + this.newline);
    }

    public void addTableColumnStart() {
        this.contents.add("<td>" + this.newline);
    }

    public void addTableColumnCenterStart() {
        this.contents.add("<td class=\"center\">" + this.newline);
    }

    public void addTableColumnLeftStart() {
        this.contents.add("<td class=\"left\">" + this.newline);
    }

    public void addTableColumnRightStart() {
        this.contents.add("<td class=\"right\">" + this.newline);
    }

    public void addTableColumnEnd() {
        this.contents.add("</td>" + this.newline);
    }

    public void addValidationInfo() {
        this.contents.add("Valid XHTML 1.0;");
        this.contents.add("&nbsp;");
        this.contents.add("Valid CSS.");
    }

    public void addFooter() {
        this.contents.add("</body>" + this.newline);
        this.contents.add("</html>" + this.newline);
    }

    public void addSpanNoteStart() {
        this.contents.add("<span class=\"note\">" + this.newline);
    }

    public void addSpanFileSizeStart() {
        this.contents.add("<span class=\"fileSize\">" + this.newline);
    }

    public void addSpanValidStart() {
        this.contents.add("<span class=\"validInfo\">" + this.newline);
    }

    public void addSpanWarningStart() {
        this.contents.add("<span class=\"warning\">" + this.newline);
    }

    public void addSpanEnd() {
        this.contents.add("</span>" + this.newline);
    }

    public void addImageMap(String string, int n, int n2, ArrayList arrayList, Boolean bl) {
        this.contents.add("<img style=\"border:0\" src=\"" + StringEscapeUtils.escapeHtml((String)string) + "\" width=\"" + Integer.toString(n) + "\" height=\"" + Integer.toString(n2) + "\" usemap=\"#cgviewmap\" />" + this.newline);
        this.contents.add("<map id=\"cgviewmap\" name=\"cgviewmap\">" + this.newline);
        for (LabelBounds labelBounds : arrayList) {
            Rectangle2D rectangle2D = labelBounds.getBounds();
            if (!labelBounds.getUse() || labelBounds.getMouseover() == null && labelBounds.getHyperlink() == null) continue;
            this.contents.add("<area shape=\"rect\" coords=\"" + Integer.toString((int)Math.floor(rectangle2D.getX() + 0.5)) + "," + Integer.toString((int)Math.floor(rectangle2D.getY() + 0.5)) + "," + Integer.toString((int)Math.floor(rectangle2D.getX() + 0.5) + (int)Math.floor(rectangle2D.getWidth() + 0.5)) + "," + Integer.toString((int)Math.floor(rectangle2D.getY() + 0.5) + (int)Math.floor(rectangle2D.getHeight() + 0.5)) + "\" ");
            if (labelBounds.getHyperlink() != null) {
                this.contents.add("href=\"" + labelBounds.getHyperlink() + "\" ");
            }
            if (labelBounds.getMouseover() != null && !labelBounds.getMouseover().matches("\\S*")) {
                if (bl != null && bl.booleanValue()) {
                    this.contents.add("onmouseover=\"return overlib('" + StringEscapeUtils.escapeJavaScript((String)labelBounds.getMouseover()) + "');\" ");
                    this.contents.add("onmouseout=\"return nd();\" ");
                } else {
                    this.contents.add("onmouseover=\"self.status='" + StringEscapeUtils.escapeJavaScript((String)labelBounds.getMouseover()) + "'; return true;\" ");
                    this.contents.add("onmouseout=\"self.status=' '; return true;\" ");
                }
            }
            this.contents.add("/>" + this.newline);
        }
        this.contents.add("</map>" + this.newline);
    }

    public void addImage(String string, int n, int n2) {
        this.addImage(string, n, n2, "map");
    }

    public void addImage(String string, int n, int n2, String string2) {
        this.contents.add("<img style=\"border:0\" src=\"" + StringEscapeUtils.escapeHtml((String)string) + "\" width=\"" + Integer.toString(n) + "\" height=\"" + Integer.toString(n2) + "\" alt=\"" + StringEscapeUtils.escapeHtml((String)string2) + "\" />" + this.newline);
    }

    public void addButton(String string, String string2, String string3) {
        this.contents.add("<a href=\"" + StringEscapeUtils.escapeHtml((String)string2) + "\">");
        this.contents.add("<img style=\"border:0\" src=\"" + StringEscapeUtils.escapeHtml((String)string) + "\" alt=\"" + StringEscapeUtils.escapeHtml((String)string3) + "\" />");
        this.contents.add("</a>" + this.newline);
    }

    public void addButtonNoLink(String string, String string2) {
        this.contents.add("<img style=\"border:0\" src=\"" + StringEscapeUtils.escapeHtml((String)string) + "\" alt=\"" + StringEscapeUtils.escapeHtml((String)string2) + "\" />" + this.newline);
    }

    public void addSVG(String string, int n, int n2) {
        this.contents.add("<object data=\"" + StringEscapeUtils.escapeHtml((String)string) + "\" type=\"image/svg+xml\" width=\"" + Integer.toString(n) + "\" height=\"" + Integer.toString(n2) + "\" />" + this.newline);
    }

    public void addBreak() {
        this.contents.add("<br />" + this.newline);
    }

    public void addSpace() {
        this.contents.add("&nbsp;");
    }

    public void addLink(String string, String string2) {
        this.contents.add("<a href=\"" + StringEscapeUtils.escapeHtml((String)string2) + "\">" + StringEscapeUtils.escapeHtml((String)string) + "</a>" + this.newline);
    }

    public void addText(String string) {
        this.contents.add(StringEscapeUtils.escapeHtml((String)string) + "" + this.newline);
    }

    public ArrayList getContents() {
        return this.contents;
    }
}

