/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.FeatureRange;
import ca.ualberta.stothard.cgview.FeatureSlot;
import ca.ualberta.stothard.cgview.Legend;
import ca.ualberta.stothard.cgview.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class CgviewFactory
extends DefaultHandler
implements CgviewConstants {
    private static final Hashtable COLORS = new Hashtable();
    private static final Hashtable LABEL_TYPES = new Hashtable();
    private static final Hashtable GLOBAL_LABEL_TYPES = new Hashtable();
    private static final Hashtable DECORATIONS = new Hashtable();
    private static final Hashtable RULER_UNITS = new Hashtable();
    private static final Hashtable USE_INNER_LABELS = new Hashtable();
    private static final Hashtable GIVE_FEATURE_POSITIONS = new Hashtable();
    private static final Hashtable FEATURE_THICKNESSES = new Hashtable();
    private static final Hashtable FEATURESLOT_SPACINGS = new Hashtable();
    private static final Hashtable BACKBONE_THICKNESSES = new Hashtable();
    private static final Hashtable ARROWHEAD_LENGTHS = new Hashtable();
    private static final Hashtable MINIMUM_FEATURE_LENGTHS = new Hashtable();
    private static final Hashtable ORIGINS = new Hashtable();
    private static final Hashtable TICK_THICKNESSES = new Hashtable();
    private static final Hashtable TICK_LENGTHS = new Hashtable();
    private static final Hashtable LABEL_LINE_THICKNESSES = new Hashtable();
    private static final Hashtable LABEL_LINE_LENGTHS = new Hashtable();
    private static final Hashtable LABEL_PLACEMENT_QUALITIES = new Hashtable();
    private static final Hashtable BOOLEANS = new Hashtable();
    private static final Hashtable SWATCH_TYPES = new Hashtable();
    private static final Hashtable LEGEND_POSITIONS = new Hashtable();
    private static final Hashtable LEGEND_ALIGNMENTS = new Hashtable();
    private static final Hashtable LEGEND_SHOW_ZOOM = new Hashtable();
    private static final int MAX_BASES = 200000000;
    private static final int MIN_BASES = 10;
    private static final double MIN_BACKBONE_RADIUS = 10.0;
    private static final double MAX_BACKBONE_RADIUS = 12000.0;
    private static final int MAX_IMAGE_WIDTH = 30000;
    private static final int MIN_IMAGE_WIDTH = 100;
    private static final int MAX_IMAGE_HEIGHT = 30000;
    private static final int MIN_IMAGE_HEIGHT = 100;
    private Pattern fontDescriptionPattern = Pattern.compile("\\s*(\\S+)\\s*,\\s*(\\S+)\\s*,\\s*(\\d+)\\s*,*\\s*");
    private Pattern colorDescriptionPattern = Pattern.compile("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,*\\s*");
    private Matcher m;
    private int cgviewLength;
    private int imageWidth;
    private int imageHeight;
    private boolean ignoreCgviewTag = false;
    private boolean ignoreLegendTag = false;
    private boolean ignoreLegendItemTag = false;
    private Cgview currentCgview;
    private FeatureSlot currentFeatureSlot;
    private Feature currentFeature;
    private FeatureRange currentFeatureRange;
    private Legend currentLegend;
    private LegendItem currentLegendItem;
    private int labelFontSize = -1;
    private int rulerFontSize = -1;
    private int legendFontSize = -1;
    private StringBuffer content = new StringBuffer();
    private Locator locator;
    private Stack context = new Stack();

    public CgviewFactory() {
        COLORS.put("black", new Color(0, 0, 0));
        COLORS.put("silver", new Color(192, 192, 192));
        COLORS.put("gray", new Color(128, 128, 128));
        COLORS.put("grey", new Color(128, 128, 128));
        COLORS.put("white", new Color(255, 255, 255));
        COLORS.put("maroon", new Color(128, 0, 0));
        COLORS.put("red", new Color(255, 0, 0));
        COLORS.put("purple", new Color(128, 0, 128));
        COLORS.put("fuchsia", new Color(255, 0, 255));
        COLORS.put("green", new Color(0, 128, 0));
        COLORS.put("lime", new Color(0, 255, 0));
        COLORS.put("olive", new Color(128, 128, 0));
        COLORS.put("yellow", new Color(255, 255, 0));
        COLORS.put("orange", new Color(255, 153, 0));
        COLORS.put("navy", new Color(0, 0, 128));
        COLORS.put("blue", new Color(0, 0, 255));
        COLORS.put("teal", new Color(0, 128, 128));
        COLORS.put("aqua", new Color(0, 255, 255));
        LABEL_TYPES.put("true", new Integer(2));
        LABEL_TYPES.put("false", new Integer(1));
        LABEL_TYPES.put("force", new Integer(3));
        GLOBAL_LABEL_TYPES.put("true", new Integer(2));
        GLOBAL_LABEL_TYPES.put("false", new Integer(1));
        GLOBAL_LABEL_TYPES.put("auto", new Integer(4));
        DECORATIONS.put("arc", new Integer(1));
        DECORATIONS.put("hidden", new Integer(4));
        DECORATIONS.put("counterclockwise-arrow", new Integer(2));
        DECORATIONS.put("clockwise-arrow", new Integer(3));
        RULER_UNITS.put("bases", new Integer(1));
        RULER_UNITS.put("centisomes", new Integer(2));
        USE_INNER_LABELS.put("true", new Integer(1));
        USE_INNER_LABELS.put("false", new Integer(2));
        USE_INNER_LABELS.put("auto", new Integer(3));
        GIVE_FEATURE_POSITIONS.put("true", new Integer(1));
        GIVE_FEATURE_POSITIONS.put("false", new Integer(2));
        GIVE_FEATURE_POSITIONS.put("auto", new Integer(3));
        FEATURE_THICKNESSES.put("xxx-small", new Float(1.0f));
        FEATURE_THICKNESSES.put("xx-small", new Float(2.0f));
        FEATURE_THICKNESSES.put("x-small", new Float(4.0f));
        FEATURE_THICKNESSES.put("small", new Float(6.0f));
        FEATURE_THICKNESSES.put("medium", new Float(8.0f));
        FEATURE_THICKNESSES.put("large", new Float(10.0f));
        FEATURE_THICKNESSES.put("x-large", new Float(12.0f));
        FEATURE_THICKNESSES.put("xx-large", new Float(14.0f));
        FEATURE_THICKNESSES.put("xxx-large", new Float(16.0f));
        FEATURESLOT_SPACINGS.put("xxx-small", new Float(0.0f));
        FEATURESLOT_SPACINGS.put("xx-small", new Float(1.0f));
        FEATURESLOT_SPACINGS.put("x-small", new Float(2.0f));
        FEATURESLOT_SPACINGS.put("small", new Float(3.0f));
        FEATURESLOT_SPACINGS.put("medium", new Float(4.0f));
        FEATURESLOT_SPACINGS.put("large", new Float(5.0f));
        FEATURESLOT_SPACINGS.put("x-large", new Float(6.0f));
        FEATURESLOT_SPACINGS.put("xx-large", new Float(7.0f));
        FEATURESLOT_SPACINGS.put("xxx-large", new Float(8.0f));
        BACKBONE_THICKNESSES.put("xxx-small", new Float(1.0f));
        BACKBONE_THICKNESSES.put("xx-small", new Float(2.0f));
        BACKBONE_THICKNESSES.put("x-small", new Float(3.0f));
        BACKBONE_THICKNESSES.put("small", new Float(4.0f));
        BACKBONE_THICKNESSES.put("medium", new Float(5.0f));
        BACKBONE_THICKNESSES.put("large", new Float(6.0f));
        BACKBONE_THICKNESSES.put("x-large", new Float(7.0f));
        BACKBONE_THICKNESSES.put("xx-large", new Float(8.0f));
        BACKBONE_THICKNESSES.put("xxx-large", new Float(9.0f));
        ARROWHEAD_LENGTHS.put("xxx-small", new Double(1.0));
        ARROWHEAD_LENGTHS.put("xx-small", new Double(2.0));
        ARROWHEAD_LENGTHS.put("x-small", new Double(3.0));
        ARROWHEAD_LENGTHS.put("small", new Double(4.0));
        ARROWHEAD_LENGTHS.put("medium", new Double(5.0));
        ARROWHEAD_LENGTHS.put("large", new Double(6.0));
        ARROWHEAD_LENGTHS.put("x-large", new Double(7.0));
        ARROWHEAD_LENGTHS.put("xx-large", new Double(8.0));
        ARROWHEAD_LENGTHS.put("xxx-large", new Double(9.0));
        TICK_LENGTHS.put("xxx-small", new Float(3.0f));
        TICK_LENGTHS.put("xx-small", new Float(4.0f));
        TICK_LENGTHS.put("x-small", new Float(5.0f));
        TICK_LENGTHS.put("small", new Float(6.0f));
        TICK_LENGTHS.put("medium", new Float(7.0f));
        TICK_LENGTHS.put("large", new Float(8.0f));
        TICK_LENGTHS.put("x-large", new Float(9.0f));
        TICK_LENGTHS.put("xx-large", new Float(10.0f));
        TICK_LENGTHS.put("xxx-large", new Float(11.0f));
        MINIMUM_FEATURE_LENGTHS.put("xxx-small", new Double(0.02));
        MINIMUM_FEATURE_LENGTHS.put("xx-small", new Double(0.05));
        MINIMUM_FEATURE_LENGTHS.put("x-small", new Double(0.1));
        MINIMUM_FEATURE_LENGTHS.put("small", new Double(0.5));
        MINIMUM_FEATURE_LENGTHS.put("medium", new Double(1.0));
        MINIMUM_FEATURE_LENGTHS.put("large", new Double(1.5));
        MINIMUM_FEATURE_LENGTHS.put("x-large", new Double(2.0));
        MINIMUM_FEATURE_LENGTHS.put("xx-large", new Double(2.5));
        MINIMUM_FEATURE_LENGTHS.put("xxx-large", new Double(3.0));
        ORIGINS.put("0", new Double(90.0));
        ORIGINS.put("0.0", new Double(90.0));
        ORIGINS.put("0.1", new Double(87.0));
        ORIGINS.put("0.2", new Double(84.0));
        ORIGINS.put("0.3", new Double(81.0));
        ORIGINS.put("0.4", new Double(78.0));
        ORIGINS.put("0.5", new Double(75.0));
        ORIGINS.put("0.6", new Double(72.0));
        ORIGINS.put("0.7", new Double(69.0));
        ORIGINS.put("0.8", new Double(66.0));
        ORIGINS.put("0.9", new Double(63.0));
        ORIGINS.put("1", new Double(60.0));
        ORIGINS.put("1.0", new Double(60.0));
        ORIGINS.put("1.1", new Double(57.0));
        ORIGINS.put("1.2", new Double(54.0));
        ORIGINS.put("1.3", new Double(51.0));
        ORIGINS.put("1.4", new Double(48.0));
        ORIGINS.put("1.5", new Double(45.0));
        ORIGINS.put("1.6", new Double(42.0));
        ORIGINS.put("1.7", new Double(39.0));
        ORIGINS.put("1.8", new Double(36.0));
        ORIGINS.put("1.9", new Double(33.0));
        ORIGINS.put("2", new Double(30.0));
        ORIGINS.put("2.0", new Double(30.0));
        ORIGINS.put("2.1", new Double(27.0));
        ORIGINS.put("2.2", new Double(24.0));
        ORIGINS.put("2.3", new Double(21.0));
        ORIGINS.put("2.4", new Double(18.0));
        ORIGINS.put("2.5", new Double(15.0));
        ORIGINS.put("2.6", new Double(12.0));
        ORIGINS.put("2.7", new Double(9.0));
        ORIGINS.put("2.8", new Double(6.0));
        ORIGINS.put("2.9", new Double(3.0));
        ORIGINS.put("3", new Double(0.0));
        ORIGINS.put("3.0", new Double(0.0));
        ORIGINS.put("3.1", new Double(-3.0));
        ORIGINS.put("3.2", new Double(-6.0));
        ORIGINS.put("3.3", new Double(-9.0));
        ORIGINS.put("3.4", new Double(-12.0));
        ORIGINS.put("3.5", new Double(-15.0));
        ORIGINS.put("3.6", new Double(-18.0));
        ORIGINS.put("3.7", new Double(-21.0));
        ORIGINS.put("3.8", new Double(-24.0));
        ORIGINS.put("3.9", new Double(-27.0));
        ORIGINS.put("4", new Double(-30.0));
        ORIGINS.put("4.0", new Double(-30.0));
        ORIGINS.put("4.1", new Double(-33.0));
        ORIGINS.put("4.2", new Double(-36.0));
        ORIGINS.put("4.3", new Double(-39.0));
        ORIGINS.put("4.4", new Double(-42.0));
        ORIGINS.put("4.5", new Double(-45.0));
        ORIGINS.put("4.6", new Double(-48.0));
        ORIGINS.put("4.7", new Double(-51.0));
        ORIGINS.put("4.8", new Double(-54.0));
        ORIGINS.put("4.9", new Double(-57.0));
        ORIGINS.put("5", new Double(-60.0));
        ORIGINS.put("5.0", new Double(-60.0));
        ORIGINS.put("5.1", new Double(-63.0));
        ORIGINS.put("5.2", new Double(-66.0));
        ORIGINS.put("5.3", new Double(-69.0));
        ORIGINS.put("5.4", new Double(-72.0));
        ORIGINS.put("5.5", new Double(-75.0));
        ORIGINS.put("5.6", new Double(-78.0));
        ORIGINS.put("5.7", new Double(-81.0));
        ORIGINS.put("5.8", new Double(-84.0));
        ORIGINS.put("5.9", new Double(-87.0));
        ORIGINS.put("6", new Double(-90.0));
        ORIGINS.put("6.0", new Double(-90.0));
        ORIGINS.put("6.1", new Double(-93.0));
        ORIGINS.put("6.2", new Double(-96.0));
        ORIGINS.put("6.3", new Double(-99.0));
        ORIGINS.put("6.4", new Double(-102.0));
        ORIGINS.put("6.5", new Double(-105.0));
        ORIGINS.put("6.6", new Double(-108.0));
        ORIGINS.put("6.7", new Double(-111.0));
        ORIGINS.put("6.8", new Double(-114.0));
        ORIGINS.put("6.9", new Double(-117.0));
        ORIGINS.put("7", new Double(-120.0));
        ORIGINS.put("7.0", new Double(-120.0));
        ORIGINS.put("7.1", new Double(-123.0));
        ORIGINS.put("7.2", new Double(-126.0));
        ORIGINS.put("7.3", new Double(-129.0));
        ORIGINS.put("7.4", new Double(-132.0));
        ORIGINS.put("7.5", new Double(-135.0));
        ORIGINS.put("7.6", new Double(-138.0));
        ORIGINS.put("7.7", new Double(-141.0));
        ORIGINS.put("7.8", new Double(-144.0));
        ORIGINS.put("7.9", new Double(-147.0));
        ORIGINS.put("8", new Double(-150.0));
        ORIGINS.put("8.0", new Double(-150.0));
        ORIGINS.put("8.1", new Double(-153.0));
        ORIGINS.put("8.2", new Double(-156.0));
        ORIGINS.put("8.3", new Double(-159.0));
        ORIGINS.put("8.4", new Double(-162.0));
        ORIGINS.put("8.5", new Double(-165.0));
        ORIGINS.put("8.6", new Double(-168.0));
        ORIGINS.put("8.7", new Double(-171.0));
        ORIGINS.put("8.8", new Double(-174.0));
        ORIGINS.put("8.9", new Double(-177.0));
        ORIGINS.put("9", new Double(-180.0));
        ORIGINS.put("9.0", new Double(-180.0));
        ORIGINS.put("9.1", new Double(-183.0));
        ORIGINS.put("9.2", new Double(-186.0));
        ORIGINS.put("9.3", new Double(-189.0));
        ORIGINS.put("9.4", new Double(-192.0));
        ORIGINS.put("9.5", new Double(-195.0));
        ORIGINS.put("9.6", new Double(-198.0));
        ORIGINS.put("9.7", new Double(-201.0));
        ORIGINS.put("9.8", new Double(-204.0));
        ORIGINS.put("9.9", new Double(-207.0));
        ORIGINS.put("10", new Double(-210.0));
        ORIGINS.put("10.0", new Double(-210.0));
        ORIGINS.put("10.1", new Double(-213.0));
        ORIGINS.put("10.2", new Double(-216.0));
        ORIGINS.put("10.3", new Double(-219.0));
        ORIGINS.put("10.4", new Double(-222.0));
        ORIGINS.put("10.5", new Double(-225.0));
        ORIGINS.put("10.6", new Double(-228.0));
        ORIGINS.put("10.7", new Double(-231.0));
        ORIGINS.put("10.8", new Double(-234.0));
        ORIGINS.put("10.9", new Double(-237.0));
        ORIGINS.put("11", new Double(-240.0));
        ORIGINS.put("11.0", new Double(-240.0));
        ORIGINS.put("11.1", new Double(-243.0));
        ORIGINS.put("11.2", new Double(-246.0));
        ORIGINS.put("11.3", new Double(-249.0));
        ORIGINS.put("11.4", new Double(-252.0));
        ORIGINS.put("11.5", new Double(-255.0));
        ORIGINS.put("11.6", new Double(-258.0));
        ORIGINS.put("11.7", new Double(-261.0));
        ORIGINS.put("11.8", new Double(-264.0));
        ORIGINS.put("11.9", new Double(-267.0));
        ORIGINS.put("12", new Double(90.0));
        ORIGINS.put("12.0", new Double(90.0));
        TICK_THICKNESSES.put("xxx-small", new Float(0.02f));
        TICK_THICKNESSES.put("xx-small", new Float(0.5f));
        TICK_THICKNESSES.put("x-small", new Float(1.0f));
        TICK_THICKNESSES.put("small", new Float(1.5f));
        TICK_THICKNESSES.put("medium", new Float(2.0f));
        TICK_THICKNESSES.put("large", new Float(2.5f));
        TICK_THICKNESSES.put("x-large", new Float(3.0f));
        TICK_THICKNESSES.put("xx-large", new Float(3.5f));
        TICK_THICKNESSES.put("xxx-large", new Float(4.0f));
        LABEL_LINE_THICKNESSES.put("xxx-small", new Float(0.02f));
        LABEL_LINE_THICKNESSES.put("xx-small", new Float(0.25f));
        LABEL_LINE_THICKNESSES.put("x-small", new Float(0.5f));
        LABEL_LINE_THICKNESSES.put("small", new Float(0.75f));
        LABEL_LINE_THICKNESSES.put("medium", new Float(1.0f));
        LABEL_LINE_THICKNESSES.put("large", new Float(1.25f));
        LABEL_LINE_THICKNESSES.put("x-large", new Float(1.5f));
        LABEL_LINE_THICKNESSES.put("xx-large", new Float(1.75f));
        LABEL_LINE_THICKNESSES.put("xxx-large", new Float(2.0f));
        LABEL_LINE_LENGTHS.put("xxx-small", new Double(10.0));
        LABEL_LINE_LENGTHS.put("xx-small", new Double(20.0));
        LABEL_LINE_LENGTHS.put("x-small", new Double(30.0));
        LABEL_LINE_LENGTHS.put("small", new Double(40.0));
        LABEL_LINE_LENGTHS.put("medium", new Double(50.0));
        LABEL_LINE_LENGTHS.put("large", new Double(60.0));
        LABEL_LINE_LENGTHS.put("x-large", new Double(70.0));
        LABEL_LINE_LENGTHS.put("xx-large", new Double(80.0));
        LABEL_LINE_LENGTHS.put("xxx-large", new Double(90.0));
        LABEL_PLACEMENT_QUALITIES.put("good", new Integer(5));
        LABEL_PLACEMENT_QUALITIES.put("better", new Integer(8));
        LABEL_PLACEMENT_QUALITIES.put("best", new Integer(10));
        BOOLEANS.put("true", new Boolean(true));
        BOOLEANS.put("false", new Boolean(false));
        LEGEND_POSITIONS.put("upper-left", new Integer(1));
        LEGEND_POSITIONS.put("upper-center", new Integer(2));
        LEGEND_POSITIONS.put("upper-right", new Integer(3));
        LEGEND_POSITIONS.put("middle-left", new Integer(4));
        LEGEND_POSITIONS.put("middle-left-of-center", new Integer(5));
        LEGEND_POSITIONS.put("middle-center", new Integer(6));
        LEGEND_POSITIONS.put("middle-right-of-center", new Integer(7));
        LEGEND_POSITIONS.put("middle-right", new Integer(8));
        LEGEND_POSITIONS.put("lower-left", new Integer(9));
        LEGEND_POSITIONS.put("lower-center", new Integer(10));
        LEGEND_POSITIONS.put("lower-right", new Integer(11));
        LEGEND_SHOW_ZOOM.put("true", new Integer(1));
        LEGEND_SHOW_ZOOM.put("false", new Integer(2));
        LEGEND_ALIGNMENTS.put("left", new Integer(1));
        LEGEND_ALIGNMENTS.put("center", new Integer(2));
        LEGEND_ALIGNMENTS.put("right", new Integer(3));
        SWATCH_TYPES.put("true", new Integer(1));
        SWATCH_TYPES.put("false", new Integer(2));
    }

    public Cgview createCgviewFromFile(String string) throws SAXException, IOException {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler(this);
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[warning] " + sAXParseException.getMessage());
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[error] " + sAXParseException.getMessage());
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[fatal error] " + sAXParseException.getMessage());
                throw sAXParseException;
            }
        };
        sAXParser.setErrorHandler(errorHandler);
        FileReader fileReader = new FileReader(string);
        sAXParser.parse(new InputSource(fileReader));
        if (this.currentCgview == null) {
            String string2 = "no cgview tags were encountered";
            throw new SAXException(string2);
        }
        return this.currentCgview;
    }

    public Cgview createCgviewFromString(String string) throws SAXException, IOException {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler(this);
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[warning] " + sAXParseException.getMessage());
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[error] " + sAXParseException.getMessage());
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[fatal error] " + sAXParseException.getMessage());
                throw sAXParseException;
            }
        };
        sAXParser.setErrorHandler(errorHandler);
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        sAXParser.parse(new InputSource(byteArrayInputStream));
        if (this.currentCgview == null) {
            String string2 = "no cgview tags were encountered";
            throw new SAXException(string2);
        }
        return this.currentCgview;
    }

    public void addToCgviewFromFile(Cgview cgview, String string) throws SAXException, IOException {
        this.ignoreCgviewTag = true;
        this.ignoreLegendTag = true;
        this.ignoreLegendItemTag = true;
        this.currentCgview = cgview;
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler(this);
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[warning] " + sAXParseException.getMessage());
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[error] " + sAXParseException.getMessage());
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[fatal error] " + sAXParseException.getMessage());
                throw sAXParseException;
            }
        };
        sAXParser.setErrorHandler(errorHandler);
        FileReader fileReader = new FileReader(string);
        sAXParser.parse(new InputSource(fileReader));
        this.ignoreCgviewTag = false;
        this.ignoreLegendTag = false;
        this.ignoreLegendItemTag = false;
    }

    public void addToCgviewFromString(Cgview cgview, String string) throws SAXException, IOException {
        this.ignoreCgviewTag = true;
        this.ignoreLegendTag = true;
        this.ignoreLegendItemTag = true;
        this.currentCgview = cgview;
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler(this);
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[warning] " + sAXParseException.getMessage());
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[error] " + sAXParseException.getMessage());
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("[fatal error] " + sAXParseException.getMessage());
                throw sAXParseException;
            }
        };
        sAXParser.setErrorHandler(errorHandler);
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        sAXParser.parse(new InputSource(byteArrayInputStream));
        this.ignoreCgviewTag = false;
        this.ignoreLegendTag = false;
        this.ignoreLegendItemTag = false;
    }

    public void setLabelFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.labelFontSize = n;
    }

    public void setRulerFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.rulerFontSize = n;
    }

    public void setLegendFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.legendFontSize = n;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        System.out.println("Parsing XML input.");
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElementDetails elementDetails = new ElementDetails(string2, attributes);
        this.context.push(elementDetails);
        if (string2.equalsIgnoreCase("cgview") && !this.ignoreCgviewTag) {
            this.handleCgview();
        } else if (string2.equalsIgnoreCase("featureSlot")) {
            this.handleFeatureSlot();
        } else if (string2.equalsIgnoreCase("feature")) {
            this.handleFeature();
        } else if (string2.equalsIgnoreCase("featureRange")) {
            this.handleFeatureRange();
        } else if (string2.equalsIgnoreCase("legend") && !this.ignoreLegendTag) {
            this.handleLegend();
        } else if (string2.equalsIgnoreCase("legendItem") && !this.ignoreLegendItemTag) {
            this.handleLegendItem();
        }
        this.content.setLength(0);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.content.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.content.setLength(0);
        this.context.pop();
        if (!string2.equalsIgnoreCase("cgview")) {
            if (string2.equalsIgnoreCase("featureSlot")) {
                this.currentFeatureSlot = null;
            } else if (string2.equalsIgnoreCase("feature")) {
                this.currentFeature = null;
            } else if (string2.equalsIgnoreCase("featureRange")) {
                this.currentFeatureRange = null;
            } else if (string2.equalsIgnoreCase("legend")) {
                this.currentLegend = null;
            } else if (string2.equalsIgnoreCase("legendItem")) {
                this.currentLegendItem = null;
            }
        }
    }

    private void handleCgview() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            int n;
            int n2;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("cgview")) continue;
            if (this.currentCgview != null) {
                String string = "cgview element encountered inside of another cgview element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (elementDetails.attributes.getValue("sequenceLength") == null) {
                String string = "cgview element is missing 'sequenceLength' attribute";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            try {
                this.cgviewLength = Integer.parseInt(elementDetails.attributes.getValue("sequenceLength"));
            }
            catch (NumberFormatException numberFormatException) {
                String string = "value for 'sequenceLength' attribute in cgview element not understood";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.cgviewLength > 200000000) {
                String string = "value for 'sequenceLength' attribute in cgview element must be less than 200000000";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.cgviewLength < 10) {
                String string = "value for 'sequenceLength' attribute in cgview element must be greater than 10";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            this.currentCgview = new Cgview(this.cgviewLength);
            if (elementDetails.attributes.getValue("title") != null) {
                this.currentCgview.setTitle(elementDetails.attributes.getValue("title"));
            }
            if (elementDetails.attributes.getValue("info") != null) {
                this.currentCgview.setWarningText(elementDetails.attributes.getValue("info"));
            }
            if (elementDetails.attributes.getValue("rulerUnits") != null) {
                if (RULER_UNITS.get(elementDetails.attributes.getValue("rulerUnits").toLowerCase()) != null) {
                    this.currentCgview.setRulerUnits((Integer)RULER_UNITS.get(elementDetails.attributes.getValue("rulerUnits").toLowerCase()));
                } else {
                    String string = "value for 'rulerUnits' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("showWarning") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("showWarning").toLowerCase()) != null) {
                    this.currentCgview.setShowWarning((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showWarning").toLowerCase()));
                } else {
                    String string = "value for 'showWarning' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("isLinear") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("isLinear").toLowerCase()) != null) {
                    this.currentCgview.setIsLinear((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("isLinear").toLowerCase()));
                } else {
                    String string = "value for 'isLinear' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("showBorder") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("showBorder").toLowerCase()) != null) {
                    this.currentCgview.setShowBorder((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showBorder").toLowerCase()));
                } else {
                    String string = "value for 'showBorder' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("moveInnerLabelsToOuter") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("moveInnerLabelsToOuter").toLowerCase()) != null) {
                    this.currentCgview.setMoveInnerLabelsToOuter((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("moveInnerLabelsToOuter").toLowerCase()));
                } else {
                    String string = "value for 'moveInnerLabelsToOuter' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("showShading") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()) != null) {
                    this.currentCgview.setShowShading((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()));
                } else {
                    String string = "value for 'showShading' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("useColoredLabelBackgrounds") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("useColoredLabelBackgrounds").toLowerCase()) != null) {
                    this.currentCgview.setUseColoredLabelBackgrounds((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("useColoredLabelBackgrounds").toLowerCase()));
                } else {
                    String string = "value for 'useColoredLabelBackgrounds' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("labelPlacementQuality") != null) {
                if (LABEL_PLACEMENT_QUALITIES.get(elementDetails.attributes.getValue("labelPlacementQuality").toLowerCase()) != null) {
                    this.currentCgview.setLabelPlacementQuality((Integer)LABEL_PLACEMENT_QUALITIES.get(elementDetails.attributes.getValue("labelPlacementQuality").toLowerCase()));
                } else {
                    String string = "value for 'labelPlacementQuality' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("useInnerLabels") != null) {
                if (USE_INNER_LABELS.get(elementDetails.attributes.getValue("useInnerLabels").toLowerCase()) != null) {
                    this.currentCgview.setUseInnerLabels((Integer)USE_INNER_LABELS.get(elementDetails.attributes.getValue("useInnerLabels").toLowerCase()));
                } else {
                    String string = "value for 'useInnerLabels' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("giveFeaturePositions") != null) {
                if (GIVE_FEATURE_POSITIONS.get(elementDetails.attributes.getValue("giveFeaturePositions").toLowerCase()) != null) {
                    this.currentCgview.setGiveFeaturePositions((Integer)GIVE_FEATURE_POSITIONS.get(elementDetails.attributes.getValue("giveFeaturePositions").toLowerCase()));
                } else {
                    String string = "value for 'giveFeaturePositions' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("titleFont") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("titleFont"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string2 = this.m.group(2);
                        n2 = Integer.parseInt(this.m.group(3));
                        n = 0;
                        if (string2.equalsIgnoreCase("bold")) {
                            n = 1;
                        } else if (string2.equalsIgnoreCase("italic") || string2.equalsIgnoreCase("italics")) {
                            n = 2;
                        } else if (string2.equalsIgnoreCase("bold-italic") || string2.equalsIgnoreCase("italic-bold")) {
                            n = 3;
                        }
                        this.currentCgview.setTitleFont(new Font(string, n, n2));
                    }
                    catch (Exception exception) {
                        String string = "value for 'titleFont' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'titleFont' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("warningFont") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("warningFont"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string3 = this.m.group(2);
                        n2 = Integer.parseInt(this.m.group(3));
                        n = 0;
                        if (string3.equalsIgnoreCase("bold")) {
                            n = 1;
                        } else if (string3.equalsIgnoreCase("italic") || string3.equalsIgnoreCase("italics")) {
                            n = 2;
                        } else if (string3.equalsIgnoreCase("bold-italic") || string3.equalsIgnoreCase("italic-bold")) {
                            n = 3;
                        }
                        this.currentCgview.setWarningFont(new Font(string, n, n2));
                    }
                    catch (Exception exception) {
                        String string = "value for 'warningFont' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'warningFont' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("rulerFont") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("rulerFont"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string4 = this.m.group(2);
                        n2 = Integer.parseInt(this.m.group(3));
                        n = 0;
                        if (string4.equalsIgnoreCase("bold")) {
                            n = 1;
                        } else if (string4.equalsIgnoreCase("italic") || string4.equalsIgnoreCase("italics")) {
                            n = 2;
                        } else if (string4.equalsIgnoreCase("bold-italic") || string4.equalsIgnoreCase("italic-bold")) {
                            n = 3;
                        }
                        this.currentCgview.setRulerFont(new Font(string, n, n2));
                    }
                    catch (Exception exception) {
                        String string = "value for 'rulerFont' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'rulerFont' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("labelFont") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("labelFont"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string5 = this.m.group(2);
                        n2 = Integer.parseInt(this.m.group(3));
                        n = 0;
                        if (string5.equalsIgnoreCase("bold")) {
                            n = 1;
                        } else if (string5.equalsIgnoreCase("italic") || string5.equalsIgnoreCase("italics")) {
                            n = 2;
                        } else if (string5.equalsIgnoreCase("bold-italic") || string5.equalsIgnoreCase("italic-bold")) {
                            n = 3;
                        }
                        this.currentCgview.setLabelFont(new Font(string, n, n2));
                    }
                    catch (Exception exception) {
                        String string = "value for 'labelFont' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'labelFont' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("titleFontColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("titleFontColor").toLowerCase()) != null) {
                    this.currentCgview.setTitleFontColor((Color)COLORS.get(elementDetails.attributes.getValue("titleFontColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("titleFontColor"));
                    if (this.m.find()) {
                        try {
                            int n3 = Integer.parseInt(this.m.group(1));
                            int n4 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setTitleFontColor(new Color(n3, n4, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'titleFontColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'titleFontColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("globalLabelColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("globalLabelColor").toLowerCase()) != null) {
                    this.currentCgview.setGlobalLabelColor((Color)COLORS.get(elementDetails.attributes.getValue("globalLabelColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("globalLabelColor"));
                    if (this.m.find()) {
                        try {
                            int n5 = Integer.parseInt(this.m.group(1));
                            int n6 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setGlobalLabelColor(new Color(n5, n6, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'globalLabelColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'globalLabelColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("warningFontColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("warningFontColor").toLowerCase()) != null) {
                    this.currentCgview.setWarningFontColor((Color)COLORS.get(elementDetails.attributes.getValue("warningFontColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("warningFontColor"));
                    if (this.m.find()) {
                        try {
                            int n7 = Integer.parseInt(this.m.group(1));
                            int n8 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setWarningFontColor(new Color(n7, n8, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'warningFontColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'warningFontColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("borderColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("borderColor").toLowerCase()) != null) {
                    this.currentCgview.setBorderColor((Color)COLORS.get(elementDetails.attributes.getValue("borderColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("borderColor"));
                    if (this.m.find()) {
                        try {
                            int n9 = Integer.parseInt(this.m.group(1));
                            int n10 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setBorderColor(new Color(n9, n10, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'borderColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'borderColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("rulerFontColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("rulerFontColor").toLowerCase()) != null) {
                    this.currentCgview.setRulerFontColor((Color)COLORS.get(elementDetails.attributes.getValue("rulerFontColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("rulerFontColor"));
                    if (this.m.find()) {
                        try {
                            int n11 = Integer.parseInt(this.m.group(1));
                            int n12 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setRulerFontColor(new Color(n11, n12, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'rulerFontColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'rulerFontColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("backboneColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("backboneColor").toLowerCase()) != null) {
                    this.currentCgview.setBackboneColor((Color)COLORS.get(elementDetails.attributes.getValue("backboneColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("backboneColor"));
                    if (this.m.find()) {
                        try {
                            int n13 = Integer.parseInt(this.m.group(1));
                            int n14 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setBackboneColor(new Color(n13, n14, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'backboneColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'backboneColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("backgroundColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("backgroundColor").toLowerCase()) != null) {
                    this.currentCgview.setBackgroundColor((Color)COLORS.get(elementDetails.attributes.getValue("backgroundColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("backgroundColor"));
                    if (this.m.find()) {
                        try {
                            int n15 = Integer.parseInt(this.m.group(1));
                            int n16 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setBackgroundColor(new Color(n15, n16, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'backgroundColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'backgroundColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("longTickColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("longTickColor").toLowerCase()) != null) {
                    this.currentCgview.setLongTickColor((Color)COLORS.get(elementDetails.attributes.getValue("longTickColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("longTickColor"));
                    if (this.m.find()) {
                        try {
                            int n17 = Integer.parseInt(this.m.group(1));
                            int n18 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setLongTickColor(new Color(n17, n18, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'longTickColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'longTickColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("shortTickColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("shortTickColor").toLowerCase()) != null) {
                    this.currentCgview.setShortTickColor((Color)COLORS.get(elementDetails.attributes.getValue("shortTickColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("shortTickColor"));
                    if (this.m.find()) {
                        try {
                            int n19 = Integer.parseInt(this.m.group(1));
                            int n20 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setShortTickColor(new Color(n19, n20, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'shortTickColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'shortTickColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("zeroTickColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("zeroTickColor").toLowerCase()) != null) {
                    this.currentCgview.setZeroTickColor((Color)COLORS.get(elementDetails.attributes.getValue("zeroTickColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("zeroTickColor"));
                    if (this.m.find()) {
                        try {
                            int n21 = Integer.parseInt(this.m.group(1));
                            int n22 = Integer.parseInt(this.m.group(2));
                            n2 = Integer.parseInt(this.m.group(3));
                            this.currentCgview.setZeroTickColor(new Color(n21, n22, n2));
                        }
                        catch (Exception exception) {
                            String string = "value for 'zeroTickColor' attribute in cgview element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'zeroTickColor' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("featureThickness") != null) {
                if (FEATURE_THICKNESSES.get(elementDetails.attributes.getValue("featureThickness").toLowerCase()) != null) {
                    this.currentCgview.setFeatureThickness(((Float)FEATURE_THICKNESSES.get(elementDetails.attributes.getValue("featureThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("featureThickness"));
                        this.currentCgview.setFeatureThickness(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'featureThickness' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("featureSlotSpacing") != null) {
                if (FEATURESLOT_SPACINGS.get(elementDetails.attributes.getValue("featureSlotSpacing").toLowerCase()) != null) {
                    this.currentCgview.setFeatureSlotSpacing(((Float)FEATURESLOT_SPACINGS.get(elementDetails.attributes.getValue("featureSlotSpacing").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("featureSlotSpacing"));
                        this.currentCgview.setFeatureSlotSpacing(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'featureSlotSpacing' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("backboneThickness") != null) {
                if (BACKBONE_THICKNESSES.get(elementDetails.attributes.getValue("backboneThickness").toLowerCase()) != null) {
                    this.currentCgview.setBackboneThickness(((Float)BACKBONE_THICKNESSES.get(elementDetails.attributes.getValue("backboneThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("backboneThickness"));
                        this.currentCgview.setBackboneThickness(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'backboneThickness' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("rulerPadding") != null) {
                try {
                    double d = Double.parseDouble(elementDetails.attributes.getValue("rulerPadding"));
                    this.currentCgview.setRulerTextPadding(d);
                }
                catch (Exception exception) {
                    String string = "value for 'rulerPadding' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("arrowheadLength") != null) {
                if (ARROWHEAD_LENGTHS.get(elementDetails.attributes.getValue("arrowheadLength").toLowerCase()) != null) {
                    this.currentCgview.setArrowheadLength((Double)ARROWHEAD_LENGTHS.get(elementDetails.attributes.getValue("arrowheadLength").toLowerCase()));
                } else {
                    try {
                        double d = Double.parseDouble(elementDetails.attributes.getValue("arrowheadLength"));
                        this.currentCgview.setArrowheadLength(d);
                    }
                    catch (Exception exception) {
                        String string = "value for 'arrowheadLength' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("tickDensity") != null) {
                try {
                    double d = Double.parseDouble(elementDetails.attributes.getValue("tickDensity"));
                    this.currentCgview.setTickDensity(d);
                }
                catch (Exception exception) {
                    String string = "value for 'tickDensity' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("tickLength") != null) {
                if (TICK_LENGTHS.get(elementDetails.attributes.getValue("tickLength").toLowerCase()) != null) {
                    this.currentCgview.setTickLength(((Float)TICK_LENGTHS.get(elementDetails.attributes.getValue("tickLength").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("tickLength"));
                        this.currentCgview.setTickLength(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'tickLength' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("minimumFeatureLength") != null) {
                if (MINIMUM_FEATURE_LENGTHS.get(elementDetails.attributes.getValue("minimumFeatureLength").toLowerCase()) != null) {
                    this.currentCgview.setMinimumFeatureLength((Double)MINIMUM_FEATURE_LENGTHS.get(elementDetails.attributes.getValue("minimumFeatureLength").toLowerCase()));
                } else {
                    try {
                        double d = Double.parseDouble(elementDetails.attributes.getValue("minimumFeatureLength"));
                        this.currentCgview.setMinimumFeatureLength(d);
                    }
                    catch (Exception exception) {
                        String string = "value for 'minimumFeatureLength' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("tickThickness") != null) {
                if (TICK_THICKNESSES.get(elementDetails.attributes.getValue("tickThickness").toLowerCase()) != null) {
                    this.currentCgview.setTickThickness(((Float)TICK_THICKNESSES.get(elementDetails.attributes.getValue("tickThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("tickThickness"));
                        this.currentCgview.setTickThickness(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'tickThickness' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("shortTickThickness") != null) {
                if (TICK_THICKNESSES.get(elementDetails.attributes.getValue("shortTickThickness").toLowerCase()) != null) {
                    this.currentCgview.setShortTickThickness(((Float)TICK_THICKNESSES.get(elementDetails.attributes.getValue("shortTickThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("shortTickThickness"));
                        this.currentCgview.setShortTickThickness(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'shortTickThickness' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("labelLineThickness") != null) {
                if (LABEL_LINE_THICKNESSES.get(elementDetails.attributes.getValue("labelLineThickness").toLowerCase()) != null) {
                    this.currentCgview.setLabelLineThickness(((Float)LABEL_LINE_THICKNESSES.get(elementDetails.attributes.getValue("labelLineThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("labelLineThickness"));
                        this.currentCgview.setLabelLineThickness(f);
                    }
                    catch (Exception exception) {
                        String string = "value for 'labelLineThickness' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("labelLineLength") != null) {
                if (LABEL_LINE_LENGTHS.get(elementDetails.attributes.getValue("labelLineLength").toLowerCase()) != null) {
                    this.currentCgview.setLabelLineLength((Double)LABEL_LINE_LENGTHS.get(elementDetails.attributes.getValue("labelLineLength").toLowerCase()));
                } else {
                    try {
                        double d = Double.parseDouble(elementDetails.attributes.getValue("labelLineLength"));
                        this.currentCgview.setLabelLineLength(d);
                    }
                    catch (Exception exception) {
                        String string = "value for 'labelLineLength' attribute in cgview element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("origin") != null) {
                if (ORIGINS.get(elementDetails.attributes.getValue("origin").toLowerCase()) != null) {
                    this.currentCgview.setOrigin((Double)ORIGINS.get(elementDetails.attributes.getValue("origin").toLowerCase()));
                } else {
                    String string = "value for 'origin' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("width") != null) {
                try {
                    this.imageWidth = Integer.parseInt(elementDetails.attributes.getValue("width"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'width' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (this.imageWidth < 100) {
                    String string = "value for 'width' attribute in cgview element must be greater than or equal to 100";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (this.imageWidth > 30000) {
                    String string = "value for 'width' attribute in cgview element must be less than or equal to 30000";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentCgview.setWidth(this.imageWidth);
            }
            if (elementDetails.attributes.getValue("height") != null) {
                try {
                    this.imageHeight = Integer.parseInt(elementDetails.attributes.getValue("height"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'height' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (this.imageHeight < 100) {
                    String string = "value for 'height' attribute in cgview element must be greater than or equal to 100";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (this.imageHeight > 30000) {
                    String string = "value for 'height' attribute in cgview element must be less than or equal to 30000";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentCgview.setHeight(this.imageHeight);
            }
            if (elementDetails.attributes.getValue("backboneRadius") != null) {
                double d;
                try {
                    d = Double.parseDouble(elementDetails.attributes.getValue("backboneRadius"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'backboneRadius' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (d < 10.0) {
                    String string = "value for 'backboneRadius' attribute in cgview element must be greater than or equal to 10.0";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (d > 12000.0) {
                    String string = "value for 'backboneRadius' attribute in cgview element must be less than or equal to 12000.0";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentCgview.setBackboneRadius(d);
            }
            if (elementDetails.attributes.getValue("globalLabel") != null) {
                if (GLOBAL_LABEL_TYPES.get(elementDetails.attributes.getValue("globalLabel").toLowerCase()) != null) {
                    this.currentCgview.setGlobalLabel((Integer)GLOBAL_LABEL_TYPES.get(elementDetails.attributes.getValue("globalLabel").toLowerCase()));
                } else {
                    String string = "value for 'globalLabel' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("labelsToKeep") != null) {
                int n23;
                try {
                    n23 = Integer.parseInt(elementDetails.attributes.getValue("labelsToKeep"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'labelsToKeep' attribute in cgview element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (n23 < 0) {
                    String string = "value for 'labelsToKeep' attribute in cgview element must be greater than or equal to 0";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentCgview.setLabelsToKeep(n23);
            }
            if (this.rulerFontSize == -1) continue;
            this.currentCgview.setRulerFont(new Font(this.currentCgview.getRulerFont().getName(), this.currentCgview.getRulerFont().getStyle(), this.rulerFontSize));
        }
    }

    private void handleFeatureSlot() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            String string;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("featureSlot")) continue;
            if (this.currentFeatureSlot != null) {
                String string2 = "featureSlot element encountered inside of another featureSlot element";
                if (this.locator != null) {
                    string2 = string2 + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string2);
            }
            if (this.currentCgview == null) {
                String string3 = "featureSlot element encountered outside of a cgview element";
                if (this.locator != null) {
                    string3 = string3 + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string3);
            }
            if (elementDetails.attributes.getValue("strand") == null) {
                String string4 = "featureSlot element is missing 'strand' attribute";
                if (this.locator != null) {
                    string4 = string4 + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string4);
            }
            if (elementDetails.attributes.getValue("strand").equalsIgnoreCase("direct")) {
                this.currentFeatureSlot = new FeatureSlot(this.currentCgview, 1);
            } else if (elementDetails.attributes.getValue("strand").equalsIgnoreCase("reverse")) {
                this.currentFeatureSlot = new FeatureSlot(this.currentCgview, 2);
            } else {
                String string5 = "value for 'strand' attribute in featureSlot element not understood";
                if (this.locator != null) {
                    string5 = string5 + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string5);
            }
            if (elementDetails.attributes.getValue("featureThickness") != null) {
                if (FEATURE_THICKNESSES.get(elementDetails.attributes.getValue("featureThickness").toLowerCase()) != null) {
                    this.currentFeatureSlot.setFeatureThickness(((Float)FEATURE_THICKNESSES.get(elementDetails.attributes.getValue("featureThickness").toLowerCase())).floatValue());
                } else {
                    try {
                        float f = Float.parseFloat(elementDetails.attributes.getValue("featureThickness"));
                        this.currentFeatureSlot.setFeatureThickness(f);
                    }
                    catch (Exception exception) {
                        string = "value for 'featureThickness' attribute in featureSlot element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("minimumFeatureLength") != null) {
                if (MINIMUM_FEATURE_LENGTHS.get(elementDetails.attributes.getValue("minimumFeatureLength").toLowerCase()) != null) {
                    this.currentFeatureSlot.setMinimumFeatureLength((Double)MINIMUM_FEATURE_LENGTHS.get(elementDetails.attributes.getValue("minimumFeatureLength").toLowerCase()));
                } else {
                    try {
                        double d = Double.parseDouble(elementDetails.attributes.getValue("minimumFeatureLength"));
                        this.currentFeatureSlot.setMinimumFeatureLength(d);
                    }
                    catch (Exception exception) {
                        string = "value for 'minimumFeatureLength' attribute in featureSlot element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("showShading") == null) continue;
            if (BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()) != null) {
                this.currentFeatureSlot.setShowShading((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()));
                continue;
            }
            String string6 = "value for 'showShading' attribute in featureSlot element not understood";
            if (this.locator != null) {
                string6 = string6 + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
            }
            System.err.println("[warning] " + string6);
        }
    }

    private void handleFeature() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            int n;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("feature")) continue;
            if (this.currentFeature != null) {
                String string = "feature element encountered inside of another feature element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentCgview == null) {
                String string = "feature element encountered outside of a cgview element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentFeatureSlot == null) {
                String string = "feature element encountered outside of a featureSlot element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            this.currentFeature = new Feature(this.currentFeatureSlot);
            if (elementDetails.attributes.getValue("color") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("color").toLowerCase()) != null) {
                    this.currentFeature.setColor((Color)COLORS.get(elementDetails.attributes.getValue("color").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("color"));
                    if (this.m.find()) {
                        try {
                            int n2 = Integer.parseInt(this.m.group(1));
                            int n3 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentFeature.setColor(new Color(n2, n3, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'color' attribute in feature element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'color' attribute in feature element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("opacity") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("opacity"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'opacity' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'opacity' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'opacity' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeature.setOpacity(f);
            }
            if (elementDetails.attributes.getValue("proportionOfThickness") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("proportionOfThickness"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'proportionOfThickness' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'proportionOfThickness' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'proportionOfThickness' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeature.setProportionOfThickness(f);
            }
            if (elementDetails.attributes.getValue("radiusAdjustment") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("radiusAdjustment"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'radiusAdjustment' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'radiusAdjustment' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'radiusAdjustment' attribute in feature element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeature.setRadiusAdjustment(f);
            }
            if (elementDetails.attributes.getValue("decoration") != null) {
                if (DECORATIONS.get(elementDetails.attributes.getValue("decoration").toLowerCase()) != null) {
                    this.currentFeature.setDecoration((Integer)DECORATIONS.get(elementDetails.attributes.getValue("decoration").toLowerCase()));
                } else {
                    String string = "value for 'decoration' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("showLabel") != null) {
                if (LABEL_TYPES.get(elementDetails.attributes.getValue("showLabel").toLowerCase()) != null) {
                    this.currentFeature.setShowLabel((Integer)LABEL_TYPES.get(elementDetails.attributes.getValue("showLabel").toLowerCase()));
                } else {
                    String string = "value for 'showLabel' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("font") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("font"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string2 = this.m.group(2);
                        n = Integer.parseInt(this.m.group(3));
                        int n4 = 0;
                        if (string2.equalsIgnoreCase("bold")) {
                            n4 = 1;
                        } else if (string2.equalsIgnoreCase("italic") || string2.equalsIgnoreCase("italics")) {
                            n4 = 2;
                        } else if (string2.equalsIgnoreCase("bold-italic") || string2.equalsIgnoreCase("italic-bold")) {
                            n4 = 3;
                        }
                        this.currentFeature.setFont(new Font(string, n4, n));
                    }
                    catch (Exception exception) {
                        String string = "value for 'font' attribute in feature element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'font' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("label") != null) {
                this.currentFeature.setLabel(elementDetails.attributes.getValue("label"));
            }
            if (elementDetails.attributes.getValue("showShading") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()) != null) {
                    this.currentFeature.setShowShading((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()));
                } else {
                    String string = "value for 'showShading' attribute in feature element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("hyperlink") != null) {
                this.currentFeature.setHyperlink(elementDetails.attributes.getValue("hyperlink"));
            }
            if (elementDetails.attributes.getValue("mouseover") != null) {
                this.currentFeature.setMouseover(elementDetails.attributes.getValue("mouseover"));
            }
            if (this.labelFontSize == -1) continue;
            if (this.currentFeature.getFont() != null) {
                this.currentFeature.setFont(new Font(this.currentFeature.getFont().getName(), this.currentFeature.getFont().getStyle(), this.labelFontSize));
                continue;
            }
            this.currentFeature.setFont(new Font(this.currentCgview.getLabelFont().getName(), this.currentCgview.getLabelFont().getStyle(), this.labelFontSize));
        }
    }

    private void handleFeatureRange() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            int n;
            int n2;
            int n3;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("featureRange")) continue;
            if (this.currentFeatureRange != null) {
                String string = "featureRange element encountered inside of another featureRange element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentFeature == null) {
                String string = "featureRange element encountered outside of a feature element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentCgview == null) {
                String string = "featureRange element encountered outside of a cgview element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentFeatureSlot == null) {
                String string = "featureRange element encountered outside of a featureSlot element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (elementDetails.attributes.getValue("start") == null) {
                String string = "featureRange element is missing 'start' attribute";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (elementDetails.attributes.getValue("stop") == null) {
                String string = "featureRange element is missing 'stop' attribute";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            try {
                n3 = Integer.parseInt(elementDetails.attributes.getValue("start"));
            }
            catch (NumberFormatException numberFormatException) {
                String string = "value for 'start' attribute in featureRange element not understood";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (n3 > this.cgviewLength) {
                String string = "value for 'start' attribute in featureRange element must be less than or equal to the length of the plasmid";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (n3 < 1) {
                String string = "value for 'start' attribute in featureRange element must be greater than or equal to 1";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            try {
                n2 = Integer.parseInt(elementDetails.attributes.getValue("stop"));
            }
            catch (NumberFormatException numberFormatException) {
                String string = "value for 'stop' attribute in featureRange element not understood";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (n2 > this.cgviewLength) {
                String string = "value for 'stop' attribute in featureRange element must be less than or equal to the length of the plasmid";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (n2 < 1) {
                String string = "value for 'stop' attribute in featureRange element must be greater than or equal to 1";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            this.currentFeatureRange = new FeatureRange(this.currentFeature, n3, n2);
            if (elementDetails.attributes.getValue("color") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("color").toLowerCase()) != null) {
                    this.currentFeatureRange.setColor((Color)COLORS.get(elementDetails.attributes.getValue("color").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("color"));
                    if (this.m.find()) {
                        try {
                            n3 = Integer.parseInt(this.m.group(1));
                            n2 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentFeatureRange.setColor(new Color(n3, n2, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'color' attribute in featureRange element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'color' attribute in featureRange element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("opacity") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("opacity"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'opacity' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'opacity' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'opacity' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeatureRange.setOpacity(f);
            }
            if (elementDetails.attributes.getValue("proportionOfThickness") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("proportionOfThickness"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'proportionOfThickness' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'proportionOfThickness' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'proportionOfThickness' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeatureRange.setProportionOfThickness(f);
            }
            if (elementDetails.attributes.getValue("radiusAdjustment") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("radiusAdjustment"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'radiusAdjustment' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'radiusAdjustment' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'radiusAdjustment' attribute in featureRange element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentFeatureRange.setRadiusAdjustment(f);
            }
            if (elementDetails.attributes.getValue("decoration") != null) {
                if (DECORATIONS.get(elementDetails.attributes.getValue("decoration").toLowerCase()) != null) {
                    this.currentFeatureRange.setDecoration((Integer)DECORATIONS.get(elementDetails.attributes.getValue("decoration").toLowerCase()));
                } else {
                    String string = "value for 'decoration' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("showLabel") != null) {
                if (LABEL_TYPES.get(elementDetails.attributes.getValue("showLabel").toLowerCase()) != null) {
                    this.currentFeatureRange.setShowLabel((Integer)LABEL_TYPES.get(elementDetails.attributes.getValue("showLabel").toLowerCase()));
                } else {
                    String string = "value for 'showLabel' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("font") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("font"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string2 = this.m.group(2);
                        n = Integer.parseInt(this.m.group(3));
                        int n4 = 0;
                        if (string2.equalsIgnoreCase("bold")) {
                            n4 = 1;
                        } else if (string2.equalsIgnoreCase("italic") || string2.equalsIgnoreCase("italics")) {
                            n4 = 2;
                        } else if (string2.equalsIgnoreCase("bold-italic") || string2.equalsIgnoreCase("italic-bold")) {
                            n4 = 3;
                        }
                        this.currentFeatureRange.setFont(new Font(string, n4, n));
                    }
                    catch (Exception exception) {
                        String string = "value for 'font' attribute in featureRange element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'font' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("label") != null) {
                this.currentFeatureRange.setLabel(elementDetails.attributes.getValue("label"));
            }
            if (elementDetails.attributes.getValue("showShading") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()) != null) {
                    this.currentFeatureRange.setShowShading((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("showShading").toLowerCase()));
                } else {
                    String string = "value for 'showShading' attribute in featureRange element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("hyperlink") != null) {
                this.currentFeatureRange.setHyperlink(elementDetails.attributes.getValue("hyperlink"));
            }
            if (elementDetails.attributes.getValue("mouseover") != null) {
                this.currentFeatureRange.setMouseover(elementDetails.attributes.getValue("mouseover"));
            }
            if (this.labelFontSize == -1) continue;
            if (this.currentFeatureRange.getFont() != null) {
                this.currentFeatureRange.setFont(new Font(this.currentFeatureRange.getFont().getName(), this.currentFeatureRange.getFont().getStyle(), this.labelFontSize));
                continue;
            }
            if (this.currentFeature.getFont() != null) {
                this.currentFeatureRange.setFont(new Font(this.currentFeature.getFont().getName(), this.currentFeature.getFont().getStyle(), this.labelFontSize));
                continue;
            }
            this.currentFeatureRange.setFont(new Font(this.currentCgview.getLabelFont().getName(), this.currentCgview.getLabelFont().getStyle(), this.labelFontSize));
        }
    }

    private void handleLegend() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            int n;
            int n2;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("legend")) continue;
            if (this.currentLegend != null) {
                String string = "legend element encountered inside of another legend element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentCgview == null) {
                String string = "legend element encountered outside of a cgview element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            this.currentLegend = new Legend(this.currentCgview);
            if (elementDetails.attributes.getValue("fontColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("fontColor").toLowerCase()) != null) {
                    this.currentLegend.setFontColor((Color)COLORS.get(elementDetails.attributes.getValue("fontColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("fontColor"));
                    if (this.m.find()) {
                        try {
                            int n3 = Integer.parseInt(this.m.group(1));
                            n2 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentLegend.setFontColor(new Color(n3, n2, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'fontColor' attribute in legend element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'fontColor' attribute in legend element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("font") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("font"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string2 = this.m.group(2);
                        n = Integer.parseInt(this.m.group(3));
                        int n4 = 0;
                        if (string2.equalsIgnoreCase("bold")) {
                            n4 = 1;
                        } else if (string2.equalsIgnoreCase("italic") || string2.equalsIgnoreCase("italics")) {
                            n4 = 2;
                        } else if (string2.equalsIgnoreCase("bold-italic") || string2.equalsIgnoreCase("italic-bold")) {
                            n4 = 3;
                        }
                        this.currentLegend.setFont(new Font(string, n4, n));
                    }
                    catch (Exception exception) {
                        String string = "value for 'font' attribute in legend element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'font' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("position") != null) {
                if (LEGEND_POSITIONS.get(elementDetails.attributes.getValue("position").toLowerCase()) != null) {
                    this.currentLegend.setPosition((Integer)LEGEND_POSITIONS.get(elementDetails.attributes.getValue("position").toLowerCase()));
                } else {
                    String string = "value for 'position' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("textAlignment") != null) {
                if (LEGEND_ALIGNMENTS.get(elementDetails.attributes.getValue("textAlignment").toLowerCase()) != null) {
                    this.currentLegend.setAlignment((Integer)LEGEND_ALIGNMENTS.get(elementDetails.attributes.getValue("textAlignment").toLowerCase()));
                } else {
                    String string = "value for 'textAlignment' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("drawWhenZoomed") != null) {
                if (LEGEND_SHOW_ZOOM.get(elementDetails.attributes.getValue("drawWhenZoomed").toLowerCase()) != null) {
                    this.currentLegend.setPosition((Integer)LEGEND_POSITIONS.get(elementDetails.attributes.getValue("drawWhenZoomed").toLowerCase()));
                } else {
                    String string = "value for 'drawWhenZoomed' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("backgroundOpacity") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("backgroundOpacity"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'backgroundOpacity' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'backgroundOpacity' attribute in legend element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'backgroundOpacity' attribute in legend element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentLegend.setBackgroundOpacity(f);
            }
            if (elementDetails.attributes.getValue("backgroundColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("backgroundColor").toLowerCase()) != null) {
                    this.currentLegend.setBackgroundColor((Color)COLORS.get(elementDetails.attributes.getValue("backgroundColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("backgroundColor"));
                    if (this.m.find()) {
                        try {
                            int n5 = Integer.parseInt(this.m.group(1));
                            n2 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentLegend.setBackgroundColor(new Color(n5, n2, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'backgroundColor' attribute in legend element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'backgroundColor' attribute in legend element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("allowLabelClash") != null) {
                if (BOOLEANS.get(elementDetails.attributes.getValue("allowLabelClash").toLowerCase()) != null) {
                    this.currentLegend.setAllowLabelClash((Boolean)BOOLEANS.get(elementDetails.attributes.getValue("allowLabelClash").toLowerCase()));
                } else {
                    String string = "value for 'allowLabelClash' attribute in legend element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (this.legendFontSize == -1) continue;
            if (this.currentLegend.getFont() != null) {
                this.currentLegend.setFont(new Font(this.currentLegend.getFont().getName(), this.currentLegend.getFont().getStyle(), this.legendFontSize));
                continue;
            }
            this.currentLegend.setFont(new Font(this.currentCgview.getLegendFont().getName(), this.currentCgview.getLegendFont().getStyle(), this.legendFontSize));
        }
    }

    private void handleLegendItem() throws SAXException {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            int n;
            ElementDetails elementDetails = (ElementDetails)this.context.elementAt(i);
            if (!elementDetails.name.equalsIgnoreCase("legendItem")) continue;
            if (this.currentLegend == null) {
                String string = "legendItem element encountered inside of legend element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentCgview == null) {
                String string = "legendItem element encountered outside of a cgview element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (this.currentLegendItem != null) {
                String string = "legendItem element encountered inside of another legendItem element";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            if (elementDetails.attributes.getValue("text") == null) {
                String string = "legendItem element is missing 'text' attribute";
                if (this.locator != null) {
                    string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                }
                throw new SAXException(string);
            }
            this.currentLegendItem = new LegendItem(this.currentLegend);
            this.currentLegendItem.setLabel(elementDetails.attributes.getValue("text"));
            if (elementDetails.attributes.getValue("swatchOpacity") != null) {
                float f;
                try {
                    f = Float.parseFloat(elementDetails.attributes.getValue("swatchOpacity"));
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "value for 'swatchOpacity' attribute in legendItem element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f > 1.0f) {
                    String string = "value for 'swatchOpacity' attribute in legendItem element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                if (f < 0.0f) {
                    String string = "value for 'swatchOpacity' attribute in legendItem element must be between 0 and 1";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    throw new SAXException(string);
                }
                this.currentLegendItem.setSwatchOpacity(f);
            }
            if (elementDetails.attributes.getValue("fontColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("fontColor").toLowerCase()) != null) {
                    this.currentLegendItem.setFontColor((Color)COLORS.get(elementDetails.attributes.getValue("fontColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("fontColor"));
                    if (this.m.find()) {
                        try {
                            int n2 = Integer.parseInt(this.m.group(1));
                            int n3 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentLegendItem.setFontColor(new Color(n2, n3, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'fontColor' attribute in legendItem element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'fontColor' attribute in legendItem element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("swatchColor") != null) {
                if (COLORS.get(elementDetails.attributes.getValue("swatchColor").toLowerCase()) != null) {
                    this.currentLegendItem.setSwatchColor((Color)COLORS.get(elementDetails.attributes.getValue("swatchColor").toLowerCase()));
                } else {
                    this.m = this.colorDescriptionPattern.matcher(elementDetails.attributes.getValue("swatchColor"));
                    if (this.m.find()) {
                        try {
                            int n4 = Integer.parseInt(this.m.group(1));
                            int n5 = Integer.parseInt(this.m.group(2));
                            n = Integer.parseInt(this.m.group(3));
                            this.currentLegendItem.setSwatchColor(new Color(n4, n5, n));
                        }
                        catch (Exception exception) {
                            String string = "value for 'swatchColor' attribute in legendItem element not understood";
                            if (this.locator != null) {
                                string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                            }
                            System.err.println("[warning] " + string);
                        }
                    } else {
                        String string = "value for 'swatchColor' attribute in legendItem element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                }
            }
            if (elementDetails.attributes.getValue("drawSwatch") != null) {
                if (SWATCH_TYPES.get(elementDetails.attributes.getValue("drawSwatch").toLowerCase()) != null) {
                    this.currentLegendItem.setDrawSwatch((Integer)SWATCH_TYPES.get(elementDetails.attributes.getValue("drawSwatch").toLowerCase()));
                } else {
                    String string = "value for 'drawSwatch' attribute in legendItem element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("textAlignment") != null) {
                if (LEGEND_ALIGNMENTS.get(elementDetails.attributes.getValue("textAlignment").toLowerCase()) != null) {
                    this.currentLegendItem.setTextAlignment((Integer)LEGEND_ALIGNMENTS.get(elementDetails.attributes.getValue("textAlignment").toLowerCase()));
                } else {
                    String string = "value for 'textAlignment' attribute in legendItem element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (elementDetails.attributes.getValue("font") != null) {
                this.m = this.fontDescriptionPattern.matcher(elementDetails.attributes.getValue("font"));
                if (this.m.find()) {
                    try {
                        String string = this.m.group(1);
                        String string2 = this.m.group(2);
                        n = Integer.parseInt(this.m.group(3));
                        int n6 = 0;
                        if (string2.equalsIgnoreCase("bold")) {
                            n6 = 1;
                        } else if (string2.equalsIgnoreCase("italic") || string2.equalsIgnoreCase("italics")) {
                            n6 = 2;
                        } else if (string2.equalsIgnoreCase("bold-italic") || string2.equalsIgnoreCase("italic-bold")) {
                            n6 = 3;
                        }
                        this.currentLegendItem.setFont(new Font(string, n6, n));
                    }
                    catch (Exception exception) {
                        String string = "value for 'font' attribute in legendItem element not understood";
                        if (this.locator != null) {
                            string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                        }
                        System.err.println("[warning] " + string);
                    }
                } else {
                    String string = "value for 'font' attribute in legendItem element not understood";
                    if (this.locator != null) {
                        string = string + " in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber() + " column " + this.locator.getColumnNumber();
                    }
                    System.err.println("[warning] " + string);
                }
            }
            if (this.legendFontSize == -1) continue;
            if (this.currentLegendItem.getFont() != null) {
                this.currentLegendItem.setFont(new Font(this.currentLegendItem.getFont().getName(), this.currentLegendItem.getFont().getStyle(), this.legendFontSize));
                continue;
            }
            if (this.currentLegend.getFont() != null) {
                this.currentLegendItem.setFont(new Font(this.currentLegend.getFont().getName(), this.currentLegend.getFont().getStyle(), this.legendFontSize));
                continue;
            }
            this.currentLegendItem.setFont(new Font(this.currentCgview.getLegendFont().getName(), this.currentCgview.getLegendFont().getStyle(), this.legendFontSize));
        }
    }

    private class ElementDetails {
        public String name;
        public Attributes attributes;

        public ElementDetails(String string, Attributes attributes) {
            this.name = string;
            this.attributes = new AttributesImpl(attributes);
        }
    }
}

