/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Legend;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegendItem
implements CgviewConstants {
    private Color fontColor;
    private Color swatchColor = new Color(0, 0, 0);
    private String label;
    private Legend legend;
    private float swatchOpacity = 1.0f;
    private int drawSwatch = 2;
    private Font font;
    private int textAlignment;

    public LegendItem(Legend legend) {
        this.legend = legend;
        this.fontColor = legend.getFontColor();
        this.textAlignment = legend.getAlignment();
        this.font = legend.getFont();
        legend.addLegendItem(this);
    }

    protected void draw(Cgview cgview, double d, double d2, double d3) {
        Pattern pattern;
        Matcher matcher;
        if (this.label == null) {
            this.label = "Untitled";
        }
        if (!(matcher = (pattern = Pattern.compile("\\S")).matcher(this.label)).find()) {
            this.label = "Untitled";
        }
        Graphics2D graphics2D = cgview.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.label, this.font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d;
        d6 -= d5 / 12.0;
        double d7 = d2;
        double d8 = this.legend.getBounds().getWidth() - 10.0;
        if (d3 > 0.0) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2 - d3, d3, d3);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.swatchOpacity));
            graphics2D.setPaint(this.swatchColor);
            graphics2D.fill(double_);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            d8 = d8 - d3 - d3 / 2.0;
            d6 = d + d3 + d3 / 2.0;
        }
        if (this.textAlignment == 3) {
            d6 = d6 + d8 - d4 - d5 / 12.0;
        } else if (this.textAlignment == 2) {
            d6 = d6 + d8 / 2.0 - d4 / 2.0;
        }
        graphics2D.setPaint(this.fontColor);
        textLayout.draw(graphics2D, (float)d6, (float)d7 - textLayout.getDescent());
    }

    protected double getWidth(Cgview cgview, double d) {
        double d2 = 0.0;
        Pattern pattern = Pattern.compile("\\S");
        Matcher matcher = pattern.matcher(this.label);
        if (!matcher.find()) {
            this.label = "Untitled";
        }
        Graphics2D graphics2D = cgview.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.label, this.font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        d2 = rectangle2D.getWidth();
        d2 = d2 + d + d / 2.0;
        return d2;
    }

    protected double getHeight(Cgview cgview) {
        Pattern pattern = Pattern.compile("\\S");
        Matcher matcher = pattern.matcher(this.label);
        if (!matcher.find()) {
            this.label = "Untitled";
        }
        Graphics2D graphics2D = cgview.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.label, this.font, fontRenderContext);
        return textLayout.getDescent() + textLayout.getAscent();
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setSwatchColor(Color color) {
        this.swatchColor = color;
    }

    public Color getSwatchColor() {
        return this.swatchColor;
    }

    public void setDrawSwatch(int n) {
        this.drawSwatch = n;
    }

    public int getDrawSwatch() {
        return this.drawSwatch;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setSwatchOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.swatchOpacity = f;
    }

    public float getSwatchOpacity() {
        return this.swatchOpacity;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setTextAlignment(int n) {
        this.textAlignment = n;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }
}

