/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.InnerLabel;
import ca.ualberta.stothard.cgview.OuterLabel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureRange
implements CgviewConstants {
    private int start;
    private int stop;
    private int decoration;
    private int showLabel;
    private String hyperlink;
    private String mouseover;
    private Color color;
    private Feature feature;
    private String label;
    private Font font;
    private boolean forceLabel;
    private float radiusAdjustment;
    private float proportionOfThickness;
    private float opacity;
    private boolean showShading;

    public FeatureRange(Feature feature, int n, int n2) {
        this.start = n;
        this.stop = n2;
        feature.addRange(this);
        this.decoration = feature.getDecoration();
        this.showLabel = feature.getShowLabel();
        this.color = feature.getColor();
        this.feature = feature;
        this.hyperlink = feature.getHyperlink();
        this.mouseover = feature.getMouseover();
        this.label = feature.getLabel();
        this.font = feature.getFont();
        this.forceLabel = feature.getForceLabel();
        this.radiusAdjustment = feature.getRadiusAdjustment();
        this.proportionOfThickness = feature.getProportionOfThickness();
        this.opacity = feature.getOpacity();
        this.showShading = feature.getShowShading();
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setForceLabel(boolean bl) {
        this.forceLabel = bl;
        if (this.forceLabel) {
            this.showLabel = 3;
        }
    }

    public boolean getForceLabel() {
        return this.forceLabel;
    }

    protected void draw(Cgview cgview, double d, float f, double d2) {
        boolean bl = cgview.getKeepLastLabels();
        if (this.start < 1 || this.stop < 1 || this.start > cgview.getSequenceLength() || this.stop > cgview.getSequenceLength()) {
            System.err.println("[warning] Invalid feature position encountered: start = " + this.start + ", stop = " + this.stop + ".");
        } else if (cgview.getDrawEntirePlasmid()) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, this.start, this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, this.stop, f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, this.stop);
            }
        } else if (this.start == this.stop && cgview.inZoomRange(this.start)) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, this.start, this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, this.stop, f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, this.stop);
            }
        } else if (cgview.inZoomRangeOne(this.start) && cgview.inZoomRangeTwo(this.stop)) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, this.start, this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, this.stop, f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, this.stop);
            }
        } else if (cgview.inZoomRangeOne(this.start) && cgview.inZoomRangeOne(this.stop) && this.start < this.stop) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, this.start, this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, this.stop, f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, this.stop);
            }
        } else if (cgview.inZoomRangeTwo(this.start) && cgview.inZoomRangeTwo(this.stop) && this.start < this.stop) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, this.start, this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, this.stop, f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, this.stop);
            }
        } else if (cgview.inZoomRangeTwo(this.start) && cgview.inZoomRangeOne(this.stop)) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawClockwiseArrow(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, cgview.getZoomRangeTwoStop());
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), this.stop);
            }
        } else if (cgview.inZoomRangeOne(this.start) && cgview.inZoomRangeOne(this.stop) && this.start > this.stop) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawClockwiseArrow(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, cgview.getZoomRangeTwoStop());
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), this.stop);
            }
        } else if (cgview.inZoomRangeTwo(this.start) && cgview.inZoomRangeTwo(this.stop) && this.start > this.stop) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
                this.drawClockwiseArrow(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f);
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, cgview.getZoomRangeTwoStop());
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), this.stop);
            }
        } else if (cgview.inZoomRange(this.stop)) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            } else if (this.decoration == 3) {
                this.drawClockwiseArrow(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f);
            } else if (this.decoration == 2) {
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), this.stop, f, d2);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), this.stop);
            }
        } else if (cgview.inZoomRange(this.start)) {
            if (this.decoration == 1) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
            } else if (this.decoration == 3) {
                this.drawStandard(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f, d2);
            } else if (this.decoration == 2) {
                this.drawCounterclockwiseArrow(cgview, d, this.start, cgview.getZoomRangeTwoStop(), f);
            }
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, this.start, cgview.getZoomRangeTwoStop());
            }
        } else if (this.start < cgview.getZoomRangeOneStart() && this.stop > cgview.getZoomRangeTwoStop() && this.start != this.stop) {
            if (cgview.getZoomRangeTwoStart() == 0) {
                if (this.start > this.stop) {
                    this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop(), f, d2);
                    if (this.showLabel == 2 && !bl) {
                        this.labelStandard(cgview, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop());
                    }
                }
            } else {
                this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop(), f, d2);
                if (this.showLabel == 2 && !bl) {
                    this.labelStandard(cgview, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop());
                }
            }
        } else if (this.stop > cgview.getZoomRangeTwoStop() && this.start > this.stop) {
            this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop(), f, d2);
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop());
            }
        } else if (this.start < cgview.getZoomRangeOneStart() && this.start > this.stop) {
            this.drawStandard(cgview, d, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop(), f, d2);
            if (this.showLabel == 2 && !bl) {
                this.labelStandard(cgview, cgview.getZoomRangeOneStart(), cgview.getZoomRangeTwoStop());
            }
        }
    }

    private void drawStandard(Cgview cgview, double d, int n, int n2, float f, double d2) {
        double d3;
        double d4;
        double d5;
        float f2 = f;
        double d6 = cgview.getShadingProportion();
        float f3 = cgview.getHighlightOpacity();
        float f4 = cgview.getShadowOpacity();
        double d7 = cgview.getOrigin();
        Graphics2D graphics2D = cgview.getGraphics();
        int n3 = cgview.getSequenceLength();
        boolean bl = cgview.getShiftSmallFeatures();
        double d8 = d;
        if (this.proportionOfThickness < 1.0f) {
            d8 = d - 0.5 * (double)f2;
            d8 += (double)(f2 * this.radiusAdjustment);
        }
        double d9 = d + (double)f2 * 0.5 - 0.5 * (double)f2 * (double)this.proportionOfThickness;
        double d10 = d - (double)f2 * 0.5 + 0.5 * (double)f2 * (double)this.proportionOfThickness;
        if (d8 > d9) {
            d8 = d9;
        }
        if (d8 < d10) {
            d8 = d10;
        }
        d = d8;
        f2 = this.proportionOfThickness * f2;
        if (n <= n2) {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n2) - d5;
        } else {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n3) - d5;
            double d11 = cgview.getDegrees(0);
            d3 = cgview.getDegrees(n2) - d11;
            d4 += d3;
        }
        if (d4 * (Math.PI / 180) * d < d2) {
            d4 = d2 / d * 57.29577951308232;
            if (bl) {
                d5 -= 0.5 * d4;
            }
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        graphics2D.setPaint(this.color);
        BasicStroke basicStroke = new BasicStroke(f2, 0, 2);
        Area area = new Area();
        area.add(new Area(basicStroke.createStrokedShape(new Arc2D.Double(-d, -d, d * 2.0, d * 2.0, -d5 - d4 + d7, d4, 0))));
        area.intersect(new Area(cgview.getBackgroundRectangle()));
        graphics2D.fill(area);
        if (this.showShading) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * this.opacity));
            graphics2D.setPaint(Color.white);
            d3 = 0.5 * (double)f2 - 0.5 * ((double)f2 * d6);
            BasicStroke basicStroke2 = new BasicStroke(f2 * (float)d6, 0, 2);
            Area area2 = new Area();
            area2.add(new Area(basicStroke2.createStrokedShape(new Arc2D.Double(-d - d3, -d - d3, (d + d3) * 2.0, (d + d3) * 2.0, -d5 - d4 + d7, d4, 0))));
            area2.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f4 * this.opacity));
            graphics2D.setPaint(Color.black);
            double d12 = -0.5 * (double)f2 + 0.5 * ((double)f2 * d6);
            BasicStroke basicStroke3 = new BasicStroke(f2 * (float)d6, 0, 2);
            Area area3 = new Area();
            area3.add(new Area(basicStroke3.createStrokedShape(new Arc2D.Double(-d - d12, -d - d12, (d + d12) * 2.0, (d + d12) * 2.0, -d5 - d4 + d7, d4, 0))));
            area3.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area3);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void drawClockwiseArrow(Cgview cgview, double d, int n, int n2, float f) {
        Object object;
        double d2;
        double d3;
        double d4;
        double d5;
        float f2 = f;
        double d6 = cgview.getShadingProportion();
        float f3 = cgview.getHighlightOpacity();
        float f4 = cgview.getShadowOpacity();
        double d7 = cgview.getOrigin();
        Graphics2D graphics2D = cgview.getGraphics();
        int n3 = cgview.getSequenceLength();
        boolean bl = cgview.getShiftSmallFeatures();
        double d8 = cgview.getArrowheadLength();
        double d9 = d;
        if (this.proportionOfThickness < 1.0f) {
            d9 = d - 0.5 * (double)f2;
            d9 += (double)(f2 * this.radiusAdjustment);
        }
        double d10 = d + (double)f2 * 0.5 - 0.5 * (double)f2 * (double)this.proportionOfThickness;
        double d11 = d - (double)f2 * 0.5 + 0.5 * (double)f2 * (double)this.proportionOfThickness;
        if (d9 > d10) {
            d9 = d10;
        }
        if (d9 < d11) {
            d9 = d11;
        }
        d = d9;
        f2 = this.proportionOfThickness * f2;
        if (n <= n2) {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n2) - d5;
        } else {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n3) - d5;
            double d12 = cgview.getDegrees(0);
            double d13 = cgview.getDegrees(n2) - d12;
            d4 += d13;
        }
        int n4 = n2;
        double d14 = d8 / d * 57.29577951308232;
        if (d4 * (Math.PI / 180) * d < d8 && bl) {
            d3 = -(-cgview.getDegrees(n4) + d7 + 0.5 * d4 - 0.5 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
            d2 = -(-cgview.getDegrees(n4) + d7 + d8 / d * 57.29577951308232 + 0.5 * d4 - 0.5 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
            d4 = 0.0;
        } else {
            d4 -= d14;
            d3 = -(-cgview.getDegrees(n4) + d7) * (Math.PI / 180);
            d2 = -(-cgview.getDegrees(n4) + d7 + d8 / d * 57.29577951308232) * (Math.PI / 180);
        }
        double d15 = d + 0.5 * (double)f2;
        double d16 = d - 0.5 * (double)f2;
        Area area = new Area();
        Area area2 = new Area();
        Area area3 = new Area();
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo((float)(Math.cos(d2) * d15), (float)(Math.sin(d2) * d15));
        generalPath.lineTo((float)(Math.cos(d2) * d16), (float)(Math.sin(d2) * d16));
        generalPath.lineTo((float)(Math.cos(d3) * d), (float)(Math.sin(d3) * d));
        generalPath.closePath();
        area.add(new Area(generalPath));
        if (this.showShading) {
            object = new GeneralPath(1);
            ((Path2D.Float)object).moveTo((float)(Math.cos(d2) * d15), (float)(Math.sin(d2) * d15));
            ((Path2D.Float)object).lineTo((float)(Math.cos(d3) * d), (float)(Math.sin(d3) * d));
            ((Path2D.Float)object).lineTo((float)(Math.cos(d2) * (d15 - (double)f2 * d6)), (float)(Math.sin(d2) * (d15 - (double)f2 * d6)));
            area2.add(new Area((Shape)object));
            GeneralPath generalPath2 = new GeneralPath(1);
            generalPath2.moveTo((float)(Math.cos(d2) * d16), (float)(Math.sin(d2) * d16));
            generalPath2.lineTo((float)(Math.cos(d3) * d), (float)(Math.sin(d3) * d));
            generalPath2.lineTo((float)(Math.cos(d2) * (d16 + (double)f2 * d6)), (float)(Math.sin(d2) * (d16 + (double)f2 * d6)));
            area3.add(new Area(generalPath2));
        }
        if (d4 > 0.0) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            graphics2D.setPaint(this.color);
            object = new BasicStroke(f2, 0, 2);
            area.add(new Area(((BasicStroke)object).createStrokedShape(new Arc2D.Double(-d, -d, d * 2.0, d * 2.0, -d5 - d4 + d7, d4, 0))));
            area.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area);
            if (this.showShading) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * this.opacity));
                graphics2D.setPaint(Color.white);
                double d17 = 0.5 * (double)f2 - 0.5 * ((double)f2 * d6);
                BasicStroke basicStroke = new BasicStroke(f2 * (float)d6, 0, 2);
                area2.add(new Area(basicStroke.createStrokedShape(new Arc2D.Double(-d - d17, -d - d17, (d + d17) * 2.0, (d + d17) * 2.0, -d5 - d4 + d7, d4, 0))));
                area2.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, f4 * this.opacity));
                graphics2D.setPaint(Color.black);
                double d18 = -0.5 * (double)f2 + 0.5 * ((double)f2 * d6);
                BasicStroke basicStroke2 = new BasicStroke(f2 * (float)d6, 0, 2);
                area3.add(new Area(basicStroke2.createStrokedShape(new Arc2D.Double(-d - d18, -d - d18, (d + d18) * 2.0, (d + d18) * 2.0, -d5 - d4 + d7, d4, 0))));
                area3.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area3);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            graphics2D.setPaint(this.color);
            area.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area);
            if (this.showShading) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * this.opacity));
                graphics2D.setPaint(Color.white);
                area2.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, f4 * this.opacity));
                graphics2D.setPaint(Color.black);
                area3.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area3);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    private void drawCounterclockwiseArrow(Cgview cgview, double d, int n, int n2, float f) {
        Object object;
        double d2;
        double d3;
        double d4;
        double d5;
        float f2 = f;
        double d6 = cgview.getShadingProportion();
        float f3 = cgview.getHighlightOpacity();
        float f4 = cgview.getShadowOpacity();
        double d7 = cgview.getOrigin();
        Graphics2D graphics2D = cgview.getGraphics();
        int n3 = cgview.getSequenceLength();
        boolean bl = cgview.getShiftSmallFeatures();
        double d8 = cgview.getArrowheadLength();
        double d9 = d;
        if (this.proportionOfThickness < 1.0f) {
            d9 = d - 0.5 * (double)f2;
            d9 += (double)(f2 * this.radiusAdjustment);
        }
        double d10 = d + (double)f2 * 0.5 - 0.5 * (double)f2 * (double)this.proportionOfThickness;
        double d11 = d - (double)f2 * 0.5 + 0.5 * (double)f2 * (double)this.proportionOfThickness;
        if (d9 > d10) {
            d9 = d10;
        }
        if (d9 < d11) {
            d9 = d11;
        }
        d = d9;
        f2 = this.proportionOfThickness * f2;
        if (n <= n2) {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n2) - d5;
        } else {
            d5 = cgview.getDegrees(n - 1);
            d4 = cgview.getDegrees(n3) - d5;
            double d12 = cgview.getDegrees(0);
            double d13 = cgview.getDegrees(n2) - d12;
            d4 += d13;
        }
        int n4 = n - 1;
        double d14 = d8 / d * 57.29577951308232;
        if (d4 * (Math.PI / 180) * d < d8 && bl) {
            d3 = -(-cgview.getDegrees(n4) + d7 - 0.5 * d4 - 0.5 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
            d2 = -(-cgview.getDegrees(n4) + d7 - 0.5 * d4 + d8 / d * 57.29577951308232 - 0.5 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
            d4 = 0.0;
        } else {
            d4 -= d14;
            d5 += d14;
            d3 = -(-cgview.getDegrees(n4) + d7 - 1.0 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
            d2 = -(-cgview.getDegrees(n4) + d7 + d8 / d * 57.29577951308232 - 1.0 * (d8 / d * 57.29577951308232)) * (Math.PI / 180);
        }
        Area area = new Area();
        Area area2 = new Area();
        Area area3 = new Area();
        double d15 = d + 0.5 * (double)f2;
        double d16 = d - 0.5 * (double)f2;
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo((float)(Math.cos(d3) * d15), (float)(Math.sin(d3) * d15));
        generalPath.lineTo((float)(Math.cos(d3) * d16), (float)(Math.sin(d3) * d16));
        generalPath.lineTo((float)(Math.cos(d2) * d), (float)(Math.sin(d2) * d));
        generalPath.closePath();
        area.add(new Area(generalPath));
        if (this.showShading) {
            object = new GeneralPath(1);
            ((Path2D.Float)object).moveTo((float)(Math.cos(d3) * d15), (float)(Math.sin(d3) * d15));
            ((Path2D.Float)object).lineTo((float)(Math.cos(d2) * d), (float)(Math.sin(d2) * d));
            ((Path2D.Float)object).lineTo((float)(Math.cos(d3) * (d15 - (double)f2 * d6)), (float)(Math.sin(d3) * (d15 - (double)f2 * d6)));
            area2.add(new Area((Shape)object));
            GeneralPath generalPath2 = new GeneralPath(1);
            generalPath2.moveTo((float)(Math.cos(d3) * d16), (float)(Math.sin(d3) * d16));
            generalPath2.lineTo((float)(Math.cos(d2) * d), (float)(Math.sin(d2) * d));
            generalPath2.lineTo((float)(Math.cos(d3) * (d16 + (double)f2 * d6)), (float)(Math.sin(d3) * (d16 + (double)f2 * d6)));
            area3.add(new Area(generalPath2));
        }
        if (d4 > 0.0) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            graphics2D.setPaint(this.color);
            object = new BasicStroke(f2, 0, 2);
            area.add(new Area(((BasicStroke)object).createStrokedShape(new Arc2D.Double(-d, -d, d * 2.0, d * 2.0, -d5 - d4 + d7, d4, 0))));
            area.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area);
            if (this.showShading) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * this.opacity));
                graphics2D.setPaint(Color.white);
                double d17 = 0.5 * (double)f2 - 0.5 * ((double)f2 * d6);
                BasicStroke basicStroke = new BasicStroke(f2 * (float)d6, 0, 2);
                area2.add(new Area(basicStroke.createStrokedShape(new Arc2D.Double(-d - d17, -d - d17, (d + d17) * 2.0, (d + d17) * 2.0, -d5 - d4 + d7, d4, 0))));
                area2.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, f4 * this.opacity));
                graphics2D.setPaint(Color.black);
                double d18 = -0.5 * (double)f2 + 0.5 * ((double)f2 * d6);
                BasicStroke basicStroke2 = new BasicStroke(f2 * (float)d6, 0, 2);
                area3.add(new Area(basicStroke2.createStrokedShape(new Arc2D.Double(-d - d18, -d - d18, (d + d18) * 2.0, (d + d18) * 2.0, -d5 - d4 + d7, d4, 0))));
                area3.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area3);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
            graphics2D.setPaint(this.color);
            area.intersect(new Area(cgview.getBackgroundRectangle()));
            graphics2D.fill(area);
            if (this.showShading) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * this.opacity));
                graphics2D.setPaint(Color.white);
                area2.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, f4 * this.opacity));
                graphics2D.setPaint(Color.black);
                area3.intersect(new Area(cgview.getBackgroundRectangle()));
                graphics2D.fill(area3);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    private void labelStandard(Cgview cgview, int n, int n2) {
        double d = cgview.getOrigin();
        int n3 = cgview.getSequenceLength();
        boolean bl = true;
        if (this.label == null) {
            bl = false;
        } else {
            Pattern pattern = Pattern.compile("\\S");
            Matcher matcher = pattern.matcher(this.label);
            if (!matcher.find()) {
                bl = false;
            }
        }
        if (this.mouseover != null || this.hyperlink != null) {
            bl = true;
        }
        if (bl) {
            double d2;
            double d3;
            if (n <= n2) {
                d3 = cgview.getDegrees(n - 1);
                d2 = cgview.getDegrees(n2) - d3;
            } else {
                d3 = cgview.getDegrees(n - 1);
                d2 = cgview.getDegrees(n3) - d3;
                double d4 = cgview.getDegrees(0);
                double d5 = cgview.getDegrees(n2) - d4;
                d2 += d5;
            }
            double d6 = -(-d3 - d2 + d + d2 / 2.0) * Math.PI / 180.0;
            if (d6 < 0.0) {
                d6 = Math.PI * 2 + d6;
            }
            String string = cgview.getGiveFeaturePositions() == 2 || cgview.getZoomMultiplier() < cgview.getZoomShift() && cgview.getGiveFeaturePositions() == 3 ? this.label : (n == n2 ? this.label + " " + Integer.toString(this.start) : (this.feature.getStrand() == 2 ? (this.decoration == 1 || this.decoration == 3 ? this.label + " " + Integer.toString(this.start) + "-" + Integer.toString(this.stop) : this.label + " " + Integer.toString(this.start) + "-" + Integer.toString(this.stop)) : (this.decoration == 1 || this.decoration == 3 ? this.label + " " + Integer.toString(this.start) + "-" + Integer.toString(this.stop) : this.label + " " + Integer.toString(this.stop) + "-" + Integer.toString(this.start))));
            if (cgview.getUseInnerLabels() == 2 || cgview.getZoomMultiplier() < cgview.getZoomShift() && cgview.getUseInnerLabels() == 3) {
                OuterLabel outerLabel = new OuterLabel(cgview, string, this.hyperlink, this.mouseover, this.font, this.color, this.forceLabel, d6, this.feature.getStrand());
            } else if (this.feature.getStrand() == 1) {
                OuterLabel outerLabel = new OuterLabel(cgview, string, this.hyperlink, this.mouseover, this.font, this.color, this.forceLabel, d6, this.feature.getStrand());
            } else {
                InnerLabel innerLabel = new InnerLabel(cgview, string, this.hyperlink, this.mouseover, this.font, this.color, this.forceLabel, d6, this.feature.getStrand());
            }
        }
    }

    public void setShowLabel(int n) {
        this.showLabel = n;
        this.forceLabel = this.showLabel == 3;
    }

    public int getShowLabel() {
        return this.showLabel;
    }

    public void setDecoration(int n) {
        this.decoration = n;
    }

    public int getDecoration() {
        return this.decoration;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRadiusAdjustment(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.radiusAdjustment = f;
    }

    public float getRadiusAdjustment() {
        return this.radiusAdjustment;
    }

    public void setProportionOfThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.proportionOfThickness = f;
    }

    public float getProportionOfThickness() {
        return this.proportionOfThickness;
    }

    public void setOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.opacity = f;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setShowShading(boolean bl) {
        this.showShading = bl;
    }

    public boolean getShowShading() {
        return this.showShading;
    }

    public void setHyperlink(String string) {
        this.hyperlink = string;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setMouseover(String string) {
        this.mouseover = string;
    }

    public String getMouseover() {
        return this.mouseover;
    }
}

