/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.FeatureRange;
import ca.ualberta.stothard.cgview.FeatureSlot;
import ca.ualberta.stothard.cgview.Legend;
import ca.ualberta.stothard.cgview.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class CgviewFactoryTab
implements CgviewConstants {
    private Cgview cgview;
    private Hashtable COLORS = new Hashtable();
    private Hashtable MAP_ITEM_COLORS = new Hashtable();
    private Hashtable FEATURE_COLORS = new Hashtable();
    private Hashtable FEATURE_DECORATIONS_DIRECT = new Hashtable();
    private Hashtable FEATURE_DECORATIONS_REVERSE = new Hashtable();
    private Hashtable LEGEND_ITEM_NAMES = new Hashtable();
    private Hashtable DRAW_LEGEND_ITEMS = new Hashtable();
    private Hashtable DEFAULT_MAP_SIZES = new Hashtable();
    private Hashtable MIN_MAP_SIZES = new Hashtable();
    private Hashtable MAX_MAP_SIZES = new Hashtable();
    private Hashtable DEFAULT_MAP_MODES = new Hashtable();
    private Hashtable SMALL_MAP_MODES = new Hashtable();
    private Hashtable LARGE_MAP_MODES = new Hashtable();
    private int LARGE_MAP_MODE_DIMENSION = 2000;
    private int SMALL_MAP_MODE_DIMENSION = 800;
    private FeatureSlot forwardSlot1;
    private FeatureSlot forwardSlot2;
    private FeatureSlot forwardSlot3;
    private FeatureSlot forwardSlot4;
    private FeatureSlot forwardSlot5;
    private FeatureSlot forwardSlot6;
    private FeatureSlot reverseSlot1;
    private FeatureSlot reverseSlot2;
    private FeatureSlot reverseSlot3;
    private FeatureSlot reverseSlot4;
    private FeatureSlot reverseSlot5;
    private FeatureSlot reverseSlot6;
    private Legend legend;
    private int zoomCenter = 1;
    private int length = 0;
    private String title = "";
    private int mapWidth = 900;
    private int mapHeight = 600;
    private int mapSmallest = 0;
    private float mapItemSizeAdjustment = 0.0f;
    private int labelFontSize = -1;
    private int rulerFontSize = -1;
    private int legendFontSize = -1;
    private double tickDensity = 1.0;
    private boolean readDimension = true;
    private NumberFormat nf = NumberFormat.getInstance();
    private int MAX_MOUSEOVER_LENGTH = 100;
    private int MAX_LABEL_LENGTH = 50;
    private int MAX_TITLE_LENGTH = 50;
    private int MAX_SEQUENCE_LENGTH = 200000000;
    private int MAX_IMAGE_WIDTH;
    private int MIN_IMAGE_WIDTH;
    private int MAX_IMAGE_HEIGHT;
    private int MIN_IMAGE_HEIGHT;
    private float opacity = 1.0f;
    private boolean useColoredLabelBackground = false;
    private boolean showTitle = true;
    private boolean showShading = true;
    private boolean showBorder = false;
    private boolean allowLabelClashLegend = false;
    private boolean moveInnerLabelsToOuter = true;
    private int labelPlacementQuality = 9;
    private int legendPosition = 3;
    private boolean useColoredLabels = true;
    private boolean drawTickMarks = true;
    private boolean showLegend = true;
    private boolean showWarning = false;
    private boolean showLabels = true;
    private float shadingProportion = 0.4f;
    private float shadingOpacity = 0.5f;

    public CgviewFactoryTab() {
        this.cgview = new Cgview(1);
    }

    public Cgview createCgviewFromFile(String string) throws Exception, IOException {
        File file = new File(string);
        URL uRL = null;
        uRL = file.toURL();
        return this.createCgviewFromURL(uRL);
    }

    public Cgview createCgviewFromURL(URL uRL) throws Exception, IOException {
        String string;
        this.COLORS.put("black", new Color(0, 0, 0));
        this.COLORS.put("silver", new Color(192, 192, 192));
        this.COLORS.put("gray", new Color(128, 128, 128));
        this.COLORS.put("white", new Color(255, 255, 255));
        this.COLORS.put("maroon", new Color(128, 0, 0));
        this.COLORS.put("red", new Color(255, 0, 0));
        this.COLORS.put("pink", new Color(255, 153, 204));
        this.COLORS.put("purple", new Color(128, 0, 128));
        this.COLORS.put("fuchsia", new Color(255, 0, 255));
        this.COLORS.put("orange", new Color(255, 153, 0));
        this.COLORS.put("green", new Color(0, 128, 0));
        this.COLORS.put("spring", new Color(204, 255, 204));
        this.COLORS.put("lime", new Color(0, 255, 0));
        this.COLORS.put("olive", new Color(128, 128, 0));
        this.COLORS.put("yellow", new Color(255, 255, 0));
        this.COLORS.put("navy", new Color(0, 0, 128));
        this.COLORS.put("blue", new Color(0, 0, 255));
        this.COLORS.put("azure", new Color(51, 153, 255));
        this.COLORS.put("lightBlue", new Color(102, 204, 255));
        this.COLORS.put("teal", new Color(153, 255, 204));
        this.COLORS.put("aqua", new Color(0, 255, 255));
        this.MAP_ITEM_COLORS.put("tick", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("rulerFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("titleFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("messageFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("backbone", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("partialTick", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("zeroLine", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("background", this.COLORS.get("white"));
        this.FEATURE_COLORS.put("forward_gene", this.COLORS.get("red"));
        this.FEATURE_COLORS.put("reverse_gene", this.COLORS.get("blue"));
        this.FEATURE_COLORS.put("origin_of_replication", this.COLORS.get("black"));
        this.FEATURE_COLORS.put("promoter", this.COLORS.get("green"));
        this.FEATURE_COLORS.put("terminator", this.COLORS.get("maroon"));
        this.FEATURE_COLORS.put("regulatory_sequence", this.COLORS.get("olive"));
        this.FEATURE_COLORS.put("unique_restriction_site", this.COLORS.get("purple"));
        this.FEATURE_COLORS.put("restriction_site", this.COLORS.get("azure"));
        this.FEATURE_COLORS.put("open_reading_frame", this.COLORS.get("pink"));
        this.FEATURE_COLORS.put("predicted_gene", this.COLORS.get("orange"));
        this.FEATURE_COLORS.put("sequence_similarity", this.COLORS.get("silver"));
        this.FEATURE_COLORS.put("score", this.COLORS.get("fuchsia"));
        this.FEATURE_COLORS.put("score_II", this.COLORS.get("gray"));
        this.FEATURE_COLORS.put("misc", this.COLORS.get("gray"));
        this.FEATURE_COLORS.put("primer", this.COLORS.get("teal"));
        this.FEATURE_DECORATIONS_DIRECT.put("forward_gene", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("origin_of_replication", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("promoter", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("terminator", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("regulatory_sequence", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("unique_restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("open_reading_frame", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("predicted_gene", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("sequence_similarity", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("score", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("score_II", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("misc", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("primer", new Integer(3));
        this.FEATURE_DECORATIONS_REVERSE.put("reverse_gene", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("origin_of_replication", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("promoter", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("terminator", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("regulatory_sequence", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("unique_restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("restriction_site", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("open_reading_frame", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("predicted_gene", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("sequence_similarity", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("score", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("score_II", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("misc", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("primer", new Integer(2));
        this.LEGEND_ITEM_NAMES.put("forward_gene", "Forward gene");
        this.LEGEND_ITEM_NAMES.put("reverse_gene", "Reverse gene");
        this.LEGEND_ITEM_NAMES.put("origin_of_replication", "Origin of replication");
        this.LEGEND_ITEM_NAMES.put("promoter", "Promoter");
        this.LEGEND_ITEM_NAMES.put("terminator", "Terminator");
        this.LEGEND_ITEM_NAMES.put("regulatory_sequence", "Regulatory sequence");
        this.LEGEND_ITEM_NAMES.put("unique_restriction_site", "Unique restriction site");
        this.LEGEND_ITEM_NAMES.put("restriction_site", "Restriction site");
        this.LEGEND_ITEM_NAMES.put("open_reading_frame", "Open reading frame");
        this.LEGEND_ITEM_NAMES.put("predicted_gene", "Predicted gene");
        this.LEGEND_ITEM_NAMES.put("sequence_similarity", "Sequence similarity");
        this.LEGEND_ITEM_NAMES.put("score", "Score");
        this.LEGEND_ITEM_NAMES.put("score_II", "Score II");
        this.LEGEND_ITEM_NAMES.put("misc", "Miscellaneous");
        this.LEGEND_ITEM_NAMES.put("primer", "Primer");
        this.DEFAULT_MAP_SIZES.put("mapWidth", new Integer(900));
        this.DEFAULT_MAP_SIZES.put("mapHeight", new Integer(900));
        this.DEFAULT_MAP_SIZES.put("labelFontSize", new Integer(10));
        this.DEFAULT_MAP_SIZES.put("titleFontSize", new Integer(15));
        this.DEFAULT_MAP_SIZES.put("legendFontSize", new Integer(13));
        this.DEFAULT_MAP_SIZES.put("rulerFontSize", new Integer(8));
        this.DEFAULT_MAP_SIZES.put("messageFontSize", new Integer(12));
        this.DEFAULT_MAP_SIZES.put("featureThickness", new Float(12.0f));
        this.DEFAULT_MAP_SIZES.put("backboneThickness", new Float(4.0f));
        this.DEFAULT_MAP_SIZES.put("featureSlotSpacing", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("tickLength", new Float(6.0f));
        this.DEFAULT_MAP_SIZES.put("tickThickness", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("shortTickThickness", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("labelLineLength", new Double(50.0));
        this.DEFAULT_MAP_SIZES.put("labelLineThickness", new Float(1.0f));
        this.DEFAULT_MAP_SIZES.put("arrowheadLength", new Double(5.0));
        this.DEFAULT_MAP_SIZES.put("maxLabels", new Integer(5000));
        this.MIN_MAP_SIZES.put("mapWidth", new Integer(500));
        this.MIN_MAP_SIZES.put("mapHeight", new Integer(500));
        this.MIN_MAP_SIZES.put("labelFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("titleFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("legendFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("rulerFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("messageFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("featureThickness", new Float(0.5f));
        this.MIN_MAP_SIZES.put("backboneThickness", new Float(0.1f));
        this.MIN_MAP_SIZES.put("featureSlotSpacing", new Float(0.1f));
        this.MIN_MAP_SIZES.put("tickLength", new Float(1.0f));
        this.MIN_MAP_SIZES.put("tickThickness", new Float(0.5f));
        this.MIN_MAP_SIZES.put("shortTickThickness", new Float(0.5));
        this.MIN_MAP_SIZES.put("labelLineLength", new Double(2.0));
        this.MIN_MAP_SIZES.put("labelLineThickness", new Float(0.5));
        this.MIN_MAP_SIZES.put("arrowheadLength", new Double(0.5));
        this.MIN_MAP_SIZES.put("maxLabels", new Integer(10));
        this.MAX_MAP_SIZES.put("mapWidth", new Integer(30000));
        this.MAX_MAP_SIZES.put("mapHeight", new Integer(30000));
        this.MAX_MAP_SIZES.put("labelFontSize", new Integer(10));
        this.MAX_MAP_SIZES.put("titleFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("legendFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("rulerFontSize", new Integer(8));
        this.MAX_MAP_SIZES.put("messageFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("featureThickness", new Float(80.0f));
        this.MAX_MAP_SIZES.put("backboneThickness", new Float(5.0f));
        this.MAX_MAP_SIZES.put("featureSlotSpacing", new Float(5.0f));
        this.MAX_MAP_SIZES.put("tickLength", new Float(6.0f));
        this.MAX_MAP_SIZES.put("tickThickness", new Float(2.0f));
        this.MAX_MAP_SIZES.put("shortTickThickness", new Float(2.0f));
        this.MAX_MAP_SIZES.put("labelLineLength", new Double(80.0));
        this.MAX_MAP_SIZES.put("labelLineThickness", new Float(1.0f));
        this.MAX_MAP_SIZES.put("arrowheadLength", new Double(18.0));
        this.MAX_MAP_SIZES.put("maxLabels", new Integer(50000));
        this.DEFAULT_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.DEFAULT_MAP_MODES.put("useInnerLabels", new Integer(3));
        this.SMALL_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.SMALL_MAP_MODES.put("useInnerLabels", new Integer(3));
        this.LARGE_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.LARGE_MAP_MODES.put("useInnerLabels", new Integer(1));
        this.MAX_IMAGE_WIDTH = (Integer)this.MAX_MAP_SIZES.get("mapWidth");
        this.MIN_IMAGE_WIDTH = (Integer)this.MIN_MAP_SIZES.get("mapWidth");
        this.MAX_IMAGE_HEIGHT = (Integer)this.MAX_MAP_SIZES.get("mapHeight");
        this.MIN_IMAGE_HEIGHT = (Integer)this.MIN_MAP_SIZES.get("mapHeight");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        InputStream inputStream = uRL.openStream();
        System.out.println("Parsing tab delimited input.");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            ++n;
            if (string.startsWith("#")) {
                this.title = string.substring(1);
                continue;
            }
            if (string.startsWith("%")) {
                try {
                    this.length = Integer.parseInt(string.substring(1));
                    continue;
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with the length value on line " + n + " in the data file.");
                }
            }
            if (string.startsWith("!")) {
                string = string.substring(1);
                stringArray = string.split("(?:\\s*\\t+\\s*)|(?:\\s{2,})");
                n2 = stringArray.length;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i].trim();
                    if (string6.equalsIgnoreCase("strand")) {
                        bl = true;
                        n6 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("slot")) {
                        bl2 = true;
                        n7 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("start")) {
                        bl3 = true;
                        n8 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("stop")) {
                        bl4 = true;
                        n9 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("type")) {
                        bl8 = true;
                        n13 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("opacity")) {
                        bl5 = true;
                        n10 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("thickness")) {
                        bl6 = true;
                        n11 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("radius")) {
                        bl7 = true;
                        n12 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("label")) {
                        bl9 = true;
                        n14 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("mouseover")) {
                        bl10 = true;
                        n15 = i;
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("hyperlink")) continue;
                    bl11 = true;
                    n16 = i;
                }
                continue;
            }
            stringArray = string.split("\\s*\\t+\\s*");
            if (stringArray.length != n2) {
                stringArray = string.split("(?:\\s*\\t+\\s*)|(?:\\s{2,})");
            }
            if (stringArray.length >= 5) {
                String string7;
                if (!bl) {
                    throw new Exception("A \"strand\" column has not been defined in the data file.");
                }
                if (!bl2) {
                    throw new Exception("A \"slot\" column has not been defined in the data file.");
                }
                if (!bl3) {
                    throw new Exception("A \"start\" column has not been defined in the data file.");
                }
                if (!bl4) {
                    throw new Exception("A \"stop\" column has not been defined in the data file.");
                }
                if (!bl8) {
                    throw new Exception("A \"type\" column has not been defined in the data file.");
                }
                try {
                    string7 = stringArray[n6];
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                try {
                    n3 = Integer.parseInt(stringArray[n7]);
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                try {
                    n4 = Integer.parseInt(stringArray[n8]);
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                try {
                    n5 = Integer.parseInt(stringArray[n9]);
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                try {
                    string2 = stringArray[n13];
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                if (bl5) {
                    try {
                        if (!stringArray[n10].matches("^\\s*$") && !stringArray[n10].equals("-")) {
                            f = Float.parseFloat(stringArray[n10]);
                        }
                        f = 1.0f;
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    f = 1.0f;
                }
                if (bl6) {
                    try {
                        if (!stringArray[n11].matches("^\\s*$") && !stringArray[n11].equals("-")) {
                            f2 = Float.parseFloat(stringArray[n11]);
                        }
                        f2 = 1.0f;
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    f2 = 1.0f;
                }
                if (bl7) {
                    try {
                        if (!stringArray[n12].matches("^\\s*$") && !stringArray[n12].equals("-")) {
                            f3 = Float.parseFloat(stringArray[n12]);
                        }
                        f3 = 0.0f;
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    f3 = 0.0f;
                }
                if (bl9) {
                    try {
                        if (!stringArray[n14].matches("^\\s*$") && !stringArray[n14].equals("-")) {
                            string3 = stringArray[n14];
                        }
                        string3 = "";
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    string3 = "";
                }
                if (bl10) {
                    try {
                        if (!stringArray[n15].matches("^\\s*$") && !stringArray[n15].equals("-")) {
                            string4 = stringArray[n15];
                        }
                        string4 = "";
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    string4 = "";
                }
                if (bl11) {
                    try {
                        if (!stringArray[n16].matches("^\\s*$") && !stringArray[n16].equals("-")) {
                            string5 = stringArray[n16];
                        }
                        string5 = "";
                    }
                    catch (Exception exception) {
                        throw new Exception("There is a problem with line " + n + " in the data file.");
                    }
                } else {
                    string5 = "";
                }
                try {
                    if (string2.equalsIgnoreCase("gene")) {
                        if (string7.equalsIgnoreCase("forward") || string7.equalsIgnoreCase("+")) {
                            string2 = "forward_gene";
                        } else if (string7.equalsIgnoreCase("reverse") || string7.equalsIgnoreCase("-")) {
                            string2 = "reverse_gene";
                        }
                    }
                    this.addFeature(string7, n3, n4, n5, f, f2, f3, string2, string3, string4, string5);
                    continue;
                }
                catch (Exception exception) {
                    throw new Exception("Line " + n + ": " + exception.toString() + ".");
                }
            }
            if (stringArray.length <= 2) continue;
            throw new Exception("The contents of line " + n + " could not be parsed in the data file.");
        }
        if (this.length > this.MAX_SEQUENCE_LENGTH) {
            throw new Exception("Maximum sequence length is " + this.MAX_SEQUENCE_LENGTH + ".");
        }
        if (this.length < 1) {
            throw new Exception("Minimum sequence length is 1 base.");
        }
        if (this.mapWidth > this.MAX_IMAGE_WIDTH) {
            throw new Exception("Maximum image width is " + this.MAX_IMAGE_WIDTH + ".");
        }
        if (this.mapWidth < this.MIN_IMAGE_WIDTH) {
            throw new Exception("Minimum image width is " + this.MIN_IMAGE_WIDTH + ".");
        }
        if (this.mapHeight > this.MAX_IMAGE_HEIGHT) {
            throw new Exception("Maximum image height is " + this.MAX_IMAGE_HEIGHT + ".");
        }
        if (this.mapHeight < this.MIN_IMAGE_HEIGHT) {
            throw new Exception("Minimum image height is " + this.MIN_IMAGE_HEIGHT + ".");
        }
        this.prepareToDraw();
        return this.cgview;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFeature(String string, int n, int n2, int n3, float f, float f2, float f3, String string2, String string3, String string4, String string5) throws Exception {
        int n4;
        Color color;
        int n5;
        if (n2 > this.length) {
            throw new Exception("The start value " + n2 + " is greater than the sequence length.");
        }
        if (n2 < 1) {
            throw new Exception("The start value " + n2 + " is less than 1.");
        }
        if (n3 > this.length) {
            throw new Exception("The stop value " + n3 + " is greater than the sequence length.");
        }
        if (n3 < 1) {
            throw new Exception("The stop value " + n3 + " is less than 1.");
        }
        if (string.equalsIgnoreCase("forward") || string.equalsIgnoreCase("+")) {
            n5 = 1;
        } else {
            if (!string.equalsIgnoreCase("reverse") && !string.equalsIgnoreCase("-")) throw new Exception("The strand value must be \"forward\" or \"reverse\".");
            n5 = 2;
        }
        try {
            color = this.getFeatureColor(string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("The feature type \"" + string2 + "\" was not recognized.");
        }
        try {
            n4 = this.getFeatureDecoration(string2, n5);
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("The feature type \"" + string2 + "\" was not recognized.");
        }
        try {
            this.addItemToLegend(string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("The feature type \"" + string2 + "\" was not recognized.");
        }
        Feature feature = new Feature(this.showShading);
        FeatureRange featureRange = new FeatureRange(feature, n2, n3);
        featureRange.setDecoration(n4);
        featureRange.setColor(color);
        featureRange.setOpacity(f);
        featureRange.setProportionOfThickness(f2);
        featureRange.setRadiusAdjustment(f3);
        if (n == 5 || n == 6) {
            feature.setShowShading(false);
        }
        if (!string3.matches("^\\s*$")) {
            if (string3.length() > this.MAX_LABEL_LENGTH) {
                string3 = string3.substring(0, this.MAX_LABEL_LENGTH) + "...";
            }
            featureRange.setLabel(string3);
        }
        if (!string4.matches("^\\s*$")) {
            if (string4.length() > this.MAX_MOUSEOVER_LENGTH) {
                string4 = string4.substring(0, this.MAX_MOUSEOVER_LENGTH) + "...";
            }
            featureRange.setMouseover(string4);
        }
        if (!string5.matches("^\\s*$")) {
            featureRange.setHyperlink(string5);
        }
        if (n5 == 1) {
            if (n == 1) {
                if (this.forwardSlot1 == null) {
                    this.forwardSlot1 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot1);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot1);
                }
                return;
            } else if (n == 2) {
                if (this.forwardSlot2 == null) {
                    this.forwardSlot2 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot2);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot2);
                }
                return;
            } else if (n == 3) {
                if (this.forwardSlot3 == null) {
                    this.forwardSlot3 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot3);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot3);
                }
                return;
            } else if (n == 4) {
                if (this.forwardSlot4 == null) {
                    this.forwardSlot4 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot4);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot4);
                }
                return;
            } else if (n == 5) {
                if (this.forwardSlot5 == null) {
                    this.forwardSlot5 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot5);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot5);
                }
                return;
            } else {
                if (n != 6) throw new Exception("The slot value must be between 1 and 6");
                if (this.forwardSlot6 == null) {
                    this.forwardSlot6 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot6);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot6);
                }
            }
            return;
        } else if (n == 1) {
            if (this.reverseSlot1 == null) {
                this.reverseSlot1 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot1);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot1);
            }
            return;
        } else if (n == 2) {
            if (this.reverseSlot2 == null) {
                this.reverseSlot2 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot2);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot2);
            }
            return;
        } else if (n == 3) {
            if (this.reverseSlot3 == null) {
                this.reverseSlot3 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot3);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot3);
            }
            return;
        } else if (n == 4) {
            if (this.reverseSlot4 == null) {
                this.reverseSlot4 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot4);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot4);
            }
            return;
        } else if (n == 5) {
            if (this.reverseSlot5 == null) {
                this.reverseSlot5 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot5);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot5);
            }
            return;
        } else {
            if (n != 6) throw new Exception("The slot value must be between 1 and 6");
            if (this.reverseSlot6 == null) {
                this.reverseSlot6 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot6);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot6);
            }
        }
    }

    private Color getFeatureColor(String string) throws NullPointerException {
        Color color = (Color)this.FEATURE_COLORS.get(string);
        return color;
    }

    private int getFeatureDecoration(String string, int n) throws NullPointerException {
        int n2 = 1;
        n2 = n == 1 ? ((Integer)this.FEATURE_DECORATIONS_DIRECT.get(string)).intValue() : ((Integer)this.FEATURE_DECORATIONS_REVERSE.get(string)).intValue();
        return n2;
    }

    private void addItemToLegend(String string) throws NullPointerException {
        if (!string.equalsIgnoreCase("forward_gene") && !string.equalsIgnoreCase("reverse_gene")) {
            this.DRAW_LEGEND_ITEMS.put(string, new Boolean(true));
        }
    }

    public void setReadDimension(boolean bl) {
        this.readDimension = bl;
    }

    public void setShowWarning(boolean bl) {
        this.showWarning = bl;
    }

    public void setWidth(int n) {
        this.mapWidth = n;
    }

    public void setHeight(int n) {
        this.mapHeight = n;
    }

    public void setMapItemSizeAdjustment(float f) {
        this.mapItemSizeAdjustment = f;
    }

    public void setLabelFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.labelFontSize = n;
    }

    public void setRulerFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.rulerFontSize = n;
    }

    public void setLegendFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.legendFontSize = n;
    }

    public void setTickDensity(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        this.tickDensity = d;
    }

    private void prepareToDraw() {
        LegendItem legendItem;
        int n;
        int n2;
        int n3;
        double d = 1.0;
        this.mapSmallest = Math.min(this.mapWidth, this.mapHeight);
        int n4 = Math.min((Integer)this.DEFAULT_MAP_SIZES.get("mapWidth"), (Integer)this.DEFAULT_MAP_SIZES.get("mapHeight"));
        float f = (float)this.mapSmallest / (float)n4;
        int n5 = (int)Math.floor((f + this.mapItemSizeAdjustment) * (float)((Integer)this.DEFAULT_MAP_SIZES.get("labelFontSize")).intValue() + 0.5f);
        int n6 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("titleFontSize")).intValue() + 0.5f);
        int n7 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("legendFontSize")).intValue() + 0.5f);
        int n8 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("rulerFontSize")).intValue() + 0.5f);
        int n9 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("messageFontSize")).intValue() + 0.5f);
        if (n5 < (Integer)this.MIN_MAP_SIZES.get("labelFontSize")) {
            n5 = (Integer)this.MIN_MAP_SIZES.get("labelFontSize");
        } else if (n5 > (Integer)this.MAX_MAP_SIZES.get("labelFontSize")) {
            n5 = (Integer)this.MAX_MAP_SIZES.get("labelFontSize");
        }
        if (n6 < (Integer)this.MIN_MAP_SIZES.get("titleFontSize")) {
            n6 = (Integer)this.MIN_MAP_SIZES.get("titleFontSize");
        } else if (n6 > (Integer)this.MAX_MAP_SIZES.get("titleFontSize")) {
            n6 = (Integer)this.MAX_MAP_SIZES.get("titleFontSize");
        }
        if (n7 < (Integer)this.MIN_MAP_SIZES.get("legendFontSize")) {
            n7 = (Integer)this.MIN_MAP_SIZES.get("legendFontSize");
        } else if (n7 > (Integer)this.MAX_MAP_SIZES.get("legendFontSize")) {
            n7 = (Integer)this.MAX_MAP_SIZES.get("legendFontSize");
        }
        if (n8 < (Integer)this.MIN_MAP_SIZES.get("rulerFontSize")) {
            n8 = (Integer)this.MIN_MAP_SIZES.get("rulerFontSize");
        } else if (n8 > (Integer)this.MAX_MAP_SIZES.get("rulerFontSize")) {
            n8 = (Integer)this.MAX_MAP_SIZES.get("rulerFontSize");
        }
        if (n9 < (Integer)this.MIN_MAP_SIZES.get("messageFontSize")) {
            n9 = (Integer)this.MIN_MAP_SIZES.get("messageFontSize");
        } else if (n9 > (Integer)this.MAX_MAP_SIZES.get("messageFontSize")) {
            n9 = (Integer)this.MAX_MAP_SIZES.get("messageFontSize");
        }
        Font font = new Font("SansSerif", 0, n5);
        Font font2 = new Font("SansSerif", 0, n6);
        Font font3 = new Font("SansSerif", 0, n7);
        Font font4 = new Font("SansSerif", 0, n8);
        Font font5 = new Font("SansSerif", 0, n9);
        if (this.labelFontSize != -1) {
            font = new Font("SansSerif", 0, this.labelFontSize);
        }
        if (this.rulerFontSize != -1) {
            font4 = new Font("SansSerif", 0, this.rulerFontSize);
        }
        if (this.legendFontSize != -1) {
            font3 = new Font("SansSerif", 0, this.legendFontSize);
        }
        if ((n3 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("maxLabels")).intValue() + 0.5f)) < (Integer)this.MIN_MAP_SIZES.get("maxLabels")) {
            n3 = (Integer)this.MIN_MAP_SIZES.get("maxLabels");
        } else if (n3 > (Integer)this.MAX_MAP_SIZES.get("maxLabels")) {
            n3 = (Integer)this.MAX_MAP_SIZES.get("maxLabels");
        }
        float f2 = (f + this.mapItemSizeAdjustment) * ((Float)this.DEFAULT_MAP_SIZES.get("featureThickness")).floatValue();
        float f3 = (f + this.mapItemSizeAdjustment) * ((Float)this.DEFAULT_MAP_SIZES.get("backboneThickness")).floatValue();
        if (f3 < ((Float)this.MIN_MAP_SIZES.get("backboneThickness")).floatValue()) {
            f3 = ((Float)this.MIN_MAP_SIZES.get("backboneThickness")).floatValue();
        } else if (f3 > ((Float)this.MAX_MAP_SIZES.get("backboneThickness")).floatValue()) {
            f3 = ((Float)this.MAX_MAP_SIZES.get("backboneThickness")).floatValue();
        }
        float f4 = f * ((Float)this.DEFAULT_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        if (f4 < ((Float)this.MIN_MAP_SIZES.get("featureSlotSpacing")).floatValue()) {
            f4 = ((Float)this.MIN_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        } else if (f4 > ((Float)this.MAX_MAP_SIZES.get("featureSlotSpacing")).floatValue()) {
            f4 = ((Float)this.MAX_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        }
        float f5 = f * ((Float)this.DEFAULT_MAP_SIZES.get("tickLength")).floatValue();
        if (f5 < ((Float)this.MIN_MAP_SIZES.get("tickLength")).floatValue()) {
            f5 = ((Float)this.MIN_MAP_SIZES.get("tickLength")).floatValue();
        } else if (f5 > ((Float)this.MAX_MAP_SIZES.get("tickLength")).floatValue()) {
            f5 = ((Float)this.MAX_MAP_SIZES.get("tickLength")).floatValue();
        }
        float f6 = f * ((Float)this.DEFAULT_MAP_SIZES.get("tickThickness")).floatValue();
        if (f6 < ((Float)this.MIN_MAP_SIZES.get("tickThickness")).floatValue()) {
            f6 = ((Float)this.MIN_MAP_SIZES.get("tickThickness")).floatValue();
        } else if (f6 > ((Float)this.MAX_MAP_SIZES.get("tickThickness")).floatValue()) {
            f6 = ((Float)this.MAX_MAP_SIZES.get("tickThickness")).floatValue();
        }
        float f7 = f * ((Float)this.DEFAULT_MAP_SIZES.get("shortTickThickness")).floatValue();
        if (f7 < ((Float)this.MIN_MAP_SIZES.get("shortTickThickness")).floatValue()) {
            f7 = ((Float)this.MIN_MAP_SIZES.get("shortTickThickness")).floatValue();
        } else if (f7 > ((Float)this.MAX_MAP_SIZES.get("shortTickThickness")).floatValue()) {
            f7 = ((Float)this.MAX_MAP_SIZES.get("shortTickThickness")).floatValue();
        }
        float f8 = f * ((Float)this.DEFAULT_MAP_SIZES.get("labelLineThickness")).floatValue();
        if (f8 < ((Float)this.MIN_MAP_SIZES.get("labelLineThickness")).floatValue()) {
            f8 = ((Float)this.MIN_MAP_SIZES.get("labelLineThickness")).floatValue();
        } else if (f8 > ((Float)this.MAX_MAP_SIZES.get("labelLineThickness")).floatValue()) {
            f8 = ((Float)this.MAX_MAP_SIZES.get("labelLineThickness")).floatValue();
        }
        double d2 = (double)f * (Double)this.DEFAULT_MAP_SIZES.get("labelLineLength");
        if (d2 < (Double)this.MIN_MAP_SIZES.get("labelLineLength")) {
            d2 = (Double)this.MIN_MAP_SIZES.get("labelLineLength");
        } else if (d2 > (Double)this.MAX_MAP_SIZES.get("labelLineLength")) {
            d2 = (Double)this.MAX_MAP_SIZES.get("labelLineLength");
        }
        double d3 = (double)(f + this.mapItemSizeAdjustment) * (Double)this.DEFAULT_MAP_SIZES.get("arrowheadLength");
        if (d3 < (Double)this.MIN_MAP_SIZES.get("arrowheadLength")) {
            d3 = (Double)this.MIN_MAP_SIZES.get("arrowheadLength");
        } else if (d3 > (Double)this.MAX_MAP_SIZES.get("arrowheadLength")) {
            d3 = (Double)this.MAX_MAP_SIZES.get("arrowheadLength");
        }
        if (this.mapSmallest <= this.SMALL_MAP_MODE_DIMENSION) {
            n2 = (Integer)this.SMALL_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.SMALL_MAP_MODES.get("useInnerLabels");
        } else if (this.mapSmallest >= this.LARGE_MAP_MODE_DIMENSION) {
            n2 = (Integer)this.LARGE_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.LARGE_MAP_MODES.get("useInnerLabels");
        } else {
            n2 = (Integer)this.DEFAULT_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.DEFAULT_MAP_MODES.get("useInnerLabels");
        }
        float f9 = 0.083f * f2;
        int n10 = 0;
        if (this.forwardSlot1 == null) {
            ++n10;
        }
        if (this.forwardSlot2 == null) {
            ++n10;
        }
        if (this.forwardSlot3 == null) {
            ++n10;
        }
        if (this.forwardSlot4 == null) {
            ++n10;
        }
        if (this.forwardSlot5 == null) {
            ++n10;
        }
        if (this.forwardSlot6 == null) {
            ++n10;
        }
        if (this.reverseSlot1 == null) {
            ++n10;
        }
        if (this.reverseSlot2 == null) {
            ++n10;
        }
        if (this.reverseSlot3 == null) {
            ++n10;
        }
        if (this.reverseSlot4 == null) {
            ++n10;
        }
        if (this.reverseSlot5 == null) {
            ++n10;
        }
        if (this.reverseSlot6 == null) {
            ++n10;
        }
        if ((f2 += (float)n10 * f9) < ((Float)this.MIN_MAP_SIZES.get("featureThickness")).floatValue()) {
            f2 = ((Float)this.MIN_MAP_SIZES.get("featureThickness")).floatValue();
        } else if (f2 > ((Float)this.MAX_MAP_SIZES.get("featureThickness")).floatValue()) {
            f2 = ((Float)this.MAX_MAP_SIZES.get("featureThickness")).floatValue();
        }
        if (this.forwardSlot1 != null) {
            this.forwardSlot1.sortFeaturesByStart();
            this.forwardSlot1.setCgview(this.cgview);
            this.forwardSlot1.setFeatureThickness(f2);
        }
        if (this.forwardSlot2 != null) {
            this.forwardSlot2.sortFeaturesByStart();
            this.forwardSlot2.setCgview(this.cgview);
            this.forwardSlot2.setFeatureThickness(f2);
        }
        if (this.forwardSlot3 != null) {
            this.forwardSlot3.sortFeaturesByStart();
            this.forwardSlot3.setCgview(this.cgview);
            this.forwardSlot3.setFeatureThickness(f2);
        }
        if (this.forwardSlot4 != null) {
            this.forwardSlot4.sortFeaturesByStart();
            this.forwardSlot4.setCgview(this.cgview);
            this.forwardSlot4.setFeatureThickness(f2);
        }
        if (this.forwardSlot5 != null) {
            this.forwardSlot5.sortFeaturesByStart();
            this.forwardSlot5.setCgview(this.cgview);
            this.forwardSlot5.setFeatureThickness(f2);
        }
        if (this.forwardSlot6 != null) {
            this.forwardSlot6.sortFeaturesByStart();
            this.forwardSlot6.setCgview(this.cgview);
            this.forwardSlot6.setFeatureThickness(f2);
        }
        if (this.reverseSlot1 != null) {
            this.reverseSlot1.sortFeaturesByStart();
            this.reverseSlot1.setCgview(this.cgview);
            this.reverseSlot1.setFeatureThickness(f2);
        }
        if (this.reverseSlot2 != null) {
            this.reverseSlot2.sortFeaturesByStart();
            this.reverseSlot2.setCgview(this.cgview);
            this.reverseSlot2.setFeatureThickness(f2);
        }
        if (this.reverseSlot3 != null) {
            this.reverseSlot3.sortFeaturesByStart();
            this.reverseSlot3.setCgview(this.cgview);
            this.reverseSlot3.setFeatureThickness(f2);
        }
        if (this.reverseSlot4 != null) {
            this.reverseSlot4.sortFeaturesByStart();
            this.reverseSlot4.setCgview(this.cgview);
            this.reverseSlot4.setFeatureThickness(f2);
        }
        if (this.reverseSlot5 != null) {
            this.reverseSlot5.sortFeaturesByStart();
            this.reverseSlot5.setCgview(this.cgview);
            this.reverseSlot5.setFeatureThickness(f2);
        }
        if (this.reverseSlot6 != null) {
            this.reverseSlot6.sortFeaturesByStart();
            this.reverseSlot6.setCgview(this.cgview);
            this.reverseSlot6.setFeatureThickness(f2);
        }
        this.cgview.setWidth(this.mapWidth);
        this.cgview.setHeight(this.mapHeight);
        this.cgview.setLabelsToKeep(n3);
        this.cgview.setDrawTickMarks(this.drawTickMarks);
        this.cgview.setTitleFont(font2);
        this.cgview.setLabelFont(font);
        this.cgview.setFeatureThickness(f2);
        this.cgview.setBackboneThickness(f3);
        this.cgview.setFeatureSlotSpacing(f4);
        this.cgview.setMinimumFeatureLength(d);
        this.cgview.setLegendFont(font3);
        this.cgview.setTickLength(f5);
        this.cgview.setTickThickness(f6);
        this.cgview.setShortTickThickness(f7);
        this.cgview.setLabelLineThickness(f8);
        this.cgview.setLabelLineLength(d2);
        this.cgview.setLabelPlacementQuality(this.labelPlacementQuality);
        this.cgview.setUseColoredLabelBackgrounds(this.useColoredLabelBackground);
        this.cgview.setShowBorder(this.showBorder);
        this.cgview.setShowShading(this.showShading);
        this.cgview.setGiveFeaturePositions(n2);
        this.cgview.setShadingProportion(this.shadingProportion);
        this.cgview.setUseInnerLabels(n);
        this.cgview.setMoveInnerLabelsToOuter(this.moveInnerLabelsToOuter);
        this.cgview.setWarningFont(font4);
        this.cgview.setRulerFont(font4);
        this.cgview.setArrowheadLength(d3);
        this.cgview.setHighlightOpacity(this.shadingOpacity);
        this.cgview.setShadowOpacity(this.shadingOpacity);
        this.cgview.setTickDensity(this.tickDensity);
        if (!this.showLabels) {
            this.cgview.setShowWarning(false);
        }
        this.cgview.setSequenceLength(this.length);
        this.mapSmallest = Math.min(this.mapWidth, this.mapHeight);
        this.cgview.setBackboneRadius(0.5 * (double)this.mapSmallest / 1.9);
        if (!this.useColoredLabels) {
            this.cgview.setGlobalLabelColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        }
        this.cgview.setLongTickColor((Color)this.MAP_ITEM_COLORS.get("tick"));
        this.cgview.setShortTickColor((Color)this.MAP_ITEM_COLORS.get("partialTick"));
        this.cgview.setZeroTickColor((Color)this.MAP_ITEM_COLORS.get("zeroLine"));
        this.cgview.setRulerFontColor((Color)this.MAP_ITEM_COLORS.get("rulerFont"));
        this.cgview.setBackboneColor((Color)this.MAP_ITEM_COLORS.get("backbone"));
        this.cgview.setTitleFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        this.cgview.setWarningFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        this.cgview.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
        if (this.showLegend) {
            this.legend = new Legend(this.cgview);
            this.legend.setAllowLabelClash(this.allowLabelClashLegend);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(font3);
            this.legend.setPosition(this.legendPosition);
            this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
            this.legend.setFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            Enumeration enumeration = this.DRAW_LEGEND_ITEMS.keys();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            Collections.sort(arrayList);
            arrayList.add(0, "reverse_gene");
            arrayList.add(0, "forward_gene");
            for (String string : arrayList) {
                legendItem = new LegendItem(this.legend);
                legendItem.setLabel((String)this.LEGEND_ITEM_NAMES.get(string));
                legendItem.setSwatchColor((Color)this.FEATURE_COLORS.get(string));
                legendItem.setDrawSwatch(1);
            }
        }
        if (this.showTitle) {
            if (this.title.length() > this.MAX_TITLE_LENGTH) {
                this.title = this.title.substring(0, this.MAX_TITLE_LENGTH) + "...";
            }
            this.legend = new Legend(this.cgview);
            this.legend.setAllowLabelClash(this.allowLabelClashLegend);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(font3);
            this.legend.setPosition(10);
            legendItem = new LegendItem(this.legend);
            legendItem.setLabel(this.title);
            legendItem.setDrawSwatch(2);
        }
    }
}

