/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.Feature;
import ca.ualberta.stothard.cgview.FeatureRange;
import ca.ualberta.stothard.cgview.FeatureSlot;
import ca.ualberta.stothard.cgview.Legend;
import ca.ualberta.stothard.cgview.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CgviewFactoryPtt
implements CgviewConstants {
    private Cgview cgview;
    private Hashtable COLORS = new Hashtable();
    private Hashtable MAP_ITEM_COLORS = new Hashtable();
    private Hashtable FEATURE_COLORS = new Hashtable();
    private Hashtable FEATURE_DECORATIONS_DIRECT = new Hashtable();
    private Hashtable FEATURE_DECORATIONS_REVERSE = new Hashtable();
    private Hashtable LEGEND_ITEM_NAMES_LONG = new Hashtable();
    private Hashtable LEGEND_ITEM_NAMES_SHORT = new Hashtable();
    private Hashtable DRAW_LEGEND_ITEMS = new Hashtable();
    private Hashtable DEFAULT_MAP_SIZES = new Hashtable();
    private Hashtable MIN_MAP_SIZES = new Hashtable();
    private Hashtable MAX_MAP_SIZES = new Hashtable();
    private Hashtable DEFAULT_MAP_MODES = new Hashtable();
    private Hashtable SMALL_MAP_MODES = new Hashtable();
    private Hashtable LARGE_MAP_MODES = new Hashtable();
    private int LARGE_MAP_MODE_DIMENSION = 2000;
    private int SMALL_MAP_MODE_DIMENSION = 800;
    private FeatureSlot forwardSlot1;
    private FeatureSlot forwardSlot2;
    private FeatureSlot forwardSlot3;
    private FeatureSlot forwardSlot4;
    private FeatureSlot forwardSlot5;
    private FeatureSlot forwardSlot6;
    private FeatureSlot reverseSlot1;
    private FeatureSlot reverseSlot2;
    private FeatureSlot reverseSlot3;
    private FeatureSlot reverseSlot4;
    private FeatureSlot reverseSlot5;
    private FeatureSlot reverseSlot6;
    private Legend legend;
    private int zoomCenter = 1;
    private int length = 0;
    private String title = "";
    private int mapWidth = 900;
    private int mapHeight = 600;
    private int mapSmallest = 0;
    private float mapItemSizeAdjustment = 0.0f;
    private int labelFontSize = -1;
    private int rulerFontSize = -1;
    private int legendFontSize = -1;
    private double tickDensity = 1.0;
    private boolean readDimension = true;
    private NumberFormat nf = NumberFormat.getInstance();
    private int MAX_MOUSEOVER_LENGTH = 100;
    private int MAX_LABEL_LENGTH = 50;
    private int MAX_TITLE_LENGTH = 80;
    private int MAX_SEQUENCE_LENGTH = 200000000;
    private int MAX_IMAGE_WIDTH;
    private int MIN_IMAGE_WIDTH;
    private int MAX_IMAGE_HEIGHT;
    private int MIN_IMAGE_HEIGHT;
    private float opacity = 1.0f;
    private boolean useColoredLabelBackground = false;
    private boolean showTitle = true;
    private boolean showShading = true;
    private boolean showBorder = false;
    private boolean allowLabelClashLegend = false;
    private boolean moveInnerLabelsToOuter = true;
    private int labelPlacementQuality = 9;
    private int legendPosition = 3;
    private boolean useColoredLabels = true;
    private boolean drawTickMarks = true;
    private boolean showLegend = true;
    private boolean showLabels = true;
    private float shadingProportion = 0.4f;
    private float shadingOpacity = 0.5f;
    private boolean containsCogs = false;
    private String ncbiLink = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Text&db=Protein&dopt=genpept&dispmax=20&uid=";

    public CgviewFactoryPtt() {
        this.cgview = new Cgview(1);
    }

    public Cgview createCgviewFromFile(String string) throws Exception, IOException {
        File file = new File(string);
        URL uRL = null;
        uRL = file.toURL();
        return this.createCgviewFromURL(uRL);
    }

    public Cgview createCgviewFromURL(URL uRL) throws Exception, IOException {
        String string;
        this.COLORS.put("black", new Color(0, 0, 0));
        this.COLORS.put("silver", new Color(192, 192, 192));
        this.COLORS.put("gray", new Color(128, 128, 128));
        this.COLORS.put("white", new Color(255, 255, 255));
        this.COLORS.put("maroon", new Color(128, 0, 0));
        this.COLORS.put("red", new Color(255, 0, 0));
        this.COLORS.put("pink", new Color(255, 153, 204));
        this.COLORS.put("purple", new Color(128, 0, 128));
        this.COLORS.put("fuchsia", new Color(255, 0, 255));
        this.COLORS.put("orange", new Color(255, 153, 0));
        this.COLORS.put("green", new Color(0, 128, 0));
        this.COLORS.put("spring", new Color(204, 255, 204));
        this.COLORS.put("lime", new Color(0, 255, 0));
        this.COLORS.put("olive", new Color(128, 128, 0));
        this.COLORS.put("yellow", new Color(255, 255, 0));
        this.COLORS.put("navy", new Color(0, 0, 128));
        this.COLORS.put("blue", new Color(0, 0, 255));
        this.COLORS.put("azure", new Color(51, 153, 255));
        this.COLORS.put("lightBlue", new Color(102, 204, 255));
        this.COLORS.put("teal", new Color(153, 255, 204));
        this.COLORS.put("aqua", new Color(0, 255, 255));
        this.MAP_ITEM_COLORS.put("tick", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("rulerFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("titleFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("messageFont", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("backbone", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("partialTick", this.COLORS.get("gray"));
        this.MAP_ITEM_COLORS.put("zeroLine", this.COLORS.get("black"));
        this.MAP_ITEM_COLORS.put("background", this.COLORS.get("white"));
        this.FEATURE_COLORS.put("forward_gene", new Color(249, 0, 0));
        this.FEATURE_COLORS.put("reverse_gene", new Color(19, 19, 255));
        this.FEATURE_COLORS.put("J", new Color(152, 0, 0));
        this.FEATURE_COLORS.put("K", new Color(255, 175, 100));
        this.FEATURE_COLORS.put("L", new Color(245, 222, 188));
        this.FEATURE_COLORS.put("D", new Color(51, 255, 153));
        this.FEATURE_COLORS.put("O", new Color(150, 199, 35));
        this.FEATURE_COLORS.put("M", new Color(240, 245, 60));
        this.FEATURE_COLORS.put("N", new Color(62, 217, 157));
        this.FEATURE_COLORS.put("P", new Color(185, 255, 134));
        this.FEATURE_COLORS.put("T", new Color(0, 128, 0));
        this.FEATURE_COLORS.put("C", new Color(185, 74, 125));
        this.FEATURE_COLORS.put("G", new Color(152, 26, 206));
        this.FEATURE_COLORS.put("E", new Color(255, 79, 255));
        this.FEATURE_COLORS.put("F", new Color(255, 204, 204));
        this.FEATURE_COLORS.put("H", new Color(179, 225, 234));
        this.FEATURE_COLORS.put("I", new Color(100, 255, 250));
        this.FEATURE_COLORS.put("Q", new Color(0, 0, 139));
        this.FEATURE_COLORS.put("R", new Color(179, 179, 179));
        this.FEATURE_COLORS.put("S", new Color(240, 240, 240));
        this.FEATURE_COLORS.put("no_cog", new Color(96, 96, 96));
        this.FEATURE_DECORATIONS_DIRECT.put("forward_gene", new Integer(3));
        this.FEATURE_DECORATIONS_DIRECT.put("J", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("K", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("L", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("D", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("O", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("M", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("N", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("P", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("T", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("C", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("G", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("E", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("F", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("H", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("I", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("Q", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("R", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("S", new Integer(1));
        this.FEATURE_DECORATIONS_DIRECT.put("no_cog", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("reverse_gene", new Integer(2));
        this.FEATURE_DECORATIONS_REVERSE.put("J", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("K", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("L", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("D", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("O", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("M", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("N", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("P", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("T", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("C", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("G", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("E", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("F", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("H", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("I", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("Q", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("R", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("S", new Integer(1));
        this.FEATURE_DECORATIONS_REVERSE.put("no_cog", new Integer(1));
        this.LEGEND_ITEM_NAMES_LONG.put("forward_gene", "Forward strand gene");
        this.LEGEND_ITEM_NAMES_LONG.put("reverse_gene", "Reverse strand gene");
        this.LEGEND_ITEM_NAMES_LONG.put("J", "Translation, ribosomal structure and biogenesis");
        this.LEGEND_ITEM_NAMES_LONG.put("K", "Transcription");
        this.LEGEND_ITEM_NAMES_LONG.put("L", "DNA replication, recombination and repair");
        this.LEGEND_ITEM_NAMES_LONG.put("D", "Cell division and chromosome partitioning");
        this.LEGEND_ITEM_NAMES_LONG.put("O", "Posttranslational modification, protein turnover, chaperones");
        this.LEGEND_ITEM_NAMES_LONG.put("M", "Cell envelope biogenesis, outer membrane");
        this.LEGEND_ITEM_NAMES_LONG.put("N", "Cell motility and secretion");
        this.LEGEND_ITEM_NAMES_LONG.put("P", "Inorganic ion transport and metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("T", "Signal transduction mechanisms");
        this.LEGEND_ITEM_NAMES_LONG.put("C", "Energy production and conversion");
        this.LEGEND_ITEM_NAMES_LONG.put("G", "Carbohydrate transport and metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("E", "Amino acid transport and metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("F", "Nucleotide transport and metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("H", "Coenzyme metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("I", "Lipid metabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("Q", "Secondary metabolites biosynthesis, transport and catabolism");
        this.LEGEND_ITEM_NAMES_LONG.put("R", "General function prediction only");
        this.LEGEND_ITEM_NAMES_LONG.put("S", "Function unknown");
        this.LEGEND_ITEM_NAMES_LONG.put("no_cog", "No COG information");
        this.LEGEND_ITEM_NAMES_SHORT.put("forward_gene", "Forward");
        this.LEGEND_ITEM_NAMES_SHORT.put("reverse_gene", "Reverse");
        this.LEGEND_ITEM_NAMES_SHORT.put("J", "COG J");
        this.LEGEND_ITEM_NAMES_SHORT.put("K", "COG K");
        this.LEGEND_ITEM_NAMES_SHORT.put("L", "COG L");
        this.LEGEND_ITEM_NAMES_SHORT.put("D", "COG D");
        this.LEGEND_ITEM_NAMES_SHORT.put("O", "COG O");
        this.LEGEND_ITEM_NAMES_SHORT.put("M", "COG M");
        this.LEGEND_ITEM_NAMES_SHORT.put("N", "COG N");
        this.LEGEND_ITEM_NAMES_SHORT.put("P", "COG P");
        this.LEGEND_ITEM_NAMES_SHORT.put("T", "COG T");
        this.LEGEND_ITEM_NAMES_SHORT.put("C", "COG C");
        this.LEGEND_ITEM_NAMES_SHORT.put("G", "COG G");
        this.LEGEND_ITEM_NAMES_SHORT.put("E", "COG E");
        this.LEGEND_ITEM_NAMES_SHORT.put("F", "COG F");
        this.LEGEND_ITEM_NAMES_SHORT.put("H", "COG H");
        this.LEGEND_ITEM_NAMES_SHORT.put("I", "COG I");
        this.LEGEND_ITEM_NAMES_SHORT.put("Q", "COG Q");
        this.LEGEND_ITEM_NAMES_SHORT.put("R", "COG R");
        this.LEGEND_ITEM_NAMES_SHORT.put("S", "COG S");
        this.LEGEND_ITEM_NAMES_SHORT.put("no_cog", "No COG");
        this.DEFAULT_MAP_SIZES.put("mapWidth", new Integer(900));
        this.DEFAULT_MAP_SIZES.put("mapHeight", new Integer(900));
        this.DEFAULT_MAP_SIZES.put("labelFontSize", new Integer(10));
        this.DEFAULT_MAP_SIZES.put("titleFontSize", new Integer(15));
        this.DEFAULT_MAP_SIZES.put("legendFontSize", new Integer(13));
        this.DEFAULT_MAP_SIZES.put("rulerFontSize", new Integer(8));
        this.DEFAULT_MAP_SIZES.put("messageFontSize", new Integer(12));
        this.DEFAULT_MAP_SIZES.put("featureThickness", new Float(12.0f));
        this.DEFAULT_MAP_SIZES.put("backboneThickness", new Float(4.0f));
        this.DEFAULT_MAP_SIZES.put("featureSlotSpacing", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("tickLength", new Float(6.0f));
        this.DEFAULT_MAP_SIZES.put("tickThickness", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("shortTickThickness", new Float(2.0f));
        this.DEFAULT_MAP_SIZES.put("labelLineLength", new Double(50.0));
        this.DEFAULT_MAP_SIZES.put("labelLineThickness", new Float(1.0f));
        this.DEFAULT_MAP_SIZES.put("arrowheadLength", new Double(5.0));
        this.DEFAULT_MAP_SIZES.put("maxLabels", new Integer(5000));
        this.MIN_MAP_SIZES.put("mapWidth", new Integer(500));
        this.MIN_MAP_SIZES.put("mapHeight", new Integer(500));
        this.MIN_MAP_SIZES.put("labelFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("titleFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("legendFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("rulerFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("messageFontSize", new Integer(1));
        this.MIN_MAP_SIZES.put("featureThickness", new Float(0.5f));
        this.MIN_MAP_SIZES.put("backboneThickness", new Float(0.1f));
        this.MIN_MAP_SIZES.put("featureSlotSpacing", new Float(0.1f));
        this.MIN_MAP_SIZES.put("tickLength", new Float(1.0f));
        this.MIN_MAP_SIZES.put("tickThickness", new Float(0.5f));
        this.MIN_MAP_SIZES.put("shortTickThickness", new Float(0.5));
        this.MIN_MAP_SIZES.put("labelLineLength", new Double(2.0));
        this.MIN_MAP_SIZES.put("labelLineThickness", new Float(0.5));
        this.MIN_MAP_SIZES.put("arrowheadLength", new Double(0.5));
        this.MIN_MAP_SIZES.put("maxLabels", new Integer(10));
        this.MAX_MAP_SIZES.put("mapWidth", new Integer(30000));
        this.MAX_MAP_SIZES.put("mapHeight", new Integer(30000));
        this.MAX_MAP_SIZES.put("labelFontSize", new Integer(10));
        this.MAX_MAP_SIZES.put("titleFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("legendFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("rulerFontSize", new Integer(8));
        this.MAX_MAP_SIZES.put("messageFontSize", new Integer(100));
        this.MAX_MAP_SIZES.put("featureThickness", new Float(80.0f));
        this.MAX_MAP_SIZES.put("backboneThickness", new Float(5.0f));
        this.MAX_MAP_SIZES.put("featureSlotSpacing", new Float(5.0f));
        this.MAX_MAP_SIZES.put("tickLength", new Float(6.0f));
        this.MAX_MAP_SIZES.put("tickThickness", new Float(2.0f));
        this.MAX_MAP_SIZES.put("shortTickThickness", new Float(2.0f));
        this.MAX_MAP_SIZES.put("labelLineLength", new Double(80.0));
        this.MAX_MAP_SIZES.put("labelLineThickness", new Float(1.0f));
        this.MAX_MAP_SIZES.put("arrowheadLength", new Double(18.0));
        this.MAX_MAP_SIZES.put("maxLabels", new Integer(50000));
        this.DEFAULT_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.DEFAULT_MAP_MODES.put("useInnerLabels", new Integer(3));
        this.SMALL_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.SMALL_MAP_MODES.put("useInnerLabels", new Integer(3));
        this.LARGE_MAP_MODES.put("giveFeaturePositions", new Integer(2));
        this.LARGE_MAP_MODES.put("useInnerLabels", new Integer(1));
        this.MAX_IMAGE_WIDTH = (Integer)this.MAX_MAP_SIZES.get("mapWidth");
        this.MIN_IMAGE_WIDTH = (Integer)this.MIN_MAP_SIZES.get("mapWidth");
        this.MAX_IMAGE_HEIGHT = (Integer)this.MAX_MAP_SIZES.get("mapHeight");
        this.MIN_IMAGE_HEIGHT = (Integer)this.MIN_MAP_SIZES.get("mapHeight");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        Pattern pattern = Pattern.compile("[01]\\.\\.(\\d+)\\s*$");
        Pattern pattern2 = Pattern.compile("Location\\s*\\t+\\s*Strand");
        Pattern pattern3 = Pattern.compile("(\\d+)\\.\\.(\\d+)");
        InputStream inputStream = uRL.openStream();
        System.out.println("Parsing ptt input.");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            Matcher matcher;
            if (++n <= 5 && (matcher = pattern.matcher(string)).find()) {
                this.title = string;
                try {
                    this.length = Integer.parseInt(matcher.group(1));
                }
                catch (Exception exception) {
                    throw new Exception("There is a problem with the length value on line " + n + " in the data file.");
                }
            }
            if (n <= 8 && !bl) {
                matcher = pattern2.matcher(string);
                if (!matcher.find()) continue;
                stringArray = string.split("(?:\\s*\\t+\\s*)|(?:\\s{2,})");
                n2 = stringArray.length;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i].trim();
                    if (string6.equalsIgnoreCase("Location")) {
                        bl = true;
                        n6 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Strand")) {
                        bl2 = true;
                        n7 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Length")) {
                        bl3 = true;
                        n8 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("PID")) {
                        bl4 = true;
                        n9 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Gene")) {
                        bl5 = true;
                        n10 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Synonym")) {
                        bl6 = true;
                        n11 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Code")) {
                        bl7 = true;
                        n12 = i;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("COG")) {
                        bl8 = true;
                        n13 = i;
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("Product")) continue;
                    bl9 = true;
                    n14 = i;
                }
                continue;
            }
            if (n2 <= 0) continue;
            stringArray = string.split("\\s*\\t+\\s*");
            if (stringArray.length != n2) {
                stringArray = string.split("(?:\\s*\\t+\\s*)|(?:\\s{2,})");
            }
            if (stringArray.length >= 5) {
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                String string12;
                String string13;
                String string14;
                String string15;
                block72: {
                    block71: {
                        block70: {
                            block69: {
                                block68: {
                                    block67: {
                                        String string16;
                                        if (!bl) {
                                            throw new Exception("A \"Location\" column has not been defined in the data file.");
                                        }
                                        if (!bl2) {
                                            throw new Exception("A \"Strand\" column has not been defined in the data file.");
                                        }
                                        if (!bl4) {
                                            throw new Exception("A \"PID\" column has not been defined in the data file.");
                                        }
                                        try {
                                            string15 = stringArray[n6];
                                            string15 = string15.trim();
                                        }
                                        catch (Exception exception) {
                                            continue;
                                        }
                                        try {
                                            string14 = stringArray[n7];
                                            string14 = string14.trim();
                                        }
                                        catch (Exception exception) {
                                            continue;
                                        }
                                        try {
                                            string13 = stringArray[n9];
                                            string13 = string13.trim();
                                        }
                                        catch (Exception exception) {
                                            continue;
                                        }
                                        if (bl3) {
                                            try {
                                                string16 = stringArray[n8];
                                                string16 = string16.trim();
                                                break block67;
                                            }
                                            catch (Exception exception) {
                                                continue;
                                            }
                                        }
                                        string16 = "";
                                    }
                                    if (bl5) {
                                        try {
                                            string12 = stringArray[n10];
                                            string12 = string12.trim();
                                            break block68;
                                        }
                                        catch (Exception exception) {
                                            continue;
                                        }
                                    }
                                    string12 = "";
                                }
                                if (bl6) {
                                    try {
                                        string11 = stringArray[n11];
                                        string11 = string11.trim();
                                        break block69;
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                }
                                string11 = "";
                            }
                            if (bl7) {
                                try {
                                    string10 = stringArray[n12];
                                    string10 = string10.trim();
                                    break block70;
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                            }
                            string10 = "";
                        }
                        if (bl8) {
                            try {
                                string9 = stringArray[n13];
                                string9 = string9.trim();
                                break block71;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                        string9 = "";
                    }
                    if (bl9) {
                        try {
                            string8 = stringArray[n14];
                            string8 = string8.trim();
                            break block72;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    string8 = "";
                }
                matcher = pattern3.matcher(string15);
                if (!matcher.find()) {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                n4 = Integer.parseInt(matcher.group(1));
                n5 = Integer.parseInt(matcher.group(2));
                if (string14.equalsIgnoreCase("+")) {
                    n3 = 1;
                    string2 = "forward_gene";
                    string7 = "forward";
                } else if (string14.equalsIgnoreCase("-")) {
                    n3 = 1;
                    string2 = "reverse_gene";
                    string7 = "reverse";
                } else {
                    throw new Exception("There is a problem with line " + n + " in the data file.");
                }
                if (!string12.matches("^\\s*$") && !string12.equals("-")) {
                    string3 = string12;
                } else if (!string11.matches("^\\s*$") && !string11.equals("-")) {
                    string3 = string11;
                } else if (!string13.matches("^\\s*$") && !string13.equals("-")) {
                    string3 = string13;
                }
                string4 = string15 + ";";
                if (!string9.matches("^\\s*$") && !string9.equals("-")) {
                    string4 = string4 + " " + string9 + ";";
                }
                if (!string10.matches("^\\s*$") && !string10.equals("-")) {
                    string4 = string4 + " (code=" + string10 + ");";
                }
                if (!string8.matches("^\\s*$") && !string8.equals("-")) {
                    string4 = string4 + " " + string8 + ";";
                }
                if (!string13.matches("^\\s*$") && !string13.equals("-")) {
                    string5 = this.ncbiLink + string13;
                }
                try {
                    this.addFeature(string7, n3, n4, n5, f, f2, f3, string2, string3, string4, string5);
                }
                catch (Exception exception) {
                    throw new Exception("Line " + n + ": " + exception.toString() + ".");
                }
                if (string10.matches("^\\s*$") || string10.equals("-")) continue;
                n3 = 2;
                string3 = "";
                string4 = "";
                string5 = "";
                string2 = string10;
                this.containsCogs = true;
                try {
                    this.addFeature(string7, n3, n4, n5, f, f2, f3, string2, string3, string4, string5);
                    continue;
                }
                catch (Exception exception) {
                    throw new Exception("Line " + n + ": " + exception.toString() + ".");
                }
            }
            if (stringArray.length <= 2) continue;
            throw new Exception("The contents of line " + n + " could not be parsed in the data file.");
        }
        if (this.length > this.MAX_SEQUENCE_LENGTH) {
            throw new Exception("Maximum sequence length is " + this.MAX_SEQUENCE_LENGTH + ".");
        }
        if (this.length < 1) {
            throw new Exception("Minimum sequence length is 1 base.");
        }
        if (this.mapWidth > this.MAX_IMAGE_WIDTH) {
            throw new Exception("Maximum image width is " + this.MAX_IMAGE_WIDTH + ".");
        }
        if (this.mapWidth < this.MIN_IMAGE_WIDTH) {
            throw new Exception("Minimum image width is " + this.MIN_IMAGE_WIDTH + ".");
        }
        if (this.mapHeight > this.MAX_IMAGE_HEIGHT) {
            throw new Exception("Maximum image height is " + this.MAX_IMAGE_HEIGHT + ".");
        }
        if (this.mapHeight < this.MIN_IMAGE_HEIGHT) {
            throw new Exception("Minimum image height is " + this.MIN_IMAGE_HEIGHT + ".");
        }
        this.prepareToDraw();
        return this.cgview;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFeature(String string, int n, int n2, int n3, float f, float f2, float f3, String string2, String string3, String string4, String string5) throws Exception {
        int n4;
        Color color;
        int n5;
        if (n2 > this.length) {
            throw new Exception("The start value " + n2 + " is greater than the sequence length.");
        }
        if (n2 < 1) {
            throw new Exception("The start value " + n2 + " is less than 1.");
        }
        if (n3 > this.length) {
            throw new Exception("The stop value " + n3 + " is greater than the sequence length.");
        }
        if (n3 < 1) {
            throw new Exception("The stop value " + n3 + " is less than 1.");
        }
        if (string.equalsIgnoreCase("forward")) {
            n5 = 1;
        } else {
            if (!string.equalsIgnoreCase("reverse")) throw new Exception("The strand value must be \"forward\" or \"reverse\".");
            n5 = 2;
        }
        try {
            color = this.getFeatureColor(string2);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Warning: feature type \"" + string2 + "\" was not recognized. Feature skipped.");
            return;
        }
        try {
            n4 = this.getFeatureDecoration(string2, n5);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Warning: feature type \"" + string2 + "\" was not recognized. Feature skipped.");
            return;
        }
        try {
            this.addItemToLegend(string2);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Warning: feature type \"" + string2 + "\" was not recognized. Feature skipped.");
            return;
        }
        Feature feature = new Feature(this.showShading);
        FeatureRange featureRange = new FeatureRange(feature, n2, n3);
        featureRange.setDecoration(n4);
        featureRange.setColor(color);
        featureRange.setOpacity(f);
        featureRange.setProportionOfThickness(f2);
        featureRange.setRadiusAdjustment(f3);
        if (n == 5 || n == 6) {
            feature.setShowShading(false);
        }
        if (!string3.matches("^\\s*$")) {
            if (string3.length() > this.MAX_LABEL_LENGTH) {
                string3 = string3.substring(0, this.MAX_LABEL_LENGTH) + "...";
            }
            featureRange.setLabel(string3);
        }
        if (!string4.matches("^\\s*$")) {
            if (string4.length() > this.MAX_MOUSEOVER_LENGTH) {
                string4 = string4.substring(0, this.MAX_MOUSEOVER_LENGTH) + "...";
            }
            featureRange.setMouseover(string4);
        }
        if (!string5.matches("^\\s*$")) {
            featureRange.setHyperlink(string5);
        }
        if (n5 == 1) {
            if (n == 1) {
                if (this.forwardSlot1 == null) {
                    this.forwardSlot1 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot1);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot1);
                }
                return;
            } else if (n == 2) {
                if (this.forwardSlot2 == null) {
                    this.forwardSlot2 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot2);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot2);
                }
                return;
            } else if (n == 3) {
                if (this.forwardSlot3 == null) {
                    this.forwardSlot3 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot3);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot3);
                }
                return;
            } else if (n == 4) {
                if (this.forwardSlot4 == null) {
                    this.forwardSlot4 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot4);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot4);
                }
                return;
            } else if (n == 5) {
                if (this.forwardSlot5 == null) {
                    this.forwardSlot5 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot5);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot5);
                }
                return;
            } else {
                if (n != 6) throw new Exception("The slot value must be between 1 and 6");
                if (this.forwardSlot6 == null) {
                    this.forwardSlot6 = new FeatureSlot(1, this.showShading);
                    feature.setFeatureSlot(this.forwardSlot6);
                    return;
                } else {
                    feature.setFeatureSlot(this.forwardSlot6);
                }
            }
            return;
        } else if (n == 1) {
            if (this.reverseSlot1 == null) {
                this.reverseSlot1 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot1);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot1);
            }
            return;
        } else if (n == 2) {
            if (this.reverseSlot2 == null) {
                this.reverseSlot2 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot2);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot2);
            }
            return;
        } else if (n == 3) {
            if (this.reverseSlot3 == null) {
                this.reverseSlot3 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot3);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot3);
            }
            return;
        } else if (n == 4) {
            if (this.reverseSlot4 == null) {
                this.reverseSlot4 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot4);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot4);
            }
            return;
        } else if (n == 5) {
            if (this.reverseSlot5 == null) {
                this.reverseSlot5 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot5);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot5);
            }
            return;
        } else {
            if (n != 6) throw new Exception("The slot value must be between 1 and 6");
            if (this.reverseSlot6 == null) {
                this.reverseSlot6 = new FeatureSlot(2, this.showShading);
                feature.setFeatureSlot(this.reverseSlot6);
                return;
            } else {
                feature.setFeatureSlot(this.reverseSlot6);
            }
        }
    }

    private Color getFeatureColor(String string) throws NullPointerException {
        Color color = (Color)this.FEATURE_COLORS.get(string);
        return color;
    }

    private int getFeatureDecoration(String string, int n) throws NullPointerException {
        int n2 = 1;
        n2 = n == 1 ? ((Integer)this.FEATURE_DECORATIONS_DIRECT.get(string)).intValue() : ((Integer)this.FEATURE_DECORATIONS_REVERSE.get(string)).intValue();
        return n2;
    }

    private void addItemToLegend(String string) throws NullPointerException {
        if (!string.equalsIgnoreCase("forward_gene") && !string.equalsIgnoreCase("reverse_gene")) {
            this.DRAW_LEGEND_ITEMS.put(string, new Boolean(true));
        }
    }

    public void setReadDimension(boolean bl) {
        this.readDimension = bl;
    }

    public void setWidth(int n) {
        this.mapWidth = n;
    }

    public void setHeight(int n) {
        this.mapHeight = n;
    }

    public void setMapItemSizeAdjustment(float f) {
        this.mapItemSizeAdjustment = f;
    }

    public void setLabelFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.labelFontSize = n;
    }

    public void setRulerFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.rulerFontSize = n;
    }

    public void setLegendFontSize(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.legendFontSize = n;
    }

    public void setTickDensity(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        this.tickDensity = d;
    }

    private void prepareToDraw() {
        LegendItem legendItem;
        int n;
        int n2;
        int n3;
        double d = 1.0;
        this.mapSmallest = Math.min(this.mapWidth, this.mapHeight);
        int n4 = Math.min((Integer)this.DEFAULT_MAP_SIZES.get("mapWidth"), (Integer)this.DEFAULT_MAP_SIZES.get("mapHeight"));
        float f = (float)this.mapSmallest / (float)n4;
        int n5 = (int)Math.floor((f + this.mapItemSizeAdjustment) * (float)((Integer)this.DEFAULT_MAP_SIZES.get("labelFontSize")).intValue() + 0.5f);
        int n6 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("titleFontSize")).intValue() + 0.5f);
        int n7 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("legendFontSize")).intValue() + 0.5f);
        int n8 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("rulerFontSize")).intValue() + 0.5f);
        int n9 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("messageFontSize")).intValue() + 0.5f);
        if (n5 < (Integer)this.MIN_MAP_SIZES.get("labelFontSize")) {
            n5 = (Integer)this.MIN_MAP_SIZES.get("labelFontSize");
        } else if (n5 > (Integer)this.MAX_MAP_SIZES.get("labelFontSize")) {
            n5 = (Integer)this.MAX_MAP_SIZES.get("labelFontSize");
        }
        if (n6 < (Integer)this.MIN_MAP_SIZES.get("titleFontSize")) {
            n6 = (Integer)this.MIN_MAP_SIZES.get("titleFontSize");
        } else if (n6 > (Integer)this.MAX_MAP_SIZES.get("titleFontSize")) {
            n6 = (Integer)this.MAX_MAP_SIZES.get("titleFontSize");
        }
        if (n7 < (Integer)this.MIN_MAP_SIZES.get("legendFontSize")) {
            n7 = (Integer)this.MIN_MAP_SIZES.get("legendFontSize");
        } else if (n7 > (Integer)this.MAX_MAP_SIZES.get("legendFontSize")) {
            n7 = (Integer)this.MAX_MAP_SIZES.get("legendFontSize");
        }
        if (n8 < (Integer)this.MIN_MAP_SIZES.get("rulerFontSize")) {
            n8 = (Integer)this.MIN_MAP_SIZES.get("rulerFontSize");
        } else if (n8 > (Integer)this.MAX_MAP_SIZES.get("rulerFontSize")) {
            n8 = (Integer)this.MAX_MAP_SIZES.get("rulerFontSize");
        }
        if (n9 < (Integer)this.MIN_MAP_SIZES.get("messageFontSize")) {
            n9 = (Integer)this.MIN_MAP_SIZES.get("messageFontSize");
        } else if (n9 > (Integer)this.MAX_MAP_SIZES.get("messageFontSize")) {
            n9 = (Integer)this.MAX_MAP_SIZES.get("messageFontSize");
        }
        Font font = new Font("SansSerif", 0, n5);
        Font font2 = new Font("SansSerif", 0, n6);
        Font font3 = new Font("SansSerif", 0, n7);
        Font font4 = new Font("SansSerif", 0, n8);
        Font font5 = new Font("SansSerif", 0, n9);
        if (this.labelFontSize != -1) {
            font = new Font("SansSerif", 0, this.labelFontSize);
        }
        if (this.rulerFontSize != -1) {
            font4 = new Font("SansSerif", 0, this.rulerFontSize);
        }
        if (this.legendFontSize != -1) {
            font3 = new Font("SansSerif", 0, this.legendFontSize);
        }
        if ((n3 = (int)Math.floor(f * (float)((Integer)this.DEFAULT_MAP_SIZES.get("maxLabels")).intValue() + 0.5f)) < (Integer)this.MIN_MAP_SIZES.get("maxLabels")) {
            n3 = (Integer)this.MIN_MAP_SIZES.get("maxLabels");
        } else if (n3 > (Integer)this.MAX_MAP_SIZES.get("maxLabels")) {
            n3 = (Integer)this.MAX_MAP_SIZES.get("maxLabels");
        }
        float f2 = (f + this.mapItemSizeAdjustment) * ((Float)this.DEFAULT_MAP_SIZES.get("featureThickness")).floatValue();
        float f3 = (f + this.mapItemSizeAdjustment) * ((Float)this.DEFAULT_MAP_SIZES.get("backboneThickness")).floatValue();
        if (f3 < ((Float)this.MIN_MAP_SIZES.get("backboneThickness")).floatValue()) {
            f3 = ((Float)this.MIN_MAP_SIZES.get("backboneThickness")).floatValue();
        } else if (f3 > ((Float)this.MAX_MAP_SIZES.get("backboneThickness")).floatValue()) {
            f3 = ((Float)this.MAX_MAP_SIZES.get("backboneThickness")).floatValue();
        }
        float f4 = f * ((Float)this.DEFAULT_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        if (f4 < ((Float)this.MIN_MAP_SIZES.get("featureSlotSpacing")).floatValue()) {
            f4 = ((Float)this.MIN_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        } else if (f4 > ((Float)this.MAX_MAP_SIZES.get("featureSlotSpacing")).floatValue()) {
            f4 = ((Float)this.MAX_MAP_SIZES.get("featureSlotSpacing")).floatValue();
        }
        float f5 = f * ((Float)this.DEFAULT_MAP_SIZES.get("tickLength")).floatValue();
        if (f5 < ((Float)this.MIN_MAP_SIZES.get("tickLength")).floatValue()) {
            f5 = ((Float)this.MIN_MAP_SIZES.get("tickLength")).floatValue();
        } else if (f5 > ((Float)this.MAX_MAP_SIZES.get("tickLength")).floatValue()) {
            f5 = ((Float)this.MAX_MAP_SIZES.get("tickLength")).floatValue();
        }
        float f6 = f * ((Float)this.DEFAULT_MAP_SIZES.get("tickThickness")).floatValue();
        if (f6 < ((Float)this.MIN_MAP_SIZES.get("tickThickness")).floatValue()) {
            f6 = ((Float)this.MIN_MAP_SIZES.get("tickThickness")).floatValue();
        } else if (f6 > ((Float)this.MAX_MAP_SIZES.get("tickThickness")).floatValue()) {
            f6 = ((Float)this.MAX_MAP_SIZES.get("tickThickness")).floatValue();
        }
        float f7 = f * ((Float)this.DEFAULT_MAP_SIZES.get("shortTickThickness")).floatValue();
        if (f7 < ((Float)this.MIN_MAP_SIZES.get("shortTickThickness")).floatValue()) {
            f7 = ((Float)this.MIN_MAP_SIZES.get("shortTickThickness")).floatValue();
        } else if (f7 > ((Float)this.MAX_MAP_SIZES.get("shortTickThickness")).floatValue()) {
            f7 = ((Float)this.MAX_MAP_SIZES.get("shortTickThickness")).floatValue();
        }
        float f8 = f * ((Float)this.DEFAULT_MAP_SIZES.get("labelLineThickness")).floatValue();
        if (f8 < ((Float)this.MIN_MAP_SIZES.get("labelLineThickness")).floatValue()) {
            f8 = ((Float)this.MIN_MAP_SIZES.get("labelLineThickness")).floatValue();
        } else if (f8 > ((Float)this.MAX_MAP_SIZES.get("labelLineThickness")).floatValue()) {
            f8 = ((Float)this.MAX_MAP_SIZES.get("labelLineThickness")).floatValue();
        }
        double d2 = (double)f * (Double)this.DEFAULT_MAP_SIZES.get("labelLineLength");
        if (d2 < (Double)this.MIN_MAP_SIZES.get("labelLineLength")) {
            d2 = (Double)this.MIN_MAP_SIZES.get("labelLineLength");
        } else if (d2 > (Double)this.MAX_MAP_SIZES.get("labelLineLength")) {
            d2 = (Double)this.MAX_MAP_SIZES.get("labelLineLength");
        }
        double d3 = (double)(f + this.mapItemSizeAdjustment) * (Double)this.DEFAULT_MAP_SIZES.get("arrowheadLength");
        if (d3 < (Double)this.MIN_MAP_SIZES.get("arrowheadLength")) {
            d3 = (Double)this.MIN_MAP_SIZES.get("arrowheadLength");
        } else if (d3 > (Double)this.MAX_MAP_SIZES.get("arrowheadLength")) {
            d3 = (Double)this.MAX_MAP_SIZES.get("arrowheadLength");
        }
        if (this.mapSmallest <= this.SMALL_MAP_MODE_DIMENSION) {
            n2 = (Integer)this.SMALL_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.SMALL_MAP_MODES.get("useInnerLabels");
        } else if (this.mapSmallest >= this.LARGE_MAP_MODE_DIMENSION) {
            n2 = (Integer)this.LARGE_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.LARGE_MAP_MODES.get("useInnerLabels");
        } else {
            n2 = (Integer)this.DEFAULT_MAP_MODES.get("giveFeaturePositions");
            n = (Integer)this.DEFAULT_MAP_MODES.get("useInnerLabels");
        }
        float f9 = 0.083f * f2;
        int n10 = 0;
        if (this.forwardSlot1 == null) {
            ++n10;
        }
        if (this.forwardSlot2 == null) {
            ++n10;
        }
        if (this.forwardSlot3 == null) {
            ++n10;
        }
        if (this.forwardSlot4 == null) {
            ++n10;
        }
        if (this.forwardSlot5 == null) {
            ++n10;
        }
        if (this.forwardSlot6 == null) {
            ++n10;
        }
        if (this.reverseSlot1 == null) {
            ++n10;
        }
        if (this.reverseSlot2 == null) {
            ++n10;
        }
        if (this.reverseSlot3 == null) {
            ++n10;
        }
        if (this.reverseSlot4 == null) {
            ++n10;
        }
        if (this.reverseSlot5 == null) {
            ++n10;
        }
        if (this.reverseSlot6 == null) {
            ++n10;
        }
        if ((f2 += (float)n10 * f9) < ((Float)this.MIN_MAP_SIZES.get("featureThickness")).floatValue()) {
            f2 = ((Float)this.MIN_MAP_SIZES.get("featureThickness")).floatValue();
        } else if (f2 > ((Float)this.MAX_MAP_SIZES.get("featureThickness")).floatValue()) {
            f2 = ((Float)this.MAX_MAP_SIZES.get("featureThickness")).floatValue();
        }
        if (this.forwardSlot1 != null) {
            this.forwardSlot1.sortFeaturesByStart();
            this.forwardSlot1.setCgview(this.cgview);
            this.forwardSlot1.setFeatureThickness(f2);
        }
        if (this.forwardSlot2 != null) {
            this.forwardSlot2.sortFeaturesByStart();
            this.forwardSlot2.setCgview(this.cgview);
            this.forwardSlot2.setFeatureThickness(f2);
        }
        if (this.forwardSlot3 != null) {
            this.forwardSlot3.sortFeaturesByStart();
            this.forwardSlot3.setCgview(this.cgview);
            this.forwardSlot3.setFeatureThickness(f2);
        }
        if (this.forwardSlot4 != null) {
            this.forwardSlot4.sortFeaturesByStart();
            this.forwardSlot4.setCgview(this.cgview);
            this.forwardSlot4.setFeatureThickness(f2);
        }
        if (this.forwardSlot5 != null) {
            this.forwardSlot5.sortFeaturesByStart();
            this.forwardSlot5.setCgview(this.cgview);
            this.forwardSlot5.setFeatureThickness(f2);
        }
        if (this.forwardSlot6 != null) {
            this.forwardSlot6.sortFeaturesByStart();
            this.forwardSlot6.setCgview(this.cgview);
            this.forwardSlot6.setFeatureThickness(f2);
        }
        if (this.reverseSlot1 != null) {
            this.reverseSlot1.sortFeaturesByStart();
            this.reverseSlot1.setCgview(this.cgview);
            this.reverseSlot1.setFeatureThickness(f2);
        }
        if (this.reverseSlot2 != null) {
            this.reverseSlot2.sortFeaturesByStart();
            this.reverseSlot2.setCgview(this.cgview);
            this.reverseSlot2.setFeatureThickness(f2);
        }
        if (this.reverseSlot3 != null) {
            this.reverseSlot3.sortFeaturesByStart();
            this.reverseSlot3.setCgview(this.cgview);
            this.reverseSlot3.setFeatureThickness(f2);
        }
        if (this.reverseSlot4 != null) {
            this.reverseSlot4.sortFeaturesByStart();
            this.reverseSlot4.setCgview(this.cgview);
            this.reverseSlot4.setFeatureThickness(f2);
        }
        if (this.reverseSlot5 != null) {
            this.reverseSlot5.sortFeaturesByStart();
            this.reverseSlot5.setCgview(this.cgview);
            this.reverseSlot5.setFeatureThickness(f2);
        }
        if (this.reverseSlot6 != null) {
            this.reverseSlot6.sortFeaturesByStart();
            this.reverseSlot6.setCgview(this.cgview);
            this.reverseSlot6.setFeatureThickness(f2);
        }
        this.cgview.setWidth(this.mapWidth);
        this.cgview.setHeight(this.mapHeight);
        this.cgview.setLabelsToKeep(n3);
        this.cgview.setDrawTickMarks(this.drawTickMarks);
        this.cgview.setTitleFont(font2);
        this.cgview.setLabelFont(font);
        this.cgview.setFeatureThickness(f2);
        this.cgview.setBackboneThickness(f3);
        this.cgview.setFeatureSlotSpacing(f4);
        this.cgview.setMinimumFeatureLength(d);
        this.cgview.setLegendFont(font3);
        this.cgview.setTickLength(f5);
        this.cgview.setTickThickness(f6);
        this.cgview.setShortTickThickness(f7);
        this.cgview.setLabelLineThickness(f8);
        this.cgview.setLabelLineLength(d2);
        this.cgview.setLabelPlacementQuality(this.labelPlacementQuality);
        this.cgview.setUseColoredLabelBackgrounds(this.useColoredLabelBackground);
        this.cgview.setShowBorder(this.showBorder);
        this.cgview.setShowShading(this.showShading);
        this.cgview.setGiveFeaturePositions(n2);
        this.cgview.setShadingProportion(this.shadingProportion);
        this.cgview.setUseInnerLabels(n);
        this.cgview.setMoveInnerLabelsToOuter(this.moveInnerLabelsToOuter);
        this.cgview.setWarningFont(font4);
        this.cgview.setRulerFont(font4);
        this.cgview.setArrowheadLength(d3);
        this.cgview.setHighlightOpacity(this.shadingOpacity);
        this.cgview.setShadowOpacity(this.shadingOpacity);
        this.cgview.setTickDensity(this.tickDensity);
        if (!this.showLabels) {
            this.cgview.setShowWarning(false);
        }
        this.cgview.setSequenceLength(this.length);
        this.mapSmallest = Math.min(this.mapWidth, this.mapHeight);
        this.cgview.setBackboneRadius(0.5 * (double)this.mapSmallest / 1.9);
        if (!this.useColoredLabels) {
            this.cgview.setGlobalLabelColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        }
        this.cgview.setLongTickColor((Color)this.MAP_ITEM_COLORS.get("tick"));
        this.cgview.setShortTickColor((Color)this.MAP_ITEM_COLORS.get("partialTick"));
        this.cgview.setZeroTickColor((Color)this.MAP_ITEM_COLORS.get("zeroLine"));
        this.cgview.setRulerFontColor((Color)this.MAP_ITEM_COLORS.get("rulerFont"));
        this.cgview.setBackboneColor((Color)this.MAP_ITEM_COLORS.get("backbone"));
        this.cgview.setTitleFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        this.cgview.setWarningFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
        this.cgview.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
        if (this.showLegend) {
            this.legend = new Legend(this.cgview);
            this.legend.setAllowLabelClash(this.allowLabelClashLegend);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(font3);
            this.legend.setPosition(this.legendPosition);
            this.legend.setBackgroundColor((Color)this.MAP_ITEM_COLORS.get("background"));
            this.legend.setFontColor((Color)this.MAP_ITEM_COLORS.get("titleFont"));
            Enumeration enumeration = this.DRAW_LEGEND_ITEMS.keys();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            Collections.sort(arrayList);
            arrayList.add(0, "reverse_gene");
            arrayList.add(0, "forward_gene");
            for (String string : arrayList) {
                legendItem = new LegendItem(this.legend);
                if (this.mapSmallest >= this.LARGE_MAP_MODE_DIMENSION) {
                    legendItem.setLabel((String)this.LEGEND_ITEM_NAMES_LONG.get(string));
                } else {
                    legendItem.setLabel((String)this.LEGEND_ITEM_NAMES_SHORT.get(string));
                }
                legendItem.setSwatchColor((Color)this.FEATURE_COLORS.get(string));
                legendItem.setDrawSwatch(1);
            }
        }
        if (this.showTitle) {
            if (this.title.length() > this.MAX_TITLE_LENGTH) {
                this.title = this.title.substring(0, this.MAX_TITLE_LENGTH) + "...";
            }
            this.legend = new Legend(this.cgview);
            this.legend.setAllowLabelClash(this.allowLabelClashLegend);
            this.legend.setBackgroundOpacity(0.5f);
            this.legend.setFont(font3);
            this.legend.setPosition(10);
            legendItem = new LegendItem(this.legend);
            legendItem.setLabel(this.title);
            legendItem.setDrawSwatch(2);
        }
    }
}

