/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.FeatureSlot;
import ca.ualberta.stothard.cgview.InnerLabel;
import ca.ualberta.stothard.cgview.Label;
import ca.ualberta.stothard.cgview.LabelBounds;
import ca.ualberta.stothard.cgview.Legend;
import ca.ualberta.stothard.cgview.LegendItem;
import ca.ualberta.stothard.cgview.OuterLabel;
import ca.ualberta.stothard.cgview.SortLabelsByForceLabel;
import ca.ualberta.stothard.cgview.SortLabelsByRadians;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cgview
implements CgviewConstants {
    private Graphics2D gg;
    private int sequenceLength;
    private int width = 700;
    private int height = 700;
    private int smallestDimension = 700;
    private Color backgroundColor = new Color(255, 255, 255);
    private double backboneRadius = 190.0;
    private float backboneThickness = 5.0f;
    private Color backboneColor = new Color(128, 128, 128);
    private double origin = 90.0;
    private float featureThickness = 8.0f;
    private double featureSlotSpacing = 4.0;
    private double arrowheadLength = 5.0;
    private boolean shiftSmallFeatures = true;
    private double minimumFeatureLength = 0.02;
    private boolean showShading = true;
    private float shadingProportion = 0.2f;
    private float highlightOpacity = 0.3f;
    private float shadowOpacity = 0.3f;
    private int desiredNumberOfTicks = 25;
    private float tickThickness = 2.0f;
    private Color longTickColor = new Color(0, 0, 0);
    private Color shortTickColor = new Color(0, 0, 0);
    private float shortTickThickness = 2.0f;
    private Color zeroTickColor = new Color(0, 0, 0);
    private float tickLength = 7.0f;
    private boolean drawTickMarks = true;
    private double tickDensity = 1.0;
    private int rulerUnits = 1;
    private Font rulerFont = new Font("SansSerif", 0, 8);
    private double rulerTextPadding = 10.0;
    private Color rulerFontColor = new Color(0, 0, 0);
    private String title = "";
    private Font titleFont = new Font("SansSerif", 0, 12);
    private Color titleFontColor = new Color(0, 0, 0);
    private boolean drawLegends = true;
    private Font legendFont = new Font("SansSerif", 0, 8);
    private Color legendTextColor = new Color(0, 0, 0);
    private Font labelFont = new Font("SansSerif", 0, 10);
    private int globalLabel = 2;
    private Color globalLabelColor;
    private float labelLineThickness = 1.0f;
    private double labelLineLength = 50.0;
    private double zoomShift = 1.01;
    private int useInnerLabels = 3;
    private boolean moveInnerLabelsToOuter = true;
    private int giveFeaturePositions = 2;
    private int labelsToKeep = 8000;
    private boolean labelShuffle = true;
    private boolean useColoredLabelBackgrounds = false;
    private int clashSpan = 100;
    private int spreadIterations = 100;
    private double radiusShiftAmount = 10.0;
    private double radiansShiftConstant = 0.2;
    private int labelPlacementQuality = 8;
    private boolean keepLastLabels = false;
    private boolean isLinear = false;
    private String linearBreakText = "3'   5'";
    private double zigzagWidth = 0.0;
    private ArrayList featureSlots = new ArrayList();
    private ArrayList outerLabels = new ArrayList();
    private ArrayList innerLabels = new ArrayList();
    private ArrayList legends = new ArrayList();
    private Font warningFont = new Font("SansSerif", 0, 8);
    private Color warningFontColor = new Color(0, 0, 0);
    private String warningText = "";
    private boolean showWarning = false;
    private Point2D centerPoint;
    private int totalLabels = 0;
    private int clashLabels = 0;
    private boolean drawEntirePlasmid = true;
    private int zoomRangeOneStart;
    private int zoomRangeOneStop;
    private int zoomRangeTwoStart;
    private int zoomRangeTwoStop;
    private int centerBase;
    private double zoomMultiplier = 1.0;
    private double virtualZoomMultiplier = 1.0;
    private double virtualBackboneRadius = this.backboneRadius;
    private Rectangle2D backgroundRectangle;
    private Rectangle2D titleRectangle;
    private Rectangle2D lengthRectangle;
    private Arc2D outerArc;
    private Arc2D innerArc;
    private double desiredZoom = 1.0;
    private int desiredZoomCenter = 1;
    private Color borderColor = new Color(0, 0, 0);
    private boolean showBorder = true;
    private ArrayList labelBounds = new ArrayList();
    private Legend infoLegend;
    private int MAX_DNA_LENGTH = 200000000;
    private double ZOOM_MULTIPLIER_MAX = 30.0;
    private double VIRTUAL_ZOOM_MULTIPLIER_MAX = 500000.0;

    public Cgview(int n) {
        this.setSequenceLength(n);
    }

    public void setSequenceLength(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.MAX_DNA_LENGTH) {
            // empty if block
        }
        this.sequenceLength = n;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    protected Graphics2D getGraphics() {
        return this.gg;
    }

    public void setHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTickDensity(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        this.tickDensity = d;
    }

    public double getTickDensity() {
        return this.tickDensity;
    }

    public void setWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public int getSmallestDimension() {
        return Math.min(this.width, this.height);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBackboneRadius(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.backboneRadius = d;
    }

    public double getBackboneRadius() {
        return this.backboneRadius;
    }

    public void setBackboneThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.backboneThickness = f;
    }

    public double getBackboneThickness() {
        return this.backboneThickness;
    }

    public void setRulerFontColor(Color color) {
        this.rulerFontColor = color;
    }

    public Color getRulerFontColor() {
        return this.rulerFontColor;
    }

    public void setTitleFontColor(Color color) {
        this.titleFontColor = color;
    }

    public Color getTitleFontColor() {
        return this.titleFontColor;
    }

    public Color getLegendTextColor() {
        return this.legendTextColor;
    }

    public void setLegendTextColor(Color color) {
        this.legendTextColor = color;
    }

    public void setWarningFontColor(Color color) {
        this.warningFontColor = color;
    }

    public Color getWarningFontColor() {
        return this.warningFontColor;
    }

    public void setGlobalLabelColor(Color color) {
        this.globalLabelColor = color;
    }

    public Color getGlobalLabelColor() {
        return this.globalLabelColor;
    }

    public void setShowWarning(boolean bl) {
        this.showWarning = bl;
    }

    public boolean getShowWarning() {
        return this.showWarning;
    }

    public void setIsLinear(boolean bl) {
        this.isLinear = bl;
    }

    public boolean getIsLinear() {
        return this.isLinear;
    }

    public void setLinearBreakText(String string) {
        this.linearBreakText = string;
    }

    public String getLinearBreakText() {
        return this.linearBreakText;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public void setMoveInnerLabelsToOuter(boolean bl) {
        this.moveInnerLabelsToOuter = bl;
    }

    public boolean getMoveInnerLabelsToOuter() {
        return this.moveInnerLabelsToOuter;
    }

    public void setShowShading(boolean bl) {
        this.showShading = bl;
    }

    public boolean getShowShading() {
        return this.showShading;
    }

    public void setBackboneColor(Color color) {
        this.backboneColor = color;
    }

    public Color getBackboneColor() {
        return this.backboneColor;
    }

    public void setFeatureThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.featureThickness = f;
    }

    public float getFeatureThickness() {
        return this.featureThickness;
    }

    public void setMinimumFeatureLength(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.minimumFeatureLength = d;
    }

    public double getMinimumFeatureLength() {
        return this.minimumFeatureLength;
    }

    public void setFeatureSlotSpacing(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.featureSlotSpacing = d;
    }

    public double getFeatureSlotSpacing() {
        return this.featureSlotSpacing;
    }

    public void setArrowheadLength(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.arrowheadLength = d;
    }

    public double getArrowheadLength() {
        return this.arrowheadLength;
    }

    public void setShiftSmallFeatures(boolean bl) {
        this.shiftSmallFeatures = bl;
    }

    public boolean getShiftSmallFeatures() {
        return this.shiftSmallFeatures;
    }

    public void setShadingProportion(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.shadingProportion = f / 2.0f;
    }

    public float getShadingProportion() {
        return this.shadingProportion;
    }

    public void setHighlightOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.highlightOpacity = f;
    }

    public float getHighlightOpacity() {
        return this.highlightOpacity;
    }

    public void setShadowOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.shadowOpacity = f;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setTickThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.tickThickness = f;
    }

    public float getTickThickness() {
        return this.tickThickness;
    }

    public void setTickLength(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.tickLength = f;
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setShortTickThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.shortTickThickness = f;
    }

    public float getShortTickThickness() {
        return this.shortTickThickness;
    }

    public void setLongTickColor(Color color) {
        this.longTickColor = color;
    }

    public Color getLongTickColor() {
        return this.longTickColor;
    }

    public void setShortTickColor(Color color) {
        this.shortTickColor = color;
    }

    public Color getShortTickColor() {
        return this.shortTickColor;
    }

    public void setZeroTickColor(Color color) {
        this.zeroTickColor = color;
    }

    public Color getZeroTickColor() {
        return this.zeroTickColor;
    }

    public void setDesiredNumberOfTicks(int n) {
        if (n < 0) {
            n = 0;
        }
        this.desiredNumberOfTicks = n;
    }

    public int getDesiredNumberOfTicks() {
        return this.desiredNumberOfTicks;
    }

    public void setDesiredZoomCenter(int n) {
        this.desiredZoomCenter = n;
    }

    public int getDesiredZoomCenter() {
        return this.desiredZoomCenter;
    }

    public void setDesiredZoom(double d) {
        this.desiredZoom = d;
    }

    public double getDesiredZoom() {
        return this.desiredZoom;
    }

    public void setRulerFont(Font font) {
        this.rulerFont = font;
    }

    public Font getRulerFont() {
        return this.rulerFont;
    }

    public void setLegendFont(Font font) {
        this.legendFont = font;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    protected ArrayList getLegends() {
        return this.legends;
    }

    public void setWarningFont(Font font) {
        this.warningFont = font;
    }

    public Font getWarningFont() {
        return this.warningFont;
    }

    public void setWarningText(String string) {
        this.warningText = string;
    }

    public String getWarningText() {
        return this.warningText;
    }

    public void setRulerUnits(int n) {
        this.rulerUnits = n;
    }

    public int getRulerUnits() {
        return this.rulerUnits;
    }

    public void setGlobalLabel(int n) {
        this.globalLabel = n;
    }

    public int getGlobalLabel() {
        return this.globalLabel;
    }

    public void setDrawLegends(boolean bl) {
        this.drawLegends = bl;
    }

    public boolean getDrawLegends() {
        return this.drawLegends;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setRulerTextPadding(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.rulerTextPadding = d;
    }

    public double getRulerTextPadding() {
        return this.rulerTextPadding;
    }

    public void setOrigin(double d) {
        if (d < -360.0) {
            d = -360.0;
        }
        if (d > 360.0) {
            d = 360.0;
        }
        this.origin = d;
    }

    public double getOrigin() {
        return this.origin;
    }

    public void setLabelLineThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.labelLineThickness = f;
    }

    public float getLabelLineThickness() {
        return this.labelLineThickness;
    }

    public void setLabelLineLength(double d) {
        if (d < 10.0) {
            d = 10.0;
        }
        this.labelLineLength = d;
    }

    public double getLabelLineLength() {
        return this.labelLineLength;
    }

    protected void setZoomShift(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.zoomShift = d;
    }

    protected double getZoomShift() {
        return this.zoomShift;
    }

    public void setLabelsToKeep(int n) {
        if (n < 0) {
            n = 0;
        }
        this.labelsToKeep = n;
    }

    public int getLabelsToKeep() {
        return this.labelsToKeep;
    }

    public void setLabelShuffle(boolean bl) {
        this.labelShuffle = bl;
    }

    public boolean getLabelShuffle() {
        return this.labelShuffle;
    }

    public void setUseColoredLabelBackgrounds(boolean bl) {
        this.useColoredLabelBackgrounds = bl;
    }

    public boolean getUseColoredLabelBackgrounds() {
        return this.useColoredLabelBackgrounds;
    }

    public void setDrawTickMarks(boolean bl) {
        this.drawTickMarks = bl;
    }

    public boolean getDrawTickMarks() {
        return this.drawTickMarks;
    }

    public void setTitle(String string) {
        this.title = string.trim();
    }

    public String getTitle() {
        return this.title;
    }

    protected ArrayList getFeatureSlots() {
        return this.featureSlots;
    }

    protected void removeLegends() {
        this.legends.clear();
    }

    protected void removeLabels() {
        this.outerLabels.clear();
        this.innerLabels.clear();
    }

    protected ArrayList getOuterLabels() {
        return this.outerLabels;
    }

    protected ArrayList getInnerLabels() {
        return this.innerLabels;
    }

    public ArrayList getLabelBounds() {
        return this.labelBounds;
    }

    protected double getFirstOuterFeatureRadius() {
        return this.backboneRadius + 0.5 * (double)this.backboneThickness + this.featureSlotSpacing;
    }

    protected double getFirstInnerFeatureRadius() {
        return this.backboneRadius - 0.5 * (double)this.backboneThickness - this.featureSlotSpacing;
    }

    protected double getLastOuterFeatureRadius() {
        double d = this.getFirstOuterFeatureRadius();
        for (FeatureSlot featureSlot : this.featureSlots) {
            if (featureSlot.getStrand() != 1) continue;
            d = d + this.featureSlotSpacing + (double)featureSlot.getFeatureThickness();
        }
        return d;
    }

    protected double getLastInnerFeatureRadius() {
        double d = this.getFirstInnerFeatureRadius();
        for (FeatureSlot featureSlot : this.featureSlots) {
            if (featureSlot.getStrand() != 2) continue;
            d = d - this.featureSlotSpacing - (double)featureSlot.getFeatureThickness();
        }
        return d;
    }

    protected Rectangle2D getBackgroundRectangle() {
        return this.backgroundRectangle;
    }

    protected Rectangle2D getTitleRectangle() {
        return this.titleRectangle;
    }

    protected Rectangle2D getLengthRectangle() {
        return this.lengthRectangle;
    }

    protected double getRadians(double d) {
        if (this.virtualZoomMultiplier <= 1.0) {
            return d * (Math.PI * 2 / (double)this.sequenceLength) - Math.PI / 180 * this.origin;
        }
        double d2 = (double)this.centerBase * (Math.PI * 2 / (double)this.sequenceLength) - Math.PI / 180 * this.origin;
        if (this.inZoomRangeOne(this.centerBase) && this.inZoomRangeOne(d)) {
            double d3 = (double)this.centerBase - d;
            double d4 = d3 * (Math.PI * 2 / (double)this.sequenceLength);
            return d2 - d4 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        if (this.inZoomRangeTwo(this.centerBase) && this.inZoomRangeOne(d)) {
            if (this.zoomRangeTwoStart != 0) {
                double d5 = (double)this.centerBase - d;
                double d6 = d5 * (Math.PI * 2 / (double)this.sequenceLength);
                return d2 - d6 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
            }
            double d7 = (double)this.sequenceLength - d + (double)this.centerBase;
            double d8 = d7 * (Math.PI * 2 / (double)this.sequenceLength);
            return d2 - d8 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        if (this.inZoomRangeOne(this.centerBase) && this.inZoomRangeTwo(d)) {
            if (this.zoomRangeTwoStart != 0) {
                double d9 = (double)this.centerBase - d;
                double d10 = d9 * (Math.PI * 2 / (double)this.sequenceLength);
                return d2 - d10 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
            }
            double d11 = (double)this.sequenceLength - (double)this.centerBase + d;
            double d12 = d11 * (Math.PI * 2 / (double)this.sequenceLength);
            return d2 + d12 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        double d13 = (double)this.centerBase - d;
        double d14 = d13 * (Math.PI * 2 / (double)this.sequenceLength);
        return d2 - d14 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
    }

    protected double getRadians(int n) {
        if (this.virtualZoomMultiplier <= 1.0 || n == this.centerBase) {
            return (double)n * (Math.PI * 2 / (double)this.sequenceLength) - Math.PI / 180 * this.origin;
        }
        return this.getRadians((double)n);
    }

    protected Point2D getCenter() {
        return this.centerPoint;
    }

    protected double getDegrees(int n) {
        if (this.virtualZoomMultiplier <= 1.0 || n == this.centerBase) {
            return (double)n / (double)this.sequenceLength * 360.0;
        }
        double d = (double)this.centerBase / (double)this.sequenceLength * 360.0;
        if (this.inZoomRangeOne(this.centerBase) && this.almostInZoomRangeOne(n)) {
            int n2 = this.centerBase - n;
            double d2 = (double)n2 / (double)this.sequenceLength * 360.0;
            return d - d2 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        if (this.inZoomRangeTwo(this.centerBase) && this.almostInZoomRangeOne(n)) {
            if (this.zoomRangeTwoStart != 0) {
                int n3 = this.centerBase - n;
                double d3 = (double)n3 / (double)this.sequenceLength * 360.0;
                return d - d3 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
            }
            int n4 = this.sequenceLength - n + this.centerBase;
            double d4 = (double)n4 / (double)this.sequenceLength * 360.0;
            return d - d4 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        if (this.inZoomRangeOne(this.centerBase) && this.inZoomRangeTwo(n)) {
            if (this.zoomRangeTwoStart != 0) {
                int n5 = this.centerBase - n;
                double d5 = (double)n5 / (double)this.sequenceLength * 360.0;
                return d - d5 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
            }
            int n6 = this.sequenceLength - this.centerBase + n;
            double d6 = (double)n6 / (double)this.sequenceLength * 360.0;
            return d + d6 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
        }
        int n7 = this.centerBase - n;
        double d7 = (double)n7 / (double)this.sequenceLength * 360.0;
        return d - d7 * ((this.virtualZoomMultiplier + this.zoomMultiplier) / this.zoomMultiplier);
    }

    public void setUseInnerLabels(int n) {
        this.useInnerLabels = n;
    }

    public int getUseInnerLabels() {
        return this.useInnerLabels;
    }

    public void setGiveFeaturePositions(int n) {
        this.giveFeaturePositions = n;
    }

    public int getGiveFeaturePositions() {
        return this.giveFeaturePositions;
    }

    protected double getRadiusShiftAmount() {
        return this.radiusShiftAmount;
    }

    protected void setRadiansShiftConstant(double d) {
        this.radiansShiftConstant = d < 0.0 ? 0.0 : d;
    }

    protected double getRadiansShiftConstant() {
        return this.radiansShiftConstant;
    }

    public void setLabelPlacementQuality(int n) {
        this.labelPlacementQuality = n < 1 ? 1 : (n > 10 ? 10 : n);
        if (this.labelPlacementQuality == 0) {
            this.spreadIterations = 0;
            this.clashSpan = 0;
        } else if (this.labelPlacementQuality == 1) {
            this.spreadIterations = 10;
            this.clashSpan = 10;
            this.radiusShiftAmount = 20.0;
        } else if (this.labelPlacementQuality == 2) {
            this.spreadIterations = 20;
            this.clashSpan = 40;
            this.radiusShiftAmount = 15.0;
        } else if (this.labelPlacementQuality == 3) {
            this.spreadIterations = 30;
            this.clashSpan = 60;
            this.radiusShiftAmount = 14.0;
        } else if (this.labelPlacementQuality == 4) {
            this.spreadIterations = 40;
            this.clashSpan = 80;
            this.radiusShiftAmount = 12.0;
        } else if (this.labelPlacementQuality == 5) {
            this.spreadIterations = 50;
            this.clashSpan = 100;
            this.radiusShiftAmount = 10.0;
        } else if (this.labelPlacementQuality == 6) {
            this.spreadIterations = 60;
            this.clashSpan = 120;
            this.radiusShiftAmount = 8.0;
        } else if (this.labelPlacementQuality == 7) {
            this.spreadIterations = 65;
            this.clashSpan = 130;
            this.radiusShiftAmount = 6.0;
        } else if (this.labelPlacementQuality == 8) {
            this.spreadIterations = 70;
            this.clashSpan = 140;
            this.radiusShiftAmount = 4.0;
        } else if (this.labelPlacementQuality == 9) {
            this.spreadIterations = 200;
            this.clashSpan = 150;
            this.radiusShiftAmount = 2.0;
        } else if (this.labelPlacementQuality == 10) {
            this.spreadIterations = 500;
            this.clashSpan = 1000;
            this.radiusShiftAmount = 1.0;
        }
    }

    protected double getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    protected boolean getDrawEntirePlasmid() {
        return this.drawEntirePlasmid;
    }

    protected int getZoomRangeOneStart() {
        return this.zoomRangeOneStart;
    }

    protected int getZoomRangeOneStop() {
        return this.zoomRangeOneStop;
    }

    protected int getZoomRangeTwoStart() {
        return this.zoomRangeTwoStart;
    }

    protected int getZoomRangeTwoStop() {
        return this.zoomRangeTwoStop;
    }

    protected boolean getKeepLastLabels() {
        return this.keepLastLabels;
    }

    protected boolean baseIsDrawable(int n) {
        if (this.zoomMultiplier >= this.zoomShift) {
            if (n >= this.zoomRangeOneStart && n <= this.zoomRangeOneStop) {
                return true;
            }
            if (n >= this.zoomRangeTwoStart && n <= this.zoomRangeTwoStop) {
                return true;
            }
            if (n < this.zoomRangeOneStart) {
                return false;
            }
            return n <= this.zoomRangeTwoStop;
        }
        return true;
    }

    protected boolean inZoomRangeOne(int n) {
        return n >= this.zoomRangeOneStart && n <= this.zoomRangeOneStop;
    }

    protected boolean inZoomRangeOne(double d) {
        return d >= (double)this.zoomRangeOneStart && d <= (double)this.zoomRangeOneStop;
    }

    protected boolean almostInZoomRangeOne(int n) {
        if (n >= this.zoomRangeOneStart && n <= this.zoomRangeOneStop) {
            return true;
        }
        return n + 1 >= this.zoomRangeOneStart && n + 1 <= this.zoomRangeOneStop;
    }

    protected boolean inZoomRangeTwo(int n) {
        return n >= this.zoomRangeTwoStart && n <= this.zoomRangeTwoStop;
    }

    protected boolean inZoomRangeTwo(double d) {
        return d >= (double)this.zoomRangeTwoStart && d <= (double)this.zoomRangeTwoStop;
    }

    protected boolean inZoomRange(int n) {
        return this.inZoomRangeOne(n) || this.inZoomRangeTwo(n);
    }

    protected boolean inZoomRange(double d) {
        return this.inZoomRangeOne(d) || this.inZoomRangeTwo(d);
    }

    protected void addOuterLabel(Label label) {
        this.outerLabels.add(label);
    }

    protected void addInnerLabel(Label label) {
        this.innerLabels.add(label);
    }

    public double getZoomMax() {
        this.smallestDimension = Math.min(this.width, this.height);
        double d = Math.sqrt(this.smallestDimension * this.smallestDimension + this.smallestDimension * this.smallestDimension);
        double d2 = (double)this.sequenceLength / (Math.PI * 2 * this.backboneRadius);
        double d3 = d * d2 / 10.0;
        return d3;
    }

    protected void translateCanvas() {
        if (this.centerPoint != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation((double)(this.width / 2) - this.centerPoint.getX(), (double)(this.height / 2) - this.centerPoint.getY());
            this.gg.transform(affineTransform);
            this.backgroundRectangle = new Rectangle2D.Double(this.centerPoint.getX() - (double)(this.width / 2), this.centerPoint.getY() - (double)(this.height / 2), this.width, this.height);
        }
    }

    protected void untranslateCanvas() {
        if (this.centerPoint != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation((double)(-this.width / 2) + this.centerPoint.getX(), (double)(-this.height / 2) + this.centerPoint.getY());
            this.gg.transform(affineTransform);
            this.backgroundRectangle = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        }
    }

    protected void translateZeroCenter() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(this.width / 2, this.height / 2);
        this.gg.transform(affineTransform);
        this.backgroundRectangle = new Rectangle2D.Double(-(this.width / 2), -(this.height / 2), this.width, this.height);
    }

    protected void untranslateZeroCenter() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(-this.width / 2, -this.height / 2);
        this.gg.transform(affineTransform);
        this.backgroundRectangle = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
    }

    protected double adjustZoom(double d) {
        this.smallestDimension = Math.min(this.width, this.height);
        double d2 = Math.sqrt(this.smallestDimension * this.smallestDimension + this.smallestDimension * this.smallestDimension);
        double d3 = (double)this.sequenceLength / (Math.PI * 2 * this.backboneRadius);
        double d4 = d2 * d3 / 10.0;
        if (d < 1.0) {
            d = 1.0;
        }
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        if (d > d4) {
            d = d4;
        }
        if (d > this.ZOOM_MULTIPLIER_MAX) {
            this.virtualZoomMultiplier = d - this.ZOOM_MULTIPLIER_MAX;
            d = this.ZOOM_MULTIPLIER_MAX;
        }
        if (this.virtualZoomMultiplier > this.VIRTUAL_ZOOM_MULTIPLIER_MAX) {
            this.virtualZoomMultiplier = this.VIRTUAL_ZOOM_MULTIPLIER_MAX;
        }
        return d;
    }

    public void drawZoomed(Graphics2D graphics2D, double d, int n, boolean bl) {
        this.keepLastLabels = bl;
        this.drawZoomed(graphics2D, d, n);
    }

    public void drawZoomed(Graphics2D graphics2D, double d, int n) {
        this.gg = graphics2D;
        this.zoomMultiplier = this.adjustZoom(d);
        this.centerBase = n;
        this.smallestDimension = Math.min(this.width, this.height);
        if (this.backboneRadius > 0.8 * (double)this.smallestDimension / 2.0) {
            this.backboneRadius = 0.8 * (double)this.smallestDimension / 2.0;
            System.err.println("[warning] backbone radius was adjusted to fit inside of canvas.");
        }
        if (this.backboneRadius < 10.0) {
            this.backboneRadius = 10.0;
            System.err.println("[warning] backbone radius was increased to 10.0.");
        }
        double d2 = this.backboneRadius;
        this.backboneRadius *= this.zoomMultiplier;
        this.virtualBackboneRadius = d2 * (this.zoomMultiplier + this.virtualZoomMultiplier - 1.0);
        if (this.centerBase < 0) {
            this.centerBase = 0;
        } else if (this.centerBase > this.sequenceLength) {
            this.centerBase = this.sequenceLength;
        }
        double d3 = this.getRadians(this.centerBase);
        double d4 = Math.cos(d3) * this.backboneRadius;
        double d5 = Math.sin(d3) * this.backboneRadius;
        this.centerPoint = new Point2D.Double(d4, d5);
        this.setRenderQuality();
        this.translateCanvas();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fill(this.backgroundRectangle);
        if (this.zoomMultiplier >= this.zoomShift) {
            double d6 = this.getLastInnerFeatureRadius() - this.featureSlotSpacing - (double)this.tickLength;
            double d7 = this.getLastOuterFeatureRadius() + this.featureSlotSpacing + (double)this.tickLength;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = Math.cos(d3) * d6;
            double d11 = Math.sin(d3) * d6;
            double d12 = d10;
            double d13 = d11;
            double d14 = d10;
            double d15 = d11;
            double d16 = d3;
            double d17 = 1.5707963267948966 / this.backboneRadius;
            Point2D.Double double_ = new Point2D.Double(d10, d11);
            Point2D.Double double_2 = new Point2D.Double(d10, d11);
            this.drawEntirePlasmid = false;
            while ((this.backgroundRectangle.contains(double_) || this.backgroundRectangle.contains(double_2)) && d3 - d16 < Math.PI * 2) {
                d12 = Math.cos(d16 -= d17) * d6;
                d13 = Math.sin(d16) * d6;
                d14 = Math.cos(d16) * d7;
                d15 = Math.sin(d16) * d7;
                ((Point2D)double_).setLocation(d12, d13);
                ((Point2D)double_2).setLocation(d14, d15);
            }
            if (d3 - d16 >= Math.PI * 2) {
                this.drawEntirePlasmid = true;
            }
            d8 = d3 - d16;
            ((Point2D)double_).setLocation(d10, d11);
            ((Point2D)double_2).setLocation(d10, d11);
            d16 = d3;
            while ((this.backgroundRectangle.contains(double_) || this.backgroundRectangle.contains(double_2)) && d16 - d3 < Math.PI * 2) {
                d12 = Math.cos(d16 += d17) * d6;
                d13 = Math.sin(d16) * d6;
                d14 = Math.cos(d16) * d7;
                d15 = Math.sin(d16) * d7;
                ((Point2D)double_).setLocation(d12, d13);
                ((Point2D)double_2).setLocation(d14, d15);
            }
            if (d16 - d3 >= Math.PI * 2) {
                this.drawEntirePlasmid = true;
            }
            d9 = d16 - d3;
            double d18 = (double)this.sequenceLength / (Math.PI * 2 * this.backboneRadius);
            double d19 = d9 * d18 * this.backboneRadius;
            double d20 = d8 * d18 * this.backboneRadius;
            d19 *= this.zoomMultiplier / (this.zoomMultiplier + this.virtualZoomMultiplier - 1.0);
            d20 *= this.zoomMultiplier / (this.zoomMultiplier + this.virtualZoomMultiplier - 1.0);
            d19 += d19 * 0.2;
            d20 += d20 * 0.2;
            int n2 = Math.round((float)d19);
            int n3 = Math.round((float)d20);
            if (!this.drawEntirePlasmid && this.centerBase + n2 > this.sequenceLength) {
                this.zoomRangeOneStart = this.centerBase - n3;
                this.zoomRangeOneStop = this.sequenceLength;
                this.zoomRangeTwoStart = 0;
                this.zoomRangeTwoStop = n2 - (this.sequenceLength - this.centerBase);
            } else if (!this.drawEntirePlasmid && this.centerBase - n3 < 1) {
                this.zoomRangeOneStart = this.sequenceLength - (n3 - this.centerBase);
                this.zoomRangeOneStop = this.sequenceLength;
                this.zoomRangeTwoStart = 0;
                this.zoomRangeTwoStop = this.centerBase + n2;
            } else if (!this.drawEntirePlasmid) {
                this.zoomRangeOneStart = this.centerBase - n3;
                this.zoomRangeOneStop = this.centerBase;
                this.zoomRangeTwoStart = this.centerBase;
                this.zoomRangeTwoStop = this.centerBase + n2;
            }
        }
        this.drawMain();
        this.virtualBackboneRadius = this.backboneRadius = d2;
        this.drawEntirePlasmid = true;
        System.out.println("The map has been drawn.");
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        this.keepLastLabels = bl;
        this.draw(graphics2D);
    }

    public void draw(Graphics2D graphics2D) {
        this.gg = graphics2D;
        this.zoomMultiplier = 1.0;
        this.smallestDimension = Math.min(this.width, this.height);
        if (this.backboneRadius > 0.8 * (double)this.smallestDimension / 2.0) {
            this.backboneRadius = 0.8 * (double)this.smallestDimension / 2.0;
            System.err.println("[warning] backbone radius was adjusted to fit inside of canvas.");
        }
        if (this.backboneRadius < 10.0) {
            this.backboneRadius = 10.0;
            System.err.println("[warning] backbone radius was increased to 10.0.");
        }
        this.virtualBackboneRadius = this.backboneRadius;
        this.setRenderQuality();
        this.centerPoint = new Point2D.Double(0.0, 0.0);
        this.translateCanvas();
        graphics2D.setPaint(this.backgroundColor);
        graphics2D.fill(this.backgroundRectangle);
        this.drawMain();
        System.out.println("The map has been drawn.");
    }

    private void setRenderQuality() {
        this.gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gg.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        this.gg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.gg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.gg.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.gg.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.gg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void drawMain() {
        if (this.drawEntirePlasmid) {
            this.placeTitle();
        }
        if (!this.keepLastLabels) {
            this.innerLabels.clear();
            this.outerLabels.clear();
            this.labelBounds.clear();
            this.clashLabels = 0;
            this.totalLabels = 0;
        }
        System.out.print("Drawing features.");
        for (CgviewConstants cgviewConstants : this.featureSlots) {
            ((FeatureSlot)cgviewConstants).draw();
            System.out.print(".");
        }
        System.out.println(".");
        this.drawBackbone();
        if (this.isLinear) {
            this.drawLinearDividerLine();
        }
        if (this.globalLabel == 2 || this.globalLabel == 4 && this.zoomMultiplier >= this.zoomShift) {
            this.totalLabels = this.outerLabels.size() + this.innerLabels.size();
            System.out.print("Positioning and drawing " + this.totalLabels + " labels.");
            if (!this.keepLastLabels) {
                this.drawLabels(this.innerLabels);
                this.drawLabels(this.outerLabels);
            } else {
                for (CgviewConstants cgviewConstants : this.innerLabels) {
                    ((Label)cgviewConstants).drawLabelLine();
                }
                for (CgviewConstants cgviewConstants : this.outerLabels) {
                    ((Label)cgviewConstants).drawLabelLine();
                }
                this.untranslateCanvas();
                for (CgviewConstants cgviewConstants : this.innerLabels) {
                    ((Label)cgviewConstants).drawLabelText();
                }
                for (CgviewConstants cgviewConstants : this.outerLabels) {
                    ((Label)cgviewConstants).drawLabelText();
                }
                this.translateCanvas();
            }
            System.out.println(".");
            System.out.println(this.clashLabels + " labels were removed.");
        }
        if (this.drawTickMarks) {
            System.out.println("Drawing tick marks.");
            this.drawTickMarks(1, this.getLastOuterFeatureRadius() + 0.5 * (double)this.tickThickness);
            this.drawTickMarks(2, this.getLastInnerFeatureRadius() - 0.5 * (double)this.tickThickness);
        }
        this.untranslateCanvas();
        this.translateZeroCenter();
        this.drawWarningMessage();
        if (this.drawEntirePlasmid) {
            this.drawTitle();
        }
        if (this.showBorder) {
            double d = 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.backgroundRectangle.getX() + 0.5 * d, this.backgroundRectangle.getY() + 0.5 * d, (double)this.width - d, (double)this.height - d);
            this.gg.setPaint(this.borderColor);
            this.gg.setStroke(new BasicStroke((float)d, 2, 0));
            this.gg.draw(double_);
        }
        if (this.drawLegends) {
            System.out.println("Drawing legends.");
            for (Legend legend : this.legends) {
                legend.setBounds(0.0, 0.0);
                legend.draw();
            }
        }
        this.untranslateZeroCenter();
        this.keepLastLabels = false;
        this.legends.remove(this.infoLegend);
        this.zoomMultiplier = 1.0;
        this.virtualZoomMultiplier = 1.0;
    }

    private void drawBackbone() {
        Object object;
        double d;
        double d2;
        int n;
        int n2;
        if (!this.drawEntirePlasmid) {
            n2 = this.zoomRangeOneStart;
            n = this.zoomRangeTwoStop;
        } else {
            n2 = 1;
            n = this.sequenceLength;
        }
        if (n2 <= n) {
            d2 = this.getDegrees(n2 - 1);
            d = this.getDegrees(n) - d2;
        } else {
            d2 = ((double)n2 - 1.0) / (double)this.sequenceLength * 360.0;
            d2 = this.getDegrees(n2 - 1);
            d = this.getDegrees(this.sequenceLength) - d2;
            double d3 = this.getDegrees(0);
            double d4 = this.getDegrees(n) - d3;
            d += d4;
        }
        BasicStroke basicStroke = new BasicStroke(this.backboneThickness, 0, 2);
        Area area = new Area();
        area.add(new Area(basicStroke.createStrokedShape(new Arc2D.Double(-this.backboneRadius, -this.backboneRadius, this.backboneRadius * 2.0, this.backboneRadius * 2.0, -d2 - d + this.origin, d, 0))));
        Area area2 = null;
        if (this.isLinear && this.origin == 90.0 && (this.drawEntirePlasmid || this.zoomRangeTwoStart == 0)) {
            double d5;
            FontRenderContext fontRenderContext = this.gg.getFontRenderContext();
            TextLayout textLayout = new TextLayout(this.linearBreakText, this.rulerFont, fontRenderContext);
            object = textLayout.getBounds();
            double d6 = ((RectangularShape)object).getHeight();
            double d7 = ((RectangularShape)object).getWidth();
            double d8 = this.getRadians(0);
            double d9 = Math.cos(d8) * this.backboneRadius;
            double d10 = Math.sin(d8) * this.backboneRadius;
            double d11 = d9 - d7 / 2.0 - (double)textLayout.getDescent() * 0.4;
            double d12 = d10 + d6 / 2.0;
            this.gg.setPaint(this.backgroundColor);
            ((Rectangle2D)object).setRect(((RectangularShape)object).getX() + d11 - 1.5, ((RectangularShape)object).getY() + (d12 += (double)textLayout.getDescent()) - (double)textLayout.getDescent() - 1.5, ((RectangularShape)object).getWidth() + 3.0, ((RectangularShape)object).getHeight() + 3.0);
            this.gg.setPaint(this.rulerFontColor);
            this.untranslateCanvas();
            textLayout.draw(this.gg, (float)(d11 + (double)(this.width / 2) - this.centerPoint.getX()), (float)(d12 + (double)(this.height / 2) - this.centerPoint.getY()) - textLayout.getDescent());
            this.translateCanvas();
            double d13 = d5 = Math.toDegrees(d7 / this.backboneRadius);
            d13 += d13 * 0.1;
            this.zigzagWidth = d13 / 2.0;
            double d14 = this.getDegrees(0) - d13 / 2.0;
            double d15 = d13;
            BasicStroke basicStroke2 = new BasicStroke(this.backboneThickness + 1.0f, 0, 2);
            area2 = new Area(basicStroke2.createStrokedShape(new Arc2D.Double(-this.backboneRadius, -this.backboneRadius, this.backboneRadius * 2.0, this.backboneRadius * 2.0, -d14 - d15 + this.origin, d15, 0)));
        }
        if (area2 != null) {
            area.subtract(area2);
        }
        area.intersect(new Area(this.getBackgroundRectangle()));
        this.gg.setPaint(this.backboneColor);
        this.gg.fill(area);
        if (this.showShading) {
            this.gg.setComposite(AlphaComposite.getInstance(3, this.highlightOpacity));
            this.gg.setPaint(Color.white);
            double d16 = 0.5 * (double)this.backboneThickness - 0.5 * (double)(this.backboneThickness * this.shadingProportion);
            object = new BasicStroke(this.backboneThickness * this.shadingProportion, 0, 2);
            Area area3 = new Area();
            area3.add(new Area(((BasicStroke)object).createStrokedShape(new Arc2D.Double(-this.backboneRadius - d16, -this.backboneRadius - d16, (this.backboneRadius + d16) * 2.0, (this.backboneRadius + d16) * 2.0, -d2 - d + this.origin, d, 0))));
            if (area2 != null) {
                area3.subtract(area2);
            }
            area3.intersect(new Area(this.getBackgroundRectangle()));
            this.gg.fill(area3);
            this.gg.setComposite(AlphaComposite.getInstance(3, this.shadowOpacity));
            this.gg.setPaint(Color.black);
            double d17 = -0.5 * (double)this.backboneThickness + 0.5 * (double)(this.backboneThickness * this.shadingProportion);
            BasicStroke basicStroke3 = new BasicStroke(this.backboneThickness * this.shadingProportion, 0, 2);
            Area area4 = new Area();
            area4.add(new Area(basicStroke3.createStrokedShape(new Arc2D.Double(-this.backboneRadius - d17, -this.backboneRadius - d17, (this.backboneRadius + d17) * 2.0, (this.backboneRadius + d17) * 2.0, -d2 - d + this.origin, d, 0))));
            if (area2 != null) {
                area4.subtract(area2);
            }
            area4.intersect(new Area(this.getBackgroundRectangle()));
            this.gg.fill(area4);
            this.gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        double d18 = this.getLastOuterFeatureRadius();
        double d19 = this.getLastInnerFeatureRadius();
        this.outerArc = new Arc2D.Double(-d18, -d18, d18 * 2.0, d18 * 2.0, -d2 - d + this.origin, d, 0);
        this.innerArc = new Arc2D.Double(-d19, -d19, d19 * 2.0, d19 * 2.0, -d2 - d + this.origin, d, 0);
    }

    private void drawLinearDividerLine() {
        if (!this.drawEntirePlasmid && this.zoomRangeTwoStart != 0) {
            return;
        }
        double d = this.getLastOuterFeatureRadius() - this.featureSlotSpacing;
        double d2 = this.getLastInnerFeatureRadius() + this.featureSlotSpacing;
        double d3 = this.getRadians(0);
        int n = this.featureSlots.size() * 4;
        double d4 = Math.toRadians(this.zigzagWidth / 8.0);
        boolean bl = true;
        double d5 = d2;
        double d6 = (d - d2) / (double)n / 2.0;
        double d7 = 0.5f * this.tickThickness - 0.5f * (this.shadingProportion * this.tickThickness);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> arrayList3 = new ArrayList<Point2D.Double>();
        arrayList.add(new Point2D.Double(Math.cos(d3) * d2, Math.sin(d3) * d2));
        arrayList2.add(new Point2D.Double(Math.cos(d3 + d7 / d2) * d2, Math.sin(d3 + d7 / d2) * d2));
        arrayList3.add(new Point2D.Double(Math.cos(d3 - d7 / d2) * d2, Math.sin(d3 - d7 / d2) * d2));
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
                arrayList.add(new Point2D.Double(Math.cos(d3 + d4) * (d5 += d6), Math.sin(d3 + d4) * d5));
                arrayList2.add(new Point2D.Double(Math.cos(d3 + d4 + d7 / d5) * d5, Math.sin(d3 + d4 + d7 / d5) * d5));
                arrayList3.add(new Point2D.Double(Math.cos(d3 + d4 - d7 / d5) * d5, Math.sin(d3 + d4 - d7 / d5) * d5));
                arrayList.add(new Point2D.Double(Math.cos(d3) * (d5 += d6), Math.sin(d3) * d5));
                arrayList2.add(new Point2D.Double(Math.cos(d3 + d7 / d5) * d5, Math.sin(d3 + d7 / d5) * d5));
                arrayList3.add(new Point2D.Double(Math.cos(d3 - d7 / d5) * d5, Math.sin(d3 - d7 / d5) * d5));
                continue;
            }
            bl = true;
            arrayList.add(new Point2D.Double(Math.cos(d3 - d4) * (d5 += d6), Math.sin(d3 - d4) * d5));
            arrayList2.add(new Point2D.Double(Math.cos(d3 - d4 + d7 / d5) * d5, Math.sin(d3 - d4 + d7 / d5) * d5));
            arrayList3.add(new Point2D.Double(Math.cos(d3 - d4 - d7 / d5) * d5, Math.sin(d3 - d4 - d7 / d5) * d5));
            arrayList.add(new Point2D.Double(Math.cos(d3) * (d5 += d6), Math.sin(d3) * d5));
            arrayList2.add(new Point2D.Double(Math.cos(d3 + d7 / d5) * d5, Math.sin(d3 + d7 / d5) * d5));
            arrayList3.add(new Point2D.Double(Math.cos(d3 - d7 / d5) * d5, Math.sin(d3 - d7 / d5) * d5));
        }
        arrayList.add(new Point2D.Double(Math.cos(d3) * d, Math.sin(d3) * d));
        arrayList2.add(new Point2D.Double(Math.cos(d3 + d7 / d) * d, Math.sin(d3 + d7 / d) * d));
        arrayList3.add(new Point2D.Double(Math.cos(d3 - d7 / d) * d, Math.sin(d3 - d7 / d) * d));
        Point2D point2D = null;
        Point2D point2D2 = null;
        Iterator iterator = arrayList.iterator();
        Area area = new Area();
        BasicStroke basicStroke = new BasicStroke(this.tickThickness, 1, 2);
        if (iterator.hasNext()) {
            point2D = (Point2D)iterator.next();
        }
        while (iterator.hasNext()) {
            point2D2 = (Point2D)iterator.next();
            area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY()))));
            point2D = point2D2;
        }
        this.gg.setPaint(this.longTickColor);
        area.intersect(new Area(this.getBackgroundRectangle()));
        this.gg.fill(area);
        if (this.showShading) {
            point2D = null;
            point2D2 = null;
            iterator = arrayList2.iterator();
            area = new Area();
            basicStroke = new BasicStroke(this.tickThickness * this.shadingProportion, 1, 2);
            if (iterator.hasNext()) {
                point2D = (Point2D)iterator.next();
            }
            while (iterator.hasNext()) {
                point2D2 = (Point2D)iterator.next();
                area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY()))));
                point2D = point2D2;
            }
            this.gg.setPaint(Color.white);
            this.gg.setComposite(AlphaComposite.getInstance(3, this.highlightOpacity));
            area.intersect(new Area(this.getBackgroundRectangle()));
            this.gg.fill(area);
            point2D = null;
            point2D2 = null;
            iterator = arrayList3.iterator();
            area = new Area();
            basicStroke = new BasicStroke(this.tickThickness * this.shadingProportion, 1, 2);
            if (iterator.hasNext()) {
                point2D = (Point2D)iterator.next();
            }
            while (iterator.hasNext()) {
                point2D2 = (Point2D)iterator.next();
                area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY()))));
                point2D = point2D2;
            }
            this.gg.setPaint(Color.black);
            this.gg.setComposite(AlphaComposite.getInstance(3, this.shadowOpacity));
            area.intersect(new Area(this.getBackgroundRectangle()));
            this.gg.fill(area);
            this.gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    private void drawTickMarks(int n, double d) {
        double d2;
        double d3;
        double d4;
        int n2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        double d5 = 100000.0;
        double d6 = 10.0;
        double d7 = 0.0;
        String string = "mbp";
        int[] nArray = new int[]{1, 5, 5, 5, 5, 2, 5, 5, 5, 5};
        int n3 = 0;
        int[] nArray2 = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000, 5000000, 10000000};
        double[] dArray = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1.0, 2.0, 5.0, 10.0};
        String[] stringArray = new String[]{" bp", " bp", " bp", " bp", " bp", " bp", " bp", " bp", " bp", " kbp", " kbp", " kbp", " kbp", " kbp", " kbp", " kbp", " kbp", " kbp", " mbp", " mbp", " mbp", " mbp"};
        double[] dArray2 = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 200000.0, 500000.0, 1000000.0, 2000000.0, 5000000.0, 1.0E7};
        double[] dArray3 = new double[]{100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02, 0.01, 0.005, 0.002, 0.001, 5.0E-4, 2.0E-4, 1.0E-4, 5.0E-5, 2.0E-5, 1.0E-5};
        int[] nArray3 = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
        int n4 = 0;
        int n5 = n == 1 ? 1 : -1;
        double d8 = (double)this.sequenceLength / ((double)this.desiredNumberOfTicks * ((this.virtualBackboneRadius - (this.backboneRadius - this.getLastInnerFeatureRadius())) / 200.0) * this.tickDensity);
        if (this.rulerUnits == 1) {
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (!(d8 < (double)nArray2[n2]) && n2 != nArray2.length - 1) continue;
                d5 = nArray2[n2];
                d6 = dArray[n2];
                string = stringArray[n2];
                break;
            }
        } else if (this.rulerUnits == 2) {
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                if (!((double)this.desiredNumberOfTicks * ((this.virtualBackboneRadius - (this.backboneRadius - this.getLastInnerFeatureRadius())) / 200.0) * this.tickDensity < dArray2[n2]) && n2 != dArray2.length - 1) continue;
                if (n2 > 0) {
                    d5 = (double)this.sequenceLength / dArray2[n2 - 1];
                    d6 = dArray3[n2 - 1];
                    n4 = nArray3[n2 - 1];
                    string = "centisome";
                    numberFormat.setMaximumFractionDigits(n4);
                    numberFormat.setMinimumFractionDigits(n4);
                } else {
                    d5 = (double)this.sequenceLength / dArray2[n2];
                    d6 = dArray3[n2];
                    n4 = nArray3[n2];
                    string = "centisome";
                    numberFormat.setMaximumFractionDigits(n4);
                    numberFormat.setMinimumFractionDigits(n4);
                }
                break;
            }
        }
        d5 /= (double)nArray.length;
        double d9 = 0.0;
        int n6 = this.sequenceLength;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (this.drawEntirePlasmid) {
                bl = true;
            } else if (this.zoomRangeTwoStart != 0) {
                d9 = this.zoomRangeOneStart;
                d9 = d5 - d9 % d5 + d9;
                n6 = this.zoomRangeTwoStop;
                bl = true;
            } else if (bl2) {
                d9 = this.zoomRangeTwoStart;
                d9 = d5 - d9 % d5 + d9;
                n6 = this.zoomRangeTwoStop;
                bl = true;
            } else {
                d9 = this.zoomRangeOneStart;
                d9 = d5 - d9 % d5 + d9;
                n6 = this.zoomRangeOneStop;
                bl2 = true;
            }
            while (d9 - 0.5 < (double)n6) {
                d4 = this.getRadians(d9);
                int n7 = (int)Math.floor(d9 / d5 + 0.5);
                n3 = n7 % nArray.length;
                d7 = (double)(n7 / nArray.length) * d6;
                double d10 = nArray[n3];
                Color color = this.longTickColor;
                float f = this.tickThickness;
                if (nArray[n3] != 1) {
                    color = this.shortTickColor;
                    f = this.shortTickThickness;
                }
                double d11 = Math.cos(d4) * d;
                double d12 = Math.sin(d4) * d;
                double d13 = Math.cos(d4) * (d + (double)((float)n5 * this.tickLength) / d10);
                double d14 = Math.sin(d4) * (d + (double)((float)n5 * this.tickLength) / d10);
                if (!this.backgroundRectangle.contains(d11, d12) || !this.backgroundRectangle.contains(d13, d14)) {
                    d9 += d5;
                    if (n != 2 || nArray[n3] != 1) continue;
                    d7 += d6;
                    continue;
                }
                this.gg.setPaint(color);
                this.gg.setStroke(new BasicStroke(f, 1, 2));
                this.gg.draw(new Line2D.Double(d11, d12, d13, d14));
                d3 = 1.5;
                double d15 = Math.cos(d4) * (d + (double)((float)n5 * this.tickLength) * 0.5) - 0.5 * ((double)(this.tickLength + f) + d3);
                d2 = Math.sin(d4) * (d + (double)((float)n5 * this.tickLength) * 0.5) - 0.5 * ((double)(this.tickLength + f) + d3);
                int n8 = (int)Math.floor(d9 + 0.5) <= 0 ? 1 : (int)Math.floor(d9 + 0.5);
                Rectangle2D.Double double_ = new Rectangle2D.Double(d15 + (double)(this.width / 2) - this.centerPoint.getX(), d2 + (double)(this.height / 2) - this.centerPoint.getY(), (double)(this.tickLength + f) + d3, (double)(this.tickLength + f) + d3);
                LabelBounds labelBounds = new LabelBounds(this);
                labelBounds.setBounds(double_);
                labelBounds.setLabel(Integer.toString(n8));
                labelBounds.setType(1);
                labelBounds.setUse(true);
                labelBounds.setBase(n8);
                if (this.showShading) {
                    double d16 = 0.5 * (double)f - 0.5 * (double)(this.shadingProportion * f);
                    this.gg.setComposite(AlphaComposite.getInstance(3, this.highlightOpacity));
                    this.gg.setPaint(Color.white);
                    d11 = Math.cos(d4 + d16 / d) * d;
                    d12 = Math.sin(d4 + d16 / d) * d;
                    d13 = Math.cos(d4 + d16 / (d + (double)((float)n5 * this.tickLength) / d10)) * (d + (double)((float)n5 * this.tickLength) / d10);
                    d14 = Math.sin(d4 + d16 / (d + (double)((float)n5 * this.tickLength) / d10)) * (d + (double)((float)n5 * this.tickLength) / d10);
                    this.gg.setStroke(new BasicStroke(f * this.shadingProportion, 0, 2));
                    this.gg.draw(new Line2D.Double(d11, d12, d13, d14));
                    this.gg.setComposite(AlphaComposite.getInstance(3, this.shadowOpacity));
                    this.gg.setPaint(Color.black);
                    d11 = Math.cos(d4 - d16 / d) * d;
                    d12 = Math.sin(d4 - d16 / d) * d;
                    d13 = Math.cos(d4 - d16 / (d + (double)((float)n5 * this.tickLength) / d10)) * (d + (double)((float)n5 * this.tickLength) / d10);
                    d14 = Math.sin(d4 - d16 / (d + (double)((float)n5 * this.tickLength) / d10)) * (d + (double)((float)n5 * this.tickLength) / d10);
                    this.gg.setStroke(new BasicStroke(f * this.shadingProportion, 0, 2));
                    this.gg.draw(new Line2D.Double(d11, d12, d13, d14));
                    this.gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
                if (n == 2 && nArray[n3] == 1) {
                    if (d7 > 0.0) {
                        d11 = Math.cos(d4) * (d - this.rulerTextPadding - (double)this.tickLength - 0.5 * (double)this.tickThickness);
                        d12 = Math.sin(d4) * (d - this.rulerTextPadding - (double)this.tickLength - 0.5 * (double)this.tickThickness);
                        FontRenderContext fontRenderContext = this.gg.getFontRenderContext();
                        String string2 = this.rulerUnits == 1 ? Integer.toString((int)d7) + string : numberFormat.format(d7);
                        TextLayout textLayout = new TextLayout(string2, this.rulerFont, fontRenderContext);
                        Rectangle2D rectangle2D = textLayout.getBounds();
                        double d17 = rectangle2D.getHeight();
                        double d18 = rectangle2D.getWidth();
                        double d19 = d11;
                        double d20 = d12;
                        if (Math.sin(d4) <= 1.0 && Math.sin(d4) >= 0.0 && Math.cos(d4) >= 0.0 && Math.cos(d4) <= 1.0) {
                            d19 = d19 - d18 + 0.5 * d18 * Math.sin(d4);
                            d20 = d20 + 0.5 * d17 - 0.5 * d17 * Math.sin(d4);
                        } else if (Math.sin(d4) <= 1.0 && Math.sin(d4) >= 0.0 && Math.cos(d4) <= 0.0 && Math.cos(d4) >= -1.0) {
                            d19 -= 0.5 * d18 * Math.sin(d4);
                            d20 = d20 + 0.5 * d17 - 0.5 * d17 * Math.sin(d4);
                        } else if (Math.sin(d4) <= 0.0 && Math.sin(d4) >= -1.0 && Math.cos(d4) <= 0.0 && Math.cos(d4) >= -1.0) {
                            d19 += 0.5 * d18 * Math.sin(d4);
                            d20 = d20 + 0.5 * d17 - 0.5 * d17 * Math.sin(d4);
                        } else {
                            d19 = d19 - d18 - 0.5 * d18 * Math.sin(d4);
                            d20 = d20 + 0.5 * d17 - 0.5 * d17 * Math.sin(d4);
                        }
                        double d21 = 0.0;
                        this.gg.setPaint(this.backgroundColor);
                        rectangle2D.setRect(rectangle2D.getX() + d19 - 1.5 - d21, rectangle2D.getY() + d20 - (double)textLayout.getDescent() - 1.5 - d21, rectangle2D.getWidth() + 3.0, rectangle2D.getHeight() + 3.0);
                        if (this.backgroundRectangle.contains(rectangle2D)) {
                            this.gg.setComposite(AlphaComposite.getInstance(3, 0.6f));
                            this.gg.fill(rectangle2D);
                            this.gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
                            this.gg.setPaint(this.rulerFontColor);
                            this.untranslateCanvas();
                            textLayout.draw(this.gg, (float)(d19 + (double)(this.width / 2) - this.centerPoint.getX()), (float)(d20 + (double)(this.height / 2) - this.centerPoint.getY()) - textLayout.getDescent());
                            this.translateCanvas();
                        }
                    }
                    d7 += d6;
                }
                d9 += d5;
            }
        }
        if (this.drawEntirePlasmid || this.zoomRangeTwoStart == 0) {
            d4 = this.getRadians(0);
            double d22 = Math.cos(d4) * d;
            double d23 = Math.sin(d4) * d;
            double d24 = Math.cos(d4) * (d + (double)((float)n5 * this.tickLength));
            double d25 = Math.sin(d4) * (d + (double)((float)n5 * this.tickLength));
            if (this.backgroundRectangle.contains(d22, d23) || this.backgroundRectangle.contains(d24, d25)) {
                this.gg.setPaint(this.zeroTickColor);
                this.gg.setStroke(new BasicStroke(this.tickThickness, 1, 2));
                this.gg.draw(new Line2D.Double(d22, d23, d24, d25));
                double d26 = 1.5;
                double d27 = 1.0;
                double d28 = Math.cos(d4) * (d + (double)((float)n5 * this.tickLength) * 0.5) - 0.5 * ((double)(this.tickLength + this.tickThickness) + d26);
                d3 = Math.sin(d4) * (d + (double)((float)n5 * this.tickLength) * 0.5) - 0.5 * ((double)(this.tickLength + this.tickThickness) + d26);
                Rectangle2D.Double double_ = new Rectangle2D.Double(d28 + (double)(this.width / 2) - this.centerPoint.getX(), d3 + (double)(this.height / 2) - this.centerPoint.getY(), (double)(this.tickLength + this.tickThickness) + d26, (double)(this.tickLength + this.tickThickness) + d26);
                LabelBounds labelBounds = new LabelBounds(this);
                labelBounds.setBounds(double_);
                labelBounds.setLabel(Integer.toString(1));
                labelBounds.setType(1);
                labelBounds.setUse(true);
                labelBounds.setBase(1);
                this.gg.setPaint(Color.red);
                if (this.showShading) {
                    d2 = 0.5f * this.tickThickness - 0.5f * (this.shadingProportion * this.tickThickness);
                    this.gg.setComposite(AlphaComposite.getInstance(3, this.highlightOpacity));
                    this.gg.setPaint(Color.white);
                    d22 = Math.cos(d4 + d2 / d) * d;
                    d23 = Math.sin(d4 + d2 / d) * d;
                    d24 = Math.cos(d4 + d2 / (d + (double)((float)n5 * this.tickLength))) * (d + (double)((float)n5 * this.tickLength));
                    d25 = Math.sin(d4 + d2 / (d + (double)((float)n5 * this.tickLength))) * (d + (double)((float)n5 * this.tickLength));
                    this.gg.setStroke(new BasicStroke(this.tickThickness * this.shadingProportion, 0, 2));
                    this.gg.draw(new Line2D.Double(d22, d23, d24, d25));
                    this.gg.setComposite(AlphaComposite.getInstance(3, this.shadowOpacity));
                    this.gg.setPaint(Color.black);
                    d22 = Math.cos(d4 - d2 / d) * d;
                    d23 = Math.sin(d4 - d2 / d) * d;
                    d24 = Math.cos(d4 - d2 / (d + (double)((float)n5 * this.tickLength))) * (d + (double)((float)n5 * this.tickLength));
                    d25 = Math.sin(d4 - d2 / (d + (double)((float)n5 * this.tickLength))) * (d + (double)((float)n5 * this.tickLength));
                    this.gg.setStroke(new BasicStroke(this.tickThickness * this.shadingProportion, 0, 2));
                    this.gg.draw(new Line2D.Double(d22, d23, d24, d25));
                    this.gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
            }
        }
    }

    private void placeTitle() {
        Pattern pattern;
        Matcher matcher;
        this.titleRectangle = new Rectangle2D.Double();
        this.lengthRectangle = new Rectangle2D.Double();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.title == null) {
            this.title = "";
        }
        if ((matcher = (pattern = Pattern.compile("\\S")).matcher(this.title)).find()) {
            FontRenderContext fontRenderContext = this.gg.getFontRenderContext();
            TextLayout textLayout = new TextLayout(this.title, this.titleFont, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            d = 0.0 - 0.5 * (double)textLayout.getAdvance();
            d2 = 0.0;
            this.titleRectangle.setRect(rectangle2D.getX() + d - 1.5, rectangle2D.getY() + d2 - (double)textLayout.getDescent() - 1.5, rectangle2D.getWidth() + 3.0, rectangle2D.getHeight() + 3.0);
            fontRenderContext = this.gg.getFontRenderContext();
            textLayout = new TextLayout(Integer.toString(this.sequenceLength) + " bp", this.titleFont, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            d4 = d2 + (double)textLayout.getDescent() + (double)textLayout.getLeading() + (double)textLayout.getDescent() + (double)textLayout.getAscent();
            this.lengthRectangle.setRect(rectangle2D.getX() + (d3 -= 0.5 * (double)textLayout.getAdvance()) - 1.5, rectangle2D.getY() + d4 - (double)textLayout.getDescent() - 1.5, rectangle2D.getWidth() + 3.0, rectangle2D.getHeight() + 3.0);
        } else {
            this.titleRectangle.setRect(-5.0, -5.0, 10.0, 10.0);
        }
    }

    private void drawTitle() {
        Pattern pattern;
        Matcher matcher;
        this.titleRectangle = new Rectangle2D.Double();
        this.lengthRectangle = new Rectangle2D.Double();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.title == null) {
            this.title = "";
        }
        if ((matcher = (pattern = Pattern.compile("\\S")).matcher(this.title)).find()) {
            FontRenderContext fontRenderContext = this.gg.getFontRenderContext();
            TextLayout textLayout = new TextLayout(this.title, this.titleFont, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            d = 0.0 - 0.5 * (double)textLayout.getAdvance();
            d2 = 0.0;
            this.gg.setPaint(this.titleFontColor);
            this.titleRectangle.setRect(rectangle2D.getX() + d - 1.5, rectangle2D.getY() + d2 - (double)textLayout.getDescent() - 1.5, rectangle2D.getWidth() + 3.0, rectangle2D.getHeight() + 3.0);
            if (this.backgroundRectangle.contains(this.titleRectangle)) {
                textLayout.draw(this.gg, (float)d, (float)d2);
            } else {
                System.err.println("[warning] the plasmid title was too big for the canvas and was removed.");
            }
            fontRenderContext = this.gg.getFontRenderContext();
            textLayout = new TextLayout(Integer.toString(this.sequenceLength) + " bp", this.titleFont, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            d4 = d2 + (double)textLayout.getDescent() + (double)textLayout.getLeading() + (double)textLayout.getDescent() + (double)textLayout.getAscent();
            this.lengthRectangle.setRect(rectangle2D.getX() + (d3 -= 0.5 * (double)textLayout.getAdvance()) - 1.5, rectangle2D.getY() + d4 - (double)textLayout.getDescent() - 1.5, rectangle2D.getWidth() + 3.0, rectangle2D.getHeight() + 3.0);
            this.gg.setPaint(this.titleFontColor);
            if (this.backgroundRectangle.contains(this.lengthRectangle)) {
                textLayout.draw(this.gg, (float)d3, (float)d4);
            } else {
                System.out.println("[warning] the plasmid length was too big for the canvas and was removed.");
            }
        } else {
            this.titleRectangle.setRect(-5.0, -5.0, 10.0, 10.0);
        }
    }

    private void drawWarningMessage() {
        if (this.showWarning && this.totalLabels > 0) {
            String string = "";
            if (this.showWarning) {
                string = string + this.warningText;
            }
            if (this.zoomMultiplier == 1.0 && this.clashLabels != 0) {
                string = this.clashLabels == 1 ? string + "Warning: " + this.clashLabels + " of the " + this.totalLabels + " labels is not shown. " : string + "Warning: " + this.clashLabels + " of the " + this.totalLabels + " labels are not shown. ";
            } else if (this.zoomMultiplier == 1.0 && this.clashLabels == 0) {
                string = string + this.totalLabels + " of the " + this.totalLabels + " labels are shown. ";
            }
            Pattern pattern = Pattern.compile("\\S");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                this.infoLegend = new Legend(this);
                this.infoLegend.setFont(this.warningFont);
                this.infoLegend.setBackgroundColor(this.backgroundColor);
                this.infoLegend.setBackgroundOpacity(0.2f);
                this.infoLegend.setAllowLabelClash(false);
                this.infoLegend.setPosition(9);
                LegendItem legendItem = new LegendItem(this.infoLegend);
                legendItem.setDrawSwatch(2);
                legendItem.setLabel(string);
                legendItem.setFontColor(this.warningFontColor);
            }
        }
    }

    private void drawLabels(ArrayList arrayList) {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        if (this.drawTickMarks) {
            d2 = this.getLastOuterFeatureRadius() + (double)this.tickLength + (double)this.tickThickness + this.featureSlotSpacing;
            d = this.getLastInnerFeatureRadius() - (double)this.tickLength - (double)this.tickThickness - this.featureSlotSpacing;
        } else {
            d2 = this.getLastOuterFeatureRadius() + this.featureSlotSpacing;
            d = this.getLastInnerFeatureRadius() - this.featureSlotSpacing;
        }
        int n4 = this.clashSpan;
        System.out.print(".");
        for (Label label : arrayList) {
            if (label instanceof OuterLabel) {
                label.setLineStartRadius(d2);
                continue;
            }
            label.setLineStartRadius(d);
        }
        System.out.print(".");
        if (this.labelShuffle && arrayList.size() > 50) {
            Collections.shuffle(arrayList);
        }
        System.out.print(".");
        if (arrayList.size() > this.labelsToKeep) {
            block1: for (int i = 0; i < arrayList.size() - this.labelsToKeep; ++i) {
                if (((Label)arrayList.get(i)).getForceLabel()) continue;
                for (n3 = i; n3 < arrayList.size(); ++n3) {
                    if (!((Label)arrayList.get(i)).getBounds().intersects(((Label)arrayList.get(n3)).getBounds())) continue;
                    arrayList.remove(i);
                    --i;
                    ++this.clashLabels;
                    continue block1;
                }
            }
        }
        System.out.print(".");
        Comparator comparator = new SortLabelsByRadians();
        Collections.sort(arrayList, comparator);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((Label)iterator.next()).updateBounds(3.0);
        }
        System.out.print(".");
        if (arrayList.size() > 1) {
            for (n2 = 0; n2 < this.spreadIterations; ++n2) {
                boolean bl = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i == 0) {
                        if (((Label)arrayList.get(1)).getLineStartRadians() - ((Label)arrayList.get(0)).getLineStartRadians() > Math.PI) continue;
                        n3 = 1;
                        n = 0;
                    }
                    if (i == arrayList.size() - 1) {
                        if (((Label)arrayList.get(i)).getLineStartRadians() - ((Label)arrayList.get(0)).getLineStartRadians() < Math.PI) continue;
                        n3 = i;
                        n = 0;
                    } else {
                        n3 = i;
                        n = i + 1;
                    }
                    if (!((Label)arrayList.get(n3)).getBounds().intersects(((Label)arrayList.get(n)).getBounds())) continue;
                    bl = false;
                    ((Label)arrayList.get(n3)).shiftRadiansLower();
                    ((Label)arrayList.get(n)).shiftRadiansHigher();
                }
                if (bl) break;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((Label)iterator.next()).updateBounds(2.0);
        }
        System.out.print(".");
        if (arrayList.size() > 1) {
            block7: for (n = 0; n < arrayList.size(); ++n) {
                if (((Label)arrayList.get(n)).getForceLabel()) continue;
                if (n4 > arrayList.size() / 2) {
                    n4 = arrayList.size() / 2;
                }
                int n5 = n - n4;
                n3 = 0;
                while (n3 < n4 * 2) {
                    if (n5 == arrayList.size()) {
                        n5 = 0;
                    } else if (n5 < 0) {
                        n5 = arrayList.size() + n5;
                    }
                    if (n5 == n) {
                        ++n5;
                        continue;
                    }
                    if (((Label)arrayList.get(n)).getBounds().intersects(((Label)arrayList.get(n5)).getBounds())) {
                        if (((Label)arrayList.get(n)).extendRadius()) {
                            n5 = n - n4;
                            n3 = 0;
                            continue;
                        }
                        if (!this.moveInnerLabelsToOuter || (Label)arrayList.get(n) instanceof OuterLabel) {
                            arrayList.remove(n);
                            ++this.clashLabels;
                            --n;
                            continue block7;
                        }
                        new OuterLabel((InnerLabel)arrayList.get(n));
                        arrayList.remove(n);
                        --n;
                        continue block7;
                    }
                    ++n3;
                    ++n5;
                }
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((Label)iterator.next()).updateBounds(1.5);
        }
        System.out.print(".");
        Collections.shuffle(arrayList);
        if (arrayList.size() > 1) {
            block10: for (int i = 0; i < arrayList.size(); ++i) {
                if (((Label)arrayList.get(i)).getForceLabel()) continue;
                for (n3 = i + 1; n3 < arrayList.size(); ++n3) {
                    if (!((Label)arrayList.get(i)).getBounds().intersects(((Label)arrayList.get(n3)).getBounds())) continue;
                    if (!this.moveInnerLabelsToOuter || (Label)arrayList.get(i) instanceof OuterLabel) {
                        arrayList.remove(i);
                        ++this.clashLabels;
                        --i;
                        continue block10;
                    }
                    new OuterLabel((InnerLabel)arrayList.get(i));
                    arrayList.remove(i);
                    --i;
                    continue block10;
                }
            }
        }
        System.out.print(".");
        if (arrayList.size() > 0) {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                Label label = (Label)arrayList.get(n3);
                if (label instanceof OuterLabel) {
                    if (!this.outerArc.intersects(label.getBounds()) && this.backgroundRectangle.contains(label.getBounds()) && this.backgroundRectangle.contains(label.getLineStart()) || label.getForceLabel()) continue;
                    if (!this.moveInnerLabelsToOuter || label instanceof OuterLabel) {
                        arrayList.remove(n3);
                        ++this.clashLabels;
                        --n3;
                        continue;
                    }
                    new OuterLabel((InnerLabel)label);
                    arrayList.remove(n3);
                    --n3;
                    continue;
                }
                if (this.drawEntirePlasmid) {
                    if (!this.titleRectangle.intersects(label.getBounds()) && !this.lengthRectangle.intersects(label.getBounds()) && this.innerArc.contains(label.getBounds()) && !this.titleRectangle.contains(label.getBounds()) && !this.lengthRectangle.contains(label.getBounds()) && this.backgroundRectangle.contains(label.getBounds()) && this.backgroundRectangle.contains(label.getLineStart()) || label.getForceLabel()) continue;
                    if (!this.moveInnerLabelsToOuter || label instanceof OuterLabel) {
                        arrayList.remove(n3);
                        ++this.clashLabels;
                        --n3;
                        continue;
                    }
                    new OuterLabel((InnerLabel)label);
                    arrayList.remove(n3);
                    --n3;
                    continue;
                }
                if (this.backgroundRectangle.contains(label.getBounds()) && this.backgroundRectangle.contains(label.getLineStart()) || label.getForceLabel()) continue;
                if (!this.moveInnerLabelsToOuter || label instanceof OuterLabel) {
                    arrayList.remove(n3);
                    ++this.clashLabels;
                    --n3;
                    continue;
                }
                new OuterLabel((InnerLabel)label);
                arrayList.remove(n3);
                --n3;
            }
        }
        System.out.print(".");
        if (arrayList.size() > 0) {
            for (Legend legend : this.legends) {
                if (legend.getAllowLabelClash()) continue;
                Rectangle2D rectangle2D = legend.getBounds();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    Label label = (Label)arrayList.get(n2);
                    if (label.getForceLabel() || !rectangle2D.contains(label.getBounds()) && !rectangle2D.intersects(label.getBounds())) continue;
                    if (!this.moveInnerLabelsToOuter || label instanceof OuterLabel) {
                        arrayList.remove(n2);
                        ++this.clashLabels;
                        --n2;
                        continue;
                    }
                    new OuterLabel((InnerLabel)label);
                    arrayList.remove(n2);
                    --n2;
                }
            }
        }
        System.out.print(".");
        comparator = new SortLabelsByForceLabel();
        Collections.sort(arrayList, comparator);
        System.out.print(".");
        for (Label label : arrayList) {
            label.drawLabelLine();
        }
        this.untranslateCanvas();
        System.out.print(".");
        for (Label label : arrayList) {
            label.drawLabelText();
            if (label.getHyperlink() == null && label.getMouseover() == null) continue;
            LabelBounds labelBounds = new LabelBounds(this);
            labelBounds.setBounds(label.getBounds());
            labelBounds.setLabel(label.getLabelText());
            labelBounds.setType(2);
            labelBounds.setHyperlink(label.getHyperlink());
            labelBounds.setMouseover(label.getMouseover());
            labelBounds.setUse(true);
        }
        this.translateCanvas();
    }

    public static void main(String[] stringArray) {
    }
}

