/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.InnerLabel;
import ca.ualberta.stothard.cgview.Label;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class OuterLabel
extends Label
implements CgviewConstants {
    protected OuterLabel(Cgview cgview, String string, String string2, String string3, Font font, Color color, boolean bl, double d, int n) {
        super(cgview, string, string2, string3, font, color, bl, d, n);
        cgview.addOuterLabel(this);
    }

    protected OuterLabel(InnerLabel innerLabel) {
        super(innerLabel.cgview, innerLabel.labelText, innerLabel.hyperlink, innerLabel.mouseover, innerLabel.font, innerLabel.color, innerLabel.forceLabel, innerLabel.lineStartRadians, innerLabel.strand);
        this.cgview.addOuterLabel(this);
    }

    @Override
    protected boolean clashesWithAny() {
        ArrayList arrayList = this.cgview.getOuterLabels();
        if (arrayList.size() < 2) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Label label = (Label)arrayList.get(i);
            if (arrayList.indexOf(this) == i || !this.clashes(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void drawLabelLine() {
        double d;
        double d2;
        double d3 = this.descent;
        double d4 = 0.01;
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d5 = this.unplacedBounds.getHeight();
        double d6 = this.unplacedBounds.getWidth();
        if (this.extendedRadius) {
            d2 = Math.cos(this.lineEndRadians) * this.extendedLineEndRadius;
            d = Math.sin(this.lineEndRadians) * this.extendedLineEndRadius;
        } else {
            d2 = Math.cos(this.lineEndRadians) * this.lineEndRadius;
            d = Math.sin(this.lineEndRadians) * this.lineEndRadius;
        }
        if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d2 -= Math.sin(this.lineEndRadians) * 0.5 * d6;
                d += d5;
            } else {
                d += 0.5 * d5;
            }
        } else if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d2 = d2 - d6 + Math.sin(this.lineEndRadians) * 0.5 * d6;
                d += d5;
            } else {
                d2 -= d6;
                d += 0.5 * d5;
            }
        } else if (Math.sin(this.lineEndRadians) <= 0.0 && Math.sin(this.lineEndRadians) >= -1.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) < -0.9) {
                d2 = d2 - d6 - Math.sin(this.lineEndRadians) * 0.5 * d6;
            } else {
                d2 -= d6;
                d += 0.5 * d5;
            }
        } else if (Math.sin(this.lineEndRadians) < -0.9) {
            d2 += Math.sin(this.lineEndRadians) * 0.5 * d6;
        } else {
            d += 0.5 * d5;
        }
        double d7 = 0.0;
        if (this.cgview.getDrawEntirePlasmid()) {
            d7 = 0.0;
        }
        this.placedBounds.setRect(this.unplacedBounds.getX() + d2 - 1.5 - d7, this.unplacedBounds.getY() + d - (double)this.descent - 1.5 - d7, this.unplacedBounds.getWidth() + 3.0, this.unplacedBounds.getHeight() + 3.0);
        if (this.cgview.getUseColoredLabelBackgrounds()) {
            if (this.extendedRadius) {
                Area area = this.getLineAsArea(this.lineStartRadius, this.lineStartRadians, this.lineEndRadius, this.lineEndRadians);
                this.drawLine(this.lineEndRadius, this.lineEndRadians, this.extendedLineEndRadius + d3, this.lineEndRadians, area);
            } else {
                this.drawLine(this.lineStartRadius, this.lineStartRadians, this.lineEndRadius + d3, this.lineEndRadians);
            }
        } else if (this.extendedRadius) {
            Area area = this.getLineAsArea(this.lineStartRadius, this.lineStartRadians, this.lineEndRadius, this.lineEndRadians);
            double d8 = this.extendedLineEndRadius + d3;
            double d9 = Math.cos(this.lineEndRadians) * d8;
            double d10 = Math.sin(this.lineEndRadians) * d8;
            ((Point2D)double_).setLocation(d9, d10);
            while (this.placedBounds.contains(double_)) {
                d9 = Math.cos(this.lineEndRadians) * (d8 -= d4);
                d10 = Math.sin(this.lineEndRadians) * d8;
                ((Point2D)double_).setLocation(d9, d10);
            }
            this.drawLine(this.lineEndRadius, this.lineEndRadians, d8 -= (double)this.cgview.getLabelLineThickness(), this.lineEndRadians, area);
        } else {
            double d11 = this.lineEndRadius + d3;
            double d12 = Math.cos(this.lineEndRadians) * d11;
            double d13 = Math.sin(this.lineEndRadians) * d11;
            ((Point2D)double_).setLocation(d12, d13);
            while (this.placedBounds.contains(double_)) {
                d12 = Math.cos(this.lineEndRadians) * (d11 -= d4);
                d13 = Math.sin(this.lineEndRadians) * d11;
                ((Point2D)double_).setLocation(d12, d13);
            }
            this.drawLine(this.lineStartRadius, this.lineStartRadians, d11 -= (double)this.cgview.getLabelLineThickness(), this.lineEndRadians);
        }
    }

    @Override
    protected void drawLabelText() {
        double d;
        double d2;
        Graphics2D graphics2D = this.cgview.getGraphics();
        Color color = this.cgview.getBackgroundColor();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.labelText, this.font, fontRenderContext);
        double d3 = this.unplacedBounds.getHeight();
        double d4 = this.unplacedBounds.getWidth();
        if (this.extendedRadius) {
            d2 = Math.cos(this.lineEndRadians) * this.extendedLineEndRadius;
            d = Math.sin(this.lineEndRadians) * this.extendedLineEndRadius;
        } else {
            d2 = Math.cos(this.lineEndRadians) * this.lineEndRadius;
            d = Math.sin(this.lineEndRadians) * this.lineEndRadius;
        }
        if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d2 -= Math.sin(this.lineEndRadians) * 0.5 * d4;
                d += d3;
            } else {
                d += 0.5 * d3;
            }
        } else if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d2 = d2 - d4 + Math.sin(this.lineEndRadians) * 0.5 * d4;
                d += d3;
            } else {
                d2 -= d4;
                d += 0.5 * d3;
            }
        } else if (Math.sin(this.lineEndRadians) <= 0.0 && Math.sin(this.lineEndRadians) >= -1.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) < -0.9) {
                d2 = d2 - d4 - Math.sin(this.lineEndRadians) * 0.5 * d4;
            } else {
                d2 -= d4;
                d += 0.5 * d3;
            }
        } else if (Math.sin(this.lineEndRadians) < -0.9) {
            d2 += Math.sin(this.lineEndRadians) * 0.5 * d4;
        } else {
            d += 0.5 * d3;
        }
        d2 = d2 + (double)(this.cgview.getWidth() / 2) - this.cgview.getCenter().getX();
        d = d + (double)(this.cgview.getHeight() / 2) - this.cgview.getCenter().getY();
        double d5 = 0.0;
        if (this.cgview.getDrawEntirePlasmid()) {
            d5 = 0.0;
        }
        this.placedBounds.setRect(this.unplacedBounds.getX() + d2 - 1.5 - d5, this.unplacedBounds.getY() + d - (double)this.descent - 1.5 - d5, this.unplacedBounds.getWidth() + 3.0, this.unplacedBounds.getHeight() + 3.0);
        if (this.cgview.getUseColoredLabelBackgrounds()) {
            if (this.cgview.getGlobalLabelColor() != null) {
                graphics2D.setPaint(this.cgview.getGlobalLabelColor());
            } else {
                graphics2D.setPaint(this.color);
            }
            graphics2D.fill(this.placedBounds);
            graphics2D.setPaint(color);
            textLayout.draw(graphics2D, (float)d2, (float)d - this.descent);
        } else {
            graphics2D.setPaint(color);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
            graphics2D.fill(this.placedBounds);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.cgview.getGlobalLabelColor() != null) {
                graphics2D.setPaint(this.cgview.getGlobalLabelColor());
            } else {
                graphics2D.setPaint(this.color);
            }
            textLayout.draw(graphics2D, (float)d2, (float)d - this.descent);
        }
    }

    @Override
    protected void updateBounds() {
        this.updateBounds(2.0);
    }

    @Override
    protected void updateBounds(double d) {
        double d2;
        double d3;
        float f = this.cgview.getLabelLineThickness();
        if (this.extendedRadius) {
            d3 = Math.cos(this.lineEndRadians) * (this.extendedLineEndRadius + (double)f);
            d2 = Math.sin(this.lineEndRadians) * (this.extendedLineEndRadius + (double)f);
        } else {
            d3 = Math.cos(this.lineEndRadians) * (this.lineEndRadius + (double)f);
            d2 = Math.sin(this.lineEndRadians) * (this.lineEndRadius + (double)f);
        }
        double d4 = this.unplacedBounds.getHeight();
        double d5 = this.unplacedBounds.getWidth();
        if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d3 -= Math.sin(this.lineEndRadians) * 0.5 * d5;
                d2 += d4;
            } else {
                d2 += 0.5 * d4;
            }
        } else if (Math.sin(this.lineEndRadians) <= 1.0 && Math.sin(this.lineEndRadians) >= 0.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) > 0.9) {
                d3 = d3 - d5 + Math.sin(this.lineEndRadians) * 0.5 * d5;
                d2 += d4;
            } else {
                d3 -= d5;
                d2 += 0.5 * d4;
            }
        } else if (Math.sin(this.lineEndRadians) <= 0.0 && Math.sin(this.lineEndRadians) >= -1.0 && Math.cos(this.lineEndRadians) <= 0.0 && Math.cos(this.lineEndRadians) >= -1.0) {
            if (Math.sin(this.lineEndRadians) < -0.9) {
                d3 = d3 - d5 - Math.sin(this.lineEndRadians) * 0.5 * d5;
            } else {
                d3 -= d5;
                d2 += 0.5 * d4;
            }
        } else if (Math.sin(this.lineEndRadians) < -0.9) {
            d3 += Math.sin(this.lineEndRadians) * 0.5 * d5;
        } else {
            d2 += 0.5 * d4;
        }
        double d6 = 0.0;
        if (this.cgview.getDrawEntirePlasmid()) {
            d6 = 0.0;
        }
        this.placedBounds.setRect(this.unplacedBounds.getX() + d3 - d - d6, this.unplacedBounds.getY() + d2 - (double)this.descent - d - d6, this.unplacedBounds.getWidth() + 2.0 * d, this.unplacedBounds.getHeight() + 2.0 * d);
    }

    @Override
    protected final boolean extendRadius() {
        if (this.extendedRadius) {
            this.extendedLineEndRadius += radiusShiftAmount;
            this.placedBounds.setRect(this.placedBounds.getX() + Math.cos(this.lineEndRadians) * radiusShiftAmount, this.placedBounds.getY() + Math.sin(this.lineEndRadians) * radiusShiftAmount, this.placedBounds.getWidth(), this.placedBounds.getHeight());
            if (this.fitsInBackground()) {
                return true;
            }
            this.extendedLineEndRadius -= radiusShiftAmount;
            return false;
        }
        this.extendedRadius = true;
        this.extendedLineStartRadius = this.lineEndRadius;
        this.extendedLineEndRadius = this.lineEndRadius + radiusShiftAmount;
        this.placedBounds.setRect(this.placedBounds.getX() + Math.cos(this.lineEndRadians) * radiusShiftAmount, this.placedBounds.getY() + Math.sin(this.lineEndRadians) * radiusShiftAmount, this.placedBounds.getWidth(), this.placedBounds.getHeight());
        return true;
    }

    @Override
    protected void setLineStartRadius(double d) {
        this.lineStartRadius = d;
        this.lineEndRadius = d + this.cgview.getLabelLineLength();
        this.updateBounds();
    }

    @Override
    protected boolean fitsInBackground() {
        return this.cgview.getBackgroundRectangle().contains(this.getBounds());
    }
}

