/*
 * Decompiled with CFR 0.152.
 */
package ca.ualberta.stothard.cgview;

import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.FeatureRange;
import ca.ualberta.stothard.cgview.FeatureSlot;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Feature
implements CgviewConstants {
    private String label;
    private String hyperlink;
    private String mouseover;
    private ArrayList ranges = new ArrayList();
    private Color color = new Color(0, 0, 255);
    private int strand;
    private Font font;
    private boolean forceLabel = false;
    private int showLabel = 2;
    private int decoration = 1;
    private float radiusAdjustment = 0.0f;
    private float proportionOfThickness = 1.0f;
    private float opacity = 1.0f;
    private boolean showShading;

    public Feature(FeatureSlot featureSlot, String string) {
        this.label = string;
        this.strand = featureSlot.getStrand();
        this.showShading = featureSlot.getShowShading();
        featureSlot.addFeature(this);
    }

    public Feature(FeatureSlot featureSlot) {
        this.strand = featureSlot.getStrand();
        this.showShading = featureSlot.getShowShading();
        featureSlot.addFeature(this);
    }

    public Feature() {
    }

    public Feature(boolean bl) {
        this.showShading = bl;
    }

    public void setFeatureSlot(FeatureSlot featureSlot) {
        this.strand = featureSlot.getStrand();
        featureSlot.addFeature(this);
    }

    protected void addRange(FeatureRange featureRange) {
        this.ranges.add(featureRange);
    }

    protected ArrayList getRanges() {
        return this.ranges;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setForceLabel(boolean bl) {
        this.forceLabel = bl;
        if (this.forceLabel) {
            this.showLabel = 3;
        }
    }

    public boolean getForceLabel() {
        return this.forceLabel;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setHyperlink(String string) {
        this.hyperlink = string;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setMouseover(String string) {
        this.mouseover = string;
    }

    public String getMouseover() {
        return this.mouseover;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    protected int getStrand() {
        return this.strand;
    }

    public void setShowLabel(int n) {
        this.showLabel = n;
        this.forceLabel = this.showLabel == 3;
    }

    public int getShowLabel() {
        return this.showLabel;
    }

    public void setDecoration(int n) {
        this.decoration = n;
    }

    public int getDecoration() {
        return this.decoration;
    }

    public void setRadiusAdjustment(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.radiusAdjustment = f;
    }

    public float getRadiusAdjustment() {
        return this.radiusAdjustment;
    }

    public void setProportionOfThickness(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.proportionOfThickness = f;
    }

    public float getProportionOfThickness() {
        return this.proportionOfThickness;
    }

    public void setOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.opacity = f;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setShowShading(boolean bl) {
        this.showShading = bl;
    }

    public boolean getShowShading() {
        return this.showShading;
    }

    protected void draw(Cgview cgview, double d, float f, double d2) {
        for (FeatureRange featureRange : this.ranges) {
            featureRange.draw(cgview, d, f, d2);
        }
    }

    protected int getStart() {
        if (this.ranges.size() == 0) {
            return -1;
        }
        SortFeatureRangesByStart sortFeatureRangesByStart = new SortFeatureRangesByStart();
        Collections.sort(this.ranges, sortFeatureRangesByStart);
        FeatureRange featureRange = (FeatureRange)this.ranges.get(0);
        return featureRange.getStart();
    }

    public class SortFeatureRangesByStart
    implements Comparator {
        public int compare(Object object, Object object2) {
            FeatureRange featureRange = (FeatureRange)object;
            FeatureRange featureRange2 = (FeatureRange)object2;
            if (featureRange.getStart() == featureRange2.getStart()) {
                return 0;
            }
            if (featureRange2.getStart() < featureRange.getStart()) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean equals(Object object) {
            return object.equals(this);
        }
    }
}

