/*
 * Decompiled with CFR 0.152.
 */
import ca.ualberta.stothard.cgview.Cgview;
import ca.ualberta.stothard.cgview.CgviewConstants;
import ca.ualberta.stothard.cgview.CgviewFactoryPtt;
import ca.ualberta.stothard.cgview.CgviewFactoryTab;
import ca.ualberta.stothard.cgview.LabelBounds;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CGView
extends JApplet
implements CgviewConstants,
ActionListener {
    private JProgressBar progressBar;
    private BufferedImage biFullView;
    private BufferedImage bi;
    private Graphics2D big;
    private boolean giveLoadingMessage = true;
    private boolean redraw = true;
    private boolean firstZoom = true;
    private final double ROTATION_CONSTANT = 10.0;
    private double[] ZOOM_VALUES = new double[]{1.0, 5.0, 25.0, 125.0, 625.0, 3125.0, 15625.0, 78125.0, 390625.0, 1953125.0, 9765625.0};
    private String TOP_LABEL_MESSAGE = "CGView - Circular Genome Viewer";
    private String LOADING_MAP_DATA_MESSAGE = "Please wait while the feature data is loaded...";
    private String RENDERING_MESSAGE = "Preparing zoomed version of map...";
    private String RENDERING_MESSAGE_AFTER_ZOOM = "Redrawing map...";
    private String FULLY_ZOOMED_MESSAGE = "This is a fully zoomed view.";
    private String TICK_MESSAGE = "Click tick marks to zoom in.";
    private String ABOUT_MESSAGE = "CGView - v1.0 (2004) Paul Stothard http://wishart.biology.ualberta.ca/cgview/";
    private String ZOOM_MINUS_TIP = "Zoom out";
    private String ZOOM_PLUS_TIP = "Zoom in";
    private String FULL_VIEW_TIP = "View entire map";
    private String ROTATE_MINUS_TIP = "Move counterclockwise";
    private String ROTATE_PLUS_TIP = "Move clockwise";
    private String INFO_TIP = "Information";
    private String HELP_TIP = "About";
    private String EXTENSION_MESSAGE = "The input file should end with a '.tab' or '.ptt'";
    private ArrayList fullViewLabelBounds = new ArrayList();
    private ArrayList currentViewLabelBounds = new ArrayList();
    private MapPanel map;
    private JPanel bottomPanel;
    private JLabel topLabel;
    private JTextField bottomLabel;
    private String tempBottomText;
    private JButton zoom_minus;
    private JButton zoom_plus;
    private JButton full_view;
    private JButton rotate_minus;
    private JButton rotate_plus;
    private JButton info;
    private JButton help;
    private Cgview cgview;
    private int zoomCenter = 1;
    private int length = 0;
    private String title = "";
    private int zoomIndex = 0;
    private int zoomCenterStep = 0;
    private int mapWidth = 0;
    private int mapHeight = 0;
    private int mapSmallest = 0;
    private String mapProblem;
    private NumberFormat nf = NumberFormat.getInstance();
    private int MAX_MOUSEOVER_LENGTH = 100;
    private int MAX_TITLE_LENGTH = 50;
    private int MAX_SEQUENCE_LENGTH = 20000000;
    private int MAXLABELS = 1000;
    private float zoomedFeatureSlotSpacing = 4.0f;
    private double zoomedLabelLineLength = 50.0;

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CGView.this.createGUI();
                }
            });
        }
        catch (Exception exception) {
            System.err.println("The GUI did not successfully complete");
        }
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                while (CGView.this.mapWidth == 0 || CGView.this.mapHeight == 0 || CGView.this.mapSmallest == 0) {
                    Dimension dimension = CGView.this.map.getSize();
                    CGView.this.mapWidth = dimension.width;
                    CGView.this.mapHeight = dimension.height;
                    CGView.this.mapSmallest = Math.min(CGView.this.mapWidth, CGView.this.mapHeight);
                }
                CGView.this.buildCgview();
                if (CGView.this.mapProblem == null) {
                    CGView.this.adjustZoomValues();
                    CGView.this.drawFullMap();
                } else {
                    CGView.this.TICK_MESSAGE = CGView.this.mapProblem;
                }
                return new Integer(1);
            }

            @Override
            public void finished() {
                CGView.this.giveLoadingMessage = false;
                CGView.this.map.renderMap();
                CGView.this.progressBar.setIndeterminate(false);
                CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                if (CGView.this.mapProblem == null) {
                    CGView.this.setFullViewButtons();
                } else {
                    CGView.this.setAllButtonsOff();
                }
                CGView.this.setCursor(Cursor.getPredefinedCursor(0));
                CGView.this.redraw = false;
            }
        };
        swingWorker.start();
    }

    public void createGUI() {
        Serializable serializable;
        Serializable serializable2;
        Font font = this.getFont().deriveFont(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        this.topLabel = new JLabel();
        this.topLabel.setText(this.TOP_LABEL_MESSAGE);
        this.topLabel.setFont(font);
        this.topLabel.setHorizontalAlignment(0);
        gridBagLayout.setConstraints(this.topLabel, gridBagConstraints);
        this.getContentPane().add(this.topLabel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        try {
            serializable2 = this.getClass().getResource("ZoomOut24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.zoom_minus = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.zoom_minus = new JButton("Zoom -");
        }
        this.zoom_minus.setToolTipText(this.ZOOM_MINUS_TIP);
        this.zoom_minus.addActionListener(this);
        this.zoom_minus.setFont(font);
        gridBagLayout.setConstraints(this.zoom_minus, gridBagConstraints2);
        this.getContentPane().add(this.zoom_minus);
        try {
            serializable2 = this.getClass().getResource("ZoomIn24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.zoom_plus = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.zoom_plus = new JButton("Zoom +");
        }
        gridBagConstraints2.gridx = 1;
        this.zoom_plus.setToolTipText(this.ZOOM_PLUS_TIP);
        this.zoom_plus.addActionListener(this);
        this.zoom_plus.setFont(font);
        gridBagLayout.setConstraints(this.zoom_plus, gridBagConstraints2);
        this.getContentPane().add(this.zoom_plus);
        try {
            serializable2 = this.getClass().getResource("Home24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.full_view = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.full_view = new JButton("Full view");
        }
        gridBagConstraints2.gridx = 2;
        this.full_view.setToolTipText(this.FULL_VIEW_TIP);
        this.full_view.addActionListener(this);
        this.full_view.setFont(font);
        gridBagLayout.setConstraints(this.full_view, gridBagConstraints2);
        this.getContentPane().add(this.full_view);
        try {
            serializable2 = this.getClass().getResource("Counter24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.rotate_minus = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.rotate_minus = new JButton("Rotate -");
        }
        gridBagConstraints2.gridx = 3;
        this.rotate_minus.setToolTipText(this.ROTATE_MINUS_TIP);
        this.rotate_minus.addActionListener(this);
        this.rotate_minus.setFont(font);
        gridBagLayout.setConstraints(this.rotate_minus, gridBagConstraints2);
        this.getContentPane().add(this.rotate_minus);
        try {
            serializable2 = this.getClass().getResource("Clock24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.rotate_plus = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.rotate_plus = new JButton("Rotate +");
        }
        gridBagConstraints2.gridx = 4;
        this.rotate_plus.setToolTipText(this.ROTATE_PLUS_TIP);
        this.rotate_plus.addActionListener(this);
        this.rotate_plus.setFont(font);
        gridBagLayout.setConstraints(this.rotate_plus, gridBagConstraints2);
        this.getContentPane().add(this.rotate_plus);
        try {
            serializable2 = this.getClass().getResource("Information24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.info = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.info = new JButton("Information");
        }
        gridBagConstraints2.gridx = 5;
        this.info.setToolTipText(this.INFO_TIP);
        this.info.addActionListener(this);
        this.info.setFont(font);
        this.info.setEnabled(true);
        gridBagLayout.setConstraints(this.info, gridBagConstraints2);
        this.getContentPane().add(this.info);
        try {
            serializable2 = this.getClass().getResource("Help24.gif");
            serializable = new ImageIcon((URL)serializable2);
            this.help = new JButton((Icon)((Object)serializable));
        }
        catch (Exception exception) {
            this.help = new JButton("Help");
        }
        gridBagConstraints2.gridx = 6;
        this.help.setToolTipText(this.HELP_TIP);
        this.help.addActionListener(this);
        this.help.setFont(font);
        this.help.setEnabled(true);
        gridBagLayout.setConstraints(this.help, gridBagConstraints2);
        this.getContentPane().add(this.help);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 2;
        ((GridBagConstraints)serializable2).gridwidth = 7;
        ((GridBagConstraints)serializable2).gridheight = 1;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 1.0;
        ((GridBagConstraints)serializable2).fill = 1;
        this.map = new MapPanel();
        gridBagLayout.setConstraints(this.map, (GridBagConstraints)serializable2);
        this.map.setBackground(Color.white);
        this.getContentPane().add(this.map);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 3;
        ((GridBagConstraints)serializable).gridwidth = 7;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).fill = 1;
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        gridBagLayout.setConstraints(this.bottomPanel, (GridBagConstraints)serializable);
        this.getContentPane().add(this.bottomPanel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.bottomPanel.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.ipady = 0;
        this.bottomLabel = new JTextField();
        this.bottomLabel.setColumns(1);
        this.bottomLabel.setText(this.LOADING_MAP_DATA_MESSAGE);
        this.bottomLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.bottomLabel.setEditable(false);
        this.bottomLabel.setHorizontalAlignment(2);
        this.bottomLabel.setFont(font);
        gridBagLayout2.setConstraints(this.bottomLabel, gridBagConstraints3);
        this.bottomPanel.add(this.bottomLabel);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.ipady = 0;
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBorderPainted(false);
        gridBagLayout2.setConstraints(this.progressBar, gridBagConstraints3);
        this.bottomPanel.add(this.progressBar);
        this.bottomLabel.setBackground(this.progressBar.getBackground());
        this.validate();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setFullViewButtons() {
        this.zoom_minus.setEnabled(false);
        this.zoom_plus.setEnabled(true);
        this.full_view.setEnabled(false);
        this.rotate_minus.setEnabled(false);
        this.rotate_plus.setEnabled(false);
    }

    public void setZoomedInButtons() {
        this.zoom_minus.setEnabled(true);
        this.zoom_plus.setEnabled(true);
        this.full_view.setEnabled(true);
        this.rotate_minus.setEnabled(true);
        this.rotate_plus.setEnabled(true);
    }

    public void setFullyZoomedInButtons() {
        this.zoom_minus.setEnabled(true);
        this.zoom_plus.setEnabled(false);
        this.full_view.setEnabled(true);
        this.rotate_minus.setEnabled(true);
        this.rotate_plus.setEnabled(true);
    }

    public void setAllButtonsOff() {
        this.zoom_minus.setEnabled(false);
        this.zoom_plus.setEnabled(false);
        this.full_view.setEnabled(false);
        this.rotate_minus.setEnabled(false);
        this.rotate_plus.setEnabled(false);
        this.info.setEnabled(false);
        this.help.setEnabled(false);
    }

    public void setRenderQuality(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void updateMessage(String string) {
        this.bottomLabel.setText(string);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void buildCgview() {
        this.buildCgview(false);
    }

    public void buildCgview(boolean bl) {
        String string = null;
        String string2 = null;
        URL uRL = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            string = this.getParameter("file");
            bl2 = true;
            if (string.length() >= 3) {
                string2 = string.substring(string.length() - 3);
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            try {
                uRL = new URL(this.getDocumentBase(), string);
            }
            catch (Exception exception) {
                this.mapProblem = exception.toString();
            }
        }
        if (!bl2) {
            string = "test_input.ptt";
            if (string.length() >= 3) {
                string2 = string.substring(string.length() - 3);
            }
            try {
                uRL = this.getClass().getResource(string);
            }
            catch (Exception exception) {
                this.mapProblem = "Unable to load feature data file.";
            }
        }
        try {
            String string3 = this.getParameter("hideLegend");
            if (string3 != null && (string3.equalsIgnoreCase("t") || string3.equalsIgnoreCase("true"))) {
                bl3 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string4 = this.getParameter("hideFullViewLabels");
            if (string4 != null && (string4.equalsIgnoreCase("t") || string4.equalsIgnoreCase("true"))) {
                bl4 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string5 = this.getParameter("rulerFontSize");
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string6 = this.getParameter("labelFontSize");
            if (string6 != null) {
                n2 = Integer.parseInt(string6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string7 = this.getParameter("legendFontSize");
            if (string7 != null) {
                n3 = Integer.parseInt(string7);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mapProblem == null) {
            CgviewConstants cgviewConstants;
            if (string2.equalsIgnoreCase("tab")) {
                try {
                    cgviewConstants = new CgviewFactoryTab();
                    ((CgviewFactoryTab)cgviewConstants).setReadDimension(false);
                    ((CgviewFactoryTab)cgviewConstants).setWidth(this.mapWidth);
                    ((CgviewFactoryTab)cgviewConstants).setHeight(this.mapHeight);
                    if (n > 0) {
                        ((CgviewFactoryTab)cgviewConstants).setRulerFontSize(n);
                    }
                    if (n2 > 0) {
                        ((CgviewFactoryTab)cgviewConstants).setLabelFontSize(n2);
                    }
                    if (n3 > 0) {
                        ((CgviewFactoryTab)cgviewConstants).setLegendFontSize(n3);
                    }
                    if (bl) {
                        ((CgviewFactoryTab)cgviewConstants).setMapItemSizeAdjustment(0.5f);
                    }
                    this.cgview = ((CgviewFactoryTab)cgviewConstants).createCgviewFromURL(uRL);
                    this.cgview.setLabelPlacementQuality(5);
                    this.cgview.setLabelsToKeep(this.MAXLABELS);
                    this.cgview.setMoveInnerLabelsToOuter(false);
                    this.cgview.setUseInnerLabels(3);
                    if (!bl) {
                        this.cgview.setLabelLineLength(20.0);
                    } else {
                        if (n <= 0) {
                            this.cgview.setRulerFont(new Font("SansSerif", 0, 8));
                        }
                        this.cgview.setTickLength(6.0f);
                        this.cgview.setLabelLineLength(this.zoomedLabelLineLength);
                    }
                    this.length = this.cgview.getSequenceLength();
                    this.title = this.cgview.getTitle();
                    this.cgview.setShowBorder(false);
                    if (bl4) {
                        this.cgview.setGlobalLabel(4);
                    }
                    if (bl3) {
                        this.cgview.setDrawLegends(false);
                    }
                }
                catch (Exception exception) {
                    this.mapProblem = exception.toString();
                }
            } else if (string2.equalsIgnoreCase("ptt")) {
                try {
                    cgviewConstants = new CgviewFactoryPtt();
                    ((CgviewFactoryPtt)cgviewConstants).setReadDimension(false);
                    ((CgviewFactoryPtt)cgviewConstants).setWidth(this.mapWidth);
                    ((CgviewFactoryPtt)cgviewConstants).setHeight(this.mapHeight);
                    if (n > 0) {
                        ((CgviewFactoryPtt)cgviewConstants).setRulerFontSize(n);
                    }
                    if (n2 > 0) {
                        ((CgviewFactoryPtt)cgviewConstants).setLabelFontSize(n2);
                    }
                    if (n3 > 0) {
                        ((CgviewFactoryPtt)cgviewConstants).setLegendFontSize(n3);
                    }
                    if (bl) {
                        ((CgviewFactoryPtt)cgviewConstants).setMapItemSizeAdjustment(0.5f);
                    }
                    this.cgview = ((CgviewFactoryPtt)cgviewConstants).createCgviewFromURL(uRL);
                    this.cgview.setLabelPlacementQuality(5);
                    this.cgview.setLabelsToKeep(this.MAXLABELS);
                    this.cgview.setMoveInnerLabelsToOuter(false);
                    this.cgview.setUseInnerLabels(3);
                    if (!bl) {
                        this.cgview.setLabelLineLength(20.0);
                    } else {
                        if (n <= 0) {
                            this.cgview.setRulerFont(new Font("SansSerif", 0, 8));
                        }
                        this.cgview.setTickLength(6.0f);
                        this.cgview.setLabelLineLength(this.zoomedLabelLineLength);
                    }
                    this.length = this.cgview.getSequenceLength();
                    this.title = this.cgview.getTitle();
                    this.cgview.setShowBorder(false);
                    if (bl4) {
                        this.cgview.setGlobalLabel(4);
                    }
                    if (bl3) {
                        this.cgview.setDrawLegends(false);
                    }
                }
                catch (Exception exception) {
                    this.mapProblem = exception.toString();
                }
            } else {
                this.mapProblem = this.EXTENSION_MESSAGE;
            }
        }
    }

    public void adjustZoomValues() {
        int n = 0;
        double d = this.cgview.getZoomMax();
        for (int i = 0; i < this.ZOOM_VALUES.length; ++i) {
            if (!(this.ZOOM_VALUES[i] <= d)) continue;
            ++n;
        }
        double[] dArray = new double[n++];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.ZOOM_VALUES[i];
        }
        this.ZOOM_VALUES = dArray;
    }

    public void drawFullMap() {
        this.biFullView = new BufferedImage(this.mapWidth, this.mapHeight, 1);
        this.big = this.biFullView.createGraphics();
        this.cgview.draw(this.big);
        this.fullViewLabelBounds.clear();
        ArrayList arrayList = this.cgview.getLabelBounds();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelBounds labelBounds = (LabelBounds)arrayList.get(i);
            BoundsInfo boundsInfo = new BoundsInfo(labelBounds.getBounds(), labelBounds.getBase(), labelBounds.getType(), labelBounds.getMouseover(), labelBounds.getHyperlink());
            this.fullViewLabelBounds.add(boundsInfo);
        }
        this.cgview.setFeatureSlotSpacing(this.zoomedFeatureSlotSpacing);
        this.cgview.setLabelLineLength(this.zoomedLabelLineLength);
    }

    public void drawPartialMap() {
        if (this.firstZoom) {
            this.cgview = null;
            this.buildCgview(true);
            if (this.mapProblem == null) {
                this.firstZoom = false;
                this.RENDERING_MESSAGE = this.RENDERING_MESSAGE_AFTER_ZOOM;
            } else {
                this.TICK_MESSAGE = "Zoomed map preparation failed: " + this.mapProblem;
            }
        }
        if (this.mapProblem == null) {
            if (this.bi == null) {
                this.bi = new BufferedImage(this.mapWidth, this.mapHeight, 1);
            }
            this.big = this.bi.createGraphics();
            this.cgview.drawZoomed(this.big, this.ZOOM_VALUES[this.zoomIndex], this.zoomCenter);
            this.currentViewLabelBounds.clear();
            ArrayList arrayList = this.cgview.getLabelBounds();
            for (int i = 0; i < arrayList.size(); ++i) {
                LabelBounds labelBounds = (LabelBounds)arrayList.get(i);
                BoundsInfo boundsInfo = new BoundsInfo(labelBounds.getBounds(), labelBounds.getBase(), labelBounds.getType(), labelBounds.getMouseover(), labelBounds.getHyperlink());
                this.currentViewLabelBounds.add(boundsInfo);
            }
            this.zoomCenterStep = (int)Math.floor((double)this.length / (this.ZOOM_VALUES[this.zoomIndex] * 10.0) + 0.5);
            if (this.zoomCenterStep < 1) {
                this.zoomCenterStep = 1;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.zoom_minus && !this.redraw) {
            if (this.zoomIndex > 0) {
                this.redraw = true;
                --this.zoomIndex;
                if (this.zoomIndex == 0) {
                    this.setFullViewButtons();
                    this.zoomCenter = 1;
                } else {
                    this.setZoomedInButtons();
                }
                this.bottomLabel.setText(this.RENDERING_MESSAGE);
                this.progressBar.setIndeterminate(true);
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        if (CGView.this.zoomIndex != 0) {
                            CGView.this.drawPartialMap();
                        }
                        return new Integer(1);
                    }

                    @Override
                    public void finished() {
                        CGView.this.map.renderMap();
                        CGView.this.progressBar.setIndeterminate(false);
                        CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                        CGView.this.redraw = false;
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() == this.zoom_plus && !this.redraw) {
            if (this.zoomIndex < this.ZOOM_VALUES.length - 1) {
                this.redraw = true;
                ++this.zoomIndex;
                if (this.zoomIndex == this.ZOOM_VALUES.length - 1) {
                    this.setFullyZoomedInButtons();
                } else {
                    this.setZoomedInButtons();
                }
                this.bottomLabel.setText(this.RENDERING_MESSAGE);
                this.progressBar.setIndeterminate(true);
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        CGView.this.drawPartialMap();
                        return new Integer(1);
                    }

                    @Override
                    public void finished() {
                        CGView.this.map.renderMap();
                        CGView.this.progressBar.setIndeterminate(false);
                        if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                            CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                        } else {
                            CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                        }
                        CGView.this.redraw = false;
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() == this.full_view && !this.redraw) {
            if (this.zoomIndex != 0 || this.zoomCenter != 1) {
                this.redraw = true;
                this.zoomIndex = 0;
                this.zoomCenter = 1;
                this.setFullViewButtons();
                this.redraw = true;
                this.bottomLabel.setText(this.RENDERING_MESSAGE);
                this.progressBar.setIndeterminate(true);
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        return new Integer(1);
                    }

                    @Override
                    public void finished() {
                        CGView.this.map.renderMap();
                        CGView.this.progressBar.setIndeterminate(false);
                        CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                        CGView.this.redraw = false;
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() == this.rotate_minus && !this.redraw) {
            if (this.zoomIndex > 0) {
                this.redraw = true;
                this.zoomCenter -= this.zoomCenterStep;
                if (this.zoomCenter < 0) {
                    this.zoomCenter = this.length + this.zoomCenter;
                } else if (this.zoomCenter > this.length) {
                    this.zoomCenter = 1 + (this.zoomCenter - this.length);
                }
                this.bottomLabel.setText(this.RENDERING_MESSAGE);
                this.progressBar.setIndeterminate(true);
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        CGView.this.drawPartialMap();
                        return new Integer(1);
                    }

                    @Override
                    public void finished() {
                        CGView.this.map.renderMap();
                        CGView.this.progressBar.setIndeterminate(false);
                        if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                            CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                        } else {
                            CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                        }
                        CGView.this.redraw = false;
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() == this.rotate_plus && !this.redraw) {
            if (this.zoomIndex > 0) {
                this.redraw = true;
                this.zoomCenter += this.zoomCenterStep;
                if (this.zoomCenter < 0) {
                    this.zoomCenter = this.length + this.zoomCenter;
                } else if (this.zoomCenter > this.length) {
                    this.zoomCenter = 1 + (this.zoomCenter - this.length);
                }
                this.bottomLabel.setText(this.RENDERING_MESSAGE);
                this.progressBar.setIndeterminate(true);
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        CGView.this.drawPartialMap();
                        return new Integer(1);
                    }

                    @Override
                    public void finished() {
                        CGView.this.map.renderMap();
                        CGView.this.progressBar.setIndeterminate(false);
                        if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                            CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                        } else {
                            CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                        }
                        CGView.this.redraw = false;
                    }
                };
                swingWorker.start();
            }
        } else if (actionEvent.getSource() == this.info && !this.redraw) {
            this.redraw = true;
            this.tempBottomText = "Current zoom: " + this.nf.format((long)this.ZOOM_VALUES[this.zoomIndex]) + "; centered on base: " + this.nf.format(this.zoomCenter) + ".";
            if (this.tempBottomText.length() > this.MAX_MOUSEOVER_LENGTH) {
                this.tempBottomText = this.tempBottomText.substring(0, this.MAX_MOUSEOVER_LENGTH) + "...";
            }
            this.bottomLabel.setText(this.tempBottomText);
            this.redraw = false;
        } else if (actionEvent.getSource() == this.help && !this.redraw) {
            this.redraw = true;
            this.tempBottomText = this.ABOUT_MESSAGE;
            if (this.tempBottomText.length() > this.MAX_MOUSEOVER_LENGTH) {
                this.tempBottomText = this.tempBottomText.substring(0, this.MAX_MOUSEOVER_LENGTH) + "...";
            }
            this.bottomLabel.setText(this.tempBottomText);
            this.redraw = false;
        }
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"file", "URL", "the feature data file"}};
        return stringArray;
    }

    @Override
    public String getAppletInfo() {
        return "CGView by Paul Stothard";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("CGView - Circular Genome Viewer");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        CGView cGView = new CGView();
        jFrame.getContentPane().add("Center", cGView);
        ((Applet)cGView).init();
        jFrame.setSize(900, 920);
        jFrame.show();
    }

    private class MapPanel
    extends JPanel {
        int width;
        int height;

        public MapPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (CGView.this.zoomIndex < CGView.this.ZOOM_VALUES.length - 1 && !CGView.this.redraw) {
                        ArrayList arrayList = CGView.this.zoomIndex == 0 ? CGView.this.fullViewLabelBounds : CGView.this.currentViewLabelBounds;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            BoundsInfo boundsInfo = (BoundsInfo)arrayList.get(i);
                            if (!boundsInfo.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                            if (boundsInfo.getType() == 1) {
                                CGView.this.redraw = true;
                                CGView.this.zoomIndex++;
                                CGView.this.zoomCenter = boundsInfo.getBase();
                                if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                                    CGView.this.setFullyZoomedInButtons();
                                } else {
                                    CGView.this.setZoomedInButtons();
                                }
                                CGView.this.bottomLabel.setText(CGView.this.RENDERING_MESSAGE);
                                CGView.this.progressBar.setIndeterminate(true);
                                SwingWorker swingWorker = new SwingWorker(){

                                    @Override
                                    public Object construct() {
                                        CGView.this.drawPartialMap();
                                        return new Integer(1);
                                    }

                                    @Override
                                    public void finished() {
                                        CGView.this.map.renderMap();
                                        CGView.this.progressBar.setIndeterminate(false);
                                        if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                                            CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                                        } else {
                                            CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                                        }
                                        CGView.this.redraw = false;
                                    }
                                };
                                swingWorker.start();
                                break;
                            }
                            if (boundsInfo.getType() != 2 || boundsInfo.getHyperlink() == null) break;
                            try {
                                CGView.this.getAppletContext().showDocument(new URL(boundsInfo.getHyperlink()), "_CGViewLink");
                            }
                            catch (MalformedURLException malformedURLException) {
                                CGView.this.bottomLabel.setText("URL is not properly formed.");
                            }
                            catch (NullPointerException nullPointerException) {
                                CGView.this.bottomLabel.setText("Cannot obtain applet context.");
                            }
                            break;
                        }
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (!CGView.this.redraw) {
                        boolean bl = false;
                        ArrayList arrayList = CGView.this.zoomIndex == 0 ? CGView.this.fullViewLabelBounds : CGView.this.currentViewLabelBounds;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            BoundsInfo boundsInfo = (BoundsInfo)arrayList.get(i);
                            if (!boundsInfo.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                            bl = true;
                            if (boundsInfo.getType() == 1) {
                                if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                                    CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                                    break;
                                }
                                MapPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                                CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                                break;
                            }
                            if (boundsInfo.getType() != 2) break;
                            if (boundsInfo.getText() != null) {
                                CGView.this.bottomLabel.setText(boundsInfo.getText());
                            }
                            if (boundsInfo.getHyperlink() == null) break;
                            MapPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                            break;
                        }
                        if (!bl) {
                            MapPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                            if (CGView.this.zoomIndex == CGView.this.ZOOM_VALUES.length - 1) {
                                CGView.this.bottomLabel.setText(CGView.this.FULLY_ZOOMED_MESSAGE);
                            } else {
                                CGView.this.bottomLabel.setText(CGView.this.TICK_MESSAGE);
                            }
                        }
                    }
                }
            });
        }

        public void renderMap() {
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (CGView.this.giveLoadingMessage) {
                Dimension dimension = this.getSize();
                CGView.this.mapWidth = dimension.width;
                CGView.this.mapHeight = dimension.height;
                CGView.this.mapSmallest = Math.min(CGView.this.mapWidth, CGView.this.mapHeight);
            } else if (CGView.this.zoomCenter == 1 && CGView.this.zoomIndex == 0 && CGView.this.mapProblem == null) {
                graphics2D.drawImage((Image)CGView.this.biFullView, 0, 0, this);
            } else if (CGView.this.mapProblem == null) {
                if (CGView.this.bi != null) {
                    graphics2D.drawImage((Image)CGView.this.bi, 0, 0, this);
                } else if (CGView.this.biFullView != null) {
                    graphics2D.drawImage((Image)CGView.this.biFullView, 0, 0, this);
                }
            }
        }
    }

    private class BoundsInfo {
        Rectangle2D bounds;
        int base;
        int type;
        String text;
        String hyperlink;

        public BoundsInfo(Rectangle2D rectangle2D, int n, int n2, String string, String string2) {
            this.bounds = rectangle2D;
            this.base = n;
            this.type = n2;
            this.text = string;
            this.hyperlink = string2;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public int getBase() {
            return this.base;
        }

        public int getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public String getHyperlink() {
            return this.hyperlink;
        }
    }
}

