function out = Gcdf(t, link)
if (strcmp(link, 'logistic'))
    sigma = pi/sqrt(3);
    t = t*sigma;
    out = 1./(1+exp(-t));
elseif (strcmp(link, 'probit'))
    sigma = 1;
    t = t*sigma;
    out = normcdf(t);
elseif (strcmp(link, 'cloglog'))
    sigma = pi/sqrt(6);
    t = t*sigma;
    out = 1-exp(-exp(t));
end
out = max(1e-6, min(out, 1-1e-6));