
function out = menarcheconfint(theta, xi, F, dw, dg, dr, n, alpha, q)

% output is a 6 by 4 matrix with columns I(smoke), covariate, x0hat, halfwidth
f1 = F(:,[2,3,4])'; % 3 x N
f2 = f1([1,3],:); % 2 x N
T = [1./(theta(1) + theta([5,6])'*f2); ...
    f1./(q - theta([2,3,4])'*f1); f2./(theta(1) + theta([5,6])'*f2)]; % d by N
M = F'*(xi.*dw.*dg.*dr.*F);
V = F'*(xi.*dw.*dw.*dg.*dr.*F);
Minv = M\eye(size(M));
thetaVAR = Minv*V*Minv';

VAR = diag(T'*thetaVAR*T); % N by 1
x0hat = (q - theta([2,3,4])'*f1)./(theta(1) + theta([5,6])'*f2);
x0hat = x0hat';  % N x 1
halfwidths = norminv(1 - alpha/2)*sqrt(VAR/n).*abs(x0hat);

qwe = [F x0hat halfwidths];
out = qwe(1:6,[2 4 7 8]);

