function [diagT, pixi, check, loss0, loss1, loss2, lossall] = ...
    menarchecomps(xi, da, dw, db, Q1, Q2, nu1, nu2)

A = Q1'*(xi.*da.*Q1);
A = (A + A')/2;
if rcond(A) < 1e-10
    rcond(A)
    %pause
    A = A + (1e-6)*eye(size(A));
end

Ainv = A\eye(size(A));

B = Q1'*(xi.*dw.*da.*Q1);
B = (B + B')/2;

Rinv = Ainv*B*Ainv'; %(A\B)/A';
mat = Ainv*Q1'; % (Q1*Ainv)'
trRinv = trace(Rinv); %sum(eig(Rinv)) %trace(Rinv);
loss0 = trRinv;
T0 = 2*da.*mat'*(Rinv*Q1') - (da.*dw).*(mat'*mat);

mat1 = (xi.*da).*(mat');
U = mat1'*mat1;
[z, lambda] = eigs(U,1);
lambda = lambda - 1;
c = Ainv*z;
C = 2*(c*c');
loss1 = lambda;
T1 = (da.*Q1)*U*A*C*Q1'-(da.^2).*xi.*(Q1*C*Q1');

SS = Q1'*(xi.*da.*Q2); % = S in paper
mat2 = Ainv*SS;
loss2 = norm(mat2*db)^2;
T2 = 2*(da.*(mat'*SS-Q2)*(db*db')*(mat2)'*mat);

check = trace(xi.*(T1+T2));
%check0 = trace(xi.*(T0))-trRinv
%check1 =  trace(xi.*(T1))
%check2 =  trace(xi.*(T2))
%pause
%nu2 = min(nu2, n*(1-nu1)/(n+4)); % ensures gamma < .5
diagT = diag((1-nu1-nu2)*T0 + nu1*T1 + nu2*T2);
pixi = (max(diagT)/((1-nu1-nu2)*trRinv)) - 1; 

lossall = (1-nu1-nu2)*loss0 + nu1*loss1 + nu2*loss2; 


