function out = gpdf(t, link)
if (strcmp(link, 'logistic'))
    sigma = pi/sqrt(3);
    t = t*sigma;
    out = pdf('logistic', t);
    out = out*sigma;
elseif (strcmp(link, 'probit'))
    sigma = 1;
    t = t*sigma;
    out = normpdf(t);
    out = out*sigma;
elseif (strcmp(link, 'cloglog'))
    sigma = pi/sqrt(6);
    t = t*sigma;
    out = exp(t).*(1-Gcdf(t, link));
    out = out*sigma;
end
out = max(out, 1e-6);