function [theta0, psi0, beta0] = ...
    thetazero(n, xi, tau1, gam, thetagam, F, Q1, Q2, R, link)
G = @(t) Gcdf(t, link);
Ginv = @(u) Ginvcdf(u, link);
g = @(t) gpdf(t, link);
r = @(t) rodds(t, link);
%w = @(t) weights(t, sx, wts, link);
a = @(t) g(t).*r(t); % alpha

theta0 = thetagam;
change = 1;
step = 0;
while change > .01 && step < 20
    beta0 = F*theta0;
    a0 = a(beta0);
    % Compute psi0:
    C = (Q2'*(a0.*xi.*Q1))/(Q1'*(a0.*xi.*Q1));
    [U1,~,~] = svd(C, 'econ');
    c = U1(:,1);
    psi0 = (tau1/sqrt(n))*(Q2*c);
    % Compute theta0:
    betastar = F*thetagam + psi0;
    thetanew = R\Q1'*Ginv((1-2*gam)*G(betastar) + gam);
    change = norm(thetanew - theta0);
    disp(['Change in theta0 = ', num2str(change)]);
    theta0 = thetanew;
    step = step + 1;
end
%[theta0 thetagam]
%checks:
%checks = [(norm(C'*c))^2 - eigs(C'*C,1), norm(F'*psi0),...
%    psi0'*psi0 - tau1^2/n];
%disp(checks);  % =0?
%pause


