function [xi, THETAS, nfinal, maxlossfinal, measures, failrate, thetafinal, keepgoing] = ...
    dose_sequential(xi, y, F, theta, betastar, j, k, THETAS, nu1, nu2, gam, N, n, ...
    ninit, nmax, Q1, Q2, pistar, adaptive, sx, wts, link, options, robustdesign, runtoconvergence)

 
g = @(t) gpdf(t, link);
G = @(t) Gcdf(t, link);
r = @(t) rodds(t, link);
w = @(t) weights(t, sx, wts, link);
a = @(t) w(t).*g(t).*r(t); % alpha

beta = F*theta;
da = a(beta);
dw = w(beta);
dh = (2*G(beta)-1)./g(beta);
db = Q2'*dh;

pixi = 1;
n0 = n;
I = 1:N;
failures = 0;
attempts = 0;
measures = zeros(10000,3);
failrate = 0;
keepgoing = 1;
   
while ((~(runtoconvergence) && n <= nmax)|| ...
        ((runtoconvergence) && pixi > pistar && n < 5*nmax)) && (keepgoing)
    
    [diagT, pixi, ~, ~, ~, lossall] = comps(n, xi, da, dw, db, Q1, Q2, nu1, nu2);

    if (robustdesign)
        istar = I(diagT == max(diagT));
    else
        istar = randi(N,1);
    end
    
    %update xi:
    numxi = n*xi; % number of allocations n(i)
    %update y and theta:
    if (adaptive) %Observe Y at X(istar,:) and the 'true' thetas
        numy = numxi.*y;
        Ytrue = binornd(1, G(betastar(istar)));
        Yreturned = binornd(1,(1-2*gam)*Ytrue + gam);
        numy(istar) = numy(istar) + Yreturned;
        numxi(istar) = numxi(istar) + 1;
        y(numxi>0) = numy(numxi>0)./numxi(numxi>0);
        xi = numxi/(n+1);
        thetastart = theta;
        attempts = 0;
        exitflag = 0;
        S = @(theta) F'*(xi.*r(F*theta).*w(F*theta).*(y-G(F*theta)));
        while exitflag <= 0 && attempts <= 10
            [theta, ~, exitflag, ~] = ...
                fsolve(S, thetastart + (attempts/10)*randn(size(theta)), options);                
            attempts = attempts + 1;
        end
        if attempts == 11
            failures = failures + 1;
            theta = thetastart;
        end
        THETAS(n-n0+1,:,j,k) = theta;
        beta = F*theta;
        da = a(beta);
        dw = w(beta);
        dh = (2*G(beta)-1)./g(beta);
        db = Q2'*dh;
    else
	numxi(istar) = numxi(istar) + 1;
	xi = numxi/(n+1);
    end
    n = n+1;
    nr = n-n0;
    failrate = failures/(n-n0);
    measures(n-n0,:) = [n-1, pixi, lossall];
    disp(['run = ', num2str(k), ' nu1 = ', num2str(nu1), ' nu2 = ', ...
        num2str(nu2),' n = ', num2str(n-1), ' pi(xi) = ', num2str(pixi), ...
        ' attempts = ', num2str(attempts), ' failrate = ', num2str(failrate)]); 
    if (n > 3*ninit && failrate > .5)
        keepgoing = 0;        
        disp(['reset at j = ', num2str(j), ' due to too many failures'])
        pause(5)
    end   
	%[thetagam theta0 theta]
    %pause
end
thetafinal = theta;
measures = measures(2:nr,:);
nfinal = n-1;
maxlossfinal = lossall;
