function [theta0, psi0, gam, betastar, beta0] = ...
    thetazero(n, psi, tau1, tau2, thetagam, F, link)
%computes theta0 for varying n
G = @(t) Gcdf(t, link);
Ginv = @(u) Ginvcdf(u, link);
gam = min(.5, tau2/sqrt(n));
psi0 = (tau1/sqrt(n))*psi;
betastar = F*thetagam + psi0;
P1 = (1-gam)*G(betastar) + gam*(1-G(betastar));
theta0 = F\Ginv(P1);
beta0 = F*theta0;
