function [XI, meanXIsplit, THETA0s, THETAS, MEANCOVERAGE, x0] =...
    menarche(nruns, ninit, nfinal, link, wts, tau1, tau2)

% [XI,  meanXIsplit, THETA0s, THETAS, MEANCOVERAGE, x0] = menarche(50, 40, 200, 'probit', 'hat', 15, 1);

% ninit = 40, nfinal = 200 works well too

%clear all;nruns=2;ninit=40;nfinal=100;link='logistic';wts='constant';tau1=15;tau2=1;
close all
robustdesign = 1;
rng(13) %for reproducibility; use (1) if (13) doesn't work
options = optimoptions(@fsolve, 'Display', 'none', 'Algorithm', 'trust-region');

Ginv = @(u) Ginvcdf(u, link);
g = @(t) gpdf(t, link);
G = @(t) Gcdf(t, link);
r = @(t) rodds(t, link);

N = 144;
d = 6;
q = Ginv(.5);
alpha = .10;

NU = [.10 .10; .25 .25; .45 .45; .9 0; 0 .9]; %[nu1 nu2]
%NU = [.9 0; .8 .1; .5 .2; 0 0];
%NU = [.45 .45];
J = size(NU,1);
K = nruns;
XI = zeros(N,J,K);
XIsplit = zeros(24,J,K,2,3);
THETAS = zeros(d,J,K);
THETA0s = zeros(d,K);
bias = zeros(N,J,K);
MSE = zeros(J,K);
INTERVALS = zeros(6, 6, J, K); %intervals on x0
% for each (j,k) INTERVALS = 6 rows with
% columns [I(smoke), bmi, LCL, UCL, x0, I(x0 covered)]
for k = 1:K
    makeplots = (k == K);
    data = menarchedata(makeplots);
    X = data(:,1:3);
    prob = data(:,4);
    age = X(:,1);
    smoke = X(:,2);
    nosmoke = 1-smoke;
    bmi = X(:,3);
    
    bu = unique(bmi);
    su = unique(smoke);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%
    F = [age, smoke, nosmoke, bmi, age.*smoke, age.*bmi];
    initdesign = init(F, ninit, 100000);
    [Q, R] = qr(F);
    R = R(1:d,:);
    Q1 = Q(:,1:d);
    Q2 = Q(:, (d+1):N);
    sx = diag(Q1*Q1');
    
    w = @(t) weights(t, sx, wts, link);
    a = @(t) w(t).*g(t).*r(t); % alpha
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Carry out a regression in the entire population,
    % to obtain thetagam, then thetazero
    xi = ones(N,1)/N;
    exitflag = 0;
    attempts = 0;
    
    S = @(theta) F'*(xi.*r(F*theta).*w(F*theta).*(prob-G(F*theta)));
    while exitflag <= 0  && attempts <= 100
        thetastart = R\(Q1'*Ginv(min(max(Q1*Q1'*prob,.01),.99))); %LSE
        [thetagam, ~, exitflag, ~] = ...
            fsolve(S, thetastart + (attempts/20)*randn(d,1), options);
        attempts = attempts + 1;
        disp(['thetagam attempts = ', num2str(attempts)]);
    end
    if attempts == 101
        
        disp('thetagam did not converge; replaced by LSE');
        pause(3);
        thetagam = thetastart;
    end
    
    c0 = randn(N-d,1);
    c0 = c0/norm(c0);
    psi = Q2*c0; % norm(psi) = 1
    [theta0, ~, gam, ~, ~] = ...
        thetazero(nfinal, psi, tau1, tau2, thetagam, F, link);
    THETA0s(:,k) = theta0;
    f1 = F(:,[2,3,4])'; % 3 x N
    f2 = f1([1,3],:); % 2 x N
    x0 = (q - theta0([2,3,4])'*f1)./(theta0(1) + theta0([5,6])'*f2);
    x0 = x0(1:6)';
    %pause
    %%%%%%%%%%%%% end of preparation of data %%%%%%%%%%%%%%%%
    n = length(initdesign);
    design = initdesign';
    
    xi = zeros(N,1);
    xi(design) = 1;
    xi = xi/sum(xi);
    
    Yinit = -99*ones(N,1);
    Yinit(xi>0) = binornd(1,prob(xi>0));
    n0 = n;
    %failures = 0;
    
    % Initial estimate:
    exitflag = 0;
    attempts = 0;
    S = @(theta) F'*(xi.*r(F*theta).*w(F*theta).*(Yinit-G(F*theta)));
    while exitflag <= 0 && attempts <= 100
        [thetahat, ~, exitflag, ~] = ...
            fsolve(S, thetastart + (attempts/20)*randn(d,1), options);
        attempts = attempts + 1;
        disp(['init estimation attempts = ', num2str(attempts)]);
    end
    if attempts == 101
        disp('init estimation did not converge');
        thetahat = thetagam;
    end
    
    y = Yinit;
    I = (1:N)';
    keepgoing = 1;
    beta = F*thetahat;
    da = a(beta);
    dw = w(beta);
    dh = (2*G(beta)-1)./g(beta);
    db = Q2'*dh;
    dg = g(beta);
    dr = r(beta);
    
    j = 1;
    while (j <= J && (keepgoing))
        nu1 = NU(j,1);
        nu2 = NU(j,2);
        n = ninit;
        disp(['run = ', num2str(k), '  j = ', num2str(j),...
            '  nu1 = ', num2str(nu1), '  nu2 = ', num2str(nu2)])
        failures = 0;
        while n < nfinal && (keepgoing)            
            [diagT, pixi, check, ~, ~, ~, ~] = ...
                menarchecomps(xi, da, dw, db, Q1, Q2, nu1, nu2);
            if (robustdesign)
                istar = I(diagT == max(diagT));
            else
                istar = randi(N,1);
            end
            %design = [design; istar];
            %update xi:
            numxi = n*xi; % number of allocations n(i)
            %update y and theta:
            numy = numxi.*y;
            Yreturned = binornd(1,prob(istar));
            numy(istar) = numy(istar) + Yreturned;
            numxi(istar) = numxi(istar) + 1;
            y(numxi>0) = numy(numxi>0)./numxi(numxi>0);
            xi = numxi/(n+1);
            attempts = 0;
            exitflag = 0;
            thetastart = thetahat;
            S = @(theta) F'*(xi.*r(F*theta).*w(F*theta).*(y-G(F*theta)));
            while exitflag <= 0 && attempts <= 10
                [thetahat, ~, exitflag, ~] = ...
                    fsolve(S, thetastart + (attempts/10)*randn(size(thetahat)), options);
                attempts = attempts + 1;
            end
            if attempts == 11
                failures = failures + 1;
                thetahat = thetagam;  %%%%%%%%%%%% ??  %%%%%%%%%%%
            end
            THETAS(:,j,k) = thetahat;
            beta = F*thetahat;
            da = a(beta);
            dw = w(beta);
            dh = (2*G(beta)-1)./g(beta);
            db = Q2'*dh;
            dg = g(beta);
            dr = r(beta);
            
            n = n+1;
            failrate = failures/(n-n0);
            disp(['run = ', num2str(k), '  j = ', num2str(j), '  n = ', num2str(n-1),...
                ' pi(xi) = ', num2str(pixi), ' attempts = ', num2str(attempts),...
                ' failrate = ', num2str(failrate), ' check = ', num2str(check)]);
            %[n n0 failures failrate]
            %pause
            if (n > 2*ninit && failrate > .5)
                keepgoing = 0;
                disp(['reset at j = ', num2str(j), ' due to too many failures'])
                pause(3)
            end
        end % end of loop over n
        
        XI(:,j,k) = xi;
        for bmind = 1:length(bu)
            for smokeind = 1:length(su)
                XIsplit(:,j,k,bmind,smokeind) = xi((bmi==bu(bmind).*(smoke == su(smokeind))) == 1);
            end
        end
        
        bias(:,j,k) = F*(thetahat - theta0); %%%%%%%  ?? %%%%%%%%%%%%%%
        MSE(j,k) = (norm(F*(thetahat - theta0)))^2;
        intervals = menarcheconfint(thetahat, xi, F, dw, dg, dr, n, alpha, q);
        % intervals = [I(method1), covariate, x0hat, halfwidth]
        % for each (j,k) INTERVALS = 10 rows with
        % columns [I(method1), covariate, LCL, UCL, x0, I(x0 covered)]
        
        LCL = intervals(:,3) - intervals(:,4);
        UCL = intervals(:,3) + intervals(:,4);
        INTERVALS(:,:,j,k) = [intervals(:,1:2), LCL, UCL, x0, (LCL<x0).*(x0<UCL)];
        % for each (j,k) INTERVALS = 6 rows with
        % columns [I(smoke), bmi, LCL, UCL, x0, I(x0 covered)]
        THESETHETAS = [thetahat, thetagam, theta0];
        collabels = {'thetahat', 'thetagam', 'theta0'};
        THETAtable = array2table(THESETHETAS,'VariableNames',collabels);
        disp('   ');
        disp(THETAtable);
        disp('   ');
        disp(['gamma = ', num2str(gam)]);
        
        if (keepgoing)
            j = j+1;
        else
            keepgoing = 1;
        end
    end % end of loop over j
    
    
    if (k == K)
        Fdes = F(initdesign,:);
        collabels = {'index', 'age', 'smoke', 'bmi'};
        Xtable = array2table([initdesign', round(Fdes(:,[1,2,4]),2)],'VariableNames',collabels);
        disp('   ');
        %disp(['Initial design, with max value of|t(Fdes)*Fdes)| = ', num2str(round(det(Fdes'*Fdes))), ' is']);
        %disp('   ');
        %disp(Xtable);
    end
    
end % end of loop over k

meanXIsplit = mean(XIsplit,3);
BIAS = zeros(1,J);
for j = 1:J
    meanbias = mean(bias,3);
    BIAS(j) = round(norm(meanbias(:,j)),1);
end
rootMSE = round(sqrt(mean(MSE,2))',1);

INTSM1 = INTERVALS(1:3,:,:,:); % Smoke only
INTSM2 = INTERVALS(4:6,:,:,:); % NO-smoke  only
INTSM1C1 = reshape(INTSM1(1,:,:,:),[6,J,K]); % Smoke=1 covariate 1
INTSM1C2 = reshape(INTSM1(2,:,:,:),[6,J,K]); % etc,
INTSM1C3 = reshape(INTSM1(3,:,:,:),[6,J,K]);
INTSM2C1 = reshape(INTSM2(1,:,:,:),[6,J,K]); % Smoke=0 covariate 1
INTSM2C2 = reshape(INTSM2(2,:,:,:),[6,J,K]); % etc,
INTSM2C3 = reshape(INTSM2(3,:,:,:),[6,J,K]);


ALLINTS = {INTSM1C1, INTSM1C2, INTSM1C3, ...
    INTSM2C1, INTSM2C2, INTSM2C3};
% For each of the 6 smoke/bmi combinations,
% elements of 'all' are 6 by J=5 matrices with row labels
% [I(smoke), covariate, LCL, UCL, x0, I(x0 covered)]

if (makeplots) && (k == K)
    figlabels = zeros(J,3);
    for j = 1:J
        nu1 = NU(j,1);
        nu2 = NU(j,2);
        figure (1+j) % one figure for each nu1/nu2 combination
        hold on
        for m = 1:6 % one subplot for each smoke/covariate combination
            allm = ALLINTS{m};
            smoke = allm(1,1,1);
            bmi = allm(2,1,1);
            %bmi = mad_bmi*bmi + med_bmi;
            coverage(m,:) = 100*mean(allm(6,:,:),3);
            intsm = allm(3:5,j,:);
            intsm = reshape(intsm,[3 K]);
            subplot(6,2,m);
            for k=1:K % plot the k intervals in this subplot
                hold on
                ylim([0, K+1])
                xlim([9, 17])
                x = linspace(intsm(1,k),intsm(2,k),200);
                y = k*ones(length(x),1);
                plot(x,y, 'magenta');
                xline(intsm(3,1));
                if (m==1) || (m ==2)
                    xlabel(['BMI = LO, Smoker = ', num2str(smoke), ...
                        ', coverage ', num2str(round(coverage(m,j))), '%']);
                elseif (m==3) || (m ==4)
                    xlabel(['BMI = MED, Smoker = ', num2str(smoke), ...
                        ', coverage ', num2str(round(coverage(m,j))), '%']);
                elseif (m==5) || (m ==6)
                    xlabel(['BMI = HI, Smoker = ', num2str(smoke), ...
                        ', coverage ', num2str(round(coverage(m,j))), '%']);
                end
                hold off
            end
        end
        %suptitle(['Intervals on x_{0}: \nu_{1} = ', num2str(nu1),  ', \nu_{2} = ', num2str(nu2), '; vertical lines at x_{0}'])
        
        %figure(1+J+j) % one figure for each nu1/nu2 combination
        
        ymax = max(max(max(meanXIsplit(:,j,:,:,:))));          
        for bmind = 1:length(bu)
            for smokeind = 1:length(su)
                if smokeind == 1
                    subplot(6,2,6 + 2*bmind - 1)
                    hold on
                    ylim([0,ymax]);
                    xlim([1,24]);
                    bar(meanXIsplit(:,j,1,bmind, smokeind));
                    if (bmind==1)
                        xlabel('BMI = LO, Smoker = 1');
                    elseif (bmind==2)
                        xlabel('BMI = MED, Smoker = 1');
                    elseif (bmind==3)
                        xlabel('BMI = HI, Smoker = 1');
                    end
                    hold off
                elseif smokeind == 2
                    subplot(6,2,6 + 2*bmind)
                    hold on
                    ylim([0,ymax]);
                    xlim([1,24]);
                    bar(meanXIsplit(:,j,1,bmind, smokeind));
                    if (bmind==1)
                        xlabel('BMI = LO, Smoker = 0');
                    elseif (bmind==2)
                        xlabel('BMI = MED, Smoker = 0');
                    elseif (bmind==3)
                        xlabel('BMI = HI, Smoker = 0');
                    end
                    hold off
                end
            end
            %suptitle(['Weights = ', wts, ', \nu_{1} = ', num2str(nu1),  ', \nu_{2} = ', num2str(nu2)])
            hold off
        end 
        figlabels(j,:) = [1+j, nu1, nu2];
    end
    disp(['Weights = ', wts, '; values of nu1 and nu2 in figures 2 to ', num2str(J+1), ' are:']);
    disp('   ');
    disp(figlabels);
end



MEANCOVERAGE = round(mean(coverage),1);

BIAS
rootMSE
MEANCOVERAGE

if strcmp(link,'logistic')
    save 'outputlogistic.mat'
elseif strcmp(link,'probit')
    save 'outputprobithat.mat'
end
