function [MEANCOVERAGE, THETAS, BALANCE, Nfinal, LOSSALL, BIAS, rootMSE, FAIL] = ...
    manydose(nruns, link, wts, ...
    robustdesign, runtoconvergence, makeintervals, adaptive, tau1, tau2)

% [MEANCOVERAGE, THETAS, BALANCE, Nfinal, LOSSALL, BIAS, rootMSE, FAIL] = manydose(1, 'probit', 'hat', 1, 1, 0, 1, 15, 1);


% if (runtoconvergence) then each run terminates when pi(xi) < pistar;
% otherwise when the design size is >= nmax
% if robustdesign = 0 then a random design is used

%clear all;nruns=2;nmax=200;link='probit';robustdesign=1;wts='constant';runtoconvergence=0;adaptive=1;tau1=15;tau2=1;
close all

rng(1) %for reproducibility; use (2) if (1) crashes
options = optimoptions(@fsolve, 'Display', 'none', 'Algorithm', 'trust-region');

ninit = 20; %Initial sample size
nmax = 200; % Final sample size, unless runtoconvergence = 1
%nmax = 1000*ones(length(NU),1); % Final sample size, unless runtoconvergence = 1

pistar = .02;
%NU = [.45 .45];
NU = [0 0; .25 .25; .45 .45; .9 0; 0 .9]; %[nu1 nu2]
% Set the matrix F of regressors, obtain its qr decomposition, set the
% design space (= rows of X)
% Columns of F are
% 1 dose; 2 method1; 3 method 2; 4 covariate; 5 dose*method1 6 dose*cov
% x0 = dose, X1 = (x11,x12,x13) = (method1, method2, cov), X2 = (method1, cov)
cov = [1*ones(8,1); 2*ones(8,1); 3*ones(8,1); 4*ones(8,1); 5*ones(8,1)];
dose = kron(ones(5,1), ...
    [.1*ones(2,1);.4*ones(2,1);.7*ones(2,1);1*ones(2,1)]);
method1 = kron(ones(20,1), [1;0]);
method2 = 1-method1;
F = [dose, method1, method2, cov, dose.*method1, dose.*cov];
X = F(:,1:4);
N = size(F,1);
d = size(F,2);
[Q, R] = qr(F);
R = R(1:d,:);
Q1 = Q(:,1:d);
Q2 = Q(:, (d+1):N);
sx = diag(Q1*Q1');

Ginv = @(u) Ginvcdf(u, link);
g = @(t) gpdf(t, link);
G = @(t) Gcdf(t, link);
r = @(t) rodds(t, link);
w = @(t) weights(t, sx, wts, link);
a = @(t) w(t).*g(t).*r(t); % alpha

q = Ginv(.5);
alpha = .10;
thetagam = [.05; -.25; -.25; -.5; 0; 1];
gam = min(.5, tau2/sqrt(nmax));

J = size(NU,1);
K = nruns;
XI = zeros(N,J,K);
THETAS = zeros(10000,d,J,K);
THETAfinal = zeros(d,J,K);
THETA0 = zeros(d,J,K);
BALANCE = zeros(J,K);
LOSS0 = zeros(J,K); % tr(Rinv)
LOSS1 = zeros(J,K); %max ch root
LOSS2 = zeros(J,K); %b'*U*b
LOSSALL = zeros(J,K);
Nfinal = zeros(J,K);
FAIL = zeros(J,K);
BIAS = zeros(1,J);
MSE = zeros(J,K);
INTERVALS = zeros(10, 6, J, K); %intervals on x0
% for each (j,k) INTERVALS = 10 rows with
% columns [I(method1), covariate, LCL, UCL, x0, I(x0 covered)]
keepgoing = 1;

%labels = [1, 1, 2, 2, 7, 8, 8, 14, 23, 23, 24, 27, 27, ...
%    33, 34, 36, 39, 39, 40, 40]; %if ninit = 20
%labels = 1:N;

for k=1:K
    labels = init(F, ninit, 1000);
    xi = zeros(N,1);
    for i = 1:N
        ni = sum(labels == i);
        xi(i) = ni/ninit;
    end
    [theta0, psi0, beta0] = ...
        thetazero(nmax, xi, tau1, gam, thetagam, F, Q1, Q2, R, link);
    betastar = F*thetagam + psi0;
    j = 1;
    while (j <= J && (keepgoing))
        disp(['j = ', num2str(j)])
        %%%%%%%%%%% Inital estimate %%%%%%%%%%%%%%%%%%
        n = ninit;
        THETA0(:,j,k) = theta0;
        %disp(thetagam');
        %disp(round(theta0,2)');
        %pause
        nu1 = NU(j,1);
        nu2 = NU(j,2);
        y = zeros(N,1);
        % Simulate data for inital design:
        for i = 1:N
            ni = sum(labels == i);
            if ni>0
                Ytrue = binornd(1, G(betastar(i)), ni, 1);
                y(i) = mean(binornd(1,(1-2*gam)*Ytrue + gam)); %possibly misclassified y
            end
        end
        % Compute initial estimates
        exitflag = 0;
        attempts = 0;
        S = @(theta) F'*(xi.*r(F*theta).*w(F*theta).*(y-G(F*theta)));
        while exitflag <= 0 && attempts <= 10
            [theta, ~, exitflag, ~] = fsolve(S, randn(size(theta0)), options);
            attempts = attempts + 1;
        end
        if attempts == 11
            disp('initial estimation did not converge');
        end
        THETAS(1,:,j,k) = theta;
        %[theta0 theta]
        
        %%%%%%%%%%% Carry out the iterations %%%%%%%%%%%%%%%%%%
        [xi, THETAS, Nfinal(j,k), ~, measures, failrate, thetafinal, keepgoing] = ...
            dose_sequential(xi, y, F, theta, betastar, j, k, THETAS, nu1, nu2, gam, N, n,...
            ninit, nmax, Q1, Q2, pistar, adaptive, sx, wts,...
            link, options, robustdesign, runtoconvergence);
        disp(['failrate = ', num2str(failrate), ' j = ', num2str(j)])
        
        FAIL(j,k) = failrate;
        n = Nfinal(j,k);
        beta = F*thetafinal;
        da = a(beta0);
        dw = w(beta0);
        dh = (2*G(beta0)-1)./g(beta0);
        db = Q2'*dh;
        %Losses are computed using the 'true' theta = theta0
        [~, ~, LOSS0(j,k), LOSS1(j,k), LOSS2(j,k), LOSSALL(j,k)] = comps(n, xi, da, dw, db, Q1, Q2, nu1, nu2);
        XI(:,j,k) = xi;
        THETAfinal(:,j,k) = thetafinal;
        MEASURES(j).out = measures; % n, pi(xi), loss
        BALANCE(j,k) =  (sum(XI(:,j).*F(:,3)))';
        MSE(j,k) = ((norm(beta - beta0))^2);
        
        if (adaptive)
            dr = r(beta);
            dg = g(beta);
            dw = w(beta);
            %da = dr.*dg.*dw;
            % try to adjust thetahat for bias:
            %multiplier = tau1; 
            %prod = (da.*xi.*F)';
            %adjustment = multiplier*((prod*F)\(prod*psi))
            %theta_adjusted = theta + adjustment;
            intervals = confint(theta, xi, F, dw, dg, dr, n, alpha, q);
            % intervals = [I(method1), covariate, x0hat, halfwidth]
            % for each (j,k) INTERVALS = 10 rows with
            % columns [I(method1), covariate, LCL, UCL, x0, I(x0 covered)]
            mat = confint(theta0, xi, F, dw, dg, dr, n, alpha, q); %%%% to get true x0 %%%%%%%
            x0 = mat(:,3);
            LCL = intervals(:,3) - intervals(:,4);
            UCL = intervals(:,3) + intervals(:,4);
            INTERVALS(:,:,j,k) = [intervals(:,1:2), LCL, UCL, x0, (LCL<x0).*(x0<UCL)];
            % for each (j,k) INTERVALS = 10 rows with
            % columns [I(method1), covariate, LCL, UCL, x0, I(x0 covered)]
        end
        
        if (keepgoing)
            j = j+1;
        else
            keepgoing = 1;
        end
        
    end % end of while ...
end % end of loop over k

THETAS = THETAS(1:(nmax-ninit+1), :,:,:);
LOSS0 = round(mean(LOSS0, 2),2)';
LOSS1 = round(mean(LOSS1, 2),2)';
LOSS2 = round(mean(LOSS2, 2),2)';
LOSSALL = round(mean(LOSSALL, 2),2)';
%THETA0final
%THETAfinal
biasTHETA = THETAfinal - THETA0;
meanbias = mean(biasTHETA,3);
for j = 1:J
    BIAS(1,j) = round(norm(F*meanbias(:,j)),2);
end
%pause
FAIL = mean(FAIL,2);
FAIL = FAIL';
BALANCE = round(mean(BALANCE,2)',2);
rootMSE = sqrt(mean(MSE,2));
rootMSE = round(rootMSE',2);


figure(1)
for j = 1:J
    subplot(1,J,j);
    b = bar(XI(:,j));
    b.FaceColor = 'flat';
    
    map1 = [.3 .3 0
        .5 .5 0
        .7 .7 0
        .9 .9 0]; % shades of yellow; method 2; even rows
    
    map2 = [0 .4 0
        0 .6 0
        0 .8 0
        0 1 0];  % shades of green; method 1, odd rows
    
    b.CData([2 4 6 8],:) = map1;
    b.CData([1 3 5 7],:) = map2;
    b.CData([10 12 14 16],:) = map1;
    b.CData([9 11 13 15],:) = map2;
    b.CData([18 20 22 24],:) = map1;
    b.CData([17 19 21 23],:) = map2;
    b.CData([26 28 30 32],:) = map1;
    b.CData([25 27 29 31],:) = map2;
    b.CData([34 36 38 40],:) = map1;
    b.CData([33 35 37 39],:) = map2;
    
    xticks(linspace(4.5, 36.5, 5));
    xticklabels(1:5);
    yl = max(max(mean(XI,3)));
    ylim([0, yl])
    xlabel(['(\nu_{1},\nu_{2}) = (', num2str(NU(j,1)),',',num2str(NU(j,2)),')']);
    if (runtoconvergence)
        str = ['n = ', num2str(Nfinal(j))];
        text(10, .8*yl, str);
    end
end

figure(2) % plot progress of convergence
for j = 1:J
    subplot(1,J,j);
    ylim([0 2*pistar]);
    mat = MEASURES(j).out;
    mat1 = mat(:,1);
    nr = length(mat1);
    mat2 = mat(:,2);
    hold on
    scatter(mat(:,1),mat2, 1, 'blue');
    plot(mat1, zeros(nr,1), 'blue');
    plot(mat1, pistar*ones(nr,1), 'blue');
    xlabel(['(\nu_{1},\nu_{2}) = (', num2str(NU(j,1)),',',num2str(NU(j,2)),')']);
    hold off
end

INTSM1 = INTERVALS(1:5,:,:,:); % Method 1 only
INTSM2 = INTERVALS(6:10,:,:,:); % Method 2 only
INTSM1C1 = reshape(INTSM1(1,:,:,:),[6,J,K]); % Method 1 covariate 1
INTSM1C2 = reshape(INTSM1(2,:,:,:),[6,J,K]); % etc,
INTSM1C3 = reshape(INTSM1(3,:,:,:),[6,J,K]);
INTSM1C4 = reshape(INTSM1(4,:,:,:),[6,J,K]);
INTSM1C5 = reshape(INTSM1(5,:,:,:),[6,J,K]);
INTSM2C1 = reshape(INTSM2(1,:,:,:),[6,J,K]); % Method 1 covariate 1
INTSM2C2 = reshape(INTSM2(2,:,:,:),[6,J,K]); % etc,
INTSM2C3 = reshape(INTSM2(3,:,:,:),[6,J,K]);
INTSM2C4 = reshape(INTSM2(4,:,:,:),[6,J,K]);
INTSM2C5 = reshape(INTSM2(5,:,:,:),[6,J,K]);

all = {INTSM1C1, INTSM1C2, INTSM1C3, INTSM1C4, INTSM1C5 ...
    INTSM2C1, INTSM2C2, INTSM2C3, INTSM2C4, INTSM2C5};
% For each of the 10 method/covariate combination,
% elements of 'all' are 6 by J=5 matrices with row labels
% [I(method1), covariate, LCL, UCL, x0, I(x0 covered)]
%coverage = zeros(10,size(NU,1));
if (makeintervals) % && (adaptive)
    coverage = zeros(10,J);
    for j = 1:J
        nu1 = NU(j,1);
        nu2 = NU(j,2);
        figure (2+j) % one figure for each nu1/nu2 combination
        for m = 1:10 % one subplot for each methjod/covariate combination
            allm = all{m};
            method = 2-allm(1,1,1);
            covariate = allm(2,1,1);
            coverage(m,:) = 100*mean(allm(6,:,:),3);
            intsm = allm(3:5,j,:);
            intsm = reshape(intsm,[3 K]);
            subplot(5,2,method + 2*(covariate - 1));
            hold on
            for k=1:K % plot the k intervals in this subplot
                % xlim([min(target(i),min(ints(:,1,i)))-1, max(target(i),max(ints(:,2,i)))+1]);
                %hold on
                ylim([0, K+1])
                x = linspace(intsm(1,k),intsm(2,k),200);
                y = k*ones(length(x),1);
                plot(x,y, 'magenta');
            end
            xline(intsm(3,1));
            xlabel(['C', num2str(covariate), ', M', num2str(method), ...
                ', coverage ', num2str(round(coverage(m,j))), '%']);
            hold off
        end
        suptitle(['Intervals on x_{0}: \nu_{1} = ', num2str(nu1),  ', \nu_{2} = ', num2str(nu2), '; vertical lines at x_{0}'])
    end
    MEANCOVERAGE = round(mean(coverage),1);
end

FAIL
%LOSS0
%LOSS1
%LOSS2
LOSSALL
BIAS
rootMSE
if (makeintervals)
    MEANCOVERAGE
else
    MEANCOVERAGE = [];
end
