function [fs fd runtime] = conopt(option)

% optimization for valve stiction quantification

global model d N u y u_v y_h fs_max a b V

% TOMLAB lgo (http://www.tomopt.com)
x_L = [0 0];
x_U = [fs_max fs_max/2];
name = [];
A = [-1 1;1 1];
b_L = [-fs_max 0];
b_U = [0 fs_max];
c = [];
c_L = [];
c_U = [];
x_0 = [];

% Note that 'objfun' includes penalty functions for constraints
% so it can also be handled as an unconstrained problem
Prob = glcAssign('objfun',x_L,x_U,name,A,b_L,b_U,c,c_L,c_U,x_0); 

Prob.LGO.options.G_maxfct = 10000;

if option == 1     % Multi-start adaptive random search 
    Prob.LGO.options.opmode = 3;
elseif option == 2 % Adaptive random search
    Prob.LGO.options.opmode = 2;
elseif option == 3 % Branch and bound search
    Prob.LGO.options.opmode = 1;
end

Result = tomRun('lgo',Prob,1);
x_opt = Result.x_k;
fs = x_opt(1);
fd = x_opt(2);
runtime = Result.REALtime;

% END of conopt.m
