install.packages('gstat')
install.packages('sp')
install.packages('plyr')
library(gstat)                                 # geostatistical methods by Edzer Pebesma
library(sp)                                    # spatial points addition to regular data frames
library(plyr)                                  # manipulating data by Hadley Wickham 

nx = 400                                       # number of cells in the x direction
ny = 400                                       # number of cells in the y direction
xmin = 5.0                                     # x coordinate of lower, left cell center 
ymin = 5.0                                     # y coordinate of lower, left cell center 
xsize = 10.0                                   # extent of cells in x direction
ysize = 10.0                                   # extent of cells in y direction

setwd("D:/YX/REN R690/seminar")
krig <- read.csv("2D_MV_200Wells.csv")
head(krig)

class(krig)                                  # confirms that it is a dataframe
coordinates(krig) = ~X+Y                     # indicate the X, Y spatial coordinates

summary(krig)                                # confirms a spatial points dataframe
head(coordinates(krig))                      # check the first several coordinates

nscore <- function(x) {                        # by Ashton Shortridge, 2008
  # Takes a vector of values x and calculates their normal scores. Returns 
  # a list with the scores and an ordered table of original values and
  # scores, which is useful as a back-transform table. See backtr().
  nscore <- qqnorm(x, plot.it = FALSE)$x  # normal score 
  trn.table <- data.frame(x=sort(x),nscore=sort(nscore))
  return (list(nscore=nscore, trn.table=trn.table))
}

npor.trn = nscore(krig$porosity)             # normal scores transform
krig[["NPorosity"]]<-npor.trn$nscore         # append the normal scores transform 
head(krig)                                   # check the result

par(mfrow=c(2,2))                              # set up a 2x2 matrix of plots 
hist(krig$porosity,main="Porosity (%)",xlab="Porosity (%)",nclass = 15) # histogram
plot(ecdf(krig$porosity),main="Porosity",xlab="Porosity (%",ylab="Cumulative Probability") # CDF
hist(krig$NPorosity,main="N[Porosity (%)]",xlab="N[Porosity (%)]",nclass = 15) # histogram
plot(ecdf(krig$NPorosity),main="N[Porosity]",xlab="N[Porosity (%)]",ylab="Cumulative Probability") #CDF

spplot(krig, "porosity", do.log = TRUE,      # location map of porosity data
       key.space=list(x=.85,y=0.97,corner=c(0,1)),
       scales=list(draw=T),xlab = "X (m)", ylab = "Y (m)",main ="Porosity (%)")

por.vm.ani <- vgm(psill = 0.6, "Exp", 800, anis = c(035, 0.5),nugget=0.4)
por.vm.ani                                     # check the variogram model parameters 

name = c("035","125")                          # make name matrix
color = c("blue","red")                        # make color matrix

por.vg.035 = variogram(NPorosity~1,krig,cutoff = 3000,width =500,alpha = 35.0,tol.hor=22.5) # 035 directional 
por.vg.125 = variogram(NPorosity~1,krig,cutoff = 3000,width =500,alpha = 125.0,tol.hor=22.5) # 125 directional

plot(por.vg.035$dist,por.vg.035$gamma,main="Porosity Anisotropic Variogram",xlab="  Lag Distance (m) ",ylab=" Semivariogram ",pch=16,col=color[1],ylim=c(0,1.2))
points(por.vg.125$dist,por.vg.125$gamma,pch=16,col=color[2])
abline(h = 1.0)

unit_vector = c(sin(35*pi/180),cos(35*pi/180),0) # unit vector for 035 azimuth
vm.ani.035 <- variogramLine(por.vm.ani,maxdist=3000,min=0.0001,n=100,dir=unit_vector,covariance=FALSE) # model at 035
lines(vm.ani.035$dist,vm.ani.035$gamma,col=color[1]) # include variogram model 

unit_vector = c(sin(55*pi/180),-1*cos(35*pi/180),0) # unit vector for 125 azimuth
vm.ani.125 <- variogramLine(por.vm.ani,maxdist=3000,min=0.0001,n=100,dir=unit_vector,covariance=FALSE) # model at 125 
lines(vm.ani.125$dist,vm.ani.125$gamma,col=color[2]) # include variogram model
legend(2000,.8,name, cex=0.8, col=color,pch=c(16,16,16),lty=c(1,1,1)) # add legend

addcoord <- function(nx,xmin,xsize,ny,ymin,ysize) { # Michael Pyrcz, March, 2018                      
  # makes a 2D dataframe with coordinates based on GSLIB specification
  coords = matrix(nrow = nx*ny,ncol=2)
  ixy = 1
  for(iy in 1:nx) {
    for(ix in 1:ny) {
      coords[ixy,1] = xmin + (ix-1)*xsize  
      coords[ixy,2] = ymin + (iy-1)*ysize 
      ixy = ixy + 1
    }
  }
  coords.df = data.frame(coords)
  colnames(coords.df) <- c("X","Y")
  coordinates(coords.df) =~X+Y
  return (coords.df)
  
}  

coords <- addcoord(nx,xmin,xsize,ny,ymin,ysize) # make a dataframe with all the estimation locations
summary(coords)                                # check the coordinates

porosity.kriged = krige(porosity~1, krig, coords, model = por.vm.ani,maxdist = Inf,nmin = 0,omax=Inf) # ordinary kriging
summary(porosity.kriged)

spplot(porosity.kriged["var1.pred"],
       main = "Porosity Ordinary Kriging", key.space = "right",xlab = "X (m)", ylab = "Y (m)")


par(mfrow=c(2,2))                              # set up a 2x2 matrix of plots 
hist(krig$porosity,main="Porosity",xlab="Porosity (%)",nclass = 15) # histogram
plot(ecdf(krig$porosity),main="Porosity",xlab="Porosity (%)",ylab="Cumulative Probability") # CDF
hist(porosity.kriged$var1.pred,main="Kriged Porosity",xlab="Porosity (%)",nclass = 15) # histogram
plot(ecdf(porosity.kriged$var1.pred),main="Kriged Porosity",xlab="Porosity (%)",ylab="Cumulative Probability") #CDF

maxdist = 800                                  # maximum distance to look for data
nmin = 3                                       # minimum number of data for an estimate
omax = 1                                       # maximum number of data per octant    

porosity.kriged.sp = krige(porosity~1, krig, coords, model = por.vm.ani,maxdist = maxdist,nmin = nmin,omax=omax) # ordianry kriging
spplot(porosity.kriged.sp["var1.pred"],main = "Porosity Ordinary Kriging / Limited Search", key.space = "right",xlab = "X (m)", ylab = "Y (m)")




























