### simple version ###
#install.packages("corrplot")
library(corrplot)
M = cor(mtcars)  ## firstly, compute the correlation
corrplot(M) ## the correlation values are represented by color and size by default

corrplot(M, method = 'color', order = 'AOE')
corrplot(M, method = 'color', order = 'AOE', type = 'lower') ##only keep lower of correlation matrix

testRes = cor.mtest(mtcars, conf.level = 0.95)
corrplot(M, p.mat = testRes$p, method = 'color', diag = FALSE, type = 'upper', sig.level = c(0.001, 0.01, 0.05), pch.cex = 0.9, insig = 'label_sig', pch.col = 'grey20', order = 'AOE',col = COL2('RdYlBu'))


### advanced version ###
install.packages("BiocManager")
BiocManager::install("ComplexHeatmap")
library(ComplexHeatmap)

df <- scale(iris[, 1:4]) ## scale dataset besides the Species column
rownames(df) <- paste0('r', 1:150) ## give each record one rowname
head(df) ## just check the dataset

Heatmap(df, 
        name = "scaled_length", #title of legend
        column_title = "Variables", row_title = "Samples",
        row_names_gp = gpar(fontsize = 7) # Text size for row names
)


Heatmap(df, name = 'scaled length', column_title = 'Variables',
        row_title = 'samples',
        column_dend_height = unit(2, "cm"), ## change the height of dendrogram of variables
        row_dend_width = unit(2, "cm"), ## same but for dendrogram of samples
        row_dend_reorder = T,
        column_title_gp = gpar(fontsize = 12),
        column_names_gp = gpar(fontsize = 8),
        row_names_gp = gpar(col = rep(c('red', 'green', 'blue'), each = 50), fontsize = 4), ## use color to represent species
        rect_gp = gpar(col = "white", lwd = .2), ## add white border
        row_km = 4, row_gap = unit(5, "mm")) 


### Lineplot alternative
library(ggplot2) ## if there any error, please install this package first
library(dplyr); library(tidyr) ## same here
head(iris) ## check the dataset
iris2 <- df %>% as.data.frame() %>% mutate(id = 1:150, Species = iris$Species) %>% 
  pivot_longer(col = Sepal.Length:Petal.Width, names_to = 'var', values_to = 'length') ## change the dataset from wide to long
ggplot(data = iris2, 
       aes(x = var, y = length, group = id, col = Species)) + geom_line(alpha = .2) +
  theme_bw() +
  scale_x_discrete(expand = c(0.01,0)) + labs(x = '', y = 'length (cm)') +
  guides(col=guide_legend(override.aes=list(alpha=c(1, 1, 1))))
