## Import the data
input <- read.csv("AB_Climate.csv")
head(input)

## Create a table of means
install.packages(plyr)
library(plyr)
means <- ddply(input,.(ECOSYS),summarise,MAT=mean(MAT),MWMT=mean(MWMT),MCMT=mean(MCMT),TD=mean(TD),MAP=mean(MAP),MSP=mean(MSP),AHM=mean(AHM),SHM=mean(SHM))
means

## Add the biomes to the ecosystems
biomes <- read.csv("Ecosys to Biomes.csv")
head(biomes)
dat <- merge(means,biomes,by="ECOSYS",sort=F)
dat

climatrix=dat
rownames(climatrix)=climatrix$ECOSYS
climatrix=as.matrix(climatrix[,2:8])
climatrix

## Calculate the distance matrix
install.packages("ecodist")
library(ecodist)

mahal=distance(climatrix, method="mahal")
mahal

# Runs NMDS
nmds_out=nmds(mahal, mindim=2, maxdim=2)
nmds_xy=nmds.min(nmds_out)

# Plot NMDS result with symbols denoting species. Points are skipped by making them white
graphics.off()
x11()
plot(nmds_xy, col=rainbow(4)[dat$BIOME], pch=16, main="NMDS of Alberta Biomes")
text(nmds_xy-1, labels=means$ECOSYS, col=rainbow(4)[dat$BIOME])
par(new=T)

# Fit vectors for the main variables to the NMDS configuration
vectors=vf(nmds_xy, climatrix, nperm=10)
#plot(vectors, len=0.1, col="blue")
arrows(0,0,vectors[,1]*10,vectors[,2]*10, len=0.1, col="grey", lwd=2)
text(vectors[,1]*12,vectors[,2]*12,labels=rownames(vectors),cex=0.8,col="grey")

